/*
 * Decompiled with CFR 0.152.
 */
package BootloaderView.applicationthread;

import BootloaderView.AppContext.AppContext;
import BootloaderView.state.CommState;
import javax.swing.SwingWorker;
import protocol.interfaces.ProtocolInterface;
import protocol.protocolclasses.CommandChecksumProtocol;
import protocol.protocolclasses.CommandEraseFlashProtocol;
import protocol.protocolclasses.CommandReadVersionProtocol;
import protocol.protocolclasses.CommandResetProtocol;
import protocol.protocolclasses.CommandWriteHexFileProtocol;
import protocol.write.nextchunkgetter.state.memoryState;
import serialport.classes.SerialPort;

public class SwingWorkerThread
extends SwingWorker {
    public Void doInBackground() {
        ProtocolInterface protocol;
        AppContext.setIndexWhenConnected(AppContext.getIndexSlectedByUser());
        int tRes = SerialPort.connectToSerialPort(AppContext.getIndexWhenConnected());
        if (tRes == 0) {
            AppContext.swingEditorObj.print(1, "Connection Successful\nEvent: CONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
            protocol = new CommandReadVersionProtocol();
            AppContext.swingEditorObj.print(1, "Reading Version ...");
            protocol.sendReceiveDataProtocol();
            this.synchronize();
            if (this.testState() == -1) {
                return null;
            }
        } else {
            AppContext.setCommState(CommState.IDLE);
            AppContext.swingEditorObj.print(1, "Connection Failed\nEvent: CONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
            return null;
        }
        protocol = new CommandEraseFlashProtocol();
        AppContext.swingEditorObj.print(1, "Erasing Device ...");
        protocol.sendReceiveDataProtocol();
        this.synchronize();
        if (this.testState() == -1) {
            return null;
        }
        protocol = new CommandWriteHexFileProtocol();
        if (AppContext.dataManager.mem != memoryState.NONE) {
            AppContext.swingEditorObj.print(3, "Status: Programming...");
            AppContext.swingEditorObj.print(1, "Writing HEX File ...");
            protocol.sendReceiveDataProtocol();
        } else if (AppContext.dataManager.programMemory == null && AppContext.dataManager.eepromMemory == null) {
            AppContext.swingEditorObj.print(3, "Status: Please Select A File");
            AppContext.swingEditorObj.print(1, "HEX File Not Selected");
            AppContext.swingEditorObj.dispplayFileChooser();
            this.synchronize();
            if (AppContext.dataManager.programMemory == null || AppContext.dataManager.eepromMemory == null) {
                AppContext.swingEditorObj.print(1, "HEX File Not Loaded");
                AppContext.swingEditorObj.print(3, "Status: Programming Failed");
                AppContext.setCommState(CommState.CONNECT);
                tRes = SerialPort.disconnectSerialPort(AppContext.getIndexWhenConnected());
                if (tRes == 0) {
                    AppContext.swingEditorObj.disp(0);
                    AppContext.setCommState(CommState.IDLE);
                    AppContext.swingEditorObj.print(1, "Device Disconnected\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
                    AppContext.swingEditorObj.print(2, "Status: Disconnected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
                    AppContext.setCommState(CommState.IDLE);
                } else {
                    AppContext.swingEditorObj.print(1, "Device Disconnection Failed\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
                    AppContext.swingEditorObj.print(2, "Status: Connected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
                }
                AppContext.swingEditorObj.print(4, "Programming Failed");
                return null;
            }
            AppContext.swingEditorObj.print(3, "Status: Programming...");
            AppContext.swingEditorObj.print(1, "Writing HEX File ...");
            protocol.sendReceiveDataProtocol();
        } else {
            AppContext.swingEditorObj.print(1, "HEX File Already Written / Nothing To Write");
            AppContext.swingEditorObj.print(3, "Status: Not Programmed");
            AppContext.setCommState(CommState.CONNECT);
            tRes = SerialPort.disconnectSerialPort(AppContext.getIndexWhenConnected());
            if (tRes == 0) {
                AppContext.swingEditorObj.disp(0);
                AppContext.setCommState(CommState.IDLE);
                AppContext.swingEditorObj.print(1, "Device Disconnected\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
                AppContext.swingEditorObj.print(2, "Status: Disconnected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
                AppContext.setCommState(CommState.IDLE);
            } else {
                AppContext.swingEditorObj.print(1, "Device Disconnection Failed\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
                AppContext.swingEditorObj.print(2, "Status: Connected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
            }
            AppContext.swingEditorObj.print(5, "HEX File Already Written / Nothing To Write");
            return null;
        }
        this.synchronize();
        if (this.testState() == -1) {
            return null;
        }
        protocol = new CommandChecksumProtocol();
        AppContext.swingEditorObj.print(1, "Calculating And Comparing Checksum ...");
        protocol.sendReceiveDataProtocol();
        this.synchronize();
        if (this.testState() == -1) {
            return null;
        }
        if (AppContext.resetFlag == 1) {
            protocol = new CommandResetProtocol();
            AppContext.swingEditorObj.print(1, "Resetting Device ...");
            protocol.sendReceiveDataProtocol();
            this.synchronize();
        } else {
            AppContext.swingEditorObj.print(1, "Cannot RESET Device. Checksum Not Verified / Does Not Match");
            AppContext.swingEditorObj.print(4, "Cannot RESET Device. Checksum Not Verified / Does Not Match");
        }
        AppContext.setCommState(CommState.CONNECT);
        tRes = SerialPort.disconnectSerialPort(AppContext.getIndexWhenConnected());
        if (tRes == 0) {
            AppContext.swingEditorObj.disp(0);
            AppContext.setCommState(CommState.IDLE);
            AppContext.swingEditorObj.print(1, "Device Disconnected\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
            AppContext.swingEditorObj.print(2, "Status: Disconnected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
            AppContext.setCommState(CommState.IDLE);
        } else {
            AppContext.swingEditorObj.print(1, "Device Disconnection Failed\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
            AppContext.swingEditorObj.print(2, "Status: Connected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
        }
        AppContext.swingEditorObj.print(1, "Program Thread Ends\nEvent: PROGRAM THREAD END. STATE: " + (Object)((Object)AppContext.getCommState()));
        AppContext.swingEditorObj.disp(0);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronize() {
        SwingWorkerThread swingWorkerThread = this;
        synchronized (swingWorkerThread) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    int testState() {
        if (AppContext.getCommState() == CommState.IDLE) {
            return -1;
        }
        return 0;
    }
}

