/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommCompletionInterface;
import com.microchip.mplab.comm.MPLABCommSerialAccess;
import com.microchip.mplab.comm.MPLABCommSerialDescriptor;
import com.microchip.mplab.comm.MPLABCommServiceProviderInterface;
import com.microchip.mplab.comm.MPLABCommTool;
import com.microchip.mplab.open.util.GateSemaphore;

public class MPLABCommSerialTool
extends MPLABCommTool {
    private MPLABCommSerialAccess cAccessProvider;
    private int cInUseSelect;

    public MPLABCommSerialTool(int listHandle, int toolIndex, MPLABCommServiceProviderInterface serviceProvider, MPLABCommSerialAccess accessProvider) {
        super(listHandle, toolIndex, serviceProvider);
        this.cAccessProvider = accessProvider;
        this.cInUseSelect = listHandle << 16 | toolIndex;
    }

    public int Connect() {
        int result;
        if (this.cDeviceOpened == 0) {
            result = this.cAccessProvider.OpenDevice(this.cListHandle, this.cToolIndex);
            if (result == 0) {
                this.cDeviceOpened = 1;
            }
        } else {
            result = -105;
        }
        return result;
    }

    public int ResetTool() {
        int result = this.cDeviceOpened == 1 ? this.cAccessProvider.ResetDevice(this.cListHandle, this.cToolIndex) : -109;
        return result;
    }

    public int ClaimInterface(int interfaceNumber) {
        return -120;
    }

    public int ReleaseInterface(int interfaceNumber) {
        return -120;
    }

    public int GetClaimedInterface() {
        return -120;
    }

    public Object GetDescriptor(int selection, int subselection, int additionalInfo) {
        MPLABCommSerialDescriptor descriptor = null;
        if (this.cDeviceOpened == 1) {
            switch (selection) {
                case 90: {
                    byte[] buffer = new byte[256];
                    if (this.cAccessProvider.GetConfigurationDescriptor(this.cListHandle, this.cToolIndex, 256, buffer) != 0) break;
                    MPLABCommSerialDescriptor sDescriptor = new MPLABCommSerialDescriptor();
                    sDescriptor.cBitsPerByte = MPLABCommSerialDescriptor.getValue(buffer, 0, 0);
                    sDescriptor.cBaudRate = MPLABCommSerialDescriptor.getValue(buffer, 4, 0);
                    sDescriptor.cStopBitsSelect = MPLABCommSerialDescriptor.getValue(buffer, 8, 0);
                    int v = MPLABCommSerialDescriptor.getValue(buffer, 12, 0);
                    sDescriptor.cParityCheckingOn = v != 0;
                    sDescriptor.cParityScheme = MPLABCommSerialDescriptor.getValue(buffer, 16, 0);
                    descriptor = sDescriptor;
                    break;
                }
            }
        }
        return descriptor;
    }

    public int GetStatus(int selection) {
        return -120;
    }

    public int SetConfiguration(int selection, Object what) {
        int result = -114;
        if (this.cDeviceOpened == 1) {
            switch (selection) {
                case 90: {
                    MPLABCommSerialDescriptor sDescriptor = (MPLABCommSerialDescriptor)what;
                    byte[] buffer = new byte[256];
                    MPLABCommSerialDescriptor.setValue(sDescriptor.cBitsPerByte, buffer, 0, 0);
                    MPLABCommSerialDescriptor.setValue(sDescriptor.cBaudRate, buffer, 4, 0);
                    MPLABCommSerialDescriptor.setValue(sDescriptor.cStopBitsSelect, buffer, 8, 0);
                    int v = sDescriptor.cParityCheckingOn ? 1 : 0;
                    MPLABCommSerialDescriptor.setValue(v, buffer, 12, 0);
                    MPLABCommSerialDescriptor.setValue(sDescriptor.cParityScheme, buffer, 16, 0);
                    result = this.cAccessProvider.SetConfigurationDescriptor(this.cListHandle, this.cToolIndex, 20, buffer);
                    break;
                }
            }
        }
        return result;
    }

    public int WritePipe(final int pipeNumber, int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            if (this.cPipeInuse.get(this.cInUseSelect) == null) {
                this.cPipeInuse.put(this.cInUseSelect, 1);
                if (completionHandler == null) {
                    resultCode = this.cAccessProvider.WritePort(this.cListHandle, this.cToolIndex, timeout, byteCount, data);
                    this.cPipeInuse.remove(this.cInUseSelect);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            int result = 0;
                            int actual = MPLABCommSerialTool.this.cAccessProvider.WritePort(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, timeout, byteCount, data);
                            if (actual < 0) {
                                result = actual;
                                actual = 0;
                            }
                            completionHandler.WriteComplete(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, pipeNumber, result, actual);
                            MPLABCommSerialTool.this.cPipeInuse.remove(MPLABCommSerialTool.this.cInUseSelect);
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int ReadPipe(final int pipeNumber, int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            if (this.cPipeInuse.get(this.cInUseSelect) == null) {
                this.cPipeInuse.put(this.cInUseSelect, 1);
                if (completionHandler == null) {
                    resultCode = this.cAccessProvider.ReadPort(this.cListHandle, this.cToolIndex, timeout, byteCount, data);
                    this.cPipeInuse.remove(this.cInUseSelect);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            int result = 0;
                            int actual = MPLABCommSerialTool.this.cAccessProvider.ReadPort(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, timeout, byteCount, data);
                            if (actual < 0) {
                                result = actual;
                                actual = 0;
                            }
                            completionHandler.ReadComplete(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, pipeNumber, result, actual);
                            MPLABCommSerialTool.this.cPipeInuse.remove(MPLABCommSerialTool.this.cInUseSelect);
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int ReadPipeContinuous(final int pipeNumber, int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            if (this.cPipeInuse.get(this.cInUseSelect) == null) {
                this.cPipeInuse.put(this.cInUseSelect, 1);
                if (completionHandler == null) {
                    resultCode = this.cAccessProvider.ReadPort(this.cListHandle, this.cToolIndex, timeout, byteCount, data);
                    this.cPipeInuse.remove(this.cInUseSelect);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            int compRes = 0;
                            int result = 0;
                            while (result == 0 && compRes == 0) {
                                int actual = MPLABCommSerialTool.this.cAccessProvider.ReadPort(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, timeout, byteCount, data);
                                if (actual < 0) {
                                    result = actual;
                                    actual = 0;
                                }
                                if (result >= 0 && actual <= 0) continue;
                                compRes = completionHandler.ReadComplete(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, pipeNumber, result, actual);
                            }
                            MPLABCommSerialTool.this.cPipeInuse.remove(MPLABCommSerialTool.this.cInUseSelect);
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int ReadPipeAndWait(final int pipeNumber, int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout, final GateSemaphore gateSemaphore) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            if (this.cPipeInuse.get(this.cInUseSelect) == null) {
                this.cPipeInuse.put(this.cInUseSelect, 1);
                if (completionHandler == null) {
                    resultCode = this.cAccessProvider.ReadPort(this.cListHandle, this.cToolIndex, timeout, byteCount, data);
                    this.cPipeInuse.remove(this.cInUseSelect);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            int compRes = 0;
                            int result = 0;
                            while (result == 0 && compRes == 0) {
                                MPLABCommSerialTool.this.cPipeWaitState.put(MPLABCommSerialTool.this.cInUseSelect, 0);
                                boolean state = false;
                                int actual = MPLABCommSerialTool.this.cAccessProvider.ReadPort(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, timeout, byteCount, data);
                                if (actual < 0) {
                                    result = actual;
                                    actual = 0;
                                }
                                if (result >= 0 && actual <= 0) continue;
                                compRes = completionHandler.ReadComplete(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, pipeNumber, result, actual);
                                if (result < 0 || compRes != 0) continue;
                                gateSemaphore.Release(0);
                                while (!gateSemaphore.TryAcquire(1)) {
                                }
                                if (gateSemaphore.getMessageValue(1) != -129) continue;
                                result = -129;
                                completionHandler.ReadComplete(MPLABCommSerialTool.this.cListHandle, MPLABCommSerialTool.this.cToolIndex, pipeNumber, result, 0);
                            }
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int CancelWritePipeTransfer(int pipeNumber) {
        return -120;
    }

    public int CancelReadPipeTransfer(int pipeNumber) {
        return -120;
    }

    public int CancelReadPipeContinuous(int pipeNumber) {
        return -120;
    }

    public int CancelPipeTransfer(int pipeAddress) {
        int result = this.cDeviceOpened == 1 ? (this.cPipeInuse.get(this.cInUseSelect) != null ? this.cAccessProvider.CancelPortTransfer(this.cListHandle, this.cToolIndex) : -118) : -109;
        return result;
    }

    public int Disconnect() {
        int result;
        if (this.cDeviceOpened == 1) {
            this.ReleaseInterface(this.cActiveInterface);
            result = this.cAccessProvider.CloseDevice(this.cListHandle, this.cToolIndex);
            this.cDeviceOpened = 0;
        } else {
            result = -109;
        }
        return result;
    }
}

