/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommCompletionInterface;
import com.microchip.mplab.comm.MPLABCommDeviceDescriptor;
import com.microchip.mplab.comm.MPLABCommEndpointDescriptor;
import com.microchip.mplab.comm.MPLABCommException;
import com.microchip.mplab.comm.MPLABCommServiceProviderInterface;
import com.microchip.mplab.comm.MPLABCommStringDescriptor;
import com.microchip.mplab.comm.MPLABCommTool;
import com.microchip.mplab.comm.MPLABCommUSBAccessInterface;
import com.microchip.mplab.open.util.GateSemaphore;

public class MPLABCommUSBTool
extends MPLABCommTool {
    private MPLABCommUSBAccessInterface cAccessProvider;

    public MPLABCommUSBTool(int listHandle, int toolIndex, MPLABCommServiceProviderInterface serviceProvider, MPLABCommUSBAccessInterface accessProvider) {
        super(listHandle, toolIndex, serviceProvider);
        this.cAccessProvider = accessProvider;
    }

    public int Connect() {
        int result;
        MPLABCommException.LogInformation("MCT:USB: enter Connect()");
        if (this.cDeviceOpened == 0) {
            result = this.cAccessProvider.USB_OpenDevice(this.cListHandle, this.cToolIndex);
            if (result == 0) {
                this.cDeviceOpened = 1;
                this.ClaimInterface(this.cActiveInterface);
            }
        } else {
            result = -105;
        }
        MPLABCommException.LogInformation("MCT:USB: exit Connect()", result);
        return result;
    }

    public int ResetTool() {
        MPLABCommException.LogInformation("MCT:USB: enter ResetTool()");
        int result = this.cDeviceOpened == 1 ? this.cAccessProvider.USB_ResetDevice(this.cListHandle, this.cToolIndex) : -109;
        MPLABCommException.LogInformation("MCT:USB: exit ResetTool()", result);
        return result;
    }

    public int ClaimInterface(int interfaceNumber) {
        int previousInterfaceNumber = 0;
        previousInterfaceNumber = this.cDeviceOpened == 1 ? -120 : -109;
        return previousInterfaceNumber;
    }

    public int ReleaseInterface(int interfaceNumber) {
        int result = 0;
        if (this.cDeviceOpened == 1) {
            if (interfaceNumber == this.cActiveInterface) {
                this.ClaimInterface(0);
                this.cActiveInterface = 0;
            } else {
                result = -119;
            }
        } else {
            result = -109;
        }
        return result;
    }

    public int GetClaimedInterface() {
        int currentInterface = this.cDeviceOpened == 1 ? this.cActiveInterface : -109;
        return currentInterface;
    }

    public Object GetDescriptor(int selection, int subselection, int additionalInfo) {
        Object descriptor = null;
        if (this.cDeviceOpened == 1) {
            switch (selection) {
                case 1: {
                    byte[] buffer = new byte[18];
                    if (this.cAccessProvider.USB_GetDeviceDescriptor(this.cListHandle, this.cToolIndex, buffer) != 0) break;
                    MPLABCommDeviceDescriptor dDescriptor = new MPLABCommDeviceDescriptor();
                    dDescriptor.bLength = buffer[0] & 0xFF;
                    dDescriptor.bDescriptorType = buffer[1] & 0xFF;
                    dDescriptor.wUsbRev = buffer[2] & 0xFF;
                    dDescriptor.wUsbRev |= (buffer[3] & 0xFF) << 8;
                    dDescriptor.bDeviceClass = buffer[4] & 0xFF;
                    dDescriptor.bDeviceSubClass = buffer[5] & 0xFF;
                    dDescriptor.bDeviceProtocol = buffer[6] & 0xFF;
                    dDescriptor.bEP0MaxPacketSize = buffer[7] & 0xFF;
                    dDescriptor.wVendorId = buffer[8] & 0xFF;
                    dDescriptor.wVendorId |= (buffer[9] & 0xFF) << 8;
                    dDescriptor.wProductId = buffer[10] & 0xFF;
                    dDescriptor.wProductId |= (buffer[11] & 0xFF) << 8;
                    dDescriptor.wDeviceRev = buffer[12] & 0xFF;
                    dDescriptor.wDeviceRev |= (buffer[13] & 0xFF) << 8;
                    dDescriptor.bManufacturerStringIndex = buffer[14] & 0xFF;
                    dDescriptor.bProductStringIndex = buffer[15] & 0xFF;
                    dDescriptor.bSerialNumberStringIndex = buffer[16] & 0xFF;
                    dDescriptor.bNumberOfConfigurations = buffer[17] & 0xFF;
                    descriptor = dDescriptor;
                    break;
                }
                case 5: {
                    byte[] buffer = new byte[7];
                    if (this.cAccessProvider.USB_GetEndpointDescriptor(this.cListHandle, this.cToolIndex, subselection, buffer) != 0) break;
                    MPLABCommEndpointDescriptor dDescriptor = new MPLABCommEndpointDescriptor();
                    dDescriptor.bLength = buffer[0] & 0xFF;
                    dDescriptor.bDescriptorType = buffer[1] & 0xFF;
                    dDescriptor.bEndpointAddress = buffer[2] & 0xFF;
                    dDescriptor.bAttributes = buffer[3] & 0xFF;
                    dDescriptor.wMaxPacketSize = buffer[4] & 0xFF;
                    dDescriptor.wMaxPacketSize |= (buffer[5] & 0xFF) << 8;
                    dDescriptor.bInterval = buffer[6] & 0xFF;
                    descriptor = dDescriptor;
                    break;
                }
                case 3: {
                    int i;
                    byte[] buffer = new byte[additionalInfo];
                    if (this.cAccessProvider.USB_GetStringDescriptor(this.cListHandle, this.cToolIndex, subselection, additionalInfo, buffer) != 0) break;
                    MPLABCommStringDescriptor dDescriptor = new MPLABCommStringDescriptor();
                    dDescriptor.stringIndex = subselection;
                    for (i = 0; i < additionalInfo && buffer[i] != 0; ++i) {
                    }
                    dDescriptor.content = new String(buffer, 0, i);
                    descriptor = dDescriptor;
                    break;
                }
                case -2: {
                    String s = this.cServiceProvider.GetToolInfo(this.cListHandle, this.cToolIndex, 1);
                    MPLABCommStringDescriptor dDescriptor = new MPLABCommStringDescriptor();
                    dDescriptor.stringIndex = -2;
                    dDescriptor.content = s;
                    descriptor = dDescriptor;
                    break;
                }
            }
        }
        return descriptor;
    }

    public int GetStatus(int selection) {
        int result;
        switch (selection) {
            case 0: {
                result = this.cActiveState;
                break;
            }
            case 1: {
                result = this.cDeviceOpened == 1 ? 2 : 3;
                break;
            }
            default: {
                result = -114;
            }
        }
        return result;
    }

    public int SetStatus(int selection, int value) {
        int result = 0;
        switch (selection) {
            case 0: {
                this.cActiveState = value;
                break;
            }
            default: {
                result = -114;
            }
        }
        return result;
    }

    public int SetConfiguration(int selection, Object what) {
        return -120;
    }

    public int WritePipe(final int pipeNumber, final int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            if (this.cPipeInuse.get(pipeNumber) == null) {
                this.cPipeInuse.put(pipeNumber, 1);
                if (completionHandler == null) {
                    Integer cr;
                    resultCode = pipeType == 2 ? this.cAccessProvider.USB_WriteBulkPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data) : this.cAccessProvider.USB_WriteInterruptPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data);
                    if (resultCode == 0 && (cr = (Integer)this.cPipeCancelRequested.get(pipeNumber)) != null && cr != 0) {
                        resultCode = -129;
                        this.cPipeCancelRequested.remove(pipeNumber);
                    }
                    this.cPipeInuse.remove(pipeNumber);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            Integer cr;
                            int result = 0;
                            int l_pipeNumber = pipeNumber;
                            int l_pipeType = pipeType;
                            int l_byteCount = byteCount;
                            byte[] l_data = data;
                            MPLABCommCompletionInterface l_completionHandler = completionHandler;
                            int l_timeout = timeout;
                            int actual = l_pipeType == 2 ? MPLABCommUSBTool.this.cAccessProvider.USB_WriteBulkPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data) : MPLABCommUSBTool.this.cAccessProvider.USB_WriteInterruptPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, pipeNumber, byteCount, timeout, data);
                            if (actual == 0 && (cr = (Integer)MPLABCommUSBTool.this.cPipeCancelRequested.get(l_pipeNumber)) != null && cr != 0) {
                                actual = -129;
                                MPLABCommUSBTool.this.cPipeCancelRequested.remove(l_pipeNumber);
                            }
                            if (actual < 0) {
                                result = actual;
                                actual = 0;
                            }
                            l_completionHandler.WriteComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, actual);
                            MPLABCommUSBTool.this.cPipeInuse.remove(l_pipeNumber);
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int ReadPipe(final int pipeNumber, final int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            final int pipeAddress = pipeNumber | 0x80;
            if (this.cPipeInuse.get(pipeAddress) == null) {
                this.cPipeInuse.put(pipeAddress, 1);
                if (completionHandler == null) {
                    Integer cr;
                    resultCode = pipeType == 2 ? this.cAccessProvider.USB_ReadBulkPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data) : this.cAccessProvider.USB_ReadInterruptPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data);
                    if (resultCode == 0 && (cr = (Integer)this.cPipeCancelRequested.get(pipeAddress)) != null && cr != 0) {
                        resultCode = -129;
                        this.cPipeCancelRequested.remove(pipeAddress);
                    }
                    this.cPipeInuse.remove(pipeAddress);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            Integer cr;
                            int result = 0;
                            int l_pipeNumber = pipeNumber;
                            int l_pipeType = pipeType;
                            int l_byteCount = byteCount;
                            byte[] l_data = data;
                            MPLABCommCompletionInterface l_completionHandler = completionHandler;
                            int l_timeout = timeout;
                            int l_pipeAddress = pipeAddress;
                            int actual = l_pipeType == 2 ? MPLABCommUSBTool.this.cAccessProvider.USB_ReadBulkPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data) : MPLABCommUSBTool.this.cAccessProvider.USB_ReadInterruptPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data);
                            if (actual == 0 && (cr = (Integer)MPLABCommUSBTool.this.cPipeCancelRequested.get(l_pipeAddress)) != null && cr != 0) {
                                actual = -129;
                                MPLABCommUSBTool.this.cPipeCancelRequested.remove(l_pipeAddress);
                            }
                            if (actual < 0) {
                                result = actual;
                                actual = 0;
                            }
                            l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, actual);
                            MPLABCommUSBTool.this.cPipeInuse.remove(l_pipeNumber | 0x80);
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int ReadPipeContinuous(final int pipeNumber, final int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            final int pipeAddress = pipeNumber | 0x80;
            if (this.cPipeInuse.get(pipeAddress) == null) {
                this.cPipeInuse.put(pipeAddress, 1);
                if (completionHandler == null) {
                    Integer cr;
                    resultCode = pipeType == 2 ? this.cAccessProvider.USB_ReadBulkPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data) : this.cAccessProvider.USB_ReadInterruptPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data);
                    if (resultCode == 0 && (cr = (Integer)this.cPipeCancelRequested.get(pipeAddress)) != null && cr != 0) {
                        resultCode = -129;
                        this.cPipeCancelRequested.remove(pipeAddress);
                    }
                    this.cPipeInuse.remove(pipeAddress);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            int compRes = 0;
                            int result = 0;
                            int l_pipeNumber = pipeNumber;
                            int l_pipeType = pipeType;
                            int l_byteCount = byteCount;
                            byte[] l_data = data;
                            MPLABCommCompletionInterface l_completionHandler = completionHandler;
                            int l_timeout = timeout;
                            int l_pipeAddress = pipeAddress;
                            if (l_pipeType == 2) {
                                while (result == 0 && compRes == 0) {
                                    int actual = MPLABCommUSBTool.this.cAccessProvider.USB_ReadBulkPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data);
                                    if (actual == 0) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        Integer cr = (Integer)MPLABCommUSBTool.this.cPipeCancelRequested.get(l_pipeAddress);
                                        if (cr != null && cr != 0) {
                                            actual = -129;
                                            MPLABCommUSBTool.this.cPipeCancelRequested.remove(l_pipeAddress);
                                        }
                                    }
                                    if (actual < 0) {
                                        result = actual;
                                        actual = 0;
                                    }
                                    if (result >= 0 && actual <= 0) continue;
                                    compRes = l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, actual);
                                }
                            } else {
                                while (result == 0 && compRes == 0) {
                                    int actual = MPLABCommUSBTool.this.cAccessProvider.USB_ReadInterruptPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data);
                                    if (actual == 0) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        Integer cr = (Integer)MPLABCommUSBTool.this.cPipeCancelRequested.get(l_pipeAddress);
                                        if (cr != null && cr != 0) {
                                            actual = -129;
                                            MPLABCommUSBTool.this.cPipeCancelRequested.remove(l_pipeAddress);
                                        }
                                    }
                                    if (actual < 0) {
                                        result = actual;
                                        actual = 0;
                                    }
                                    if (result >= 0 && actual <= 0) continue;
                                    compRes = l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, actual);
                                }
                            }
                            MPLABCommUSBTool.this.cPipeInuse.remove(l_pipeNumber | 0x80);
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int ReadPipeAndWait(final int pipeNumber, final int pipeType, final int byteCount, final byte[] data, final MPLABCommCompletionInterface completionHandler, final int timeout, final GateSemaphore gateSemaphore) {
        int resultCode = 0;
        if (this.cDeviceOpened == 1) {
            final int pipeAddress = pipeNumber | 0x80;
            if (this.cPipeInuse.get(pipeAddress) == null) {
                this.cPipeInuse.put(pipeAddress, 1);
                if (completionHandler == null) {
                    Integer cr;
                    resultCode = pipeType == 2 ? this.cAccessProvider.USB_ReadBulkPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data) : this.cAccessProvider.USB_ReadInterruptPipe(this.cListHandle, this.cToolIndex, pipeNumber, byteCount, timeout, data);
                    if (resultCode == 0 && (cr = (Integer)this.cPipeCancelRequested.get(pipeAddress)) != null && cr != 0) {
                        resultCode = -129;
                        this.cPipeCancelRequested.remove(pipeAddress);
                    }
                    this.cPipeInuse.remove(pipeAddress);
                } else {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            int compRes = 0;
                            int result = 0;
                            int l_pipeNumber = pipeNumber;
                            int l_pipeType = pipeType;
                            int l_byteCount = byteCount;
                            byte[] l_data = data;
                            MPLABCommCompletionInterface l_completionHandler = completionHandler;
                            int l_timeout = timeout;
                            int l_pipeAddress = pipeAddress;
                            GateSemaphore l_gateSemaphore = gateSemaphore;
                            if (l_pipeType == 2) {
                                while (result == 0 && compRes == 0) {
                                    MPLABCommUSBTool.this.cPipeWaitState.put(l_pipeNumber | 0x80, 0);
                                    boolean state = false;
                                    int actual = MPLABCommUSBTool.this.cAccessProvider.USB_ReadBulkPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data);
                                    if (actual == 0) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        Integer cr = (Integer)MPLABCommUSBTool.this.cPipeCancelRequested.get(l_pipeAddress);
                                        if (cr != null && cr != 0) {
                                            actual = -129;
                                            MPLABCommUSBTool.this.cPipeCancelRequested.remove(l_pipeAddress);
                                        }
                                    }
                                    if (actual < 0) {
                                        result = actual;
                                        actual = 0;
                                    }
                                    if (result >= 0 && actual <= 0) continue;
                                    compRes = l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, actual);
                                    if (result < 0 || compRes != 0) continue;
                                    l_gateSemaphore.Release(0);
                                    while (!l_gateSemaphore.TryAcquire(1)) {
                                    }
                                    if (l_gateSemaphore.getMessageValue(1) != -129) continue;
                                    result = -129;
                                    l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, 0);
                                }
                            } else {
                                while (result == 0 && compRes == 0) {
                                    MPLABCommUSBTool.this.cPipeWaitState.put(l_pipeNumber | 0x80, 0);
                                    boolean state = false;
                                    int actual = MPLABCommUSBTool.this.cAccessProvider.USB_ReadInterruptPipe(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, l_byteCount, l_timeout, l_data);
                                    if (actual == 0) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                        Integer cr = (Integer)MPLABCommUSBTool.this.cPipeCancelRequested.get(l_pipeAddress);
                                        if (cr != null && cr != 0) {
                                            actual = -129;
                                            MPLABCommUSBTool.this.cPipeCancelRequested.remove(l_pipeAddress);
                                        }
                                    }
                                    if (actual < 0) {
                                        result = actual;
                                        actual = 0;
                                    }
                                    if (result >= 0 && actual <= 0) continue;
                                    compRes = l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, actual);
                                    if (result < 0 || compRes != 0) continue;
                                    l_gateSemaphore.Release(0);
                                    while (!l_gateSemaphore.TryAcquire(1)) {
                                    }
                                    if (l_gateSemaphore.getMessageValue(1) != -129) continue;
                                    result = -129;
                                    l_completionHandler.ReadComplete(MPLABCommUSBTool.this.cListHandle, MPLABCommUSBTool.this.cToolIndex, l_pipeNumber, result, 0);
                                }
                                MPLABCommUSBTool.this.cPipeInuse.remove(l_pipeNumber | 0x80);
                            }
                        }
                    });
                    t.start();
                }
            } else {
                resultCode = -121;
            }
        } else {
            resultCode = -109;
        }
        return resultCode;
    }

    public int CancelWritePipeTransfer(int pipeNumber) {
        return this.CancelPipeTransfer(pipeNumber);
    }

    public int CancelReadPipeTransfer(int pipeNumber) {
        return this.CancelPipeTransfer(pipeNumber | 0x80);
    }

    public int CancelReadPipeContinuous(int pipeNumber) {
        int result = 0;
        if (this.cDeviceOpened == 1) {
            int pipeAddress = pipeNumber | 0x80;
            if (this.cPipeInuse.get(pipeAddress) != null) {
                this.cPipeCancelRequested.put(pipeAddress, 1);
            } else {
                result = -118;
            }
        } else {
            result = -109;
        }
        return result;
    }

    public int CancelPipeTransfer(int pipeAddress) {
        int result;
        if (this.cDeviceOpened == 1) {
            if (this.cPipeInuse.get(pipeAddress) != null) {
                result = this.cAccessProvider.USB_CancelPipeTransfer(this.cListHandle, this.cToolIndex, pipeAddress);
                this.cPipeCancelRequested.put(pipeAddress, 1);
            } else {
                result = -118;
            }
        } else {
            result = -109;
        }
        return result;
    }

    public int Disconnect() {
        int result;
        MPLABCommException.LogInformation("MCT:USB: enter Disconnect()");
        if (this.cDeviceOpened == 1) {
            this.ReleaseInterface(this.cActiveInterface);
            result = this.cAccessProvider.USB_CloseDevice(this.cListHandle, this.cToolIndex);
            this.cDeviceOpened = 0;
        } else {
            result = -109;
        }
        MPLABCommException.LogInformation("MCT:USB: exit Disconnect()", result);
        return result;
    }
}

