/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.HotplugObject;
import com.microchip.mplab.comm.MPLABCommEvent;
import com.microchip.mplab.comm.MPLABCommException;
import com.microchip.mplab.comm.MPLABCommServiceProviderInterface;
import com.microchip.mplab.comm.MPLABCommTool;
import com.microchip.mplab.comm.MPLABCommUSBAccess;
import com.microchip.mplab.comm.MPLABCommUSBAccessInterface;
import com.microchip.mplab.comm.MPLABCommUSBMonitor;
import com.microchip.mplab.comm.MPLABCommUSBTool;
import com.microchip.mplab.comm.ToolInfoObject;
import com.microchip.mplab.util.observers.Observer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPLABCommUSBServiceProvider
implements MPLABCommServiceProviderInterface {
    private String cJNILinkLibraryName = "USBAccessLink";
    private MPLABCommUSBAccess cUsbAccess = new MPLABCommUSBAccess();
    private int cUsbSession = this.cUsbAccess.USB_Initialize(this.cJNILinkLibraryName);
    private MPLABCommUSBMonitor cMonitor;
    private Thread cMonitorThread;
    private String cActiveToolFile;
    private String cAlternateMonitorFile;
    private static ArrayList<Observer> cListenerList = null;
    private Map<Integer, Map<Integer, ToolInfoObject>> cToolLists = new HashMap<Integer, Map<Integer, ToolInfoObject>>();
    private Map<String, HotplugObject> cHotplugEntries;
    private Map<Integer, Integer> cListAndVendor;

    public MPLABCommUSBServiceProvider() {
        cListenerList = new ArrayList();
        this.cMonitor = null;
        this.cAlternateMonitorFile = null;
        this.cActiveToolFile = null;
        this.cHotplugEntries = new HashMap<String, HotplugObject>();
        this.cListAndVendor = new HashMap<Integer, Integer>();
    }

    @Override
    public String GetProviderName() {
        String s = new String("MPLABCommUSB");
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int CreateToolList(String host, String selection, String subselection, String alternatePortFile) {
        int listHandle;
        int vendorID;
        if (selection.equals("Microchip")) {
            vendorID = 1240;
        } else if (selection.equals("All")) {
            vendorID = -1;
        } else {
            if (!selection.equals("USB") || subselection == null) return -114;
            try {
                vendorID = Integer.valueOf(subselection, 16);
            }
            catch (Exception e) {
                return -139;
            }
        }
        if (alternatePortFile != null && alternatePortFile.length() > 0) {
            this.cAlternateMonitorFile = alternatePortFile.substring(0);
        }
        MPLABCommException.LogInformation("MCSP:USB: enter CreateToolList()");
        if (!this.cListAndVendor.isEmpty()) {
            Set<Integer> mListHandles = this.cListAndVendor.keySet();
            for (int lh : mListHandles) {
                int vid = this.cListAndVendor.get(lh);
                if (vid != vendorID) continue;
                return lh;
            }
        }
        if ((listHandle = this.cUsbAccess.USB_CreateDeviceList(this.cUsbSession, vendorID)) >= 0) {
            this.cListAndVendor.put(listHandle, vendorID);
            HashMap<Integer, ToolInfoObject> toolInfoList = new HashMap<Integer, ToolInfoObject>();
            String[] toolDescriptions = this.cUsbAccess.USB_GetDeviceList(listHandle);
            int key = 0;
            for (String s : toolDescriptions) {
                s = s.substring(1);
                String sTemp = "";
                for (int c = 0; c < s.length(); ++c) {
                    char ch = s.charAt(c);
                    if (ch < ' ' || ch > '~') continue;
                    sTemp = sTemp + ch;
                }
                s = sTemp.substring(0);
                if (s.endsWith("d")) {
                    s = s.substring(0, s.length() - 1);
                }
                ToolInfoObject toolInfo = new ToolInfoObject();
                toolInfo.cCommServiceProvider = this;
                toolInfo.cListId = listHandle;
                toolInfo.cToolIndex = key;
                toolInfo.cDescription = s.substring(0);
                toolInfo.cFullDescription = ":=".substring(0) + this.GetProviderName().substring(0) + s.substring(0);
                toolInfo.cTool = new MPLABCommUSBTool(listHandle, key, this, this.cUsbAccess);
                toolInfo.cTool.SetStatus(0, 1);
                String[] si = this.SplitString(toolInfo.cFullDescription, ":=", false, false);
                toolInfo.cSerialNumber = si[6].substring(0);
                toolInfo.cPidSn = ":=".substring(0) + si[2].substring(0) + ":=".substring(0) + si[6].substring(0);
                toolInfo.cFriendlyName = null;
                toolInfo.cChanged = false;
                toolInfo.cState = 1;
                toolInfoList.put(key, toolInfo);
                ++key;
            }
            this.cToolLists.put(listHandle, toolInfoList);
            MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): check cMonitor");
            if (this.cMonitor == null) {
                MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): create cMonitor");
                this.cMonitor = new MPLABCommUSBMonitor(this);
                if (this.cMonitor == null) throw new MPLABCommException(MPLABCommException.ErrorType.MONITOR_INIT_FAILURE);
                MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): create cMonitor thread");
                this.cMonitorThread = new Thread(this.cMonitor);
                if (this.cMonitorThread == null) throw new MPLABCommException(MPLABCommException.ErrorType.MONITOR_INIT_FAILURE);
                MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): start cMonitor thread");
                try {
                    this.cMonitorThread.start();
                    MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): cMonitor thread started");
                }
                catch (IllegalThreadStateException e) {
                    MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): cMonitor IllegalThreadStateExecption");
                    throw new MPLABCommException(MPLABCommException.ErrorType.MONITOR_THREAD_FAILURE, e);
                }
                catch (Exception e) {
                    MPLABCommException.LogInformation("MCSP:USB:CreateToolList(): cMonitor thread exception");
                    throw new MPLABCommException(MPLABCommException.ErrorType.MONITOR_THREAD_FAILURE, e);
                }
            }
        } else if (this.cUsbSession < 0) {
            listHandle = this.cUsbSession;
        }
        MPLABCommException.LogInformation("MCSP:USB: exit CreateToolList()", listHandle);
        return listHandle;
    }

    @Override
    public synchronized int UpdateToolList(int listId) {
        this.UpdateToolList(null);
        return 0;
    }

    public synchronized void UpdateToolList(String hotplugAction) {
        boolean newDevice = false;
        int result = -131;
        MPLABCommException.LogInformation("MCSP:USB: enter UpdateToolList()");
        Set<Integer> mListHandles = this.cToolLists.keySet();
        for (int listHandle : mListHandles) {
            ToolInfoObject tObj;
            int vendorId = this.cListAndVendor.get(listHandle);
            Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
            result = this.cUsbAccess.USB_UpdateDeviceList(listHandle, vendorId);
            if (result < 0) continue;
            int toolIndex = 0;
            while ((tObj = toolInfoList.get(toolIndex)) != null) {
                tObj.cChanged = true;
                ++toolIndex;
            }
            String[] toolDescriptions = this.cUsbAccess.USB_GetDeviceList(listHandle);
            Object lastDesc = null;
            for (String s : toolDescriptions) {
                MPLABCommException.LogInformation("MCSP:USB: ts: " + s);
                boolean toolPluggedIn = s.startsWith("1");
                s = s.substring(1);
                String sTemp = "";
                for (int c = 0; c < s.length(); ++c) {
                    char ch = s.charAt(c);
                    if (ch < ' ' || ch > '~') continue;
                    sTemp = sTemp + ch;
                }
                s = sTemp.substring(0);
                if (s.endsWith("d")) {
                    s = s.substring(0, s.length() - 1);
                }
                boolean found = false;
                ToolInfoObject toolInfo = new ToolInfoObject();
                toolInfo.cCommServiceProvider = this;
                toolInfo.cListId = listHandle;
                toolInfo.cDescription = s.substring(0);
                toolInfo.cFullDescription = ":=".substring(0) + this.GetProviderName().substring(0) + s.substring(0);
                String[] si = this.SplitString(toolInfo.cFullDescription, ":=", false, false);
                toolInfo.cSerialNumber = si[6].substring(0);
                toolInfo.cPidSn = ":=".substring(0) + si[2].substring(0) + ":=".substring(0) + si[6].substring(0);
                toolInfo.cFriendlyName = null;
                toolInfo.cChanged = false;
                toolInfo.cState = 1;
                toolIndex = 0;
                while ((tObj = toolInfoList.get(toolIndex)) != null) {
                    if (toolInfo.cDescription.equals(tObj.cDescription) && toolInfo.cSerialNumber.equals(tObj.cSerialNumber)) {
                        MPLABCommException.LogInformation("MCSP:USB: in list");
                        if (tObj.cState == 1) {
                            if (toolPluggedIn) {
                                tObj.cChanged = false;
                            } else {
                                MPLABCommException.LogInformation("MCSP:USB: removed");
                                tObj.cTool.clearToolReserved();
                                tObj.cTool.Disconnect();
                                tObj.cState = 0;
                            }
                        } else if (!toolPluggedIn) {
                            tObj.cChanged = false;
                        } else {
                            MPLABCommException.LogInformation("MCSP:USB: added");
                            tObj.cState = 1;
                        }
                        found = true;
                        break;
                    }
                    ++toolIndex;
                }
                if (found) continue;
                MPLABCommException.LogInformation("MCSP:USB: new");
                toolInfo.cToolIndex = toolIndex;
                toolInfo.cTool = new MPLABCommUSBTool(listHandle, toolIndex, this, this.cUsbAccess);
                toolInfo.cTool.SetStatus(0, 1);
                toolInfoList.put(toolIndex, toolInfo);
                this.cToolLists.put(listHandle, toolInfoList);
                this.Notify(new MPLABCommEvent(1, this, listHandle, toolIndex, toolInfo.cTool));
            }
            toolIndex = 0;
            while ((tObj = toolInfoList.get(toolIndex)) != null) {
                if (tObj.cChanged) {
                    tObj.cChanged = false;
                    if (tObj.cState == 1) {
                        MPLABCommException.LogInformation("MCSP:USB: add notify");
                        tObj.cTool.SetStatus(0, 1);
                        this.Notify(new MPLABCommEvent(1, this, listHandle, toolIndex, tObj.cTool));
                        tObj.cTool.Notify(new MPLABCommEvent(1, this, listHandle, toolIndex, tObj.cTool));
                    } else {
                        MPLABCommException.LogInformation("MCSP:USB: remove notify");
                        tObj.cTool.SetStatus(0, 0);
                        this.Notify(new MPLABCommEvent(0, this, listHandle, toolIndex, tObj.cTool));
                        tObj.cTool.Notify(new MPLABCommEvent(0, this, listHandle, toolIndex, tObj.cTool));
                    }
                }
                ++toolIndex;
            }
        }
        MPLABCommException.LogInformation("MCSP:USB: exit UpdateToolList()");
    }

    @Override
    public int ReleaseToolList(int listHandle) {
        MPLABCommException.LogInformation("MCSP:USB: enter ReleaseToolList()");
        this.cMonitor.Cancel();
        MPLABCommException.LogInformation("MCSP:USB: exit ReleaseToolList()");
        return this.cUsbAccess.USB_ReleaseDeviceList(listHandle);
    }

    @Override
    public int GetToolCount(int listHandle) {
        Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
        int count = toolInfoList.size();
        return count;
    }

    @Override
    public Map<Integer, String> GetToolList(int listHandle) {
        ToolInfoObject t;
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
        int key = 0;
        while ((t = toolInfoList.get(key)) != null) {
            nameMap.put(key, t.cFullDescription);
            ++key;
        }
        return nameMap;
    }

    @Override
    public int SetFriendlyName(int listHandle, int toolIndex, String friendlyName) {
        int result = 0;
        try {
            Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
            toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFriendlyName = friendlyName.substring(0);
        }
        catch (Exception e) {
            result = -114;
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommUSBServiceProvider.SetFriendlyName", e);
        }
        return result;
    }

    @Override
    public String GetFriendlyName(int listHandle, int toolIndex) {
        String friendlyName = null;
        try {
            Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
            friendlyName = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFriendlyName.substring(0);
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommUSBServiceProvider.GetFriendlyName", e);
        }
        return friendlyName;
    }

    @Override
    public String GetToolInfo(int listHandle, int toolIndex, int selection) {
        String info = null;
        try {
            Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
            switch (selection) {
                case 0: {
                    info = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cDescription.substring(0);
                    break;
                }
                case 1: {
                    info = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFullDescription.substring(0);
                    break;
                }
                case 2: {
                    info = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cSerialNumber.substring(0);
                    break;
                }
                case 3: {
                    info = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFriendlyName.substring(0);
                    break;
                }
                case 4: {
                    info = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cPidSn.substring(0);
                    break;
                }
                case 5: {
                    info = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cMajMin.substring(0);
                }
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommUSBServiceProvider.GetToolInfo", e);
        }
        return info;
    }

    @Override
    public int GetToolState(int listHandle, int toolIndex, int selection) {
        int result = -114;
        Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
        switch (selection) {
            case 0: {
                ToolInfoObject tObj = toolInfoList.get(toolIndex);
                result = tObj.cState;
            }
        }
        return result;
    }

    @Override
    public synchronized MPLABCommTool ReserveTool(int listHandle, int toolIndex) {
        MPLABCommException.LogInformation("MCSP:USB: enter ReserveTool()");
        MPLABCommUSBTool tool = null;
        try {
            Map<Integer, ToolInfoObject> toolInfoList = this.cToolLists.get(listHandle);
            tool = toolInfoList.get((Object)Integer.valueOf((int)toolIndex)).cTool;
            if (tool.setToolReserved() != 0) {
                tool = null;
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommUSBServiceProvider.ReserveTool", e);
        }
        MPLABCommException.LogInformation("MCSP:USB: exit ReserveTool() " + (tool == null ? "null" : ""));
        return tool;
    }

    @Override
    public synchronized int ReleaseTool(MPLABCommTool tool) {
        MPLABCommException.LogInformation("MCSP:USB: enter ReleaseTool()");
        int result = tool.clearToolReserved();
        MPLABCommException.LogInformation("MCSP:USB: exit ReleaseTool()", result);
        return result;
    }

    public synchronized boolean Attach(Observer who, Object what) {
        boolean result = true;
        if (!cListenerList.contains(who)) {
            result = cListenerList.add(who);
        }
        return result;
    }

    public synchronized boolean Detach(Observer who, Object what) {
        boolean result = cListenerList.contains(who);
        if (result) {
            result = cListenerList.remove(who);
        }
        return result;
    }

    public synchronized void Notify(final Object what) {
        final ArrayList<Observer> listeners = new ArrayList<Observer>(cListenerList);
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (Observer ob : listeners) {
                    ob.Update(what);
                }
            }
        });
        t.start();
    }

    public MPLABCommUSBAccessInterface getUSBAccess() {
        return this.cUsbAccess;
    }

    public String getActiveToolFile() {
        return this.cActiveToolFile;
    }

    public String getAlternatePortFile() {
        return this.cAlternateMonitorFile;
    }

    public String[] SplitString(String src, String del, boolean addLeading, boolean ignoreTrailing) {
        int n;
        int e;
        ArrayList<String> sa = new ArrayList<String>();
        String[] sv = null;
        int s = 0;
        while ((e = src.indexOf(del, s)) != -1) {
            if (e == s) {
                if (e == 0 && addLeading || e != 0) {
                    sa.add("");
                }
            } else {
                sa.add(src.substring(s, e));
            }
            s = e + del.length();
        }
        String t = src.substring(s);
        if (t.length() != 0 || t.length() == 0 && !ignoreTrailing) {
            sa.add(t);
        }
        if ((n = sa.size()) > 0) {
            sv = new String[n];
            int i = 0;
            Iterator i$ = sa.iterator();
            while (i$.hasNext()) {
                String st;
                sv[i] = st = (String)i$.next();
                ++i;
            }
        }
        return sv;
    }
}

