/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class MPLABCommGenericSocketHandler {
    private String cIpAddress;
    private int cPort;
    private Socket cSocket;
    private int cHandle;

    public MPLABCommGenericSocketHandler(int port, String ipAddress) {
        this.cIpAddress = ipAddress;
        this.cPort = port;
        this.cSocket = null;
        this.cHandle = this.hashCode();
        if (this.cHandle < 0) {
            this.cHandle = -this.cHandle;
        }
    }

    public ServerSocket getServerSocket(String ipAddress, int port) {
        try {
            byte[] addr = new byte[4];
            String[] a = ipAddress.split("\\.");
            if (a.length != 4) {
                return null;
            }
            addr[0] = (byte)Integer.parseInt(a[0]);
            addr[1] = (byte)Integer.parseInt(a[1]);
            addr[2] = (byte)Integer.parseInt(a[2]);
            addr[3] = (byte)Integer.parseInt(a[3]);
            ServerSocket ss = new ServerSocket(port, 64, InetAddress.getByAddress(addr));
            return ss;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int releaseServerSocket(ServerSocket ss) {
        int result = 0;
        try {
            ss.close();
        }
        catch (Exception e) {
            result = -103;
        }
        return result;
    }

    public String readServerSocket(ServerSocket ss) {
        String line = null;
        try {
            Socket s = ss.accept();
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            line = in.readLine();
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return line;
    }

    public int readServerSocket(ServerSocket ss, byte[] data) {
        int len = 0;
        int maxLen = data.length;
        try {
            Socket s = ss.accept();
            DataInputStream in = new DataInputStream(s.getInputStream());
            len = in.read(data, 0, maxLen);
            s.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return len;
    }

    public int writeServerSocket(ServerSocket ss, String data) {
        int result = 0;
        try {
            Socket s = ss.accept();
            PrintStream out = new PrintStream(s.getOutputStream());
            out.print(data);
            out.close();
            s.close();
        }
        catch (Exception e) {
            result = -103;
        }
        return result;
    }

    public int writeServerSocket(ServerSocket ss, byte[] data) {
        int result = 0;
        try {
            Socket s = ss.accept();
            PrintStream out = new PrintStream(s.getOutputStream());
            out.write(data);
            out.close();
            s.close();
        }
        catch (Exception e) {
            result = -103;
        }
        return result;
    }

    public Socket getClientSocket(String ipAddress, int port) {
        try {
            byte[] addr = new byte[4];
            String[] a = ipAddress.split("\\.");
            if (a.length != 4) {
                return null;
            }
            addr[0] = (byte)Integer.parseInt(a[0]);
            addr[1] = (byte)Integer.parseInt(a[1]);
            addr[2] = (byte)Integer.parseInt(a[2]);
            addr[3] = (byte)Integer.parseInt(a[3]);
            Socket s = new Socket(InetAddress.getByAddress(addr), port);
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int releaseClientSocket(Socket s) {
        int result = 0;
        try {
            s.close();
        }
        catch (Exception e) {
            result = -103;
        }
        return result;
    }

    public String readClientSocket(Socket s) {
        String line = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            line = in.readLine();
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return line;
    }

    public int readClientSocket(Socket s, byte[] data) {
        int len = 0;
        int maxLen = data.length;
        try {
            DataInputStream in = new DataInputStream(s.getInputStream());
            len = in.read(data, 0, maxLen);
            s.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return len;
    }

    public int writeClientSocket(Socket s, String data) {
        int result = 0;
        try {
            PrintStream out = new PrintStream(s.getOutputStream());
            out.print(data);
            out.close();
            s.close();
        }
        catch (Exception e) {
            result = -103;
        }
        return result;
    }

    public int writeClientSocket(Socket s, byte[] data) {
        int result = 0;
        try {
            PrintStream out = new PrintStream(s.getOutputStream());
            out.write(data);
            out.close();
            s.close();
        }
        catch (Exception e) {
            result = -103;
        }
        return result;
    }

    public int openSocket() {
        if (this.cSocket != null) {
            return -105;
        }
        try {
            this.cSocket = new Socket(this.cIpAddress, this.cPort);
        }
        catch (Exception e) {
            return -107;
        }
        return this.cHandle;
    }

    public int closeSocket() {
        if (this.cSocket == null) {
            return -109;
        }
        try {
            this.cSocket.close();
            this.cSocket = null;
            this.cHandle = -103;
        }
        catch (Exception e) {
            return -132;
        }
        return 0;
    }

    public int writeSocket(String s) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(this.cSocket.getOutputStream());
            oos.writeObject(s);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            return -135;
        }
        return 0;
    }

    public String readSocket() {
        String response = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(this.cSocket.getInputStream());
            response = (String)ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }
}

