/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

public class MPLABCommSerialAccess {
    int cSessionID = -1;
    int DeviceListCount = 0;
    String[] DeviceNameList;

    private native int serialInitialize();

    private native int serialRelease(int var1);

    private native int serialCreateDeviceList(int var1, int var2, int var3);

    private native int serialCreateNamedDeviceList(int var1, int var2, int var3, String var4, boolean var5);

    private native int serialUpdateDeviceList(int var1);

    private native int serialReleaseDeviceList(int var1);

    private native int serialGetDeviceListCount(int var1);

    private native String serialGetDeviceInfo(int var1, int var2);

    private native int serialOpenDevice(int var1, int var2);

    private native int serialCloseDevice(int var1, int var2);

    private native int serialResetDevice(int var1, int var2);

    private native int serialWritePort(int var1, int var2, int var3, int var4, byte[] var5);

    private native int serialReadPort(int var1, int var2, int var3, int var4, byte[] var5);

    private native int serialCancelPortTransfer(int var1, int var2);

    private native int serialGetConfigurationDescriptor(int var1, int var2, int var3, byte[] var4);

    private native int serialSetConfigurationDescriptor(int var1, int var2, int var3, byte[] var4);

    public int Initialize(String serialAccessLibName) {
        int result;
        if (this.cSessionID == -1) {
            try {
                System.loadLibrary(serialAccessLibName);
                result = this.serialInitialize();
                if (result >= 0) {
                    this.cSessionID = result;
                }
            }
            catch (UnsatisfiedLinkError e) {
                result = -137;
            }
        } else {
            result = -115;
        }
        return result;
    }

    public int Release(int sessionId) {
        int result;
        if (this.cSessionID >= 0 && sessionId == this.cSessionID) {
            result = this.serialRelease(this.cSessionID);
            this.cSessionID = -1;
        } else {
            result = -116;
        }
        return result;
    }

    public synchronized int CreateDeviceList(int sessionId, int begin, int end, String altPortName, boolean append) {
        int listHandle = sessionId == this.cSessionID ? (altPortName == null ? this.serialCreateDeviceList(sessionId, begin, end) : this.serialCreateNamedDeviceList(sessionId, begin, end, altPortName, append)) : -116;
        return listHandle;
    }

    public synchronized int UpdateDeviceList(int listHandle) {
        int result = this.serialUpdateDeviceList(listHandle);
        return result;
    }

    public synchronized int ReleaseDeviceList(int listHandle) {
        int result = this.serialReleaseDeviceList(listHandle);
        return result;
    }

    public synchronized String[] GetDeviceList(int listHandle) {
        int count = this.serialGetDeviceListCount(listHandle);
        String[] deviceList = new String[count];
        for (int i = 0; i < count; ++i) {
            deviceList[i] = this.serialGetDeviceInfo(listHandle, i);
        }
        return deviceList;
    }

    public synchronized int GetDeviceCount(int listHandle) {
        int count = this.serialGetDeviceListCount(listHandle);
        return count;
    }

    public synchronized int OpenDevice(int listHandle, int deviceIndex) {
        int result = this.serialOpenDevice(listHandle, deviceIndex);
        return result;
    }

    public synchronized int CloseDevice(int listHandle, int deviceIndex) {
        int result = this.serialCloseDevice(listHandle, deviceIndex);
        return result;
    }

    public synchronized int ResetDevice(int listHandle, int deviceIndex) {
        int result = this.serialResetDevice(listHandle, deviceIndex);
        return result;
    }

    public synchronized int WritePort(int listHandle, int deviceIndex, int timeout, int byteCount, byte[] data) {
        int result = this.serialWritePort(listHandle, deviceIndex, timeout, byteCount, data);
        return result;
    }

    public synchronized int ReadPort(int listHandle, int deviceIndex, int timeout, int byteCount, byte[] data) {
        int result = this.serialReadPort(listHandle, deviceIndex, timeout, byteCount, data);
        return result;
    }

    public synchronized int CancelPortTransfer(int listHandle, int deviceIndex) {
        int result = this.serialCancelPortTransfer(listHandle, deviceIndex);
        return result;
    }

    public synchronized int GetConfigurationDescriptor(int listHandle, int deviceIndex, int bufferLength, byte[] buffer) {
        int result = this.serialGetConfigurationDescriptor(listHandle, deviceIndex, bufferLength, buffer);
        return result;
    }

    public synchronized int SetConfigurationDescriptor(int listHandle, int deviceIndex, int bufferLength, byte[] buffer) {
        int result = this.serialSetConfigurationDescriptor(listHandle, deviceIndex, bufferLength, buffer);
        return result;
    }
}

