/*
 * Decompiled with CFR 0.152.
 */
package serialport.classes;

import BootloaderView.AppContext.AppContext;
import com.microchip.mplab.comm.MPLABCommCompletionInterface;
import com.microchip.mplab.comm.MPLABCommException;
import com.microchip.mplab.comm.MPLABCommProviderInterface;
import com.microchip.mplab.comm.MPLABCommTool;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import serialport.classes.MyToolObject;
import serialport.interfaces.CommInterface;

public class SerialPort
implements CommInterface {
    private static Map<Integer, MyToolObject> serialToolMap;
    private static MPLABCommProviderInterface pI;
    private static MPLABCommTool tool;

    public static Map<Integer, MyToolObject> getPortListInit() {
        Map toolNameMap;
        MPLABCommException.LogEnable((boolean)false);
        Lookup cServicesLookup = Lookup.getDefault();
        Lookup.Template cServicesTemplate = new Lookup.Template(MPLABCommProviderInterface.class);
        Lookup.Result cServicesResults = cServicesLookup.lookup(cServicesTemplate);
        Collection cServices = cServicesResults.allInstances();
        Iterator i$ = cServices.iterator();
        if (i$.hasNext()) {
            MPLABCommProviderInterface mspi;
            pI = mspi = (MPLABCommProviderInterface)i$.next();
        }
        if ((toolNameMap = pI.GetCurrentToolList(null, "Microchip", null, null)) == null) {
            System.out.println("ERROR: GetCurrentToolList() failed (likely an invalid selection)");
            return null;
        }
        Map resultMap = pI.GetProviderLoadResults();
        Set resProv = resultMap.keySet();
        int rm = 0;
        if (AppContext.debugEnable) {
            System.out.println("****_Service_Provider_Load_Result_Map_Test_****************");
            System.out.println("Provider\t\tResult");
            System.out.println("--------\t\t------");
        }
        for (String rs : resProv) {
            rm = (Integer)resultMap.get(rs);
            if (!AppContext.debugEnable) continue;
            System.out.println("\t\thtgjkhfjghjkgn" + rm);
        }
        if (AppContext.debugEnable) {
            System.out.println("***********************************************************");
        }
        if (rm < 0) {
            return null;
        }
        if (AppContext.debugEnable) {
            System.out.println("**** Device List ******************************************");
        }
        if (!toolNameMap.isEmpty()) {
            serialToolMap = new HashMap<Integer, MyToolObject>();
            Set keySet = toolNameMap.keySet();
            int index = 0;
            Iterator i$2 = keySet.iterator();
            while (i$2.hasNext()) {
                int k = (Integer)i$2.next();
                String desc = (String)toolNameMap.get(k);
                if (!desc.contains("COM")) continue;
                MyToolObject sto = new MyToolObject(k, desc);
                serialToolMap.put(index, sto);
                ++index;
            }
            if (AppContext.debugEnable) {
                System.out.println("Done");
            }
            return serialToolMap;
        }
        if (AppContext.debugEnable) {
            System.out.println("List is empty");
            System.out.println("Done");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int connectToSerialPort(int index) {
        int tRes;
        AppContext.lockTool.lock();
        try {
            int firstIndex = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)index)).cToolDescription.indexOf("COM");
            int lastIndex = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)index)).cToolDescription.lastIndexOf(58);
            AppContext.connectedPortName = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)index)).cToolDescription.substring(firstIndex, lastIndex);
            int toolKey = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)index)).cToolKey;
            tool = pI.GetTool(toolKey);
            if (AppContext.debugEnable) {
                System.out.println("#### SERIAL DEVICE ###################################");
                System.out.println("[Index=" + index + "]");
            }
            if ((tRes = tool.Connect()) == 0 && AppContext.debugEnable) {
                System.out.println("Connect result=" + tRes);
            }
            pI.ReleaseTool(toolKey, tool);
        }
        finally {
            AppContext.lockTool.unlock();
        }
        return tRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] data, MPLABCommCompletionInterface completionHandler, int timeoutMS) {
        int byte_count = 0;
        AppContext.lockTool.lock();
        try {
            int toolKey = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)AppContext.getIndexWhenConnected())).cToolKey;
            tool = pI.GetTool(toolKey);
            byte_count = tool.WritePipe(0, 0, data.length, data, completionHandler, timeoutMS);
            pI.ReleaseTool(toolKey, tool);
        }
        finally {
            AppContext.lockTool.unlock();
        }
        return byte_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] data, MPLABCommCompletionInterface completionHandler, int timeoutMS) {
        int byte_count = 0;
        AppContext.lockTool.lock();
        try {
            int toolKey = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)AppContext.getIndexWhenConnected())).cToolKey;
            tool = pI.GetTool(toolKey);
            byte_count = tool.ReadPipe(6, 6, data.length - 1, data, completionHandler, timeoutMS);
            pI.ReleaseTool(toolKey, tool);
        }
        finally {
            AppContext.lockTool.unlock();
        }
        return byte_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int disconnectSerialPort(int index) {
        int tRes;
        AppContext.lockTool.lock();
        try {
            int toolKey = SerialPort.serialToolMap.get((Object)Integer.valueOf((int)index)).cToolKey;
            tool = pI.GetTool(toolKey);
            tRes = tool.Disconnect();
            pI.ReleaseTool(toolKey, tool);
            byte checkHex = (byte)Integer.parseInt("AF", 16);
            if (AppContext.debugEnable) {
                System.out.println(String.format("The Hex number is: 0x%1$02X", checkHex));
            }
        }
        finally {
            AppContext.lockTool.unlock();
        }
        return tRes;
    }

    static {
        pI = null;
    }
}

