/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommException;
import com.microchip.mplab.comm.MPLABCommUSBServiceProvider;
import com.microchip.mplab.open.util.pathretrieval.PathRetrieval;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class MPLABCommUSBMonitor
implements Runnable {
    private MPLABCommUSBServiceProvider cServiceProvider;
    private boolean cCancelled;
    private String cDefaultHostPortFile;

    public MPLABCommUSBMonitor(MPLABCommUSBServiceProvider serviceProvider) {
        this.cServiceProvider = serviceProvider;
        this.cDefaultHostPortFile = null;
        String s = this.cServiceProvider.getAlternatePortFile();
        if (s != null) {
            this.cDefaultHostPortFile = s.substring(0);
        }
        this.cCancelled = false;
    }

    public void run() {
        String hostInfo = "localhost";
        int port = 30000;
        this.cCancelled = false;
        if (this.cDefaultHostPortFile == null) {
            this.cDefaultHostPortFile = PathRetrieval.getPath(MPLABCommUSBMonitor.class);
            this.cDefaultHostPortFile = this.cDefaultHostPortFile + "mchpdefport";
        }
        BufferedReader in = null;
        boolean found = false;
        try {
            in = new BufferedReader(new FileReader(this.cDefaultHostPortFile));
            found = true;
        }
        catch (FileNotFoundException e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.JARLOC_PORT_FILE_NOT_FOUND);
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.DEFAULT_PORT_FILE_IO_ERROR);
        }
        if (!found) {
            try {
                this.cDefaultHostPortFile = "/etc/.mplab_ide/mchpdefport";
                in = new BufferedReader(new FileReader(this.cDefaultHostPortFile));
                found = true;
            }
            catch (FileNotFoundException e) {
                MPLABCommException.LogWarning(MPLABCommException.ErrorType.DEFAULT_PORT_FILE_NOT_FOUND);
            }
            catch (Exception e) {
                MPLABCommException.LogWarning(MPLABCommException.ErrorType.DEFAULT_PORT_FILE_IO_ERROR);
            }
        }
        if (found) {
            try {
                String aHPTemp = in.readLine();
                if (aHPTemp != null) {
                    hostInfo = aHPTemp.toString();
                    aHPTemp = in.readLine();
                    if (aHPTemp != null) {
                        port = Integer.parseInt(aHPTemp);
                    }
                }
                in.close();
            }
            catch (Exception e) {
                MPLABCommException.LogWarning(MPLABCommException.ErrorType.DEFAULT_PORT_FILE_IO_ERROR);
            }
        }
        MPLABCommException.LogInformation("MonitorRun: entering loop");
        try {
            ServerSocket server = new ServerSocket(port, 64, InetAddress.getByName(hostInfo));
            while (!this.cCancelled) {
                Socket incoming = server.accept();
                in = new BufferedReader(new InputStreamReader(incoming.getInputStream()));
                String line = in.readLine();
                MPLABCommException.LogInformation("MonitorRun: line read");
                if (line != null) {
                    MPLABCommException.LogInformation("MonitorRun: process line / calling UpdateToolList");
                    if (line.startsWith("a")) {
                        Thread.sleep(1000L);
                    }
                    this.cServiceProvider.UpdateToolList(line);
                }
                incoming.close();
            }
            server.close();
            MPLABCommException.LogInformation("MonitorRun: exiting loop");
        }
        catch (UnknownHostException e) {
            MPLABCommException.LogInformation("MonitorRun: Socket: HOST_NOT_FOUND (UnknownHostException)");
            throw new MPLABCommException(MPLABCommException.ErrorType.HOST_NOT_FOUND, e);
        }
        catch (IOException e) {
            MPLABCommException.LogInformation("MonitorRun: Socket: SOCKET_FAILURE (IOException)");
            throw new MPLABCommException(MPLABCommException.ErrorType.SOCKET_FAILURE, e);
        }
        catch (Exception e) {
            MPLABCommException.LogInformation("MonitorRun: Socket: SOCKET_FAILURE (Exception)");
            throw new MPLABCommException(MPLABCommException.ErrorType.SOCKET_FAILURE, e);
        }
    }

    public void Cancel() {
        this.cCancelled = true;
    }
}

