/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.logger.MPLABLogger;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class MPLABCommException
extends RuntimeException {
    private String LogErrorHeader = "MPLABComm Fatal Exception: ";
    private static String LogHeader = "MPLABComm: ";
    private static String LogDebugHeader = "MPLABComm Debug: ";
    private static boolean LogEnable = true;

    public MPLABCommException(ErrorType eType) {
        super(eType.getErrorDescription());
        MPLABLogger.mplog.log(Level.SEVERE, this.LogErrorHeader + eType.getErrorDescription());
    }

    public MPLABCommException(ErrorType eType, String moreDesc) {
        super(eType.getErrorDescription() + moreDesc);
        MPLABLogger.mplog.log(Level.SEVERE, this.LogErrorHeader + eType.getErrorDescription());
    }

    public MPLABCommException(ErrorType eType, Exception e) {
        super(eType.getErrorDescription(), e);
        MPLABLogger.mplog.log(Level.SEVERE, this.LogErrorHeader + eType.getErrorDescription());
    }

    public MPLABCommException(ErrorType eType, String moreDesc, Exception e) {
        super(eType.getErrorDescription() + moreDesc, e);
        MPLABLogger.mplog.log(Level.SEVERE, this.LogErrorHeader + eType.getErrorDescription());
    }

    public static void LogWarning(ErrorType eType) {
        if (LogEnable) {
            MPLABLogger.mplog.log(Level.WARNING, LogHeader + eType.getErrorDescription());
        }
    }

    public static void LogWarning(ErrorType eType, Exception e) {
        if (LogEnable) {
            MPLABLogger.mplog.log(Level.WARNING, LogHeader + "(1) " + eType.getErrorDescription());
            MPLABLogger.mplog.log(Level.WARNING, LogHeader + "(2) " + e.getMessage());
        }
    }

    public static void LogWarning(ErrorType eType, String source, Exception e) {
        if (LogEnable) {
            MPLABLogger.mplog.log(Level.WARNING, LogHeader + source + " (1) " + eType.getErrorDescription());
            MPLABLogger.mplog.log(Level.WARNING, LogHeader + source + " (2) " + e.getMessage());
        }
    }

    public static void LogInformation(String info) {
        if (LogEnable) {
            MPLABLogger.mplog.log(Level.FINEST, LogHeader + info);
        }
    }

    public static void LogInformation(String info, int returnValue) {
        if (LogEnable) {
            MPLABLogger.mplog.log(Level.FINEST, LogHeader + info + " : " + returnValue);
        }
    }

    public static void LogInformation(String info, byte[] data, int count) {
        if (LogEnable) {
            String dumpBuf = " <no data>";
            if (count == 0) {
                dumpBuf = " count=0";
            } else if (count < 0) {
                dumpBuf = " Error=" + count;
            } else {
                dumpBuf = "";
                for (int i = 0; i < count; ++i) {
                    if (i % 16 == 0) {
                        dumpBuf = dumpBuf + "\n";
                    }
                    dumpBuf = dumpBuf + String.format("%02X ", data[i]);
                }
                dumpBuf = dumpBuf + "\n";
            }
            MPLABLogger.mplog.log(Level.FINEST, LogHeader + info + dumpBuf);
        }
    }

    public static void LogDebugInformation(String info) {
        if (LogEnable) {
            MPLABLogger.mplog.log(Level.WARNING, LogDebugHeader + info);
        }
    }

    public static void LogEnable(boolean state) {
        LogEnable = state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        NO_ERROR,
        SOCKET_FAILURE,
        HOST_NOT_FOUND,
        DEFAULT_PORT_FILE_NOT_FOUND,
        DEFAULT_PORT_FILE_IO_ERROR,
        EXCEPTION_NOT_AN_ERROR,
        HOTPLUG_FILE_NOT_FOUND,
        MONITOR_THREAD_FAILURE,
        MONITOR_INIT_FAILURE,
        JARLOC_PORT_FILE_NOT_FOUND;


        String getErrorDescription() {
            return ResourceBundle.getBundle("com/microchip/mplab/comm/MPLABCommExceptionStrings").getString(this.toString());
        }
    }
}

