/*
 * Decompiled with CFR 0.152.
 */
package protocol.write.nextchunkgetter;

import BootloaderView.AppContext.AppContext;
import protocol.write.nextchunkgetter.dataChunk;
import protocol.write.nextchunkgetter.state.memoryState;

public class GetNextByte {
    public int cursorStart = 1536;
    public int cursor = 0;
    public memoryState mem = memoryState.NONE;
    boolean skipBlanks;
    public int programMemorySize;
    public int eepromMemorySize;
    public int conmMemorySize;
    public int eepromOffset;
    public int configBitsOffset;
    public byte[] eepromMemory = null;
    public byte[] programMemory = null;
    public byte[] configurationWords = null;
    private final int dataBlockDivisor = 64;

    public void rewind() {
        this.cursor = this.cursorStart;
    }

    public void init() {
        this.mem = this.programMemory == null || this.eepromMemory == null ? memoryState.NONE : memoryState.PROGRAM_MEMORY;
        this.rewind();
        this.skipBlanks = false;
    }

    public dataChunk getData() {
        dataChunk result;
        block1: {
            result = null;
            if (!(this.skipBlanks & (result = this.getNextChunk()) != null)) break block1;
            while (result.noData && (result = this.getNextChunk()) != null) {
            }
        }
        return result;
    }

    private dataChunk getNextChunk() {
        dataChunk result = new dataChunk();
        result.noData = true;
        switch (this.mem) {
            case PROGRAM_MEMORY: {
                int i;
                result.address = this.cursor;
                result.length = 64;
                result.data = new byte[result.length];
                for (i = 0; i < result.length; ++i) {
                    result.data[i] = -1;
                }
                for (i = 0; i < result.length; ++i) {
                    int mask = !AppContext.pic18DeviceWhenCaptured ? (this.cursor % 2 == 0 ? -1 : 63) : -1;
                    result.data[i] = this.programMemory[this.cursor++];
                    if ((result.data[i] ^ mask) != 0) {
                        result.noData = false;
                    }
                    if (this.cursor >= this.programMemorySize) break;
                }
                if (this.cursor >= this.programMemorySize) {
                    this.cursor = 0;
                    this.mem = memoryState.EEPROM_MEMORY;
                }
                if (this.cursor == 0) break;
                AppContext.swingEditorObj.disp(this.cursor);
                break;
            }
            case EEPROM_MEMORY: {
                result.address = this.cursor + this.eepromOffset;
                result.length = 64;
                result.data = new byte[result.length];
                for (int i = 0; i < result.length; ++i) {
                    result.data[i] = this.eepromMemory[this.cursor];
                    if (AppContext.debugEnable) {
                        System.out.println(String.format("The temp dataXXXXXXX address :%02X ", this.eepromMemory[this.cursor]));
                    }
                    if (!AppContext.pic18DeviceWhenCaptured) {
                        ++this.cursor;
                        ++this.cursor;
                    } else {
                        ++this.cursor;
                    }
                    if (~result.data[i] != 0) {
                        result.noData = false;
                    }
                    if (this.cursor >= this.eepromMemorySize) break;
                }
                if (this.cursor >= this.eepromMemorySize) {
                    if (AppContext.debugEnable) {
                        System.out.println("I am in eeprom");
                    }
                    this.cursor = 0;
                    this.mem = !AppContext.pic18DeviceWhenCaptured ? memoryState.NONE : memoryState.CONFIG_WORDS;
                }
                AppContext.swingEditorObj.disp(this.cursor + this.programMemorySize);
                break;
            }
            case CONFIG_WORDS: {
                result.address = this.cursor + this.configBitsOffset;
                result.length = 14;
                result.data = new byte[result.length];
                for (int i = 0; i < result.length; ++i) {
                    result.data[i] = this.configurationWords[this.cursor++];
                    if (~result.data[i] != 0) {
                        result.noData = false;
                    }
                    if (this.cursor >= this.conmMemorySize) break;
                }
                if (this.cursor >= this.conmMemorySize) {
                    if (AppContext.debugEnable) {
                        System.out.println("I am in configwords");
                    }
                    this.cursor = 0;
                    this.mem = memoryState.NONE;
                }
                AppContext.swingEditorObj.disp(this.cursor + this.conmMemorySize);
                break;
            }
            case NONE: {
                result = null;
            }
        }
        if (result != null) {
            if (AppContext.debugEnable) {
                System.out.println("GetChunk: " + (Object)((Object)this.mem) + " , " + this.cursor + " , " + result.noData);
            }
        } else if (AppContext.debugEnable) {
            System.out.println("GetChunk: " + (Object)((Object)this.mem) + " , " + this.cursor + " , " + "null");
        }
        return result;
    }
}

