/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommException;
import com.microchip.mplab.comm.MPLABCommSerialAccess;
import com.microchip.mplab.comm.MPLABCommSerialTool;
import com.microchip.mplab.comm.MPLABCommServiceProviderInterface;
import com.microchip.mplab.comm.MPLABCommTool;
import com.microchip.mplab.comm.PortInfoObject;
import com.microchip.mplab.util.observers.Observer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPLABCommSerialServiceProvider
implements MPLABCommServiceProviderInterface {
    private String cJNILinkLibraryName = "SerialAccessLink";
    private MPLABCommSerialAccess cSerialAccess = new MPLABCommSerialAccess();
    private int cSerialSession = this.cSerialAccess.Initialize(this.cJNILinkLibraryName);
    private String cAlternatePortFile;
    private static ArrayList<Observer> cListenerList = null;
    private Map<Integer, Map<Integer, PortInfoObject>> cToolLists = new HashMap<Integer, Map<Integer, PortInfoObject>>();
    private Map<Integer, String> cListAndPortString;
    private int cBeginCOM;
    private int cEndCOM;

    public MPLABCommSerialServiceProvider() {
        cListenerList = new ArrayList();
        this.cAlternatePortFile = null;
        this.cListAndPortString = new HashMap<Integer, String>();
        this.cBeginCOM = 1;
        this.cEndCOM = 100;
    }

    @Override
    public String GetProviderName() {
        String s = new String("MPLABCommSerialPort");
        return s;
    }

    @Override
    public int CreateToolList(String host, String selection, String subselection, String alternatePortFile) {
        int listHandle;
        int vendorID;
        String altPortString = null;
        boolean appendFlag = false;
        if (selection.equals("Microchip")) {
            vendorID = 1240;
        } else if (selection.equals("All")) {
            vendorID = -1;
        } else if (selection.equals("SERIAL") && subselection == null) {
            vendorID = 1240;
        } else if (selection.equals("SERIAL") && subselection != null) {
            try {
                altPortString = subselection.substring(0);
            }
            catch (Exception e) {
                return -139;
            }
        } else {
            return -114;
        }
        if (alternatePortFile != null && alternatePortFile.length() > 0) {
            this.cAlternatePortFile = alternatePortFile.substring(0);
        }
        if (altPortString != null && altPortString.contains("%")) {
            appendFlag = true;
        }
        if (!this.cListAndPortString.isEmpty()) {
            Set<Integer> mListHandles = this.cListAndPortString.keySet();
            boolean f = false;
            int lstHnd = -114;
            for (int lh : mListHandles) {
                String alt = this.cListAndPortString.get(lh);
                if (alt == null && alternatePortFile == null) {
                    f = true;
                    lstHnd = lh;
                    break;
                }
                if (alt == null || alternatePortFile == null || !alt.equals(alternatePortFile)) continue;
                f = true;
                lstHnd = lh;
                break;
            }
            if (f) {
                int uRes = this.UpdateToolList(lstHnd);
                if (uRes == 0) {
                    return lstHnd;
                }
                return uRes;
            }
        }
        if ((listHandle = this.cSerialAccess.CreateDeviceList(this.cSerialSession, this.cBeginCOM, this.cEndCOM, altPortString, appendFlag)) >= 0) {
            this.cListAndPortString.put(listHandle, altPortString);
            HashMap<Integer, PortInfoObject> toolInfoList = new HashMap<Integer, PortInfoObject>();
            String[] toolDescriptions = this.cSerialAccess.GetDeviceList(listHandle);
            int key = 0;
            for (String s : toolDescriptions) {
                s = s.substring(1);
                PortInfoObject toolInfo = new PortInfoObject();
                toolInfo.cCommServiceProvider = this;
                toolInfo.cListId = listHandle;
                toolInfo.cToolIndex = key;
                toolInfo.cDescription = s.substring(0);
                toolInfo.cFullDescription = ":=".substring(0) + this.GetProviderName().substring(0) + s.substring(0);
                toolInfo.cTool = new MPLABCommSerialTool(listHandle, key, this, this.cSerialAccess);
                toolInfo.cFriendlyName = null;
                toolInfo.cChanged = false;
                toolInfo.cState = 1;
                toolInfoList.put(key, toolInfo);
                ++key;
            }
            this.cToolLists.put(listHandle, toolInfoList);
        } else if (this.cSerialSession < 0) {
            listHandle = this.cSerialSession;
        }
        return listHandle;
    }

    @Override
    public synchronized int UpdateToolList(int listHandle) {
        int result = this.cSerialAccess.UpdateDeviceList(listHandle);
        if (result == 0) {
            String[] toolDescriptions = this.cSerialAccess.GetDeviceList(listHandle);
            Map<Integer, PortInfoObject> toolInfoList = this.cToolLists.get(listHandle);
            for (String s : toolDescriptions) {
                s = s.substring(1);
                String fs = ":=".substring(0) + this.GetProviderName().substring(0) + s.substring(0);
                int key = 0;
                boolean found = false;
                while (toolInfoList.containsKey(key)) {
                    PortInfoObject pio = toolInfoList.get(key);
                    if (pio.cFullDescription.equals(fs)) {
                        found = true;
                        break;
                    }
                    ++key;
                }
                if (found) continue;
                PortInfoObject toolInfo = new PortInfoObject();
                toolInfo.cCommServiceProvider = this;
                toolInfo.cListId = listHandle;
                toolInfo.cToolIndex = key;
                toolInfo.cDescription = s.substring(0);
                toolInfo.cFullDescription = ":=".substring(0) + this.GetProviderName().substring(0) + s.substring(0);
                toolInfo.cTool = new MPLABCommSerialTool(listHandle, key, this, this.cSerialAccess);
                toolInfo.cFriendlyName = null;
                toolInfo.cChanged = false;
                toolInfo.cState = 1;
                toolInfoList.put(key, toolInfo);
            }
        }
        return result;
    }

    public synchronized void UpdateToolList(String hotplugAction) {
    }

    @Override
    public int ReleaseToolList(int listHandle) {
        return this.cSerialAccess.ReleaseDeviceList(listHandle);
    }

    @Override
    public int GetToolCount(int listHandle) {
        Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
        int count = portInfoList.size();
        return count;
    }

    @Override
    public Map<Integer, String> GetToolList(int listHandle) {
        PortInfoObject t;
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
        int key = 0;
        while ((t = portInfoList.get(key)) != null) {
            nameMap.put(key, t.cFullDescription);
            ++key;
        }
        return nameMap;
    }

    @Override
    public int SetFriendlyName(int listHandle, int toolIndex, String friendlyName) {
        int result = 0;
        try {
            Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
            portInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFriendlyName = friendlyName.substring(0);
        }
        catch (Exception e) {
            result = -114;
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommSerialServiceProvider.SetFriendlyName", e);
        }
        return result;
    }

    @Override
    public String GetFriendlyName(int listHandle, int toolIndex) {
        String friendlyName = null;
        try {
            Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
            friendlyName = portInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFriendlyName.substring(0);
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommSerialServiceProvider.GetFriendlyName", e);
        }
        return friendlyName;
    }

    @Override
    public String GetToolInfo(int listHandle, int toolIndex, int selection) {
        String info = null;
        try {
            Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
            switch (selection) {
                case 0: {
                    info = portInfoList.get((Object)Integer.valueOf((int)toolIndex)).cDescription.substring(0);
                    break;
                }
                case 1: {
                    info = portInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFullDescription.substring(0);
                    break;
                }
                case 3: {
                    info = portInfoList.get((Object)Integer.valueOf((int)toolIndex)).cFriendlyName.substring(0);
                    break;
                }
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommSerialServiceProvider.GetToolInfo", e);
        }
        return info;
    }

    @Override
    public int GetToolState(int listHandle, int toolIndex, int selection) {
        int result = -114;
        Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
        switch (selection) {
            case 0: {
                PortInfoObject tObj = portInfoList.get(toolIndex);
                result = tObj.cState;
            }
        }
        return result;
    }

    @Override
    public MPLABCommTool ReserveTool(int listHandle, int toolIndex) {
        MPLABCommSerialTool tool = null;
        try {
            Map<Integer, PortInfoObject> portInfoList = this.cToolLists.get(listHandle);
            tool = portInfoList.get((Object)Integer.valueOf((int)toolIndex)).cTool;
            if (tool.setToolReserved() != 0) {
                tool = null;
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommSerialServiceProvider.ReserveTool", e);
        }
        return tool;
    }

    @Override
    public int ReleaseTool(MPLABCommTool tool) {
        int result = tool.clearToolReserved();
        return result;
    }

    public synchronized boolean Attach(Observer who, Object what) {
        boolean result = true;
        if (!cListenerList.contains(who)) {
            result = cListenerList.add(who);
        }
        return result;
    }

    public synchronized boolean Detach(Observer who, Object what) {
        boolean result = cListenerList.contains(who);
        if (result) {
            result = cListenerList.remove(who);
        }
        return result;
    }

    public synchronized void Notify(final Object what) {
        final ArrayList<Observer> listeners = new ArrayList<Observer>(cListenerList);
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (Observer ob : listeners) {
                    ob.Update(what);
                }
            }
        });
        t.start();
    }
}

