/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommEvent;
import com.microchip.mplab.comm.MPLABCommException;
import com.microchip.mplab.comm.MPLABCommProviderInterface;
import com.microchip.mplab.comm.MPLABCommServiceProviderInterface;
import com.microchip.mplab.comm.MPLABCommServiceProviderLoader;
import com.microchip.mplab.comm.MPLABCommTool;
import com.microchip.mplab.comm.ToolInformation;
import com.microchip.mplab.util.observers.Observer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPLABCommProvider
implements MPLABCommProviderInterface {
    private static int cProviderActive = 0;
    private static String cFriendlyNameFile = null;
    private static MPLABCommServiceProviderLoader cCommProvidersLoader = null;
    private static Map<Integer, MPLABCommServiceProviderInterface> cCommProvidersMap = null;
    private static Map<String, Integer> cCommProviderListLoadResult = null;
    private static int cNextToolListKey = 0;
    private static Map<Integer, String> cToolNameList = null;
    private static Map<Integer, ToolInformation> cToolInformationMap;

    protected void finalize() throws Throwable {
        MPLABCommServiceProviderInterface sp;
        HashMap<MPLABCommServiceProviderInterface, ArrayList> spList = new HashMap<MPLABCommServiceProviderInterface, ArrayList>();
        for (Map.Entry<Integer, ToolInformation> entry : cToolInformationMap.entrySet()) {
            ArrayList al;
            ToolInformation ti = entry.getValue();
            sp = ti.cServiceProvider;
            int lid = ti.cServiceProviderListId;
            if (spList.containsKey(sp)) {
                al = (ArrayList)spList.get(sp);
                if (al.contains(lid)) continue;
                al.add(lid);
                spList.put(sp, al);
                continue;
            }
            al = new ArrayList();
            al.add(lid);
            spList.put(sp, al);
        }
        for (Map.Entry<Integer, ToolInformation> entry : spList.entrySet()) {
            sp = (MPLABCommServiceProviderInterface)((Object)entry.getKey());
            ArrayList al = (ArrayList)((Object)entry.getValue());
            Iterator i$ = al.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                sp.ReleaseToolList(i);
            }
        }
        super.finalize();
    }

    @Override
    public Map<Integer, String> GetCurrentToolList(String host, String selection, String subselection, String alternateMonitorFile) {
        MPLABCommServiceProviderInterface tProvider;
        int devCount;
        Map<Integer, String> devMap;
        if (cProviderActive == 0) {
            MPLABCommException.LogInformation("MCP: enter GetCurrentToolList() first time");
            cProviderActive = 1;
            cToolNameList = new HashMap<Integer, String>();
            cCommProviderListLoadResult = new HashMap<String, Integer>();
            cCommProvidersLoader = MPLABCommServiceProviderLoader.getInstance();
            cCommProvidersMap = cCommProvidersLoader.getProviderObjectMap();
            cToolInformationMap = new HashMap<Integer, ToolInformation>();
            boolean noError = true;
            String fns = System.getProperty("user.home");
            fns = fns.contains("\\") ? fns + "\\.mplabcomm" : fns + "/.mplabcomm";
            File fnf = new File(fns);
            if (fnf != null) {
                if (!fnf.exists() && !fnf.mkdir()) {
                    noError = false;
                }
            } else {
                noError = false;
            }
            if (noError) {
                fns = fns.contains("\\") ? fns + "\\friendlynames.txt" : fns + "/friendlynames.txt";
                cFriendlyNameFile = fns.substring(0);
                File fnk = new File(fns);
                if (!fnk.exists()) {
                    try {
                        fnk.createNewFile();
                    }
                    catch (Exception e) {
                        noError = false;
                    }
                }
            }
            if (!noError) {
                cFriendlyNameFile = "friendlynames.txt";
            }
        }
        HashMap<Integer, String> toolMap = new HashMap<Integer, String>();
        if (!cToolInformationMap.isEmpty()) {
            int listId = 0;
            MPLABCommServiceProviderInterface sp = null;
            boolean f = false;
            for (Map.Entry<Integer, ToolInformation> pairs : cToolInformationMap.entrySet()) {
                int uid = pairs.getKey();
                ToolInformation ti = pairs.getValue();
                int go = 0;
                if (host == null && ti.cHost == null) {
                    ++go;
                } else if (host != null && ti.cHost != null && ti.cHost.equals(host)) {
                    ++go;
                }
                if (selection == null && ti.cSelection == null) {
                    ++go;
                } else if (selection != null && ti.cSelection != null && ti.cSelection.equals(selection)) {
                    ++go;
                }
                if (subselection == null && ti.cSubselection == null) {
                    ++go;
                } else if (subselection != null && ti.cSubselection != null && ti.cSubselection.equals(subselection)) {
                    ++go;
                }
                if (alternateMonitorFile == null && ti.cAlternateMonitorFile == null) {
                    ++go;
                } else if (alternateMonitorFile != null && ti.cAlternateMonitorFile != null && ti.cAlternateMonitorFile.equals(alternateMonitorFile)) {
                    ++go;
                }
                if (go != 4) continue;
                f = true;
                listId = ti.cServiceProviderListId;
                sp = ti.cServiceProvider;
                break;
            }
            if (f) {
                sp.UpdateToolList(listId);
                devMap = sp.GetToolList(listId);
                devCount = sp.GetToolCount(listId);
                for (int i = 0; i < devCount; ++i) {
                    boolean found = false;
                    Set<Integer> toolIndexSet = cToolInformationMap.keySet();
                    for (int t : toolIndexSet) {
                        ToolInformation ti = cToolInformationMap.get(t);
                        if (!ti.cToolDescription.equals(devMap.get(i).substring(0))) continue;
                        ti.cServiceProviderToolIndex = i;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ToolInformation tInfo = new ToolInformation();
                    tInfo.cServiceProvider = sp;
                    tInfo.cServiceProviderListId = listId;
                    tInfo.cServiceProviderToolIndex = i;
                    tInfo.cToolDescription = devMap.get(i).substring(0);
                    tInfo.cHost = host == null ? null : host.substring(0);
                    tInfo.cSelection = selection == null ? null : selection.substring(0);
                    tInfo.cSubselection = subselection == null ? null : subselection.substring(0);
                    tInfo.cAlternateMonitorFile = alternateMonitorFile == null ? null : alternateMonitorFile.substring(0);
                    cToolInformationMap.put(cNextToolListKey, tInfo);
                    ++cNextToolListKey;
                }
                for (Map.Entry<Integer, ToolInformation> pairs : cToolInformationMap.entrySet()) {
                    int uid = pairs.getKey();
                    ToolInformation ti = pairs.getValue();
                    int go = 0;
                    if (host == null && ti.cHost == null) {
                        ++go;
                    } else if (host != null && ti.cHost != null && ti.cHost.equals(host)) {
                        ++go;
                    }
                    if (selection == null && ti.cSelection == null) {
                        ++go;
                    } else if (selection != null && ti.cSelection != null && ti.cSelection.equals(selection)) {
                        ++go;
                    }
                    if (subselection == null && ti.cSubselection == null) {
                        ++go;
                    } else if (subselection != null && ti.cSubselection != null && ti.cSubselection.equals(subselection)) {
                        ++go;
                    }
                    if (alternateMonitorFile == null && ti.cAlternateMonitorFile == null) {
                        ++go;
                    } else if (alternateMonitorFile != null && ti.cAlternateMonitorFile != null && ti.cAlternateMonitorFile.equals(alternateMonitorFile)) {
                        ++go;
                    }
                    if (go != 4) continue;
                    toolMap.put(uid, ti.cToolDescription.substring(0));
                }
                return toolMap;
            }
        }
        int key = 0;
        while ((tProvider = cCommProvidersMap.get(key)) != null) {
            String s = tProvider.GetProviderName();
            int listId = tProvider.CreateToolList(host, selection, subselection, alternateMonitorFile);
            if (listId >= 0) {
                devMap = tProvider.GetToolList(listId);
                devCount = tProvider.GetToolCount(listId);
                for (int i = 0; i < devCount; ++i) {
                    ToolInformation tInfo = new ToolInformation();
                    tInfo.cServiceProvider = tProvider;
                    tInfo.cServiceProviderListId = listId;
                    tInfo.cServiceProviderToolIndex = i;
                    tInfo.cToolDescription = devMap.get(i).substring(0);
                    tInfo.cHost = host == null ? null : host.substring(0);
                    tInfo.cSelection = selection == null ? null : selection.substring(0);
                    tInfo.cSubselection = subselection == null ? null : subselection.substring(0);
                    tInfo.cAlternateMonitorFile = alternateMonitorFile == null ? null : alternateMonitorFile.substring(0);
                    cToolInformationMap.put(cNextToolListKey, tInfo);
                    toolMap.put(cNextToolListKey, tInfo.cToolDescription.substring(0));
                    ++cNextToolListKey;
                }
            } else {
                cCommProviderListLoadResult.put(tProvider.GetProviderName(), listId);
            }
            ++key;
        }
        MPLABCommException.LogInformation("MCP: exit GetCurrentToolList() " + (toolMap.isEmpty() ? "empty" : "c=" + toolMap.size()));
        return toolMap;
    }

    @Override
    public Map<Integer, String> GetCurrentToolList() {
        return this.GetCurrentToolList(null, "Microchip", null, null);
    }

    @Override
    public Map<Integer, String> GetCurrentToolMap(String host, String selection, String subselection, String alternateMonitorFile) {
        return this.GetCurrentToolList(host, selection, subselection, alternateMonitorFile);
    }

    @Override
    public Map<Integer, String> GetCurrentToolMap() {
        return this.GetCurrentToolList(null, "Microchip", null, null);
    }

    @Override
    public Map<String, Integer> GetProviderLoadResults() {
        return cCommProviderListLoadResult;
    }

    @Override
    public int GetToolIndex(int selection, String identifier) {
        MPLABCommException.LogInformation("MCP: enter GetToolIndex(int,String)");
        if (cProviderActive == 0) {
            MPLABCommException.LogInformation("MCP: exit GetToolIndex(int,String) : MPLABCOMM_NOT_OPEN");
            return -109;
        }
        MPLABCommException.LogInformation("MCP: GetToolIndex(int,String): int=" + selection + ",String=" + identifier);
        int toolIndex = -114;
        boolean flag = true;
        try {
            int toolCount = cToolInformationMap.size();
            for (int i = 0; flag && i < toolCount; ++i) {
                ToolInformation t = cToolInformationMap.get(i);
                if (t == null) continue;
                String info = null;
                switch (selection) {
                    case 0: {
                        info = t.cServiceProvider.GetToolInfo(t.cServiceProviderListId, t.cServiceProviderToolIndex, 1);
                        break;
                    }
                    case 1: {
                        info = t.cServiceProvider.GetToolInfo(t.cServiceProviderListId, t.cServiceProviderToolIndex, 2);
                        break;
                    }
                    case 2: {
                        info = t.cServiceProvider.GetToolInfo(t.cServiceProviderListId, t.cServiceProviderToolIndex, 3);
                    }
                }
                if (info == null || identifier == null || !info.equals(identifier)) continue;
                toolIndex = i;
                break;
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.GetToolIndex(int,String)", e);
        }
        MPLABCommException.LogInformation("MCP: exit GetToolIndex(int,String)", toolIndex);
        return toolIndex;
    }

    @Override
    public int GetToolIndex(MPLABCommEvent event) {
        int result = -131;
        MPLABCommException.LogInformation("MCP: enter GetToolIndex(MPLABCommEvent)");
        try {
            int cnt = cToolInformationMap.size();
            for (int i = 0; i < cnt; ++i) {
                ToolInformation t = cToolInformationMap.get(i);
                if (t == null || event.ServiceProvider != t.cServiceProvider || event.ListHandle != t.cServiceProviderListId || event.ListIndex != t.cServiceProviderToolIndex) continue;
                result = i;
                break;
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.GetToolIndex(MPLABCommEvent)", e);
        }
        MPLABCommException.LogInformation("MCP: exit GetToolIndex(MPLABCommEvent)", result);
        return result;
    }

    @Override
    public String GetSerialNumber(int toolIndex) {
        MPLABCommException.LogInformation("MCP: enter GetSerialNumber()");
        if (cProviderActive == 0) {
            MPLABCommException.LogInformation("MCP: exit GetSerialNumber() : MPLABCOMM_NOT_OPEN");
            return null;
        }
        String sn = null;
        try {
            ToolInformation t = cToolInformationMap.get(toolIndex);
            if (t != null) {
                sn = t.cServiceProvider.GetToolInfo(t.cServiceProviderListId, t.cServiceProviderToolIndex, 2);
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.GetSerialNumber", e);
        }
        MPLABCommException.LogInformation("MCP: exit GetSerialNumber() '" + sn + "'");
        return sn;
    }

    @Override
    public int GetToolState(int toolIndex, int selection) {
        int result = -114;
        switch (selection) {
            case 0: {
                try {
                    ToolInformation t = cToolInformationMap.get(toolIndex);
                    if (t == null) break;
                    result = t.cServiceProvider.GetToolState(t.cServiceProviderListId, t.cServiceProviderToolIndex, selection);
                    break;
                }
                catch (Exception e) {
                    MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.GetToolState", e);
                }
            }
        }
        return result;
    }

    @Override
    public String GetFriendlyName(int toolIndex) {
        if (cProviderActive == 0) {
            return null;
        }
        String friendlyname = null;
        String name = null;
        try {
            String s;
            ToolInformation t = cToolInformationMap.get(toolIndex);
            name = t.cServiceProvider.GetToolInfo(t.cServiceProviderListId, t.cServiceProviderToolIndex, 1);
            BufferedReader fileIn = new BufferedReader(new FileReader(cFriendlyNameFile));
            while ((s = fileIn.readLine()) != null) {
                if (!s.equalsIgnoreCase(name)) continue;
                friendlyname = fileIn.readLine();
                break;
            }
            fileIn.close();
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.GetFriendlyName", e);
        }
        return friendlyname;
    }

    @Override
    public int SetFriendlyName(int toolIndex, String friendlyName) {
        if (cProviderActive == 0) {
            return -109;
        }
        int result = 0;
        try {
            ToolInformation t = cToolInformationMap.get(toolIndex);
            String desc = t.cServiceProvider.GetToolInfo(t.cServiceProviderListId, t.cServiceProviderToolIndex, 1);
            String bak = cFriendlyNameFile + ".bak";
            File bakFile = new File(bak);
            if (bakFile.exists()) {
                bakFile.delete();
            }
            bakFile = new File(bak);
            File curFile = new File(cFriendlyNameFile);
            curFile.renameTo(bakFile);
            curFile = new File(cFriendlyNameFile);
            curFile.createNewFile();
            PrintWriter fileOut = new PrintWriter(new FileWriter(curFile));
            bakFile = new File(bak);
            if (bakFile.exists()) {
                String d;
                BufferedReader fileIn = new BufferedReader(new FileReader(bakFile));
                boolean found = false;
                while ((d = fileIn.readLine()) != null) {
                    String name = fileIn.readLine();
                    if (d.equalsIgnoreCase(desc)) {
                        if (friendlyName != null) {
                            fileOut.println(d);
                            fileOut.println(friendlyName);
                        }
                        found = true;
                        continue;
                    }
                    fileOut.println(d);
                    fileOut.println(name);
                }
                if (!found && friendlyName != null) {
                    fileOut.println(desc);
                    fileOut.println(friendlyName);
                }
                fileIn.close();
            } else if (friendlyName != null) {
                fileOut.println(desc);
                fileOut.println(friendlyName);
            }
            fileOut.flush();
            fileOut.close();
        }
        catch (Exception e) {
            result = -132;
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.SetFriendlyName", e);
        }
        return result;
    }

    @Override
    public MPLABCommTool GetTool(int toolIndex) {
        MPLABCommException.LogInformation("MCP: enter GetTool()");
        if (cProviderActive == 0) {
            MPLABCommException.LogInformation("MCP: exit GetTool() : MPLABCOMM_NOT_OPEN");
            return null;
        }
        MPLABCommTool tool = null;
        try {
            ToolInformation t = cToolInformationMap.get(toolIndex);
            if (t != null) {
                tool = t.cServiceProvider.ReserveTool(t.cServiceProviderListId, t.cServiceProviderToolIndex);
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.GetTool", e);
        }
        MPLABCommException.LogInformation("MCP: exit GetTool() " + (tool == null ? "null" : ""));
        return tool;
    }

    @Override
    public int ReleaseTool(int toolIndex, MPLABCommTool tool) {
        MPLABCommException.LogInformation("MCP: enter ReleaseTool()");
        if (cProviderActive == 0) {
            MPLABCommException.LogInformation("MCP: exit ReleaseTool() : MPLABCOMM_NOT_OPEN");
            return -109;
        }
        int result = -136;
        try {
            ToolInformation t = cToolInformationMap.get(toolIndex);
            if (t != null) {
                result = t.cServiceProvider.ReleaseTool(tool);
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.ReleaseTool", e);
        }
        MPLABCommException.LogInformation("MCP: exit ReleaseTool()", result);
        return result;
    }

    @Override
    public boolean IsTool(int toolIndex, MPLABCommEvent event) {
        boolean result = false;
        try {
            ToolInformation t = cToolInformationMap.get(toolIndex);
            if (t != null && event.ServiceProvider == t.cServiceProvider && event.ListHandle == t.cServiceProviderListId && event.ListIndex == t.cServiceProviderToolIndex) {
                result = true;
            }
        }
        catch (Exception e) {
            MPLABCommException.LogWarning(MPLABCommException.ErrorType.EXCEPTION_NOT_AN_ERROR, "MPLABCommProvider.IsTool", e);
        }
        return result;
    }

    public synchronized boolean Attach(Observer who, Object what) {
        MPLABCommException.LogInformation("MCP: enter MCP Attach()");
        if (cCommProvidersMap == null) {
            MPLABCommException.LogInformation("MCP: exit MCP Attach() : MPLABCOMM_NOT_OPEN");
            return false;
        }
        int k = cCommProvidersMap.size();
        for (int i = 0; i < k; ++i) {
            cCommProvidersMap.get(i).Attach(who, what);
        }
        MPLABCommException.LogInformation("MCP: exit MCP Attach()");
        return true;
    }

    public synchronized boolean Detach(Observer who, Object what) {
        MPLABCommException.LogInformation("MCP: enter MCP Detach()");
        if (cCommProvidersMap == null) {
            MPLABCommException.LogInformation("MCP: exit MCP Detach() : MPLABCOMM_NOT_OPEN");
            return false;
        }
        int k = cCommProvidersMap.size();
        for (int i = 0; i < k; ++i) {
            cCommProvidersMap.get(i).Detach(who, what);
        }
        MPLABCommException.LogInformation("MCP: exit MCP Detach()");
        return true;
    }

    public synchronized void Notify(Object what) {
        if (cCommProvidersMap != null) {
            int k = cCommProvidersMap.size();
            for (int i = 0; i < k; ++i) {
                cCommProvidersMap.get(i).Notify(what);
            }
        }
    }
}

