/*
 * Decompiled with CFR 0.152.
 */
package readhexfile.classes;

import BootloaderView.AppContext.AppContext;
import com.microchip.intelhex.HexAddressRange;
import com.microchip.intelhex.HexAddressRangeList;
import com.microchip.intelhex.HexException;
import com.microchip.intelhex.HexFile;
import java.io.File;
import java.io.IOException;
import protocol.write.nextchunkgetter.MemoryRecordTypes;
import readhexfile.interfaces.FileIO;

public class ReadHexFile
implements FileIO {
    public boolean deviceErase = false;

    @Override
    public void getRangeAddressList(String fileName) {
        File fp = new File(fileName);
        try {
            AppContext.setRangeList(HexAddressRangeList.getList((File)fp));
        }
        catch (IOException ex) {
            System.out.println("IO Exception trigerred. No File Found");
        }
        catch (HexException ex) {
            System.out.println("HEX Exception trigerred. Not a HEX File");
        }
    }

    @Override
    public void getFileData(String fileName, MemoryRecordTypes memoryType) {
        this.deviceErase = false;
        File fp = new File(fileName);
        this.getRangeAddressList(fileName);
        HexAddressRange[] tempRangeList = AppContext.getRangeList();
        block8: for (int i = 0; i < tempRangeList.length; ++i) {
            byte[] tempBuffer = new byte[(int)tempRangeList[i].getRange()];
            try {
                tempBuffer = HexFile.getData((File)fp, (long)((int)tempRangeList[i].getStartingAddress()), (int)((int)tempRangeList[i].getRange()));
            }
            catch (IOException ex) {
                System.out.println("IO Exception trigerred !!");
            }
            catch (HexException ex) {
                System.out.println("HEX Exception trigerred !!");
            }
            switch (memoryType) {
                case PROGRAM_MEMORY: {
                    if (AppContext.dataManager.programMemorySize == 0) {
                        AppContext.swingEditorObj.print(1, "ProgramMemory Load Failed. Out of Memory");
                        AppContext.dataManager.programMemory = null;
                    }
                    if ((int)tempRangeList[i].getStartingAddress() >= AppContext.dataManager.programMemorySize) continue block8;
                    if (!this.deviceErase) {
                        AppContext.dataManager.programMemory = new byte[AppContext.dataManager.programMemorySize];
                        for (int k = 0; k < AppContext.dataManager.programMemorySize; ++k) {
                            AppContext.dataManager.programMemory[k] = -1;
                            if (AppContext.pic18DeviceWhenCaptured || k % 2 == 0) continue;
                            AppContext.dataManager.programMemory[k] = 63;
                        }
                        this.deviceErase = true;
                    }
                    for (int j = 0; j < tempBuffer.length; ++j) {
                        if ((int)tempRangeList[i].getStartingAddress() + j >= AppContext.dataManager.programMemorySize) {
                            AppContext.swingEditorObj.print(1, "ProgramMemory Load Failed. Out of Memory");
                            AppContext.dataManager.programMemory = null;
                            continue block8;
                        }
                        AppContext.dataManager.programMemory[(int)tempRangeList[i].getStartingAddress() + j] = tempBuffer[j];
                    }
                    continue block8;
                }
                case CONFIGURATION_WORDS: {
                    if (AppContext.dataManager.conmMemorySize == 0) {
                        AppContext.swingEditorObj.print(1, "ConfigWords Load Failed. Out of Memory");
                        AppContext.dataManager.configurationWords = null;
                    }
                    if ((int)tempRangeList[i].getStartingAddress() < AppContext.dataManager.configBitsOffset) continue block8;
                    if (!this.deviceErase) {
                        AppContext.dataManager.configurationWords = new byte[AppContext.dataManager.conmMemorySize];
                        for (int k = 0; k < AppContext.dataManager.conmMemorySize; ++k) {
                            AppContext.dataManager.configurationWords[k] = -1;
                        }
                        this.deviceErase = true;
                    }
                    for (int j = 0; j < tempBuffer.length; ++j) {
                        if ((int)tempRangeList[i].getStartingAddress() + j - AppContext.dataManager.configBitsOffset >= AppContext.dataManager.conmMemorySize) {
                            AppContext.swingEditorObj.print(1, "ConfigWords Load Failed. Out of Memory1");
                            AppContext.dataManager.configurationWords = null;
                            continue block8;
                        }
                        AppContext.dataManager.configurationWords[(int)tempRangeList[i].getStartingAddress() + j - AppContext.dataManager.configBitsOffset] = tempBuffer[j];
                    }
                    continue block8;
                }
                case EEPROM_MEMORY: {
                    if (AppContext.dataManager.eepromMemorySize == 0) {
                        AppContext.swingEditorObj.print(1, "fdfdfEEPROMMemory Load Failed. Out of Memory");
                        AppContext.dataManager.eepromMemory = null;
                    }
                    if ((int)tempRangeList[i].getStartingAddress() < AppContext.dataManager.eepromOffset || (int)tempRangeList[i].getStartingAddress() >= AppContext.dataManager.configBitsOffset) continue block8;
                    if (!this.deviceErase) {
                        AppContext.dataManager.eepromMemory = new byte[AppContext.dataManager.eepromMemorySize];
                        for (int k = 0; k < AppContext.dataManager.eepromMemorySize; ++k) {
                            AppContext.dataManager.eepromMemory[k] = -1;
                        }
                        this.deviceErase = true;
                    }
                    for (int j = 0; j < tempBuffer.length; ++j) {
                        System.out.println(String.format("%02X", tempRangeList[i].getStartingAddress()));
                        if ((int)tempRangeList[i].getStartingAddress() + j - AppContext.dataManager.eepromOffset >= AppContext.dataManager.eepromMemorySize) {
                            AppContext.swingEditorObj.print(1, "EEPROMMemory Load Failed. Out of Memory");
                            AppContext.dataManager.eepromMemory = null;
                            continue block8;
                        }
                        AppContext.dataManager.eepromMemory[(int)tempRangeList[i].getStartingAddress() + j - AppContext.dataManager.eepromOffset] = tempBuffer[j];
                    }
                    continue block8;
                }
            }
        }
    }
}

