/*
 * Decompiled with CFR 0.152.
 */
package protocol.write.thread;

import BootloaderView.AppContext.AppContext;
import BootloaderView.state.CommState;
import java.awt.EventQueue;
import javax.swing.SwingWorker;
import packetprocessor.PacketProcessor;
import protocol.state.InnerCommState;
import protocol.write.nextchunkgetter.dataChunk;
import protocol.write.nextchunkgetter.state.memoryState;
import serialport.classes.SerialPort;
import serialport.completionhandler.ReadWriteCompletionHandler;

public class SwingWorkerThreadWrite
extends SwingWorker {
    private int length1;
    private int textFieldNumber;
    private boolean mustWait = false;

    public SwingWorkerThreadWrite(int length, int textFieldNumber) {
        this.length1 = length;
        this.textFieldNumber = textFieldNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void doInBackground() {
        ReadWriteCompletionHandler completionHandler1 = null;
        dataChunk tmpData = null;
        while (AppContext.breakWhile == 0) {
            this.mustWait = false;
            int byte_count_write = 0;
            switch (AppContext.innerCommState) {
                case INIT: {
                    tmpData = AppContext.dataManager.getData();
                    AppContext.innerCommState = InnerCommState.WRITE;
                    break;
                }
                case READ: {
                    int byte_count_read = 0;
                    ReadWriteCompletionHandler completionHandler = new ReadWriteCompletionHandler(this.textFieldNumber, this.length1);
                    byte_count_read = PacketProcessor.readBeforePacket(this.length1, completionHandler);
                    if (byte_count_read == -109) {
                        AppContext.communicationLock.release();
                        AppContext.breakWhile = 1;
                        AppContext.setCommState(CommState.IDLE);
                        AppContext.swingEditorObj.print(3, "Status: Programming Failed");
                        break;
                    }
                    while (byte_count_read != 0) {
                        byte_count_read = PacketProcessor.readBeforePacket(this.length1, completionHandler);
                    }
                    if (AppContext.debugEnable) {
                        System.out.println("READ");
                    }
                    this.mustWait = true;
                    break;
                }
                case DATA_READY: {
                    if (AppContext.debugEnable) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : AppContext.data) {
                            sb.append(String.format("%02X", b));
                        }
                        AppContext.swingEditorObj.print(this.textFieldNumber, sb.toString());
                    }
                    if (AppContext.byteCount < this.length1 || AppContext.STX_READ != 85 || AppContext.command_READ != 2 && AppContext.command_READ != 5 && AppContext.command_READ != 7 || AppContext.successBit != 1) {
                        if (++AppContext.retryFlag == 3) {
                            AppContext.setCommState(CommState.IDLE);
                            int tRes = SerialPort.disconnectSerialPort(AppContext.getIndexWhenConnected());
                            if (tRes == 0) {
                                AppContext.swingEditorObj.disp(0);
                                AppContext.setCommState(CommState.IDLE);
                                AppContext.swingEditorObj.print(1, "Device Disconnected\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()));
                                AppContext.swingEditorObj.print(2, "Status: Disconnected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
                                AppContext.setCommState(CommState.IDLE);
                            } else {
                                AppContext.swingEditorObj.print(1, "Device Disconnection Failed\nEvent: DISCONNECT. STATE: " + (Object)((Object)AppContext.getCommState()) + " .STATE NOT CHANGED. PRESENT STATE = PREVIOUS STATE");
                                AppContext.swingEditorObj.print(2, "Status: Connected to port (" + AppContext.connectedPortName + "). Target Device not Connected");
                            }
                            AppContext.swingEditorObj.print(1, "Communication to device failed. Please disconnect and try again\nEvent: TIMEOUT/CONNECTION PIPE BROKEN. STATE: " + (Object)((Object)AppContext.getCommState()));
                            AppContext.swingEditorObj.disp(0);
                            if (AppContext.debugEnable) {
                                System.out.println("Done");
                            }
                            AppContext.breakWhile = 1;
                            AppContext.swingEditorObj.print(3, "Status: Programming Failed");
                            AppContext.swingEditorObj.print(4, "Programming Failed");
                            break;
                        }
                    } else {
                        tmpData = AppContext.dataManager.getData();
                    }
                }
                case WRITE: {
                    if (tmpData != null) {
                        completionHandler1 = new ReadWriteCompletionHandler(1, 11);
                        if (tmpData.address >= AppContext.dataManager.eepromOffset) {
                            byte_count_write = PacketProcessor.sendBeforePacket((byte)5, tmpData.length, tmpData.address, tmpData.data, completionHandler1);
                        } else if (tmpData.address < AppContext.dataManager.programMemorySize) {
                            byte_count_write = PacketProcessor.sendBeforePacket((byte)2, tmpData.length, tmpData.address, tmpData.data, completionHandler1);
                        } else if (tmpData.address > AppContext.dataManager.programMemorySize && tmpData.address < AppContext.dataManager.eepromOffset) {
                            byte_count_write = PacketProcessor.sendBeforePacket((byte)7, tmpData.length, tmpData.address, tmpData.data, completionHandler1);
                        }
                        if (byte_count_write == -109) {
                            AppContext.communicationLock.release();
                            AppContext.breakWhile = 1;
                            AppContext.setCommState(CommState.IDLE);
                            AppContext.swingEditorObj.print(3, "Status: Programming Failed");
                            break;
                        }
                        while (byte_count_write != 0) {
                            if (tmpData.address >= AppContext.dataManager.eepromOffset) {
                                byte_count_write = PacketProcessor.sendBeforePacket((byte)5, tmpData.length, tmpData.address, tmpData.data, completionHandler1);
                            } else if (tmpData.address < AppContext.dataManager.programMemorySize) {
                                byte_count_write = PacketProcessor.sendBeforePacket((byte)2, tmpData.length, tmpData.address, tmpData.data, completionHandler1);
                            } else if (tmpData.address > AppContext.dataManager.programMemorySize && tmpData.address < AppContext.dataManager.eepromOffset) {
                                byte_count_write = PacketProcessor.sendBeforePacket((byte)7, tmpData.length, tmpData.address, tmpData.data, completionHandler1);
                            }
                            if (!AppContext.debugEnable) continue;
                            System.out.println("Try to write");
                        }
                        this.mustWait = true;
                        break;
                    }
                    AppContext.breakWhile = 1;
                    AppContext.swingEditorObj.print(1, "Hex File Written Successfully");
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppContext.swingEditorObj.print(3, "Status: Device Programmed");
                        }
                    });
                    if (!AppContext.debugEnable) break;
                    System.out.println("HANG DONE");
                    break;
                }
                default: {
                    if (!AppContext.debugEnable) break;
                    System.out.println("Big problem !!");
                }
            }
            if (!this.mustWait) continue;
            if (AppContext.debugEnable) {
                System.out.println("I am waiting!");
            }
            try {
                AppContext.communicationLock.acquire();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!AppContext.debugEnable) continue;
            System.out.println("I got released!");
        }
        AppContext.breakWhile = 0;
        AppContext.writeHexFileFlag = 0;
        AppContext.retryFlag = 0;
        AppContext.checksumFlag = 0;
        AppContext.innerCommState = InnerCommState.INIT;
        AppContext.dataManager.mem = memoryState.PROGRAM_MEMORY;
        AppContext.dataManager.rewind();
        AppContext.swingEditorObj.disp(0);
        AppContext.communicationLock = null;
        if (AppContext.thread1 != null) {
            SwingWorker<Void, Void> swingWorker = AppContext.thread1;
            synchronized (swingWorker) {
                AppContext.thread1.notify();
            }
        }
        return null;
    }
}

