/*
 * Decompiled with CFR 0.152.
 */
package protocol.erase.nextchunkgetter;

import BootloaderView.AppContext.AppContext;
import protocol.erase.nextchunkgetter.EraseChunk;

public class GetNextEraseChunk {
    int startAddress;
    int address;
    int programMemSize;
    boolean firstTime;
    int eraseRowSize;
    int length;

    public GetNextEraseChunk() {
        this.startAddress = AppContext.dataManager.cursorStart;
        this.address = 0;
        this.programMemSize = AppContext.dataManager.programMemorySize;
        this.firstTime = true;
        this.eraseRowSize = 64;
        this.length = 0;
        this.calculateLengthOfRows();
    }

    private void calculateLengthOfRows() {
        this.length = (this.programMemSize - this.startAddress) / this.eraseRowSize / 4;
    }

    public EraseChunk getChuncks() {
        if (this.firstTime) {
            this.address += this.startAddress;
            this.firstTime = false;
            return new EraseChunk(this.length, this.address);
        }
        this.address += this.length * this.eraseRowSize;
        if (this.address == this.programMemSize) {
            return null;
        }
        return new EraseChunk(this.length, this.address);
    }
}

