/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.logger;

import com.microchip.mplab.logger.ILogfileProperty;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class MPLABLogger
extends Logger {
    public static Logger mplog = MPLABLogger.getLogger("MPLAB");
    protected static Level LogLevel = null;
    protected static String LogFileName = "";
    private static boolean triedPrefs = false;
    private static Preferences prefs = null;

    public MPLABLogger(String name) {
        super(name, null);
    }

    protected MPLABLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    protected void logFormatted(String fmt, Object ... args) {
        this.severe(String.format(fmt, args));
    }

    protected static ILogfileProperty getIogfileProperty() {
        ILogfileProperty logfileProperty = null;
        try {
            Class<?> logfilePropertyClass = Class.forName("com.microchip.mplab.mdb.logfileproperty.LogfileProperty");
            if (logfilePropertyClass != null) {
                logfileProperty = (ILogfileProperty)logfilePropertyClass.newInstance();
            }
        }
        catch (Exception e) {
            logfileProperty = null;
        }
        return logfileProperty;
    }

    public static synchronized void setLogFileName(String Name) {
        if (!LogFileName.equals(Name)) {
            LogFileName = Name;
            if (mplog != null) {
                Handler[] hs;
                for (Handler h : hs = mplog.getHandlers()) {
                    if (h instanceof FileHandler) {
                        mplog.removeHandler(h);
                    }
                    try {
                        mplog.addHandler(new FileHandler(Name));
                    }
                    catch (Exception Ex) {
                        mplog.log(Level.ALL, "ERROR: Unable to create file handler " + Name);
                    }
                }
            }
            MPLABLogger.serializeLogFileName(Name);
        }
        MPLABLogger.getLogger("MPLAB");
    }

    public static String getLogFileName() {
        String RetVal = System.getProperty("user.home");
        if (RetVal == null) {
            RetVal = "";
        } else {
            RetVal = RetVal.replace('\\', '/');
            RetVal = RetVal + "/MPLABXLog.xml";
        }
        RetVal = LogFileName != null && !LogFileName.isEmpty() ? LogFileName : MPLABLogger.getPreference("MPLAB_LOG_OUTPUT_FILE", RetVal);
        return RetVal;
    }

    public static synchronized void setLogLevel(Level NewLevel) {
        LogLevel = NewLevel;
        if (mplog != null) {
            if (NewLevel == Level.OFF) {
                mplog.info("MPLABLogger.setLogLevel: Logging is being turned off");
            }
            mplog.setLevel(NewLevel);
        }
        MPLABLogger.serializeLogLevel(NewLevel);
        MPLABLogger.getLogger("MPLAB");
    }

    protected static void serializeLogLevel(Level level) {
        if (prefs != null) {
            prefs.put("LoggingLevel", level.toString());
        }
    }

    protected static void serializeLogFileName(String Name) {
        if (prefs != null) {
            prefs.put("MPLAB_LOG_OUTPUT_FILE", Name);
        }
    }

    protected static String getLogLevel() {
        String RetVal = "OFF";
        RetVal = LogLevel != null ? LogLevel.toString() : MPLABLogger.getPreference("LoggingLevel", "OFF");
        return RetVal;
    }

    private static String getPreference(String key, String defaultValue) {
        if (!triedPrefs) {
            triedPrefs = true;
            NbPreferences.Provider provider = (NbPreferences.Provider)Lookup.getDefault().lookup(NbPreferences.Provider.class);
            if (provider != null) {
                prefs = NbPreferences.root();
            }
        }
        if (prefs == null) {
            return defaultValue;
        }
        return prefs.get(key, defaultValue);
    }

    public static synchronized MPLABLogger getLogger(String name) {
        boolean jeff = false;
        if (!name.equals("MPLAB")) {
            jeff = true;
        }
        String loggingLevel = MPLABLogger.getLogLevel();
        String logFileName = MPLABLogger.getLogFileName();
        LogManager logmanager = LogManager.getLogManager();
        Logger lgr = logmanager.getLogger(name);
        if (lgr == null || !LogFileName.equals(logFileName) && "MPLAB".equals(name)) {
            if (lgr != null) {
                Handler[] currentHandlers = lgr.getHandlers();
                for (int i = 0; i < currentHandlers.length; ++i) {
                    lgr.removeHandler(currentHandlers[i]);
                }
            }
            lgr = new MPLABLogger(name, null);
            logmanager.addLogger(lgr);
            lgr = logmanager.getLogger(name);
            try {
                FileHandler fh = new FileHandler(logFileName);
                if (name.equals("MPLAB")) {
                    lgr.setLevel(Level.parse(loggingLevel));
                    fh.setLevel(Level.parse(loggingLevel));
                }
                lgr.addHandler(fh);
                LogFileName = logFileName;
            }
            catch (IOException ex) {
                Logger.getLogger(MPLABLogger.class.getName()).setUseParentHandlers(false);
                Logger.getLogger(MPLABLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(MPLABLogger.class.getName()).setUseParentHandlers(false);
                Logger.getLogger(MPLABLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Handler[] currentHandlers;
            lgr.setLevel(Level.parse(loggingLevel));
            for (Handler h : currentHandlers = lgr.getHandlers()) {
                if (!(h instanceof FileHandler)) continue;
                h.setLevel(Level.parse(loggingLevel));
            }
        }
        lgr.setUseParentHandlers(false);
        return (MPLABLogger)lgr;
    }
}

