/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.open.util;

import java.util.concurrent.Semaphore;

public class GateSemaphore {
    private int cPermitsCount;
    private int cGateCount;
    private Semaphore[] cGate;
    private int[] cMessageValue;
    private String[] cMessageText;

    public GateSemaphore(int gateCount, int permits) {
        this.cGateCount = gateCount;
        if (this.cGateCount <= 0) {
            this.cGateCount = 1;
        }
        this.cPermitsCount = permits;
        if (this.cPermitsCount <= 0) {
            this.cPermitsCount = 1;
        }
        this.cGate = new Semaphore[gateCount];
        this.cMessageValue = new int[gateCount];
        this.cMessageText = new String[gateCount];
        for (int i = 0; i < this.cGateCount; ++i) {
            this.cGate[i] = new Semaphore(this.cPermitsCount);
            this.cMessageValue[i] = -1;
            this.cMessageText[i] = new String("");
        }
    }

    public void Acquire(int gate) throws InterruptedException {
        this.cGate[gate].acquire();
    }

    public boolean TryAcquire(int gate) {
        return this.cGate[gate].tryAcquire();
    }

    public void Release(int gate) {
        this.cGate[gate].release();
    }

    public void setMessageValue(int gate, int messageValue) {
        this.cMessageValue[gate] = messageValue;
    }

    public int getMessageValue(int gate) {
        return this.cMessageValue[gate];
    }

    public void clearMessageValue(int gate) {
        this.cMessageValue[gate] = -1;
    }

    public void setMessageText(int gate, String messageText) {
        this.cMessageText[gate] = messageText;
    }

    public String getMessageText(int gate) {
        return this.cMessageText[gate];
    }

    public void clearMessageText(int gate) {
        this.cMessageText[gate] = "";
    }
}

