/*
 * Decompiled with CFR 0.152.
 */
package com.microchip.mplab.comm;

import com.microchip.mplab.comm.MPLABCommServiceProviderInterface;
import com.microchip.mplab.comm.MPLABCommToolInterface;
import com.microchip.mplab.util.observers.Observer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class MPLABCommTool
implements MPLABCommToolInterface {
    protected int cListHandle;
    protected int cToolIndex;
    protected int cDeviceOpened;
    protected int cActiveInterface;
    protected MPLABCommServiceProviderInterface cServiceProvider;
    protected int cToolReservedId;
    protected static int cToolReservationId = 0;
    protected Map<Integer, Integer> cPipeInuse;
    protected Map<Integer, Integer> cPipeCancelRequested;
    protected int cMonitoring;
    protected Map<Integer, Integer> cPipeWaitState;
    protected int cActiveState = 0;
    protected ArrayList<Observer> cListenerList = null;

    public MPLABCommTool(int listHandle, int toolIndex, MPLABCommServiceProviderInterface serviceProvider) {
        this.cListHandle = listHandle;
        this.cToolIndex = toolIndex;
        this.cDeviceOpened = 0;
        this.cActiveInterface = 0;
        this.cServiceProvider = serviceProvider;
        this.cToolReservedId = -1;
        this.cPipeInuse = new HashMap<Integer, Integer>();
        this.cPipeCancelRequested = new HashMap<Integer, Integer>();
        this.cMonitoring = 0;
        this.cPipeWaitState = new HashMap<Integer, Integer>();
        this.cListenerList = new ArrayList();
    }

    public String GetProvider() {
        return this.cServiceProvider.GetProviderName();
    }

    public synchronized boolean Attach(Observer who, Object what) {
        boolean result = true;
        if (!this.cListenerList.contains(who)) {
            result = this.cListenerList.add(who);
        }
        return result;
    }

    public synchronized boolean Detach(Observer who, Object what) {
        boolean result = this.cListenerList.contains(who);
        if (result) {
            result = this.cListenerList.remove(who);
        }
        return result;
    }

    public synchronized void Notify(final Object what) {
        final ArrayList<Observer> listeners = new ArrayList<Observer>(this.cListenerList);
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (Observer ob : listeners) {
                    ob.Update(what);
                }
            }
        });
        t.start();
    }

    public synchronized int setToolReserved() {
        if (this.cToolReservedId != -1) {
            return -124;
        }
        this.cToolReservedId = cToolReservationId++;
        return 0;
    }

    public synchronized int clearToolReserved() {
        if (this.cToolReservedId == -1) {
            return -125;
        }
        this.cToolReservedId = -1;
        return 0;
    }

    public synchronized void internalDisconnect() {
        this.cDeviceOpened = 1;
        this.Disconnect();
    }

    public boolean isTool(int listHandle, int toolIndex) {
        return listHandle == this.cListHandle && toolIndex == this.cToolIndex;
    }

    public boolean isTool(MPLABCommTool tool) {
        return tool == this;
    }
}

