// MIT License
//
// Copyright (c) 2017-2019 MessageKit
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

import UIKit

internal class TextFieldTableViewCell: UITableViewCell {
  // MARK: Lifecycle

  // MARK: - View lifecycle

  override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
    super.init(style: style, reuseIdentifier: reuseIdentifier)

    mainLabel.translatesAutoresizingMaskIntoConstraints = false
    textField.translatesAutoresizingMaskIntoConstraints = false

    contentView.addSubview(mainLabel)
    contentView.addSubview(textField)

    NSLayoutConstraint.activate([
      mainLabel.leadingAnchor.constraint(equalTo: contentView.leadingAnchor, constant: 20),
      mainLabel.widthAnchor.constraint(equalToConstant: 200),
      mainLabel.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),

      textField.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),

      textField.trailingAnchor.constraint(equalTo: contentView.trailingAnchor, constant: -20),
      textField.widthAnchor.constraint(equalToConstant: 50),
    ])

    textField.textAlignment = .right
  }

  required init?(coder _: NSCoder) {
    fatalError("init(coder:) has not been implemented")
  }

  // MARK: Internal

  static let identifier = "TextFieldTableViewCellIdentifier"

  var mainLabel = UILabel()
  var textField = UITextField()
}
