import { BytemdPlugin } from 'bytemd';
export function insertMore(): BytemdPlugin {
  return {
    actions: [
      {
        title: '插入 more 标记',
        icon: icon, // 16x16 SVG icon
        handler: {
          type: 'action',
          click(ctx) {
            const pos = ctx.appendBlock(`<!-- more -->\n`);
            ctx.editor.setSelection(
              ctx.codemirror.Pos(pos.line, 0),
              ctx.codemirror.Pos(pos.line, 13),
            );
            ctx.editor.focus();
          },
        },
      },
    ],
  };
}
const icon = `<svg fill="currentColor" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2605" width="16" height="16"><path d="M227.14123 413.647995c-52.14973 0-94.587262 42.439578-94.587262 94.587262 0 52.14973 42.437531 94.587262 94.587262 94.587262 52.147684 0 94.587262-42.437531 94.587262-94.587262C321.728492 456.087573 279.288914 413.647995 227.14123 413.647995z" p-id="2606"></path><path d="M510.903016 413.647995c-52.14973 0-94.587262 42.439578-94.587262 94.587262 0 52.14973 42.437531 94.587262 94.587262 94.587262 52.147684 0 94.587262-42.437531 94.587262-94.587262C605.490278 456.087573 563.051723 413.647995 510.903016 413.647995z" p-id="2607"></path><path d="M794.665825 413.647995c-52.14973 0-94.587262 42.439578-94.587262 94.587262 0 52.14973 42.437531 94.587262 94.587262 94.587262 52.147684 0 94.587262-42.437531 94.587262-94.587262C889.253086 456.087573 846.813508 413.647995 794.665825 413.647995z" p-id="2608"></path></svg>`;
