export default [
  {
    path: '/user',
    layout: false,
    routes: [
      { name: '登录', path: '/user/login', component: './user/Login' },
      { name: '忘记密码', path: '/user/restore', component: './user/Restore' },
      { component: './404' },
    ],
  },
  { path: '/init', layout: false, component: './InitPage' },
  {
    path: '/welcome',
    name: '分析概览',
    icon: 'smile',
    component: './Welcome',
    access: 'isAdmin',
  },
  { name: '文章管理', icon: 'form', path: '/article', component: './Article' },
  {
    name: '图形编辑器',
    icon: 'form',
    path: '/editor',
    component: './Editor',
    hideInMenu: true,
  },
  {
    name: '代码编辑器',
    icon: 'tool',
    path: '/code',
    component: './Code',
    hideInMenu: true,
    access: 'isAdmin',
  },
  {
    name: '关于',
    icon: 'form',
    path: '/about',
    component: './About',
    hideInMenu: true,
  },
  { name: '草稿管理', icon: 'container', path: '/draft', component: './Draft' },
  {
    name: '图片管理',
    icon: 'picture',
    path: '/static/img',
    hideInBreadcrumb: true,
    component: './Static/img',
  },
  {
    name: '站点管理',
    icon: 'tool',
    path: '/site',
    hideInBreadcrumb: true,
    access: 'isAdmin',
    routes: [
      { name: '数据管理', path: '/site/data', component: './DataManage' },
      { name: '评论管理', path: '/site/comment', component: './CommentManage' },
      { name: '流水线', path: '/site/pipeline', component: './Pipeline' },
      { name: '系统设置', path: '/site/setting', component: './SystemConfig' },
      {
        name: '自定义页面',
        path: '/site/customPage',
        component: './CustomPage',
      },
      { name: '日志管理', path: '/site/log', component: './LogManage' },
    ],
  },
  { path: '/', redirect: '/article' },
  { component: './404' },
];
