---
title: 站点配置
icon: gear
order: 1
---

VanBlog 可以配置一系列的站点配置项，可在 `站点管理/系统设置` 中查看。

## 基本设置

博客系统正常运行必须的配置

| 设置名称  | 必填 | 说明                                                          |
| --------- | ---- | ------------------------------------------------------------- |
| 作者名字  | 是   | 会展示在侧边栏的作者卡片和版权声明上                          |
| 作者描述  | 是   | 会展示在侧边栏的作者卡片上                                    |
| 作者 logo | 是   | 会展示在侧边栏的作者卡片上                                    |
| 网站图标  | 是   | 浏览器标签的图标                                              |
| 网站名    | 是   | 会展示在浏览器标签和友链中的本站信息上                        |
| 网站描述  | 是   | 会展示在友链中的本站信息上，并用于 SEO                        |
| 网站 URL  | 是   | 会被前后台用来展示一些跳转的链接以及作为 RSS 订阅中的链接基址 |

![基本设置](https://pic.mereith.com/img/2c4254e19beaad471b275e897ff54fbe.clipboard-2022-08-15.png)

## 高级设置

博客系统的进阶选项

| 设置名称                   | 必填 | 说明                                                     |
| -------------------------- | ---- | -------------------------------------------------------- |
| 作者 Logo（黑暗模式）      | 否   | 切换到黑暗模式后的作者 logo，没有的话就沿用正常的        |
| 网站 Logo                  | 否   | 会被展示在导航栏最左面，和用于友情链接的站点信息         |
| 网站 Logo（黑暗模式）      | 否   | 切换到黑暗模式后的网站 logo，没有的话就沿用正常的        |
| 支付宝图片 URL             | 否   | 文章中的支付宝打赏二维码图片，没有的话就不显示打赏按钮了 |
| 支付宝图片 URL（黑暗模式） | 否   | 切换到黑暗模式后的打赏二维码，没有的话就沿用正常的       |
| 微信图片 URL               | 否   | 文章中的微信打赏二维码图片，没有的话就不显示打赏按钮了   |
| 微信图片 URL（黑暗模式）   | 否   | 切换到黑暗模式后的打赏二维码，没有的话就沿用正常的       |
| 版权协议                   | 否   | 版权协议                                                 |
| icp 备案号                 | 否   | 页面底部的 icp 备案号，没有就不显示                      |
| icp 备案网址               | 否   | 页面底部的 icp 备案号点击后的跳转地址                    |
| 公安备案号                 | 否   | 页面底部的公安备案号，未填写则不显示                     |
| 公安备案网址               | 否   | 公安备案号点击后的跳转地址                               |
| 公安备案 Logo              | 否   | 公安备案号的 logo 地址，没有则不显示 logo                |
| Google Analysis ID         | 否   | Google Analysis 的 ID，没有的话就不开启 GA 了            |
| Baidu 分析 ID              | 否   | 百度分析的 ID，没有的话就不开启百度分析（统计）了        |
| 是否开启评论系统           | 否   | 默认开启，具体参考 [开启评论](../features/comment.md)    |
| 建站时间                   | 否   | 用于显示页面底部的本站运行时间，没有的话从今天算起       |

![高级设置](https://pic.mereith.com/img/cf276f8eec35c11300a64e4dbd1b7efd.clipboard-2022-08-15.png)

## 布局设置

改变前台展示布局的设置

| 设置名称 | 默认值 | 说明 |
| --- | --- | --- |
| 显示分类导航栏 | 隐藏 | 开启后会在上方导航栏下面显示一个分类子导航栏（开启需要配置至少一个分类） |
| 分类导航栏左侧偏移（px） | 0 | 导航栏显示的是网站名的时候，设置正确偏移以对其分类第一个字 |
| 导航栏左侧显示内容 | 网站名 | 切换成 logo 的前提是在 `高级设置` 中配置了网站 logo |
| 后台按钮是否显示 | 显示 | 关闭后会在导航栏右上角隐藏进入后台的按钮 |
| 是否显示友情链接 | 显示 | 开启后会在导航栏显示友情链接 |
| 是否显示捐赠信息 | 显示 | 开启后会在关于页面展示捐赠信息（前提是有至少一个捐赠） |
| 是否显示版权声明 | 显示 | 默认显示，关闭后文章页面将不显示版权声明 |
| 是否显示打赏按钮 | 显示 | 默认显示（前提是设置了支付宝和微信支付图片），关闭后所有位置将不显示打赏按钮 |
| 关于页面是否显示打赏按钮 | 隐藏 | 开启后关于页面将会显示打赏按钮 |
| 前台默认主题模式 | 自动模式 | 设置后第一次进入前台的用户将以此作为默认主题模式。 |
| 是否允许通过 URL 打开隐藏的文章 | 不允许 | 默认不允许，开启后可通过 URL 打开隐藏文章。 |
| 是否开启定制化功能 | 开启 | 默认开启，关闭后即使通过定制化面板，自定义了 CSS、Script、HTML 也不会生效 |
| 是否显示 RSS 按钮 | 开启 | 默认开启，关闭后所有位置会隐藏 RSS 按钮 |
| 前台点击链接时的默认行为 | 在当前页面跳转 | 默认在当前页面跳转，会影响除了导航栏之外的大部分链接 |
| 是否显示文章内容过时提醒 | 显示 | 默认显示，关闭后文章页面不会显示内容过期提醒。 |
| 是否在前台展示编辑按钮 | 显示 | 默认开启，关闭后登录后台时，前台将不再显示编辑按钮。 |

![布局设置](https://pic.mereith.com/img/ea8f567f74f4364bbbeffca9c365de2b.clipboard-2023-05-06.webp)
