---
title: 流水线
icon: tree
order: 9
---

流水线功能允许你在特定的事件发生前后，执行基本上任意的 `javascript` 代码，处理事件发生前后的数据，甚至改写事件发生的结果。例如：

- 在每次登录时，发送登录信息到微信机器人
- 在每次保存草稿或文章前，自动给文章增加统一的前置段落描述
- 在每次修改草稿或文章后，同步此文章到其他平台

结合 `API` 系统，可以做更多事情：

- 在每次删除文章前，调用 API，保存一份到草稿。
- 每次发布文章时，在另一篇文章里的引用链接加入新发布的文章

再结合 `手动触发事件` 和 `手动触发 API`，还可以做更多事情：

- 创建一键整理所有文字格式的流水线，通过 API 手动触发，做一个浏览器插件
- 做一个一键爬取其他平台文章的流水线，通过 API 手动触发，触发时传入要爬取的 URL

以后会有 `定时触发事件` 等更多事件类型，敬请期待。

## 事件类型

目前只有一些内置的系统事件，后续会逐步添加新事件。

| 名称 | 触发事件 | 输入 | 修改后的影响 |
| --- | --- | --- | --- |
| 登录 | 登录成功后触发 | 登录成功后的用户和 token | 无 |
| 登出 | 登出时触发会 | 当前登出的 token | 无 |
| 更新文章之前 | 更新文章之前 | 被更新的文章信息 | 修改后会影响更新后保存到数据库的结果 |
| 更新文章之后 | 更新文章之后 | 被更新文章的全部信息 | 无 |
| 删除文章 | 删除文章 | 被删除文章的全部信息 | 无 |
| 更新草稿之前 | 更新草稿之前 | 被更新的草稿信息 | 修改后会影响更新后保存到数据库的结果 |
| 更新草稿之后 | 更新草稿之后 | 被更新草稿的全部信息 | 无 |
| 删除草稿 | 删除草稿 | 被删除草稿的全部信息 | 无 |
| 更新站点信息 | 更新站点信息 | 更新的站点信息 | 无 |
| 手动触发事件 | 手动运行代码或手动通过 API 触发 | 手动触发时可传入 | 无 |

## 自定义代码

流水线可以执行的自定义代码是 `javascript` 代码，可以在其中使用 `require` 引入自定义依赖。编写时有几点注意事项：

- 脚本从上到下执行走一遍视为结束，异步操作请在顶层使用 `await` 关键字，不然将被不恰当终止
- 脚本的输入请直接使用 `input` 变量，修改里面的值后，将会在脚本结束传递给事件处理器

![](https://pic.mereith.com/img/1d851d0dbbcf3a394fc1208f5b9e3199.clipboard-2023-03-22.png)

## 依赖管理

创建流水线时，可以选择依赖，依赖是一些 `nodejs` 包，会分别通过 `pnpm install <依赖名>` 安装。

![](https://pic.mereith.com/img/25e5e6b6828856232851c2adf575674e.clipboard-2023-03-22.png)

## 调试代码

在代码编辑器可以调试代码，调试时，可以指定 JSON 输入给脚本的 `input` 变量中。

![](https://pic.mereith.com/img/2e920393bf748bef318bd13b6ac5c760.clipboard-2023-03-22.png)

![](https://pic.mereith.com/img/6a3f61ff043a5dbb1957cc8d86ee93d6.clipboard-2023-03-22.png)

## 运行日志

流水线的运行日志可以在 `站点管理/日志管理` 中找到，点击每一条的详情可以看到每一条流水线的输入、输出和脚本的 `console.log`。

![](https://pic.mereith.com/img/2bcb0ef613c63ca0ddcf01d184e8afc9.clipboard-2023-03-22.png)

![](https://pic.mereith.com/img/4401674ee1d74aea1f6df22401b1cf82.clipboard-2023-03-22.png)
