---
title: 草稿管理
icon: feather
order: 2
---

与 [文章管理](./article.md) 类似，你可以在在草稿管理页面下对草稿进行管理。

![草稿管理](https://pic.mereith.com/img/0f7f16346a52a69190fa11d08e92beb2.clipboard-2022-08-30.png)

![草稿搜索](https://pic.mereith.com/img/730ad49e1827f8972e582239122a62b4.clipboard-2022-08-16.png)

::: tip

一般而言，你应该从草稿开始书写文章，完成草稿后再发布到文章列表中。

直接创建新文章**会立即展示在前台页面**。

:::

## 新建草稿

你可以点击 `新建草稿` 按钮创建新草稿。

新建草稿包含有以下选项：

![新建草稿](https://www.mereith.com/static/img/4f96f5e2e1d7d289e85f69cabe2a8d35.clipboard-2022-09-06.png)

### 相关项目

- 作者

  默认为登录者本人，下拉框内的选择范围包括 _所有的协作者的昵称_ 以及后台站点设置中的 _作者名称_。

- 标签

  每篇文章可以有多个标签，用于索引文章。

  标签不需要提前创建，你可以在需要标签的表单看到所有的标签或者创建新的标签：

  ![设置标签](https://pic.mereith.com/img/f96db83327831a83b5eb7b010be0f431.clipboard-2022-08-15.png)

- 分类

  选择分类前需要创建分类，具体请参考[分类管理](./tag.md#分类管理)

## 导入草稿

你可以点击 `导入` 按钮导入 Markdown 文件来创建草稿，暂不支持其他类型的文件。

![导入 Markdown](https://pic.mereith.com/img/513d3fa66a42e3832682d623a0f0f664.clipboard-2022-08-29.png)

其中，Markdown 文件的 [Front Matter](https://hexo.bootcss.com/docs/front-matter.html) 将会被自动解析成 VanBlog 的字段并展示在弹出的确认表单中，具体而言：

| 字段名称   | 映射到 VanBlog 中的字段 | 说明                                              |
| ---------- | ----------------------- | ------------------------------------------------- |
| title      | 标题                    | 默认使用文件名                                    |
| tags       | 标签                    | 默认为空                                          |
| categories | 分类                    | 会选择第一个包含在 Vanblog 系统中的分类，否则为空 |
| category   | 分类                    | 会选择第一个包含在 Vanblog 系统中的分类，否则为空 |
| date       | 创建日期                | 如果默认为当前时间                                |
| hide       | 是否隐藏文章            | 默认不隐藏                                        |
| hidden     | 是否隐藏文章            | 默认不隐藏                                        |
| password   | 是否加密/密码           | 如果有，则文章自动为加密，且该字段为密码          |
| top        | 置顶优先级              | 默认为 0                                          |

选择文件后，会弹出确认窗口，您可以在这里继续编辑或修改信息：

![信息确认](https://pic.mereith.com/img/507093b889194a9726439c74474e90b0.clipboard-2022-08-29.png)

点击确定后，则以该表单为数据进行草稿创建。

## 编辑草稿

点击编辑按钮，即可跳转到编辑器编辑该草稿。

![编辑草稿](https://pic.mereith.com/img/577da489715c94c183247ba63887aac5.clipboard-2022-08-30.png)

如需修改草稿信息，点击 `修改信息` 按钮即可。

::: tip 自动实时保存

编辑草稿时会自动实时保存内容到本地缓存，此功能默认关闭，可在编辑器右上角下拉菜单中的 `偏好设置` 中开启。

即使没有点击保存按钮就退出了编辑器，下次进入后也会自动恢复上次的状态。

![自动保存](https://pic.mereith.com/img/85fa1dc72226c92b7b176cc40690999d.clipboard-2022-08-31.png)

![开启自动保存](https://pic.mereith.com/img/83e5a9815d0538447ef2fa97fe9c875d.clipboard-2023-06-27.webp) :::

## 修改草稿信息

可以点击草稿表格操作栏下拉菜单中的修改信息进行修改。

或者在编辑页面点击右上角操作中的 `修改信息` 按钮进行修改。

## 发布草稿

当草稿被完善到可以发布的地步，可以在编辑页面点击右上角操作菜单中的 `发布草稿按钮` 进行发布。具体选项含义可以参考 [文章管理](./article.md)。

![发布草稿](https://pic.mereith.com/img/4aadf867768d04fb906085532664c0df.clipboard-2023-02-27.png)

注意的是，草稿发布后会在草稿管理页面消失，而文章管理页面会出现已经发布的草稿。

## 导出草稿

你可以在草稿管理页面操作栏下拉菜单中点击 `导出` 来导出草稿，或者通过在编辑器中的导出按钮来导出草稿。

导出时会自动映射信息到 Markdown 文件的 FrontMatter 中。

现在也可以进行批量导出了，多选后点击批量导出即可。

## 删除草稿

你可以选择删除某篇草稿，删除后原则上不可恢复。

现在也可以进行批量删除了，多选后点击批量删除即可。

::: note 实际上只是软删除，但没有误删恢复的功能，如果真有恢复需求请联系作者或自行去数据库搜查 :::

## 批量操作

文章管理页面支持批量操作，可以批量删除或者批量导出。
