/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class PDFObject
implements Serializable {
    private String type;
    protected int objser;
    protected PDFDocument pdfDocument;

    public PDFObject(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public final int getSerialID() {
        return this.objser;
    }

    public final PDFDocument getPDFDocument() {
        return this.pdfDocument;
    }

    public abstract void write(OutputStream var1) throws IOException;

    public final void writeStart(OutputStream os) throws IOException {
        os.write(Integer.toString(this.objser).getBytes("UTF-8"));
        os.write(" 0 obj\n<<\n".getBytes("UTF-8"));
        if (this.type != null) {
            os.write("/Type ".getBytes("UTF-8"));
            os.write(this.type.getBytes("UTF-8"));
            os.write("\n".getBytes("UTF-8"));
        }
    }

    public final void writeEnd(OutputStream os) throws IOException {
        os.write(">>\nendobj\n".getBytes("UTF-8"));
    }

    public String toString() {
        return "" + this.objser + " 0 R";
    }

    public static String toArray(Vector<? extends PDFObject> v) {
        if (v.size() == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        String bs = "[";
        for (PDFObject pDFObject : v) {
            b.append(bs);
            b.append(pDFObject.toString());
            bs = " ";
        }
        b.append("]");
        return b.toString();
    }
}

