/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFStringHelper;
import java.io.IOException;
import java.io.OutputStream;

public class PDFInfo
extends PDFObject {
    private String author;
    private String creator;
    private String title;
    private String subject;
    private String keywords;

    public PDFInfo() {
        super(null);
    }

    public PDFInfo(String title) {
        this();
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String v) {
        this.author = v;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String v) {
        this.creator = v;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String v) {
        this.subject = v;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String v) {
        this.keywords = v;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this.author != null) {
            os.write("/Author (".getBytes("UTF-8"));
            os.write(PDFStringHelper.makePDFString(this.author).getBytes("UTF-8"));
            os.write(")\n".getBytes("UTF-8"));
        }
        if (this.creator != null) {
            os.write("/Creator (".getBytes("UTF-8"));
            os.write(PDFStringHelper.makePDFString(this.creator).getBytes("UTF-8"));
            os.write(")\n".getBytes("UTF-8"));
        }
        os.write("/Producer ".getBytes("UTF-8"));
        os.write(PDFStringHelper.makePDFString("gnujpdf - gnujpdf.sourceforge.net").getBytes("UTF-8"));
        os.write("\n".getBytes("UTF-8"));
        if (this.title != null) {
            os.write("/Title ".getBytes("UTF-8"));
            os.write(PDFStringHelper.makePDFString(this.title).getBytes("UTF-8"));
            os.write("\n".getBytes("UTF-8"));
        }
        if (this.subject != null) {
            os.write("/Subject (".getBytes("UTF-8"));
            os.write(PDFStringHelper.makePDFString(this.subject).getBytes("UTF-8"));
            os.write(")\n".getBytes("UTF-8"));
        }
        if (this.keywords != null) {
            os.write("/Keywords (".getBytes("UTF-8"));
            os.write(PDFStringHelper.makePDFString(this.keywords).getBytes("UTF-8"));
            os.write(")\n".getBytes("UTF-8"));
        }
        this.writeEnd(os);
    }
}

