/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.fullscreen.adaptive;

import java.awt.Window;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.fullscreen.exclusivemode.ExclusiveModeFullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.fullscreen.osx.OsxFullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.fullscreen.windows.Win32FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.fullscreen.x.XFullScreenStrategy;

public class AdaptiveFullScreenStrategy
implements FullScreenStrategy {
    private final FullScreenStrategy strategy;

    public AdaptiveFullScreenStrategy(Window window) {
        this.strategy = this.getStrategy(window);
    }

    @Override
    public final void enterFullScreenMode() {
        this.onBeforeEnterFullScreen();
        this.strategy.enterFullScreenMode();
    }

    @Override
    public final void exitFullScreenMode() {
        this.strategy.exitFullScreenMode();
        this.onAfterExitFullScreen();
    }

    @Override
    public final boolean isFullScreenMode() {
        return this.strategy.isFullScreenMode();
    }

    protected void onBeforeEnterFullScreen() {
    }

    protected void onAfterExitFullScreen() {
    }

    private FullScreenStrategy getStrategy(Window window) {
        if (RuntimeUtil.isNix()) {
            return new XFullScreenStrategy(window);
        }
        if (RuntimeUtil.isWindows()) {
            return new Win32FullScreenStrategy(window);
        }
        if (RuntimeUtil.isMac()) {
            return new OsxFullScreenStrategy(window);
        }
        return new ExclusiveModeFullScreenStrategy(window);
    }
}

