/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.DialogId;
import uk.co.caprica.vlcj.factory.DialogType;
import uk.co.caprica.vlcj.factory.Dialogs;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;

public final class DialogsApi
extends BaseApi {
    DialogsApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public Dialogs newDialogs(DialogType ... dialogTypes) {
        return new Dialogs(dialogTypes);
    }

    public void enable(Dialogs dialogs) {
        this.enable(dialogs, null);
    }

    public void disable() {
        this.disable(null);
    }

    public void enable(Dialogs dialogs, Long userData) {
        LibVlc.libvlc_dialog_set_callbacks(this.libvlcInstance, dialogs.callbacks(), DialogsApi.pointer(userData));
    }

    public void disable(Long userData) {
        LibVlc.libvlc_dialog_set_callbacks(this.libvlcInstance, null, DialogsApi.pointer(userData));
    }

    public boolean postLogin(DialogId id, String username, String password, boolean storeCredentials) {
        return LibVlc.libvlc_dialog_post_login(id.id(), username, password, storeCredentials ? 1 : 0) == 0;
    }

    public boolean postAction(DialogId id, int action) {
        return LibVlc.libvlc_dialog_post_action(id.id(), action) == 0;
    }

    public boolean dismiss(DialogId id) {
        return LibVlc.libvlc_dialog_dismiss(id.id()) == 0;
    }

    private static Pointer pointer(Long userData) {
        return userData != null ? Pointer.createConstant((long)userData) : null;
    }
}

