/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.video;

import com.jpexs.helpers.Helper;
import com.jpexs.video.FrameListener;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.MediaListRef;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.CallbackVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapters;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventAdapter;
import uk.co.caprica.vlcj.player.list.MediaListPlayerEventListener;
import uk.co.caprica.vlcj.player.list.PlaybackMode;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

public class SimpleMediaPlayer {
    private List<FrameListener> listeners = new ArrayList<FrameListener>();
    private final EmbeddedMediaPlayer embeddedMediaPlayer;
    private final MediaListPlayer mediaListPlayer;
    private final MediaPlayerFactory mediaPlayerFactory;
    private boolean paused = false;
    private long time = 0L;
    private float position = 0.0f;
    private long length = 0L;
    private boolean positionSet = false;
    private boolean loaded = false;
    private boolean finished = false;
    private boolean singleFrame = false;
    private final Object displayLock = new Object();
    private final Object pauseLock = new Object();
    private String file;
    private MyRenderCallback callback;
    private static boolean available = true;

    public static boolean isAvailable() {
        return available;
    }

    public long getLength() {
        return this.length;
    }

    public void addFrameListener(FrameListener listener) {
        this.listeners.add(listener);
    }

    public void removeFrameListener(FrameListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String file) {
        this.loaded = false;
        this.file = file;
        MediaList mediaList = this.mediaPlayerFactory.media().newMediaList();
        mediaList.media().add(file, new String[0]);
        MediaListRef mediaListRef = mediaList.newMediaListRef();
        try {
            this.mediaListPlayer.list().setMediaList(mediaListRef);
        }
        finally {
            mediaListRef.release();
        }
        this.mediaListPlayer.controls().play();
        this.embeddedMediaPlayer.controls().setPause(true);
    }

    public void stop() {
        this.embeddedMediaPlayer.controls().stop();
    }

    public float getPosition() {
        return this.embeddedMediaPlayer.status().position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(float position) {
        if (!this.isPaused()) {
            Object object = this.pauseLock;
            synchronized (object) {
                this.embeddedMediaPlayer.controls().setPause(true);
                try {
                    this.pauseLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.embeddedMediaPlayer.controls().setPosition(position);
        this.embeddedMediaPlayer.controls().play();
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized void setPaused(boolean val) {
        this.paused = val;
    }

    public void pause() {
        this.embeddedMediaPlayer.controls().pause();
    }

    public SimpleMediaPlayer() {
        BufferFormatCallback bufferFormatCallback = new BufferFormatCallback(){

            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                return new BufferFormat("BGRA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
            }

            public void allocatedBuffers(ByteBuffer[] buffers) {
            }
        };
        this.callback = new MyRenderCallback(this.listeners);
        CallbackVideoSurface callbackVideoSurface = new CallbackVideoSurface(bufferFormatCallback, (RenderCallback)this.callback, false, VideoSurfaceAdapters.getVideoSurfaceAdapter());
        this.mediaPlayerFactory = new MediaPlayerFactory();
        this.embeddedMediaPlayer = this.mediaPlayerFactory.mediaPlayers().newEmbeddedMediaPlayer();
        callbackVideoSurface.attach((MediaPlayer)this.embeddedMediaPlayer);
        this.embeddedMediaPlayer.videoSurface().set((VideoSurface)callbackVideoSurface);
        this.embeddedMediaPlayer.videoSurface().attachVideoSurface();
        MediaPlayerEventAdapter adapter = new MediaPlayerEventAdapter(){

            public void lengthChanged(MediaPlayer mediaPlayer, long newLength) {
                SimpleMediaPlayer.this.length = newLength;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paused(MediaPlayer mediaPlayer) {
                SimpleMediaPlayer.this.setPaused(true);
                Object object = SimpleMediaPlayer.this.pauseLock;
                synchronized (object) {
                    SimpleMediaPlayer.this.pauseLock.notifyAll();
                }
            }

            public void playing(MediaPlayer mediaPlayer) {
                SimpleMediaPlayer.this.finished = false;
                SimpleMediaPlayer.this.setPaused(false);
            }
        };
        this.mediaListPlayer = this.mediaPlayerFactory.mediaPlayers().newMediaListPlayer();
        this.mediaListPlayer.events().addMediaListPlayerEventListener((MediaListPlayerEventListener)new MediaListPlayerEventAdapter(){

            public void nextItem(MediaListPlayer mediaListPlayer, MediaRef item) {
            }
        });
        this.mediaListPlayer.mediaPlayer().setMediaPlayer((MediaPlayer)this.embeddedMediaPlayer);
        this.mediaListPlayer.controls().setMode(PlaybackMode.LOOP);
        this.embeddedMediaPlayer.events().addMediaPlayerEventListener((MediaPlayerEventListener)adapter);
    }

    public boolean isFinished() {
        return this.finished;
    }

    static {
        if (Platform.isWindows()) {
            boolean needs64bit = Helper.is64BitJre();
            String VLC_REGISTRY_KEY = "SOFTWARE\\VideoLAN\\VLC";
            if (Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\VideoLAN\\VLC", needs64bit)) {
                if (Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\VideoLAN\\VLC", "InstallDir", needs64bit)) {
                    String vlcInstallDir = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\VideoLAN\\VLC", "InstallDir", needs64bit);
                    NativeLibrary.addSearchPath((String)"libvlc", (String)vlcInstallDir);
                } else {
                    available = false;
                }
            } else {
                available = false;
            }
        }
        if (available) {
            try {
                LibVlcVersion version = new LibVlcVersion();
                if (!version.isSupported()) {
                    available = false;
                }
            }
            catch (UnsatisfiedLinkError err) {
                available = false;
            }
        }
    }

    private class MyRenderCallback
    implements RenderCallback {
        private List<FrameListener> videoSurfaces;
        private int width;
        private int height;
        private BufferedImage image;
        private int[] rgbBuffer;

        public BufferedImage getImage() {
            return this.image;
        }

        public void sendImage() {
            for (FrameListener fl : this.videoSurfaces) {
                fl.newFrameRecieved(this.image);
            }
        }

        public MyRenderCallback(List<FrameListener> listeners) {
            this.videoSurfaces = listeners;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
            if (!SimpleMediaPlayer.this.isPaused()) {
                // empty if block
            }
            Object object = SimpleMediaPlayer.this.displayLock;
            synchronized (object) {
                SimpleMediaPlayer.this.singleFrame = false;
                if (this.image == null) {
                    this.width = bufferFormat.getWidth();
                    this.height = bufferFormat.getHeight();
                    this.image = new BufferedImage(this.width, this.height, 2);
                    this.rgbBuffer = new int[this.image.getWidth() * this.image.getHeight()];
                }
                nativeBuffers[0].asIntBuffer().get(this.rgbBuffer, 0, bufferFormat.getHeight() * bufferFormat.getWidth());
                this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), this.rgbBuffer, 0, this.image.getWidth());
                this.sendImage();
            }
        }
    }
}

