/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers.utf8;

import com.jpexs.helpers.utf8.charset.Gb2312;
import com.jpexs.helpers.utf8.charset.ShiftJis;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utf8Helper {
    public static String charsetName = "UTF-8";
    public static Charset charset = Charset.forName("UTF-8");
    private static List<String> allowedVariableLengthCharsets = Arrays.asList("GB2312", "Shift_JIS", "UTF-8", "UTF-16", "UTF16-BE", "UTF-16-LE", "UTF-32", "UTF-32LE", "UTF-32BE");
    public static List<String> allowedCharsets = new ArrayList<String>();

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static byte[] getBytes(String string) {
        return string.getBytes(charset);
    }

    public static int getBytesLength(String string) {
        return string.getBytes(charset).length;
    }

    public static char codePointToChar(int codePoint, String charsetName) {
        int newCodePoint;
        switch (charsetName) {
            case "GB2312": {
                newCodePoint = new Gb2312().toUnicode(codePoint);
                break;
            }
            case "Shift_JIS": {
                newCodePoint = new ShiftJis().toUnicode(codePoint);
                break;
            }
            case "UTF-8": 
            case "UTF-16": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "UTF-32": 
            case "UTF-32BE": 
            case "UTF-32LE": {
                newCodePoint = codePoint;
                break;
            }
            default: {
                newCodePoint = -1;
                try {
                    newCodePoint = new String(new byte[]{(byte)codePoint}, charsetName).codePointAt(0);
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(Utf8Helper.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (newCodePoint >= 0) {
            return (char)newCodePoint;
        }
        return '?';
    }

    public static int charToCodePoint(char character, String charsetName) {
        int codePoint;
        int unicodeCodePoint = character;
        switch (charsetName) {
            case "GB2312": {
                codePoint = new Gb2312().fromUnicode(unicodeCodePoint);
                break;
            }
            case "Shift_JIS": {
                codePoint = new ShiftJis().fromUnicode(unicodeCodePoint);
                break;
            }
            case "UTF-8": 
            case "UTF-16": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "UTF-32": 
            case "UTF-32BE": 
            case "UTF-32LE": {
                codePoint = unicodeCodePoint;
                break;
            }
            default: {
                codePoint = -1;
                try {
                    codePoint = ("" + (char)character).getBytes(charsetName)[0] & 0xFF;
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(Utf8Helper.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return codePoint;
    }

    static {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        for (String s : charsets.keySet()) {
            Charset charset = (Charset)charsets.get(s);
            int maxLen = 0;
            int minLen = Integer.MAX_VALUE;
            try {
                for (int i = 0; i < 65536; ++i) {
                    ByteBuffer buf = charset.encode("" + (char)i);
                    int len = buf.remaining();
                    if (len > maxLen) {
                        maxLen = len;
                    }
                    if (len >= minLen) continue;
                    minLen = len;
                }
                if ((minLen != maxLen || minLen != 1) && !allowedVariableLengthCharsets.contains(s)) continue;
                allowedCharsets.add(s);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }
}

