/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.helpers.JpegMarker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JpegFixer {
    public static final int SOI = 216;
    public static final int EOI = 217;

    public void fixJpeg(InputStream is, OutputStream os) throws IOException {
        boolean prevEoi = false;
        int val = is.read();
        if (val == -1) {
            return;
        }
        if (val == 255) {
            val = is.read();
            if (val == -1) {
                os.write(255);
                return;
            }
            if (val != 216 && val != 217) {
                os.write(255);
                os.write(val);
                while ((val = is.read()) > -1) {
                    os.write(val);
                }
                return;
            }
            if (val == 217) {
                val = is.read();
                int val2 = is.read();
                if (val == 255 && val2 == 216) {
                    val = is.read();
                    val2 = is.read();
                    if (val != 255 || val2 != 216) {
                        os.write(255);
                        os.write(217);
                        os.write(255);
                        os.write(216);
                        if (val != -1) {
                            os.write(val);
                        }
                        if (val2 != -1) {
                            os.write(val2);
                        }
                        while ((val = is.read()) > -1) {
                            os.write(val);
                        }
                        return;
                    }
                } else {
                    os.write(255);
                    os.write(217);
                    if (val != -1) {
                        os.write(val);
                    }
                    if (val2 != -1) {
                        os.write(val2);
                    }
                    while ((val = is.read()) > -1) {
                        os.write(val);
                    }
                    return;
                }
            }
            os.write(255);
            os.write(216);
        } else {
            os.write(val);
            while ((val = is.read()) > -1) {
                os.write(val);
            }
            return;
        }
        block4: while ((val = is.read()) > -1) {
            if (val == 255) {
                val = is.read();
                if (val == 0) {
                    os.write(255);
                    os.write(val);
                    prevEoi = false;
                    continue;
                }
                if (!(val == 216 && prevEoi || val == 216)) {
                    if (prevEoi) {
                        os.write(255);
                        os.write(217);
                        os.write(255);
                        if (val != -1) {
                            os.write(val);
                        }
                    } else if (val != 217) {
                        os.write(255);
                        if (val != -1) {
                            os.write(val);
                        }
                    }
                }
                if (val != -1 && JpegMarker.markerHasLength(val)) {
                    int len1 = is.read();
                    if (len1 == -1) break;
                    int len2 = is.read();
                    if (len2 == -1) {
                        os.write(len1);
                        break;
                    }
                    os.write(len1);
                    os.write(len2);
                    int len = (len1 << 8) + len2;
                    for (int i = 0; i < len - 2; ++i) {
                        int val2 = is.read();
                        if (val2 == -1) break block4;
                        os.write(val2);
                    }
                }
                prevEoi = val == 217;
                continue;
            }
            os.write(val);
            prevEoi = false;
        }
        if (prevEoi) {
            os.write(255);
            os.write(217);
        }
    }
}

