/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.helpers.JpegMarker;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class JpegAnalyzer {
    public void analyze(InputStream is) throws IOException {
        int val;
        while ((val = is.read()) != -1) {
            if (val != 255) continue;
            val = is.read();
            if (val == -1) break;
            if (val == 0) continue;
            int len = 2;
            if (JpegMarker.markerHasLength(val)) {
                int len1 = is.read();
                int len2 = is.read();
                len = (len1 << 8) + len2;
                is.skip(len - 2);
            }
            System.out.println("marker " + JpegMarker.markerToString(val) + " len: " + len);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        JpegAnalyzer analyzer = new JpegAnalyzer();
        analyzer.analyze(new FileInputStream("sample.jpg"));
    }
}

