/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class HashArrayList<E>
extends ArrayList<E> {
    private HashMap<E, Integer> map = new HashMap();

    public HashArrayList() {
    }

    public HashArrayList(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
    }

    public HashArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        super.ensureCapacity(minCapacity);
        HashMap<E, Integer> oldMap = this.map;
        this.map = new HashMap(minCapacity * 10 / 7);
        this.map.putAll(oldMap);
    }

    @Override
    public boolean add(E e) {
        this.map.put(e, this.size());
        return super.add(e);
    }

    @Override
    public E set(int index, E element) {
        this.map.remove(this.get(index));
        this.map.put(element, index);
        return super.set(index, element);
    }

    @Override
    public int indexOf(Object o) {
        Integer index = this.map.get(o);
        if (index == null) {
            return -1;
        }
        return index;
    }
}

