/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.Freed;
import com.jpexs.helpers.FileHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cache<K, V>
implements Freed {
    private Map<K, V> cache;
    private Map<K, Long> lastAccessed;
    private static final Object instancesLock = new Object();
    private static final List<WeakReference<Cache>> instances = new ArrayList<WeakReference<Cache>>();
    public static final int STORAGE_FILES = 1;
    public static final int STORAGE_MEMORY = 2;
    private final boolean weak;
    private final boolean memoryOnly;
    private final String name;
    private final boolean temporary;
    private static final long CLEAN_INTERVAL = 5000L;
    private static Thread oldCleaner = null;
    private static int storageType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Cache<K, V> getInstance(boolean weak, boolean memoryOnly, String name, boolean temporary) {
        if (oldCleaner == null) {
            oldCleaner = new Thread("Cache cleaner"){

                @Override
                public void run() {
                    while (!Thread.interrupted()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        try {
                            Cache.clearAllOldAndOverMax();
                        }
                        catch (Exception cme) {
                            Logger.getLogger(Cache.class.getSimpleName()).log(Level.SEVERE, "Error during clearing cache thread", cme);
                        }
                    }
                }
            };
            oldCleaner.setDaemon(true);
            oldCleaner.setPriority(1);
            oldCleaner.start();
        }
        Cache<K, V> instance = new Cache<K, V>(weak, memoryOnly, name, temporary);
        Object object = instancesLock;
        synchronized (object) {
            instances.add(new WeakReference<Cache<K, V>>(instance));
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        Object object = instancesLock;
        synchronized (object) {
            for (WeakReference<Cache> cw : instances) {
                Cache c = (Cache)cw.get();
                if (c == null) continue;
                c.clear();
                c.initCache();
            }
        }
    }

    public static void setStorageType(int storageType) {
        if (storageType == Cache.storageType) {
            return;
        }
        switch (storageType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("storageType must be one of STORAGE_FILES or STORAGE_MEMORY");
            }
        }
        if (storageType != Cache.storageType) {
            Cache.clearAll();
        }
        Cache.storageType = storageType;
    }

    public static int getStorageType() {
        return storageType;
    }

    private void initCache() {
        int thisStorageType = storageType;
        if (this.memoryOnly) {
            thisStorageType = 2;
        }
        AbstractMap newCache = null;
        if (thisStorageType == 1) {
            try {
                newCache = new FileHashMap(File.createTempFile("ffdec_cache_" + this.name + "_", ".tmp"));
            }
            catch (IOException ex) {
                thisStorageType = 2;
            }
        }
        if (thisStorageType == 2) {
            newCache = this.weak ? new WeakHashMap() : new HashMap();
        }
        if (this.cache instanceof Freed) {
            ((Freed)((Object)this.cache)).free();
        }
        this.lastAccessed = new WeakHashMap<K, Long>();
        this.cache = newCache;
    }

    private Cache(boolean weak, boolean memoryOnly, String name, boolean temporary) {
        this.weak = weak;
        this.name = name;
        this.memoryOnly = memoryOnly;
        this.temporary = temporary;
        this.initCache();
    }

    public synchronized boolean contains(K key) {
        boolean ret = this.cache.containsKey(key);
        if (ret) {
            this.lastAccessed.put(key, System.currentTimeMillis());
        }
        return ret;
    }

    public synchronized void clear() {
        this.cache.clear();
        this.lastAccessed.clear();
    }

    public synchronized void remove(K key) {
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
        if (this.lastAccessed.containsKey(key)) {
            this.lastAccessed.remove(key);
        }
    }

    public synchronized V get(K key) {
        this.lastAccessed.put(key, System.currentTimeMillis());
        return this.cache.get(key);
    }

    public synchronized void put(K key, V value) {
        this.cache.put(key, value);
        this.lastAccessed.put(key, System.currentTimeMillis());
    }

    @Override
    public boolean isFreeing() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void free() {
        if (this.cache instanceof Freed) {
            ((Freed)((Object)this.cache)).free();
        }
    }

    public Set<K> keys() {
        HashSet<K> ret = new HashSet<K>();
        ret.addAll(this.cache.keySet());
        return ret;
    }

    private synchronized int clearOverMax() {
        HashSet<K> keys = new HashSet<K>(this.lastAccessed.keySet());
        int num = 0;
        if (Configuration.maxCachedNum.get() > 0 && keys.size() > Configuration.maxCachedNum.get()) {
            ArrayList<K> keysList = new ArrayList<K>(keys);
            Collections.sort(keysList, new Comparator<K>(){

                @Override
                public int compare(K o1, K o2) {
                    long t2;
                    long t1 = (Long)Cache.this.lastAccessed.get(o1);
                    if (t1 > (t2 = ((Long)Cache.this.lastAccessed.get(o2)).longValue())) {
                        return 1;
                    }
                    if (t2 > t1) {
                        return -1;
                    }
                    return 0;
                }
            });
            int cnt = keysList.size() - Configuration.maxCachedNum.get();
            for (int i = 0; i < cnt; ++i) {
                this.remove(keysList.get(i));
                ++num;
            }
        }
        return num;
    }

    private synchronized int clearOld() {
        long currentTime = System.currentTimeMillis();
        HashSet<K> keys = new HashSet<K>(this.lastAccessed.keySet());
        int temporaryThreshold = Configuration.maxCachedTime.get();
        if (temporaryThreshold == 0) {
            return 0;
        }
        int num = 0;
        for (Object key : keys) {
            long time = this.lastAccessed.get(key);
            if (time >= currentTime - (long)temporaryThreshold) continue;
            this.remove(key);
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearAllOldAndOverMax() {
        int num = 0;
        Object object = instancesLock;
        synchronized (object) {
            for (WeakReference<Cache> cw : instances) {
                Cache c = (Cache)cw.get();
                if (c == null) continue;
                num += c.clearOverMax();
                if (!c.temporary) continue;
                num += c.clearOld();
            }
        }
        if (num > 0) {
            System.gc();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = instancesLock;
                synchronized (object) {
                    for (WeakReference cw : instances) {
                        Cache c = (Cache)cw.get();
                        if (c == null) continue;
                        c.clear();
                        c.free();
                    }
                }
            }
        });
        storageType = 1;
    }
}

