/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.precontinues;

import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.ThrowState;
import com.jpexs.decompiler.graph.precontinues.DoWhileNode;
import com.jpexs.decompiler.graph.precontinues.IfNode;
import com.jpexs.decompiler.graph.precontinues.JoinedNode;
import com.jpexs.decompiler.graph.precontinues.Node;
import com.jpexs.decompiler.graph.precontinues.WhileNode;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GraphPrecontinueDetector {
    public void detectPrecontinues(List<GraphPart> heads, Set<GraphPart> allParts, List<Loop> loops, List<ThrowState> throwStates) {
        boolean bl;
        Node node;
        boolean isSomethingTodo = false;
        for (Loop loop : loops) {
            if (loop.backEdges.size() != 1) continue;
            isSomethingTodo = true;
        }
        if (!isSomethingTodo) {
            return;
        }
        HashMap<GraphPart, Node> partToNode = new HashMap<GraphPart, Node>();
        for (GraphPart graphPart : allParts) {
            node = new Node();
            node.graphPart = graphPart;
            partToNode.put(graphPart, node);
        }
        for (GraphPart graphPart : allParts) {
            node = (Node)partToNode.get(graphPart);
            for (GraphPart prev : graphPart.refs) {
                if (prev.start < 0) continue;
                Node prevNode = (Node)partToNode.get(prev);
                node.prev.add(prevNode);
            }
            for (GraphPart next : graphPart.nextParts) {
                Node nextNode = (Node)partToNode.get(next);
                node.next.add(nextNode);
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (GraphPart head : heads) {
            arrayList.add((Node)partToNode.get(head));
        }
        boolean bl2 = true;
        while (bl) {
            bl = false;
            if (this.joinNodes(arrayList)) {
                bl = true;
            }
            if (this.checkIfs(arrayList)) {
                bl = true;
            }
            if (!this.handleWhile(arrayList)) continue;
            bl = true;
        }
        ArrayList<GraphPart> targetParts = new ArrayList<GraphPart>();
        for (ThrowState ts : throwStates) {
            targetParts.add(ts.targetPart);
        }
        for (Loop el : loops) {
            if (el.backEdges.size() != 1) continue;
            GraphPart backEdgePart = el.backEdges.iterator().next();
            Node node2 = (Node)partToNode.get(backEdgePart);
            boolean wholeLoop = false;
            boolean inTryTarget = false;
            boolean hasMoreNexts = false;
            boolean usePreNode = false;
            if (node2.parentNode == null && node2.prev.size() == 1) {
                Node prev = node2.prev.get(0);
                if (prev.next.size() == 2) {
                    Node other = null;
                    other = prev.next.get(0) == node2 ? prev.next.get(1) : prev.next.get(0);
                    if (other.graphPart == el.loopBreak) {
                        node2 = prev;
                        usePreNode = true;
                    }
                }
            }
            if (!usePreNode && node2.next.size() > 1) {
                if (node2.next.size() == 2) {
                    Node other = null;
                    other = node2.next.get((int)0).graphPart == el.loopContinue ? node2.next.get(1) : node2.next.get(0);
                    if (other.graphPart != el.loopBreak) {
                        hasMoreNexts = true;
                    }
                } else {
                    hasMoreNexts = true;
                }
            }
            if (targetParts.contains(node2.graphPart)) {
                inTryTarget = true;
            }
            if (!inTryTarget && !hasMoreNexts) {
                while (node2.parentNode != null) {
                    node2 = node2.parentNode;
                    if (node2.graphPart.equals(el.loopContinue)) {
                        wholeLoop = true;
                        break;
                    }
                    if (!targetParts.contains(node2.graphPart)) continue;
                    inTryTarget = true;
                    break;
                }
            }
            if (wholeLoop || inTryTarget || hasMoreNexts) continue;
            el.loopPreContinue = node2.graphPart;
        }
    }

    public void printGraph(List<Node> headNodes) {
        LinkedHashSet<Node> allNodes = new LinkedHashSet<Node>();
        for (Node headNode : headNodes) {
            this.populateNodes(headNode, allNodes);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("digraph mygraph {\r\n");
        for (Node node : allNodes) {
            String label = node.toString();
            for (Node n : node.next) {
                label = label + " next " + n.toString();
            }
            for (Node p : node.prev) {
                label = label + " prev " + p.toString();
            }
            sb.append("node" + node.getId() + "[label=\"" + label + "\"];\r\n");
            for (Node n : node.next) {
                sb.append("node" + node.getId() + "->node" + n.getId() + ";\r\n");
            }
        }
        sb.append("}\r\n");
        System.err.println(sb.toString());
    }

    private void populateNodes(Node node, Set<Node> populated) {
        if (populated.contains(node)) {
            return;
        }
        populated.add(node);
        for (Node n : node.next) {
            this.populateNodes(n, populated);
        }
    }

    private boolean checkIfs(List<Node> headNodes) {
        HashSet<Node> visited = new HashSet<Node>();
        Reference<Integer> numChanged = new Reference<Integer>(0);
        for (int h = 0; h < headNodes.size(); ++h) {
            Node newHeadNode = this.checkIfs(headNodes.get(h), visited, numChanged);
            headNodes.set(h, newHeadNode);
        }
        return numChanged.getVal() > 0;
    }

    private boolean joinNodes(List<Node> headNodes) {
        HashSet<Node> visited = new HashSet<Node>();
        Reference<Integer> numChanged = new Reference<Integer>(0);
        for (int h = 0; h < headNodes.size(); ++h) {
            Node newHeadNode = this.joinNodes(headNodes.get(h), visited, numChanged);
            headNodes.set(h, newHeadNode);
        }
        return numChanged.getVal() > 0;
    }

    private boolean handleWhile(List<Node> headNodes) {
        HashSet<Node> visited = new HashSet<Node>();
        Reference<Integer> numChanged = new Reference<Integer>(0);
        for (int h = 0; h < headNodes.size(); ++h) {
            Node newHeadNode = this.handleWhile(headNodes.get(h), visited, numChanged);
            headNodes.set(h, newHeadNode);
        }
        return numChanged.getVal() > 0;
    }

    private Node handleWhile(Node node, Set<Node> visited, Reference<Integer> numWhile) {
        if (visited.contains(node)) {
            return node;
        }
        visited.add(node);
        Node result = node;
        if (node.prev.contains(node) && node.next.contains(node) && node.next.size() == 2) {
            int i;
            DoWhileNode doWhileNode = new DoWhileNode();
            doWhileNode.body = node;
            doWhileNode.graphPart = node.graphPart;
            doWhileNode.prev = new ArrayList<Node>(node.prev);
            for (i = doWhileNode.prev.size() - 1; i >= 0; --i) {
                if (doWhileNode.prev.get(i) != node) continue;
                doWhileNode.prev.remove(i);
            }
            doWhileNode.next = new ArrayList<Node>(node.next);
            for (i = doWhileNode.next.size() - 1; i >= 0; --i) {
                if (doWhileNode.next.get(i) != node) continue;
                doWhileNode.next.remove(i);
            }
            node.replacePrevs(doWhileNode);
            node.replaceNexts(doWhileNode);
            node.removeFromGraph();
            node.parentNode = doWhileNode;
            result = doWhileNode;
            numWhile.setVal(numWhile.getVal() + 1);
        } else {
            Node bodyNode = null;
            Node breakNode = null;
            if (node.next.size() == 2 && node.next.get((int)0).next.size() == 1 && node.next.get((int)0).next.get(0) == node && node.next.get((int)0).prev.size() == 1) {
                breakNode = node.next.get(1);
                bodyNode = node.next.get(0);
            } else if (node.next.size() == 2 && node.next.get((int)1).next.size() == 1 && node.next.get((int)1).next.get(0) == node && node.next.get((int)1).prev.size() == 1) {
                breakNode = node.next.get(0);
                bodyNode = node.next.get(1);
            }
            if (bodyNode != null) {
                WhileNode whileNode = new WhileNode();
                bodyNode.parentNode = whileNode;
                whileNode.graphPart = node.graphPart;
                whileNode.body = bodyNode;
                whileNode.body.removeFromGraph();
                whileNode.prev = new ArrayList<Node>(node.prev);
                node.replacePrevs(whileNode);
                node.replaceNexts(whileNode);
                whileNode.next.add(breakNode);
                result = whileNode;
                numWhile.setVal(numWhile.getVal() + 1);
            }
        }
        ArrayList<Node> nexts = new ArrayList<Node>(result.next);
        for (Node n : nexts) {
            this.handleWhile(n, visited, numWhile);
        }
        return result;
    }

    private Node joinNodes(Node node, Set<Node> visited, Reference<Integer> numJoined) {
        if (visited.contains(node)) {
            return node;
        }
        visited.add(node);
        Node currentNode = node;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        nodeList.add(currentNode);
        while (currentNode.next.size() == 1 && currentNode.next.get((int)0).prev.size() == 1 && !visited.contains(currentNode.next.get(0))) {
            currentNode = currentNode.next.get(0);
            visited.add(currentNode);
            nodeList.add(currentNode);
        }
        Node result = node;
        if (nodeList.size() > 1) {
            Node n2;
            int i;
            JoinedNode joinedNode = new JoinedNode();
            joinedNode.graphPart = node.graphPart;
            joinedNode.nodes = nodeList;
            joinedNode.next = new ArrayList<Node>(currentNode.next);
            for (i = 0; i < joinedNode.next.size(); ++i) {
                n2 = (Node)joinedNode.next.get(i);
                if (n2 != node) continue;
                joinedNode.next.set(i, joinedNode);
            }
            joinedNode.prev = new ArrayList<Node>(node.prev);
            for (i = 0; i < joinedNode.prev.size(); ++i) {
                n2 = (Node)joinedNode.prev.get(i);
                if (n2 != currentNode) continue;
                joinedNode.prev.set(i, joinedNode);
            }
            node.replacePrevs(joinedNode);
            currentNode.replaceNexts(joinedNode);
            for (Node n2 : nodeList) {
                n2.parentNode = joinedNode;
                n2.removeFromGraph();
            }
            result = joinedNode;
            numJoined.setVal(numJoined.getVal() + 1);
        }
        ArrayList<Node> nexts = new ArrayList<Node>(result.next);
        for (Node n2 : nexts) {
            this.joinNodes(n2, visited, numJoined);
        }
        return result;
    }

    private Node checkIfs(Node node, Set<Node> visited, Reference<Integer> numIfs) {
        if (visited.contains(node)) {
            return node;
        }
        visited.add(node);
        if (node.next.size() == 2 && node.next.get((int)0).next.size() == 1 && node.next.get((int)0).next.get(0) == node.next.get(1) && node.next.get((int)0).prev.size() == 1) {
            IfNode ifNode = new IfNode();
            ifNode.onTrue = node.next.get(0);
            Node after = node.next.get(1);
            ifNode.onTrue.parentNode = ifNode;
            ifNode.onTrue.removeFromGraph();
            ifNode.onFalse = null;
            ifNode.graphPart = node.graphPart;
            ifNode.prev = new ArrayList<Node>(node.prev);
            node.replacePrevs(ifNode);
            node.removeFromGraph();
            ifNode.next.add(after);
            after.prev.add(ifNode);
            numIfs.setVal(numIfs.getVal() + 1);
            this.checkIfs(after, visited, numIfs);
            return ifNode;
        }
        if (node.next.size() == 2 && node.next.get((int)1).next.size() == 1 && node.next.get((int)1).next.get(0) == node.next.get(0) && node.next.get((int)1).prev.size() == 1) {
            IfNode ifNode = new IfNode();
            ifNode.onTrue = null;
            ifNode.onFalse = node.next.get(1);
            Node after = node.next.get(0);
            ifNode.onFalse.parentNode = ifNode;
            ifNode.onFalse.removeFromGraph();
            ifNode.graphPart = node.graphPart;
            ifNode.prev = new ArrayList<Node>(node.prev);
            node.replacePrevs(ifNode);
            node.removeFromGraph();
            ifNode.next.add(after);
            after.prev.add(ifNode);
            numIfs.setVal(numIfs.getVal() + 1);
            this.checkIfs(after, visited, numIfs);
            return ifNode;
        }
        if (node.next.size() == 2 && node.next.get((int)0).next.size() == 1 && node.next.get((int)1).next.size() == 1 && node.next.get((int)0).next.get(0) == node.next.get((int)1).next.get(0) && node.next.get((int)0).prev.size() == 1 && node.next.get((int)1).prev.size() == 1) {
            IfNode ifNode = new IfNode();
            Node after = node.next.get((int)0).next.get(0);
            ifNode.onTrue = node.next.get(0);
            ifNode.onTrue.parentNode = ifNode;
            ifNode.onFalse = node.next.get(1);
            ifNode.onFalse.parentNode = ifNode;
            ifNode.onTrue.removeFromGraph();
            ifNode.onFalse.removeFromGraph();
            ifNode.graphPart = node.graphPart;
            ifNode.prev = new ArrayList<Node>(node.prev);
            node.replacePrevs(ifNode);
            node.removeFromGraph();
            ifNode.next.add(after);
            after.prev.add(ifNode);
            numIfs.setVal(numIfs.getVal() + 1);
            this.checkIfs(after, visited, numIfs);
            return ifNode;
        }
        ArrayList<Node> nexts = new ArrayList<Node>(node.next);
        for (Node n : nexts) {
            this.checkIfs(n, visited, numIfs);
        }
        return node;
    }
}

