/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartChangeException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class GraphSource
implements Serializable {
    public abstract int size();

    public abstract GraphSourceItem get(int var1);

    public abstract boolean isEmpty();

    public abstract List<GraphTargetItem> translatePart(Graph var1, GraphPart var2, BaseLocalData var3, TranslateStack var4, int var5, int var6, int var7, String var8) throws InterruptedException, GraphPartChangeException;

    public abstract Set<Long> getImportantAddresses();

    public abstract String insToString(int var1);

    private void visitCode(int ip, int lastIp, HashMap<Integer, List<Integer>> refs, int endIp) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        boolean debugMode = false;
        while ((endIp == -1 || ip < endIp) && ip < this.size()) {
            refs.get(ip).add(lastIp);
            lastIp = ip;
            if (refs.get(ip).size() > 1) break;
            GraphSourceItem ins = this.get(ip);
            if (ins.isIgnored()) {
                ++ip;
                continue;
            }
            if (debugMode) {
                System.err.println("visit ip " + ip + " action:" + ins);
            }
            if (ins.isExit()) break;
            if (ins instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)ins);
                if (ins instanceof Action) {
                    long endAddr = ((Action)ins).getAddress() + cnt.getHeaderSize();
                    for (long size : cnt.getContainerSizes()) {
                        if (size != 0L) {
                            this.visitCode(this.adr2pos(endAddr), ip, refs, this.adr2pos(endAddr + size));
                        }
                        endAddr += size;
                    }
                    ip = this.adr2pos(endAddr);
                    continue;
                }
            }
            if (ins.isBranch() || ins.isJump()) {
                List<Integer> branches = ins.getBranches(this);
                for (int b : branches) {
                    if (b < 0) continue;
                    this.visitCode(b, ip, refs, endIp);
                }
                break;
            }
            ++ip;
        }
    }

    public HashMap<Integer, List<Integer>> visitCode(List<Integer> alternateEntries) throws InterruptedException {
        HashMap<Integer, List<Integer>> refs = new HashMap<Integer, List<Integer>>();
        int siz = this.size();
        for (int i = 0; i < siz; ++i) {
            refs.put(i, new ArrayList());
        }
        this.visitCode(0, 0, refs, -1);
        int pos = 0;
        for (int e : alternateEntries) {
            this.visitCode(e, -(++pos), refs, -1);
        }
        return refs;
    }

    public abstract int adr2pos(long var1);

    public abstract int adr2pos(long var1, boolean var3);

    public abstract long pos2adr(int var1);

    public long getAddressAfterCode() {
        if (this.isEmpty()) {
            return 0L;
        }
        long lastAddr = this.pos2adr(this.size() - 1);
        return lastAddr + (long)this.get(this.size() - 1).getBytesLength();
    }

    public final long pos2adr(int pos, boolean allowPosAfterCode) {
        if (pos == this.size() && allowPosAfterCode) {
            return this.getAddressAfterCode();
        }
        return this.pos2adr(pos);
    }
}

