/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.graph.GraphPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GraphPartMarkedArrayList<E>
extends ArrayList<E> {
    private List<List<GraphPart>> listParts = new ArrayList<List<GraphPart>>();
    private List<GraphPart> currentParts = new ArrayList<GraphPart>();

    public GraphPartMarkedArrayList(Collection<? extends E> collection) {
        super(collection);
        if (collection instanceof GraphPartMarkedArrayList) {
            for (int i = 0; i < collection.size(); ++i) {
                this.listParts.add(((GraphPartMarkedArrayList)collection).listParts.get(i));
            }
            this.currentParts = ((GraphPartMarkedArrayList)collection).currentParts;
        } else {
            for (int i = 0; i < collection.size(); ++i) {
                this.listParts.add(this.currentParts);
            }
        }
    }

    public GraphPartMarkedArrayList() {
    }

    public void startPart(GraphPart part) {
        this.currentParts.add(part);
    }

    public void clearCurrentParts() {
        this.currentParts = new ArrayList<GraphPart>();
    }

    @Override
    public boolean add(E e) {
        this.listParts.add(this.currentParts);
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.listParts.add(index, this.currentParts);
        super.add(index, element);
    }

    public List<GraphPart> getPartsAt(int index) {
        return this.listParts.get(index);
    }

    public int indexOfPart(GraphPart part) {
        for (int i = 0; i < this.listParts.size(); ++i) {
            List<GraphPart> list = this.listParts.get(i);
            if (list.indexOf(part) <= -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof GraphPartMarkedArrayList) {
            for (int i = 0; i < c.size(); ++i) {
                this.listParts.add(((GraphPartMarkedArrayList)c).listParts.get(i));
            }
        } else {
            for (int i = 0; i < c.size(); ++i) {
                this.listParts.add(this.currentParts);
            }
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c instanceof GraphPartMarkedArrayList) {
            for (int i = 0; i < c.size(); ++i) {
                this.listParts.add(index + i, ((GraphPartMarkedArrayList)c).listParts.get(i));
            }
        } else {
            for (int i = 0; i < c.size(); ++i) {
                this.listParts.add(index + i, this.currentParts);
            }
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            this.listParts.remove(this.indexOf(o));
        }
        return super.remove(o);
    }

    @Override
    public E remove(int index) {
        this.listParts.remove(index);
        return super.remove(index);
    }

    @Override
    public void clear() {
        this.listParts.clear();
        super.clear();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int i;
        GraphPartMarkedArrayList<E> ret = new GraphPartMarkedArrayList<E>(this);
        for (i = this.size(); i > toIndex; --i) {
            ret.remove(i);
        }
        for (i = 0; i < fromIndex; ++i) {
            ret.remove(i);
        }
        return ret;
    }

    @Override
    public Object clone() {
        return new GraphPartMarkedArrayList<E>(this);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            this.listParts.remove(this.indexOf(o));
        }
        return super.removeAll(c);
    }
}

