/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DottedChain
implements Serializable,
Comparable<DottedChain> {
    public static final DottedChain EMPTY = new DottedChain(true);
    public static final DottedChain UNBOUNDED = new DottedChain(new String[]{"*"});
    public static final DottedChain TOPLEVEL = new DottedChain(new String[0]);
    public static final DottedChain BOOLEAN = new DottedChain(new String[]{"Boolean"});
    public static final DottedChain STRING = new DottedChain(new String[]{"String"});
    public static final DottedChain ARRAY = new DottedChain(new String[]{"Array"});
    public static final DottedChain NUMBER = new DottedChain(new String[]{"Number"});
    public static final DottedChain OBJECT = new DottedChain(new String[]{"Object"});
    public static final DottedChain INT = new DottedChain(new String[]{"int"});
    public static final DottedChain UINT = new DottedChain(new String[]{"uint"});
    public static final DottedChain UNDEFINED = new DottedChain(new String[]{"Undefined"});
    public static final DottedChain XML = new DottedChain(new String[]{"XML"});
    public static final DottedChain NULL = new DottedChain(new String[]{"null"});
    public static final DottedChain FUNCTION = new DottedChain(new String[]{"Function"});
    public static final DottedChain VOID = new DottedChain(new String[]{"void"});
    public static final DottedChain NAMESPACE = new DottedChain(new String[]{"Namespace"});
    public static final DottedChain ALL = new DottedChain(new String[]{"*"});
    private List<PathPart> parts;
    private boolean isNull = false;

    public String getNamespaceSuffix(int index) {
        return this.parts.get((int)index).namespaceSuffix;
    }

    public String getLastNamespaceSuffix() {
        if (this.parts.isEmpty()) {
            return "";
        }
        return this.parts.get((int)(this.parts.size() - 1)).namespaceSuffix;
    }

    public static final DottedChain parseNoSuffix(String name) {
        if (name == null) {
            return EMPTY;
        }
        if (name.isEmpty()) {
            return TOPLEVEL;
        }
        String[] parts = name.split("\\.");
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (String part : parts) {
            newParts.add(new PathPart(part, false, ""));
        }
        return new DottedChain(newParts, false);
    }

    public static final DottedChain parseWithSuffix(String name) {
        if (name == null) {
            return EMPTY;
        }
        if (name.isEmpty()) {
            return TOPLEVEL;
        }
        String[] parts = name.split("\\.");
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        String[] stringArray = parts;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String part;
            String nameNoSuffix = part = stringArray[i];
            String namespaceSuffix = "";
            if (part.matches(".*#[0-9]+$")) {
                nameNoSuffix = part.substring(0, part.lastIndexOf("#"));
                namespaceSuffix = part.substring(part.lastIndexOf("#"));
            }
            newParts.add(new PathPart(nameNoSuffix, false, namespaceSuffix));
        }
        return new DottedChain(newParts, false);
    }

    private DottedChain(boolean isNull) {
        this.isNull = isNull;
        this.parts = new ArrayList<PathPart>();
    }

    public DottedChain(DottedChain src) {
        this.parts = new ArrayList<PathPart>(src.parts);
        this.isNull = src.isNull;
    }

    public DottedChain(String[] parts) {
        this(Arrays.asList(parts));
    }

    private DottedChain(List<PathPart> parts, boolean isNull) {
        this.parts = parts;
        this.isNull = isNull;
    }

    public DottedChain(List<String> parts) {
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (String part : parts) {
            newParts.add(new PathPart(part, false, ""));
        }
        this.parts = newParts;
    }

    public DottedChain(String[] parts, String[] namespaceSuffixes) {
        this(new boolean[parts.length], parts, namespaceSuffixes);
    }

    public DottedChain(boolean[] attributes, String[] parts, String[] namespaceSuffixes) {
        ArrayList<PathPart> newParts = new ArrayList<PathPart>();
        for (int i = 0; i < attributes.length; ++i) {
            newParts.add(new PathPart(parts[i], attributes[i], namespaceSuffixes[i]));
        }
        this.parts = newParts;
    }

    public boolean isTopLevel() {
        return !this.isNull && this.parts.isEmpty();
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public int size() {
        return this.parts.size();
    }

    public String get(int index) {
        if (index >= this.parts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.parts.get((int)index).name;
    }

    public boolean isAttribute(int index) {
        if (index >= this.parts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.parts.get((int)index).attribute;
    }

    public DottedChain subChain(int count) {
        if (count > this.parts.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new DottedChain(new ArrayList<PathPart>(this.parts.subList(0, count)), this.isNull);
    }

    public String getLast() {
        if (this.isNull) {
            return null;
        }
        if (this.parts.isEmpty()) {
            return "";
        }
        return this.parts.get((int)(this.parts.size() - 1)).name;
    }

    public boolean isLastAttribute() {
        if (this.isNull) {
            return false;
        }
        if (this.parts.isEmpty()) {
            return false;
        }
        return this.parts.get((int)(this.parts.size() - 1)).attribute;
    }

    public DottedChain getWithoutLast() {
        if (this.isNull) {
            return null;
        }
        if (this.parts.size() < 2) {
            return EMPTY;
        }
        return this.subChain(this.parts.size() - 1);
    }

    public DottedChain addWithSuffix(String name) {
        String addedNameNoSuffix = name;
        String addedNamespaceSuffix = "";
        if (name != null && name.matches(".*#[0-9]+$")) {
            addedNameNoSuffix = name.substring(0, name.lastIndexOf("#"));
            addedNamespaceSuffix = name.substring(name.lastIndexOf("#"));
        }
        return this.add(addedNameNoSuffix, addedNamespaceSuffix);
    }

    public DottedChain add(String name, String namespaceSuffix) {
        return this.add(false, name, namespaceSuffix);
    }

    public DottedChain add(boolean attribute, String name, String namespaceSuffix) {
        if (name == null) {
            return new DottedChain(this);
        }
        ArrayList<PathPart> newParts = new ArrayList<PathPart>(this.parts);
        newParts.add(new PathPart(name, attribute, namespaceSuffix));
        return new DottedChain(newParts, false);
    }

    protected String toString(boolean as3, boolean raw, boolean withSuffix) {
        if (this.isNull) {
            return "";
        }
        if (this.parts.isEmpty()) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            if (i > 0) {
                ret.append(".");
            }
            if (this.parts.get((int)i).attribute) {
                ret.append("@");
            }
            String part = this.parts.get((int)i).name;
            boolean lastStar = i == this.parts.size() - 1 && "*".equals(part);
            ret.append(raw || lastStar ? part : IdentifiersDeobfuscation.printIdentifier(as3, part, new String[0]));
            if (!withSuffix) continue;
            ret.append(this.parts.get((int)i).namespaceSuffix);
        }
        return ret.toString();
    }

    public String toFilePath() {
        if (this.isNull) {
            return "";
        }
        if (this.parts.isEmpty()) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            if (i > 0) {
                ret.append(File.separator);
            }
            ret.append(Helper.makeFileName(IdentifiersDeobfuscation.printIdentifier(true, this.parts.get((int)i).name, new String[0])));
        }
        return ret.toString();
    }

    public List<String> toList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (PathPart p : this.parts) {
            ret.add(p.name);
        }
        return ret;
    }

    public String toPrintableString(boolean as3) {
        return this.toString(as3, false, true);
    }

    public String toRawString() {
        return this.toString(false, true, true);
    }

    public String toString() {
        return this.toRawString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.parts);
        hash = 41 * hash + (this.isNull ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DottedChain other = (DottedChain)obj;
        if (this.isNull != other.isNull) {
            return false;
        }
        return Objects.equals(this.parts, other.parts);
    }

    @Override
    public int compareTo(DottedChain o) {
        return this.toRawString().compareTo(o.toRawString());
    }

    private static class PathPart
    implements Serializable {
        public String name;
        public boolean attribute;
        public String namespaceSuffix;

        public PathPart(String name, boolean attribute, String namespaceSuffix) {
            this.name = name;
            this.attribute = attribute;
            this.namespaceSuffix = namespaceSuffix;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Objects.hashCode(this.name);
            hash = 79 * hash + (this.attribute ? 1 : 0);
            hash = 79 * hash + Objects.hashCode(this.namespaceSuffix);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathPart other = (PathPart)obj;
            if (this.attribute != other.attribute) {
                return false;
            }
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.namespaceSuffix, other.namespaceSuffix);
        }
    }
}

