/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import com.jpexs.decompiler.flash.xfl.shapefixer.CurvedEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.Edge;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StraightEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StyleChangeRecordAdvanced;
import com.jpexs.helpers.Helper;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShapeFixer {
    private void addToEdgeMap(Map<Point2D, List<Edge>> edgeMap, Edge edge) {
        if (!edgeMap.containsKey(edge.getFrom())) {
            edgeMap.put(edge.getFrom(), new ArrayList());
        }
        if (!edgeMap.containsKey(edge.getTo())) {
            edgeMap.put(edge.getTo(), new ArrayList());
        }
        edgeMap.get(edge.getFrom()).add(edge);
        edgeMap.get(edge.getTo()).add(edge.invert());
    }

    private boolean fixSingleEdge(List<ShapeRecordAdvanced> records) {
        LinkedHashMap<Point2D, List<Edge>> edgeMap = new LinkedHashMap<Point2D, List<Edge>>();
        double x = 0.0;
        double y = 0.0;
        int fillStyle0 = 0;
        int fillStyle1 = 0;
        for (int r = 0; r < records.size(); ++r) {
            ShapeRecordAdvanced rec = records.get(r);
            if (rec instanceof StyleChangeRecordAdvanced) {
                StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)rec;
                if (scr.stateNewStyles) {
                    fillStyle0 = 0;
                    fillStyle1 = 0;
                }
                if (scr.stateFillStyle0) {
                    fillStyle0 = scr.fillStyle0;
                }
                if (scr.stateFillStyle1) {
                    fillStyle1 = scr.fillStyle1;
                }
            }
            if (rec instanceof StraightEdgeRecordAdvanced) {
                StraightEdgeRecordAdvanced ser = (StraightEdgeRecordAdvanced)rec;
                this.addToEdgeMap(edgeMap, new Edge(fillStyle0, fillStyle1, r, false, x, y, x + ser.deltaX, y + ser.deltaY));
            }
            if (rec instanceof CurvedEdgeRecordAdvanced) {
                CurvedEdgeRecordAdvanced cer = (CurvedEdgeRecordAdvanced)rec;
                this.addToEdgeMap(edgeMap, new Edge(fillStyle0, fillStyle1, r, false, x, y, x + cer.controlDeltaX, y + cer.controlDeltaY, x + cer.controlDeltaX + cer.anchorDeltaX, y + cer.controlDeltaY + cer.anchorDeltaY));
            }
            x = rec.changeX(x);
            y = rec.changeY(y);
        }
        for (Point2D p : edgeMap.keySet()) {
            List edges = (List)edgeMap.get(p);
            for (int i = 0; i < edges.size(); ++i) {
                for (int j = 0; j < edges.size(); ++j) {
                    ArrayList<Edge> newEdges2;
                    ArrayList<Edge> newEdges1;
                    Edge edge2;
                    Edge edge1;
                    if (i == j || !(edge1 = (Edge)edges.get(i)).intersection(edge2 = (Edge)edges.get(j), newEdges1 = new ArrayList<Edge>(), newEdges2 = new ArrayList<Edge>())) continue;
                    Point2D a = edge1.getFrom();
                    Point2D b = edge1.getTo();
                    Point2D c = edge2.getTo();
                    boolean edge2isRight = (b.getX() - a.getX()) * (c.getY() - a.getY()) - (b.getY() - a.getY()) * (c.getX() - a.getX()) > 0.0;
                    fillStyle0 = edge2isRight ? edge1.fillStyle0 : edge2.fillStyle0;
                    fillStyle1 = edge2isRight ? edge2.fillStyle1 : edge1.fillStyle1;
                    StyleChangeRecordAdvanced moveCenter = new StyleChangeRecordAdvanced();
                    moveCenter.stateMoveTo = true;
                    moveCenter.moveDeltaX = edge1.getFrom().getX();
                    moveCenter.moveDeltaY = edge1.getFrom().getY();
                    moveCenter.stateFillStyle0 = true;
                    moveCenter.stateFillStyle1 = true;
                    moveCenter.fillStyle0 = fillStyle0;
                    moveCenter.fillStyle1 = fillStyle1;
                    StraightEdgeRecordAdvanced ser = new StraightEdgeRecordAdvanced();
                    ser.deltaX = ((Edge)newEdges1.get(0)).getTo().getX() - edge1.getFrom().getX();
                    ser.deltaY = ((Edge)newEdges1.get(0)).getTo().getY() - edge1.getFrom().getY();
                    StyleChangeRecordAdvanced scrStart1 = new StyleChangeRecordAdvanced();
                    scrStart1.stateMoveTo = false;
                    scrStart1.stateFillStyle0 = true;
                    scrStart1.stateFillStyle1 = true;
                    scrStart1.fillStyle0 = ((Edge)newEdges1.get((int)1)).fillStyle0;
                    scrStart1.fillStyle1 = ((Edge)newEdges1.get((int)1)).fillStyle1;
                    StyleChangeRecordAdvanced moveBack1 = new StyleChangeRecordAdvanced();
                    moveBack1.stateMoveTo = true;
                    Edge edge1NotInverted = edge1.inverted ? edge1.invert() : edge1;
                    moveBack1.moveDeltaX = edge1NotInverted.getTo().getX();
                    moveBack1.moveDeltaY = edge1NotInverted.getTo().getY();
                    moveBack1.stateFillStyle0 = true;
                    moveBack1.stateFillStyle1 = true;
                    moveBack1.fillStyle0 = edge1NotInverted.fillStyle0;
                    moveBack1.fillStyle1 = edge1NotInverted.fillStyle1;
                    records.remove(edge1.recordIndex);
                    records.add(edge1.recordIndex, moveCenter);
                    records.add(edge1.recordIndex + 1, ser);
                    records.add(edge1.recordIndex + 2, scrStart1);
                    records.add(edge1.recordIndex + 3, ((Edge)newEdges1.get(1)).toShapeRecordAdvanced());
                    records.add(edge1.recordIndex + 4, moveBack1);
                    if (edge2.recordIndex > edge1.recordIndex) {
                        edge2.recordIndex += 4;
                    }
                    StyleChangeRecordAdvanced moveStart2 = new StyleChangeRecordAdvanced();
                    moveStart2.stateMoveTo = true;
                    moveStart2.moveDeltaX = ((Edge)newEdges2.get(1)).getFrom().getX();
                    moveStart2.moveDeltaY = ((Edge)newEdges2.get(1)).getFrom().getY();
                    moveStart2.stateFillStyle0 = true;
                    moveStart2.stateFillStyle1 = true;
                    moveStart2.fillStyle0 = ((Edge)newEdges2.get((int)1)).fillStyle0;
                    moveStart2.fillStyle1 = ((Edge)newEdges2.get((int)1)).fillStyle1;
                    StyleChangeRecordAdvanced moveBack2 = new StyleChangeRecordAdvanced();
                    moveBack2.stateMoveTo = true;
                    Edge edge2NotInverted = edge2.inverted ? edge2.invert() : edge2;
                    moveBack2.moveDeltaX = edge2NotInverted.getTo().getX();
                    moveBack2.moveDeltaY = edge2NotInverted.getTo().getY();
                    moveBack2.stateFillStyle0 = true;
                    moveBack2.stateFillStyle1 = true;
                    moveBack2.fillStyle0 = edge2NotInverted.fillStyle0;
                    moveBack2.fillStyle1 = edge2NotInverted.fillStyle1;
                    records.remove(edge2.recordIndex);
                    records.add(edge2.recordIndex, moveStart2);
                    records.add(edge2.recordIndex + 1, ((Edge)newEdges2.get(1)).toShapeRecordAdvanced());
                    records.add(edge2.recordIndex + 2, moveBack2);
                    return true;
                }
            }
        }
        return false;
    }

    public List<ShapeRecordAdvanced> fixShape(List<ShapeRecordAdvanced> records) {
        List<ShapeRecordAdvanced> ret = Helper.deepCopy(records);
        while (this.fixSingleEdge(ret)) {
        }
        for (ShapeRecordAdvanced rec : ret) {
            rec.round();
        }
        return ret;
    }
}

