/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl.shapefixer;

import com.jpexs.decompiler.flash.math.BezierEdge;
import com.jpexs.decompiler.flash.xfl.shapefixer.CurvedEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StraightEdgeRecordAdvanced;
import com.jpexs.helpers.Reference;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class Edge {
    int recordIndex;
    boolean inverted;
    int fillStyle0 = 0;
    int fillStyle1 = 0;
    List<Point2D> points = new ArrayList<Point2D>();

    public Point2D getFrom() {
        return this.points.get(0);
    }

    public Point2D getTo() {
        return this.points.get(this.points.size() - 1);
    }

    public BezierEdge toBezierEdge() {
        return new BezierEdge(new ArrayList<Point2D>(this.points));
    }

    public boolean intersection(Edge otherEdge, List<Edge> newThisEdges, List<Edge> newOtherEdges) {
        BezierEdge be2;
        ArrayList<Double> t1s = new ArrayList<Double>();
        ArrayList<Double> t2s = new ArrayList<Double>();
        BezierEdge be1 = this.toBezierEdge();
        if (!be1.intersects(be2 = otherEdge.toBezierEdge(), t1s, t2s)) {
            return false;
        }
        Reference<Object> be1aRef = new Reference<Object>(null);
        Reference<Object> be1bRef = new Reference<Object>(null);
        Reference<Object> be2aRef = new Reference<Object>(null);
        Reference<Object> be2bRef = new Reference<Object>(null);
        t1s.sort(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o1, o2);
            }
        });
        t2s.sort(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o1, o2);
            }
        });
        if (t1s.size() == 1) {
            return false;
        }
        double t1 = (Double)t1s.get(t1s.size() - 1);
        double t2 = (Double)t2s.get(t2s.size() - 1);
        be1.split(t1, be1aRef, be1bRef);
        be2.split(t2, be2aRef, be2bRef);
        newThisEdges.add(new Edge(this.fillStyle0, this.fillStyle1, -1, this.inverted, be1aRef.getVal()));
        newThisEdges.add(new Edge(this.fillStyle0, this.fillStyle1, -1, this.inverted, be1bRef.getVal()));
        newOtherEdges.add(new Edge(otherEdge.fillStyle0, otherEdge.fillStyle1, -1, otherEdge.inverted, be2aRef.getVal()));
        newOtherEdges.add(new Edge(otherEdge.fillStyle0, otherEdge.fillStyle1, -1, otherEdge.inverted, be2bRef.getVal()));
        if (newThisEdges.get(0).isEmpty() || newOtherEdges.get(0).isEmpty()) {
            newThisEdges.clear();
            newOtherEdges.clear();
            return false;
        }
        return true;
    }

    public Point2D pointAt(double t) {
        return this.toBezierEdge().pointAt(t);
    }

    public Edge invert() {
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        for (int i = this.points.size() - 1; i >= 0; --i) {
            newPoints.add(this.points.get(i));
        }
        return new Edge(this.fillStyle1, this.fillStyle0, this.recordIndex, !this.inverted, newPoints);
    }

    public Edge(int fillStyle0, int fillStyle1, int recordIndex, boolean inverted, BezierEdge be) {
        List<Point2D> points2D = be.points;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Point2D p : points2D) {
            points.add(new Point2D.Double(p.getX(), p.getY()));
        }
        this.points = points;
        this.recordIndex = recordIndex;
        this.inverted = inverted;
        this.fillStyle0 = fillStyle0;
        this.fillStyle1 = fillStyle1;
    }

    public Edge(int fillStyle0, int fillStyle1, int recordIndex, boolean inverted, List<Point2D> points) {
        this.points = points;
        this.recordIndex = recordIndex;
        this.inverted = inverted;
        this.fillStyle0 = fillStyle0;
        this.fillStyle1 = fillStyle1;
    }

    public Edge(int fillStyle0, int fillStyle1, int recordIndex, boolean inverted, double fromX, double fromY, double toX, double toY) {
        this.points.add(new Point2D.Double(fromX, fromY));
        this.points.add(new Point2D.Double(toX, toY));
        this.recordIndex = recordIndex;
        this.inverted = inverted;
        this.fillStyle0 = fillStyle0;
        this.fillStyle1 = fillStyle1;
    }

    public Edge(int fillStyle0, int fillStyle1, int recordIndex, boolean inverted, double fromX, double fromY, double controlX, double controlY, double toX, double toY) {
        this.points.add(new Point2D.Double(fromX, fromY));
        this.points.add(new Point2D.Double(controlX, controlY));
        this.points.add(new Point2D.Double(toX, toY));
        this.recordIndex = recordIndex;
        this.inverted = inverted;
        this.fillStyle0 = fillStyle0;
        this.fillStyle1 = fillStyle1;
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (Point2D p : this.points) {
            list.add("[" + p.getX() + "," + p.getY() + "]");
        }
        return "{" + String.join((CharSequence)"-", list) + "}";
    }

    public boolean isEmpty() {
        return this.getFrom().equals(this.getTo());
    }

    public ShapeRecordAdvanced toShapeRecordAdvanced() {
        if (this.points.size() == 3) {
            CurvedEdgeRecordAdvanced cer = new CurvedEdgeRecordAdvanced();
            cer.controlDeltaX = this.points.get(1).getX() - this.points.get(0).getX();
            cer.controlDeltaY = this.points.get(1).getY() - this.points.get(0).getY();
            cer.anchorDeltaX = this.points.get(2).getX() - this.points.get(1).getX();
            cer.anchorDeltaY = this.points.get(2).getY() - this.points.get(1).getY();
            return cer;
        }
        StraightEdgeRecordAdvanced ser = new StraightEdgeRecordAdvanced();
        ser.deltaX = this.points.get(1).getX() - this.points.get(0).getX();
        ser.deltaY = this.points.get(1).getY() - this.points.get(0).getY();
        return ser;
    }
}

