/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.model.CallPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.action.ActionTreeOperation;
import com.jpexs.decompiler.flash.action.model.CallMethodActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.amf.amf3.types.ObjectType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.MovieExporter;
import com.jpexs.decompiler.flash.exporters.SoundExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.modes.MovieExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SoundExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.flash.tags.CSMTextSettingsTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonCxformTag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineFontNameTag;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineText2Tag;
import com.jpexs.decompiler.flash.tags.DefineTextTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ButtonAction;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.tags.font.CharacterRanges;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.SOUNDENVELOPE;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.decompiler.flash.types.sound.MP3FRAME;
import com.jpexs.decompiler.flash.types.sound.MP3SOUNDDATA;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.decompiler.flash.xfl.FLAVersion;
import com.jpexs.decompiler.flash.xfl.XFLExportSettings;
import com.jpexs.decompiler.flash.xfl.XFLXmlWriter;
import com.jpexs.decompiler.flash.xfl.shapefixer.CurvedEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.ShapeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StraightEdgeRecordAdvanced;
import com.jpexs.decompiler.flash.xfl.shapefixer.StyleChangeRecordAdvanced;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.XmlPrettyFormat;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XFLConverter {
    private static final Logger logger = Logger.getLogger(XFLConverter.class.getName());
    public static final int KEY_MODE_NORMAL = 9728;
    public static final int KEY_MODE_CLASSIC_TWEEN = 22017;
    public static final int KEY_MODE_SHAPE_TWEEN = 17922;
    public static final int KEY_MODE_MOTION_TWEEN = 8195;
    public static final int KEY_MODE_SHAPE_LAYERS = 8192;
    public static final String PUBLISH_DATA_PREFIX = "PUB_PRST_DATA";
    public static final String PUBLISH_DATA_FORMAT = "_EMBED_SWF_";
    private final Random random = new Random(123L);
    private final boolean DEBUG_EXPORT_LAYER_DEPTHS = false;
    private static final String[] BLENDMODES = new String[]{null, null, "layer", "multiply", "screen", "lighten", "darken", "difference", "add", "subtract", "invert", "alpha", "erase", "overlay", "hardligh"};

    private static String formatEdgeDouble(double value, boolean curved) {
        if (value % 1.0 == 0.0) {
            return "" + (int)value;
        }
        DecimalFormat df = new DecimalFormat("0.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setGroupingUsed(false);
        String strValue = "" + df.format(value);
        if (curved) {
            String[] parts = strValue.split("\\.");
            return ("#" + Integer.toHexString(Integer.parseInt(parts[0])) + "." + Integer.toHexString(Integer.parseInt(parts[1]))).toUpperCase(Locale.ENGLISH);
        }
        return "" + strValue;
    }

    private static void convertShapeEdge(MATRIX mat, ShapeRecordAdvanced record, double x, double y, StringBuilder ret) {
        if (record instanceof StyleChangeRecordAdvanced) {
            StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)record;
            Point2D.Double p = new Point2D.Double(scr.moveDeltaX, scr.moveDeltaY);
            if (scr.stateMoveTo) {
                ret.append("! ").append(XFLConverter.formatEdgeDouble(((Point2D)p).getX(), false)).append(" ").append(XFLConverter.formatEdgeDouble(((Point2D)p).getY(), false));
            }
        } else if (record instanceof StraightEdgeRecordAdvanced) {
            StraightEdgeRecordAdvanced ser = (StraightEdgeRecordAdvanced)record;
            Point2D.Double p = new Point2D.Double(x += ser.deltaX, y += ser.deltaY);
            ret.append("| ");
            ret.append(XFLConverter.formatEdgeDouble(((Point2D)p).getX(), false));
            ret.append(" ");
            ret.append(XFLConverter.formatEdgeDouble(((Point2D)p).getY(), false));
        } else if (record instanceof CurvedEdgeRecordAdvanced) {
            CurvedEdgeRecordAdvanced cer = (CurvedEdgeRecordAdvanced)record;
            double controlX = cer.controlDeltaX + x;
            double controlY = cer.controlDeltaY + y;
            double anchorX = cer.anchorDeltaX + controlX;
            double anchorY = cer.anchorDeltaY + controlY;
            Point2D.Double control = new Point2D.Double(controlX, controlY);
            Point2D.Double anchor = new Point2D.Double(anchorX, anchorY);
            ret.append("[ ").append(XFLConverter.formatEdgeDouble(((Point2D)control).getX(), true)).append(" ").append(XFLConverter.formatEdgeDouble(((Point2D)control).getY(), true)).append(" ").append(XFLConverter.formatEdgeDouble(((Point2D)anchor).getX(), true)).append(" ").append(XFLConverter.formatEdgeDouble(((Point2D)anchor).getY(), true));
        }
    }

    private static void convertShapeEdges(boolean close, double startX, double startY, MATRIX mat, List<ShapeRecordAdvanced> recordsAdvanced, StringBuilder ret) {
        double x = startX;
        double y = startY;
        boolean hasMove = false;
        if (!recordsAdvanced.isEmpty() && recordsAdvanced.get(0) instanceof StyleChangeRecordAdvanced) {
            StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)recordsAdvanced.get(0);
            if (scr.stateMoveTo) {
                hasMove = true;
            }
        }
        if (!hasMove) {
            ret.append("! ").append(XFLConverter.formatEdgeDouble(startX, false)).append(" ").append(XFLConverter.formatEdgeDouble(startY, false));
        }
        double lastMoveToX = startX;
        double lastMoveToY = startY;
        for (ShapeRecordAdvanced rec : recordsAdvanced) {
            if (rec instanceof StyleChangeRecordAdvanced) {
                StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)rec;
                if (scr.stateMoveTo) {
                    lastMoveToX = scr.moveDeltaX;
                    lastMoveToY = scr.moveDeltaY;
                }
            }
            XFLConverter.convertShapeEdge(mat, rec, x, y, ret);
            x = rec.changeX(x);
            y = rec.changeY(y);
        }
        if (close && (Double.compare(lastMoveToX, x) != 0 || Double.compare(lastMoveToY, y) != 0)) {
            StraightEdgeRecordAdvanced ser = new StraightEdgeRecordAdvanced(lastMoveToX - x, lastMoveToY - y);
            XFLConverter.convertShapeEdge(mat, ser, x, y, ret);
        }
    }

    private static String getScaleMode(ILINESTYLE lineStyle) {
        if (lineStyle instanceof LINESTYLE2) {
            LINESTYLE2 ls2 = (LINESTYLE2)lineStyle;
            if (ls2.noHScaleFlag && ls2.noVScaleFlag) {
                return "none";
            }
            if (ls2.noHScaleFlag) {
                return "vertical";
            }
            if (ls2.noVScaleFlag) {
                return "horizontal";
            }
            return "normal";
        }
        return "normal";
    }

    private static void convertLineStyle(ILINESTYLE ls, int shapeNum, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("SolidStroke", new String[]{"scaleMode", XFLConverter.getScaleMode(ls), "weight", Double.toString((double)ls.getWidth() / 20.0)});
        writer.writeStartElement("fill");
        if (!(ls instanceof LINESTYLE2) || !((LINESTYLE2)ls).hasFillFlag) {
            writer.writeStartElement("SolidColor", new String[]{"color", ls.getColor().toHexRGB()});
            if (shapeNum >= 3) {
                writer.writeAttribute("alpha", ((RGBA)ls.getColor()).getAlphaFloat());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertLineStyle(HashMap<Integer, CharacterTag> characters, LINESTYLE2 ls, int shapeNum, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("SolidStroke", new String[]{"weight", Double.toString((double)ls.width / 20.0)});
        if (ls.pixelHintingFlag) {
            writer.writeAttribute("pixelHinting", true);
        }
        if (ls.width == 1) {
            writer.writeAttribute("solidStyle", "hairline");
        }
        writer.writeAttribute("scaleMode", XFLConverter.getScaleMode(ls));
        switch (ls.endCapStyle) {
            case 1: {
                writer.writeAttribute("caps", "none");
                break;
            }
            case 2: {
                writer.writeAttribute("caps", "square");
            }
        }
        switch (ls.joinStyle) {
            case 1: {
                writer.writeAttribute("joints", "bevel");
                break;
            }
            case 2: {
                writer.writeAttribute("joints", "miter");
                float miterLimitFactor = ls.miterLimitFactor;
                if (miterLimitFactor == 3.0f) break;
                writer.writeAttribute("miterLimit", miterLimitFactor);
            }
        }
        writer.writeStartElement("fill");
        if (!ls.hasFillFlag) {
            RGBA color = ls.color;
            writer.writeStartElement("SolidColor", new String[]{"color", color.toHexRGB()});
            if (color.getAlphaFloat() != 1.0f) {
                writer.writeAttribute("alpha", Float.toString(color.getAlphaFloat()));
            }
            writer.writeEndElement();
        } else {
            XFLConverter.convertFillStyle(null, characters, ls.fillType, shapeNum, writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertFillStyle(MATRIX mat, HashMap<Integer, CharacterTag> characters, FILLSTYLE fs, int shapeNum, XFLXmlWriter writer) throws XMLStreamException {
        switch (fs.fillStyleType) {
            case 0: {
                writer.writeStartElement("SolidColor", new String[]{"color", fs.color.toHexRGB()});
                if (shapeNum >= 3) {
                    writer.writeAttribute("alpha", ((RGBA)fs.color).getAlphaFloat());
                }
                writer.writeEndElement();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                CharacterTag bitmapCh = characters.get(fs.bitmapId);
                if (!(bitmapCh instanceof ImageTag)) {
                    if (bitmapCh != null) {
                        logger.log(Level.SEVERE, "Suspicious bitmapfill:{0}", bitmapCh.getClass().getSimpleName());
                    }
                    writer.writeEmptyElement("SolidColor", new String[]{"color", "#ffffff"});
                    return;
                }
                ImageTag it = (ImageTag)bitmapCh;
                writer.writeStartElement("BitmapFill");
                writer.writeAttribute("bitmapPath", "bitmap" + bitmapCh.getCharacterId() + it.getImageFormat().getExtension());
                if (fs.fillStyleType == 65 || fs.fillStyleType == 67) {
                    writer.writeAttribute("bitmapIsClipped", true);
                }
                writer.writeStartElement("matrix");
                XFLConverter.convertMatrix(fs.bitmapMatrix, writer);
                writer.writeEndElement();
                writer.writeEndElement();
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                if (fs.fillStyleType == 16) {
                    writer.writeStartElement("LinearGradient");
                } else {
                    writer.writeStartElement("RadialGradient");
                    String focalPointRatioStr = fs.fillStyleType == 19 ? Float.toString(((FOCALGRADIENT)fs.gradient).focalPoint) : "0";
                    writer.writeAttribute("focalPointRatio", focalPointRatioStr);
                }
                int interpolationMode = fs.fillStyleType == 19 ? fs.gradient.interpolationMode : fs.gradient.interpolationMode;
                int spreadMode = fs.fillStyleType == 19 ? fs.gradient.spreadMode : fs.gradient.spreadMode;
                if (interpolationMode == 1) {
                    writer.writeAttribute("interpolationMethod", "linearRGB");
                }
                switch (spreadMode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        writer.writeAttribute("spreadMethod", "reflect");
                        break;
                    }
                    case 2: {
                        writer.writeAttribute("spreadMethod", "repeat");
                    }
                }
                writer.writeStartElement("matrix");
                XFLConverter.convertMatrix(fs.gradientMatrix, writer);
                writer.writeEndElement();
                GRADRECORD[] records = fs.fillStyleType == 19 ? fs.gradient.gradientRecords : fs.gradient.gradientRecords;
                for (GRADRECORD rec : records) {
                    writer.writeStartElement("GradientEntry");
                    writer.writeAttribute("color", rec.color.toHexRGB());
                    if (shapeNum >= 3) {
                        writer.writeAttribute("alpha", ((RGBA)rec.color).getAlphaFloat());
                    }
                    writer.writeAttribute("ratio", rec.getRatioFloat());
                    writer.writeEndElement();
                }
                if (fs.fillStyleType == 16) {
                    writer.writeEndElement();
                    break;
                }
                writer.writeEndElement();
            }
        }
    }

    private static void convertMatrix(MATRIX matrix, XFLXmlWriter writer) throws XMLStreamException {
        Matrix m = new Matrix(matrix);
        writer.writeStartElement("Matrix");
        writer.writeAttribute("tx", (double)((float)m.translateX) / 20.0);
        writer.writeAttribute("ty", (double)((float)m.translateY) / 20.0);
        if (m.scaleX != 1.0 || m.scaleY != 1.0) {
            writer.writeAttribute("a", m.scaleX);
            writer.writeAttribute("d", m.scaleY);
        }
        if (m.rotateSkew0 != 0.0 || m.rotateSkew1 != 0.0) {
            writer.writeAttribute("b", m.rotateSkew0);
            writer.writeAttribute("c", m.rotateSkew1);
        }
        writer.writeEndElement();
    }

    private static boolean shapeHasMultiLayers(HashMap<Integer, CharacterTag> characters, MATRIX mat, int shapeNum, List<SHAPERECORD> shapeRecords, FILLSTYLEARRAY fillStyles, LINESTYLEARRAY lineStyles) throws XMLStreamException {
        List<String> layers = XFLConverter.getShapeLayers(characters, mat, shapeNum, shapeRecords, fillStyles, lineStyles, false);
        return layers.size() > 1;
    }

    private static void convertShape(HashMap<Integer, CharacterTag> characters, MATRIX mat, int shapeNum, List<SHAPERECORD> shapeRecords, FILLSTYLEARRAY fillStyles, LINESTYLEARRAY lineStyles, boolean morphshape, boolean useLayers, XFLXmlWriter writer) throws XMLStreamException {
        List<String> layers = XFLConverter.getShapeLayers(characters, mat, shapeNum, shapeRecords, fillStyles, lineStyles, morphshape);
        if (!useLayers) {
            for (int l = layers.size() - 1; l >= 0; --l) {
                writer.writeCharactersRaw(layers.get(l));
            }
        } else {
            int layer = 1;
            for (int l = layers.size() - 1; l >= 0; --l) {
                writer.writeStartElement("DOMLayer", new String[]{"name", "Layer " + layer++});
                writer.writeStartElement("frames");
                writer.writeStartElement("DOMFrame", new String[]{"index", "0", "motionTweenScale", "false", "keyMode", Integer.toString(8192)});
                writer.writeStartElement("elements");
                writer.writeCharactersRaw(layers.get(l));
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    private static int snapToGrid(int v, int gridSize) {
        double divisor = gridSize;
        int ret = (int)((double)Math.round((double)v / divisor) * divisor);
        return ret;
    }

    private static List<SHAPERECORD> snapShapeToGrid(List<SHAPERECORD> shapeRecords, int gridSize) {
        ArrayList<SHAPERECORD> ret = new ArrayList<SHAPERECORD>(shapeRecords.size());
        int hintedX = 0;
        int hintedY = 0;
        int correctX = 0;
        int correctY = 0;
        for (SHAPERECORD rec : shapeRecords) {
            int shouldBeX;
            SHAPERECORD ch = rec.clone();
            int lastCorrectX = correctX;
            int lastCorrectY = correctY;
            correctX = ch.changeX(correctX);
            correctY = ch.changeY(correctY);
            if (ch instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)ch;
                if (scr.stateMoveTo) {
                    shouldBeX = XFLConverter.snapToGrid(correctX, gridSize);
                    int shouldBeY = XFLConverter.snapToGrid(correctY, gridSize);
                    scr.moveDeltaX = shouldBeX;
                    scr.moveDeltaY = shouldBeY;
                    hintedX = shouldBeX;
                    hintedY = shouldBeY;
                }
            } else if (ch instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)ch;
                if (ser.generalLineFlag || !ser.vertLineFlag) {
                    shouldBeX = XFLConverter.snapToGrid(correctX, gridSize);
                    ser.deltaX = shouldBeX - hintedX;
                    hintedX = shouldBeX;
                }
                if (ser.generalLineFlag || ser.vertLineFlag) {
                    int shouldBeY = XFLConverter.snapToGrid(correctY, gridSize);
                    ser.deltaY = shouldBeY - hintedY;
                    hintedY = shouldBeY;
                }
            } else if (ch instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)ch;
                int controlShouldBeX = XFLConverter.snapToGrid(lastCorrectX + cer.controlDeltaX, gridSize);
                int controlShouldBeY = XFLConverter.snapToGrid(lastCorrectY + cer.controlDeltaY, gridSize);
                cer.controlDeltaX = controlShouldBeX - hintedX;
                cer.controlDeltaY = controlShouldBeY - hintedY;
                int anchorShouldBeX = XFLConverter.snapToGrid(correctX, gridSize);
                int anchorShouldBeY = XFLConverter.snapToGrid(correctY, gridSize);
                cer.anchorDeltaX = anchorShouldBeX - (hintedX + cer.controlDeltaX);
                cer.anchorDeltaY = anchorShouldBeY - (hintedY + cer.controlDeltaY);
                hintedX = anchorShouldBeX;
                hintedY = anchorShouldBeY;
            }
            ret.add(ch);
        }
        return ret;
    }

    private static double distance(Point p1, Point p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static List<SHAPERECORD> snapCloseTogether(List<SHAPERECORD> shapeRecords, double maxDistance) {
        ArrayList<Point> points = new ArrayList<Point>();
        int x = 0;
        int y = 0;
        Point prevPoint = null;
        Point startPoint = null;
        for (SHAPERECORD rec : shapeRecords) {
            x = rec.changeX(x);
            y = rec.changeY(y);
            Point currentPoint = new Point(x, y);
            if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)rec;
                if (scr.stateMoveTo) {
                    if (prevPoint != null && startPoint != null && XFLConverter.distance(prevPoint, startPoint) <= maxDistance) {
                        prevPoint.x = startPoint.x;
                        prevPoint.y = startPoint.y;
                    }
                    startPoint = currentPoint;
                }
            }
            points.add(currentPoint);
            prevPoint = currentPoint;
        }
        ArrayList<SHAPERECORD> ret = new ArrayList<SHAPERECORD>(shapeRecords.size());
        int hintedX = 0;
        int hintedY = 0;
        int correctX = 0;
        int correctY = 0;
        int lastCorrectX = 0;
        int lastCorrectY = 0;
        int index = 0;
        for (SHAPERECORD rec : shapeRecords) {
            int shouldBeX;
            SHAPERECORD ch = rec.clone();
            lastCorrectX = correctX;
            lastCorrectY = correctY;
            correctX = ch.changeX(correctX);
            correctY = ch.changeY(correctY);
            if (ch instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)ch;
                if (scr.stateMoveTo) {
                    shouldBeX = ((Point)points.get((int)index)).x;
                    int shouldBeY = ((Point)points.get((int)index)).y;
                    scr.moveDeltaX = shouldBeX;
                    scr.moveDeltaY = shouldBeY;
                    hintedX = shouldBeX;
                    hintedY = shouldBeY;
                }
            } else if (ch instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)ch;
                if (ser.generalLineFlag || !ser.vertLineFlag) {
                    shouldBeX = ((Point)points.get((int)index)).x;
                    ser.deltaX = shouldBeX - hintedX;
                    hintedX = shouldBeX;
                }
                if (ser.generalLineFlag || ser.vertLineFlag) {
                    int shouldBeY = ((Point)points.get((int)index)).y;
                    ser.deltaY = shouldBeY - hintedY;
                    hintedY = shouldBeY;
                }
            } else if (ch instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)ch;
                int anchorShouldBeX = ((Point)points.get((int)index)).x;
                int anchorShouldBeY = ((Point)points.get((int)index)).y;
                cer.anchorDeltaX = anchorShouldBeX - (hintedX + cer.controlDeltaX);
                cer.anchorDeltaY = anchorShouldBeY - (hintedY + cer.controlDeltaY);
                hintedX = anchorShouldBeX;
                hintedY = anchorShouldBeY;
            }
            ret.add(ch);
            ++index;
        }
        return ret;
    }

    private static List<String> getShapeLayers(HashMap<Integer, CharacterTag> characters, MATRIX mat, int shapeNum, List<SHAPERECORD> shapeRecords, FILLSTYLEARRAY fillStyles, LINESTYLEARRAY lineStyles, boolean morphshape) throws XMLStreamException {
        if (mat == null) {
            mat = new MATRIX();
        }
        ArrayList<ShapeRecordAdvanced> shapeRecordsAdvanced = new ArrayList<ShapeRecordAdvanced>();
        for (SHAPERECORD rec : shapeRecords) {
            ShapeRecordAdvanced arec = ShapeRecordAdvanced.createFromSHAPERECORD(rec);
            if (arec == null) continue;
            shapeRecordsAdvanced.add(arec);
        }
        ArrayList<ShapeRecordAdvanced> edges = new ArrayList<ShapeRecordAdvanced>();
        int lineStyleCount = 0;
        int fillStyle0 = -1;
        int fillStyle1 = -1;
        int strokeStyle = -1;
        XFLXmlWriter fillsStr = new XFLXmlWriter();
        XFLXmlWriter strokesStr = new XFLXmlWriter();
        fillsStr.writeStartElement("fills");
        strokesStr.writeStartElement("strokes");
        ArrayList<String> layers = new ArrayList<String>();
        int fillStyleCount = 0;
        if (fillStyles != null) {
            for (FILLSTYLE fs : fillStyles.fillStyles) {
                fillsStr.writeStartElement("FillStyle", new String[]{"index", Integer.toString(fillStyleCount + 1)});
                XFLConverter.convertFillStyle(mat, characters, fs, shapeNum, fillsStr);
                fillsStr.writeEndElement();
                ++fillStyleCount;
            }
        }
        if (lineStyles != null) {
            if (shapeNum <= 3 && lineStyles.lineStyles != null) {
                for (int l = 0; l < lineStyles.lineStyles.length; ++l) {
                    strokesStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                    XFLConverter.convertLineStyle(lineStyles.lineStyles[l], shapeNum, strokesStr);
                    strokesStr.writeEndElement();
                    ++lineStyleCount;
                }
            } else if (lineStyles.lineStyles2 != null) {
                for (int l = 0; l < lineStyles.lineStyles2.length; ++l) {
                    strokesStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                    XFLConverter.convertLineStyle(characters, lineStyles.lineStyles2[l], shapeNum, strokesStr);
                    strokesStr.writeEndElement();
                    ++lineStyleCount;
                }
            }
        }
        fillsStr.writeEndElement();
        strokesStr.writeEndElement();
        boolean layer = true;
        boolean hasEdge = false;
        XFLXmlWriter currentLayer = new XFLXmlWriter();
        if (fillStyleCount > 0 || lineStyleCount > 0) {
            currentLayer.writeStartElement("DOMShape", new String[]{"isFloating", "true"});
            currentLayer.writeCharactersRaw(fillsStr.toString());
            currentLayer.writeCharactersRaw(strokesStr.toString());
            currentLayer.writeStartElement("edges");
        }
        double x = 0.0;
        double y = 0.0;
        double startEdgeX = 0.0;
        double startEdgeY = 0.0;
        LINESTYLEARRAY actualLinestyles = lineStyles;
        int strokeStyleOrig = 0;
        fillStyleCount = fillStyles == null ? 0 : fillStyles.fillStyles.length;
        for (ShapeRecordAdvanced edge : shapeRecordsAdvanced) {
            if (edge instanceof StyleChangeRecordAdvanced) {
                StyleChangeRecordAdvanced scr = (StyleChangeRecordAdvanced)edge;
                boolean styleChange = false;
                int lastFillStyle1 = fillStyle1;
                int lastFillStyle0 = fillStyle0;
                int lastStrokeStyle = strokeStyle;
                if (scr.stateNewStyles) {
                    int l;
                    XFLXmlWriter fillsNewStr = new XFLXmlWriter();
                    XFLXmlWriter strokesNewStr = new XFLXmlWriter();
                    fillsNewStr.writeStartElement("fills");
                    strokesNewStr.writeStartElement("strokes");
                    if (!(fillStyleCount <= 0 && lineStyleCount <= 0 || fillStyle0 <= 0 && fillStyle1 <= 0 && strokeStyle <= 0)) {
                        currentLayer.writeStartElement("Edge");
                        if (fillStyle0 > -1) {
                            currentLayer.writeAttribute("fillStyle0", fillStyle0);
                        }
                        if (fillStyle1 > -1) {
                            currentLayer.writeAttribute("fillStyle1", fillStyle1);
                        }
                        if (strokeStyle > -1) {
                            currentLayer.writeAttribute("strokeStyle", strokeStyle);
                        }
                        StringBuilder edgesSb = new StringBuilder();
                        XFLConverter.convertShapeEdges((fillStyle0 > 0 || fillStyle1 > 0) && morphshape, startEdgeX, startEdgeY, mat, edges, edgesSb);
                        currentLayer.writeAttribute("edges", edgesSb.toString());
                        currentLayer.writeEndElement();
                        hasEdge = true;
                    }
                    if (currentLayer.length() > 0) {
                        currentLayer.writeEndElement();
                        currentLayer.writeEndElement();
                    }
                    if (currentLayer.length() > 0 && hasEdge) {
                        String s = currentLayer.toString();
                        if (morphshape) {
                            s = XFLConverter.removeOnlyStrokeEdgesBeforeSameFilled(s);
                        }
                        layers.add(s);
                    }
                    currentLayer.setLength(0);
                    hasEdge = false;
                    currentLayer.writeStartElement("DOMShape", new String[]{"isFloating", "true"});
                    for (int f = 0; f < scr.fillStyles.fillStyles.length; ++f) {
                        fillsNewStr.writeStartElement("FillStyle", new String[]{"index", Integer.toString(f + 1)});
                        XFLConverter.convertFillStyle(mat, characters, scr.fillStyles.fillStyles[f], shapeNum, fillsNewStr);
                        fillsNewStr.writeEndElement();
                        ++fillStyleCount;
                    }
                    lineStyleCount = 0;
                    if (shapeNum <= 3) {
                        for (l = 0; l < scr.lineStyles.lineStyles.length; ++l) {
                            strokesNewStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                            XFLConverter.convertLineStyle(scr.lineStyles.lineStyles[l], shapeNum, strokesNewStr);
                            strokesNewStr.writeEndElement();
                            ++lineStyleCount;
                        }
                    } else {
                        for (l = 0; l < scr.lineStyles.lineStyles2.length; ++l) {
                            strokesNewStr.writeStartElement("StrokeStyle", new String[]{"index", Integer.toString(lineStyleCount + 1)});
                            XFLConverter.convertLineStyle(characters, scr.lineStyles.lineStyles2[l], shapeNum, strokesNewStr);
                            strokesNewStr.writeEndElement();
                            ++lineStyleCount;
                        }
                    }
                    fillsNewStr.writeEndElement();
                    strokesNewStr.writeEndElement();
                    currentLayer.writeCharactersRaw(fillsNewStr.toString());
                    currentLayer.writeCharactersRaw(strokesNewStr.toString());
                    currentLayer.writeStartElement("edges");
                    actualLinestyles = scr.lineStyles;
                }
                if (scr.stateFillStyle0) {
                    int fillStyle0_new = scr.fillStyle0;
                    if (morphshape) {
                        fillStyle1 = fillStyle0_new;
                    } else {
                        fillStyle0 = fillStyle0_new;
                    }
                    styleChange = true;
                }
                if (scr.stateFillStyle1) {
                    int fillStyle1_new = scr.fillStyle1;
                    if (morphshape) {
                        fillStyle0 = fillStyle1_new;
                    } else {
                        fillStyle1 = fillStyle1_new;
                    }
                    styleChange = true;
                }
                if (scr.stateLineStyle) {
                    strokeStyle = scr.lineStyle;
                    strokeStyleOrig = scr.lineStyle - 1;
                    styleChange = true;
                }
                if (!edges.isEmpty()) {
                    if (fillStyle0 > 0 || fillStyle1 > 0 || strokeStyle > 0) {
                        currentLayer.writeStartElement("Edge");
                        if (lastFillStyle0 > -1) {
                            currentLayer.writeAttribute("fillStyle0", lastFillStyle0);
                        }
                        if (lastFillStyle1 > -1) {
                            currentLayer.writeAttribute("fillStyle1", lastFillStyle1);
                        }
                        if (lastStrokeStyle > -1) {
                            currentLayer.writeAttribute("strokeStyle", lastStrokeStyle);
                        }
                        StringBuilder edgesSb = new StringBuilder();
                        XFLConverter.convertShapeEdges((lastFillStyle0 > 0 || lastFillStyle1 > 0) && morphshape, startEdgeX, startEdgeY, mat, edges, edgesSb);
                        currentLayer.writeAttribute("edges", edgesSb.toString());
                        currentLayer.writeEndElement();
                        hasEdge = true;
                        startEdgeX = x;
                        startEdgeY = y;
                    }
                    edges.clear();
                }
            }
            edges.add(edge);
            x = edge.changeX(x);
            y = edge.changeY(y);
        }
        if (!(edges.isEmpty() || fillStyle0 <= 0 && fillStyle1 <= 0 && strokeStyle <= 0)) {
            currentLayer.writeStartElement("Edge");
            if (fillStyle0 > -1) {
                currentLayer.writeAttribute("fillStyle0", fillStyle0);
            }
            if (fillStyle1 > -1) {
                currentLayer.writeAttribute("fillStyle1", fillStyle1);
            }
            if (strokeStyle > -1) {
                currentLayer.writeAttribute("strokeStyle", strokeStyle);
            }
            StringBuilder edgesSb = new StringBuilder();
            XFLConverter.convertShapeEdges((fillStyle0 > 0 || fillStyle1 > 0) && morphshape, startEdgeX, startEdgeY, mat, edges, edgesSb);
            currentLayer.writeAttribute("edges", edgesSb.toString());
            currentLayer.writeEndElement();
            hasEdge = true;
        }
        edges.clear();
        if (currentLayer.length() > 0) {
            currentLayer.writeEndElement();
            currentLayer.writeEndElement();
            if (currentLayer.length() > 0 && hasEdge) {
                String s = currentLayer.toString();
                if (morphshape) {
                    s = XFLConverter.removeOnlyStrokeEdgesBeforeSameFilled(s);
                }
                layers.add(s);
            }
        }
        return layers;
    }

    private static String removeOnlyStrokeEdgesBeforeSameFilled(String layer) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String docString = "<x>" + layer + "</x>";
            Document doc = db.parse(new ByteArrayInputStream(docString.getBytes("UTF-8")));
            NodeList edgesParentList = doc.getElementsByTagName("edges");
            String prevStrokeOnly = null;
            String prevEdgesStr = "";
            for (int j = 0; j < edgesParentList.getLength(); ++j) {
                Node edgesParent = edgesParentList.item(j);
                NodeList edges = edgesParent.getChildNodes();
                Node prevNode = null;
                for (int i = 0; i < edges.getLength(); ++i) {
                    String fillStyle1;
                    Node edge = edges.item(i);
                    if (edge.getNodeType() == 3) continue;
                    NamedNodeMap attributes = edge.getAttributes();
                    Node strokeStyleNode = attributes.getNamedItem("strokeStyle");
                    Node fillStyle0Node = attributes.getNamedItem("fillStyle0");
                    Node fillStyle1Node = attributes.getNamedItem("fillStyle1");
                    Node edgesNode = attributes.getNamedItem("edges");
                    String edgesStr = edgesNode.getNodeValue();
                    String strokeStyle = strokeStyleNode != null ? strokeStyleNode.getNodeValue() : null;
                    String fillStyle0 = fillStyle0Node != null ? fillStyle0Node.getNodeValue() : null;
                    String string = fillStyle1 = fillStyle1Node != null ? fillStyle1Node.getNodeValue() : null;
                    if (prevStrokeOnly != null && strokeStyle != null && strokeStyle.equals(prevStrokeOnly) && edgesStr.startsWith(prevEdgesStr)) {
                        Node edgeToRemove = prevNode;
                        edgeToRemove.getParentNode().removeChild(edgeToRemove);
                    }
                    prevStrokeOnly = null;
                    if (strokeStyle != null && fillStyle0 == null && fillStyle1 == null) {
                        prevStrokeOnly = strokeStyle;
                    }
                    prevNode = edge;
                    prevEdgesStr = edgesStr;
                }
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            output = output.trim();
            output = output.substring(3, output.length() - 4);
            return output;
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException ex) {
            Logger.getLogger(XFLConverter.class.getName()).log(Level.SEVERE, null, ex);
            return layer;
        }
    }

    private static int getMaxDepth(ReadOnlyTagList tags) {
        int maxDepth = 0;
        for (Tag t : tags) {
            int cd;
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            int d = ((PlaceObjectTypeTag)t).getDepth();
            if (d > maxDepth) {
                maxDepth = d;
            }
            if ((cd = ((PlaceObjectTypeTag)t).getClipDepth()) <= maxDepth) continue;
            maxDepth = cd;
        }
        return maxDepth;
    }

    private static void walkShapeUsages(ReadOnlyTagList timeLineTags, HashMap<Integer, CharacterTag> characters, HashMap<Integer, Integer> usages) {
        HashMap<Integer, Integer> depthMap = new HashMap<Integer, Integer>();
        for (Tag t : timeLineTags) {
            if (t instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)t;
                XFLConverter.walkShapeUsages(sprite.getTags(), characters, usages);
            }
            if (t instanceof RemoveTag) {
                depthMap.remove(((RemoveTag)t).getDepth());
            }
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
            int d = po.getDepth();
            if (!po.flagMove() && depthMap.containsKey(d)) continue;
            int ch = po.getCharacterId();
            if (ch == -1) {
                if (depthMap.containsKey(d)) {
                    ch = (Integer)depthMap.get(d);
                }
            } else {
                depthMap.put(d, ch);
            }
            if (ch == -1) continue;
            if (!usages.containsKey(ch)) {
                usages.put(ch, 0);
            }
            int usageCount = usages.get(ch);
            ++usageCount;
            if (po.getInstanceName() != null) {
                ++usageCount;
            } else if (po.getColorTransform() != null) {
                ++usageCount;
            } else if (po.cacheAsBitmap()) {
                ++usageCount;
            } else if (po.getMatrix() != null && !po.getMatrix().isEmpty()) {
                ++usageCount;
            }
            usages.put(ch, usageCount);
        }
    }

    private static List<Integer> getNonLibraryShapes(ReadOnlyTagList tags, HashMap<Integer, CharacterTag> characters) {
        HashMap<Integer, Integer> usages = new HashMap<Integer, Integer>();
        XFLConverter.walkShapeUsages(tags, characters, usages);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        try {
            for (int ch : usages.keySet()) {
                ShapeTag shp;
                if (usages.get(ch) >= 2 || !(characters.get(ch) instanceof ShapeTag) || XFLConverter.shapeHasMultiLayers(characters, null, (shp = (ShapeTag)characters.get(ch)).getShapeNum(), shp.getShapes().shapeRecords, shp.getShapes().fillStyles, shp.getShapes().lineStyles)) continue;
                ret.add(ch);
            }
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    private static HashMap<Integer, CharacterTag> getCharacters(ReadOnlyTagList tags) {
        HashMap<Integer, CharacterTag> ret = new HashMap<Integer, CharacterTag>();
        for (Tag t : tags) {
            if (!(t instanceof CharacterTag)) continue;
            CharacterTag ct = (CharacterTag)t;
            ret.put(ct.getCharacterId(), ct);
        }
        return ret;
    }

    private static double radToDeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    private static String doubleToString(double d, int precision) {
        double m = Math.pow(10.0, precision);
        d = (double)Math.round(d * m) / m;
        return XFLConverter.doubleToString(d);
    }

    private static String doubleToString(double d) {
        String ds = "" + d;
        if (ds.endsWith(".0")) {
            ds = ds.substring(0, ds.length() - 2);
        }
        return ds;
    }

    private static void convertFilter(FILTER filter, XFLXmlWriter writer) throws XMLStreamException {
        if (filter instanceof DROPSHADOWFILTER) {
            DROPSHADOWFILTER dsf = (DROPSHADOWFILTER)filter;
            writer.writeStartElement("DropShadowFilter");
            if (dsf.dropShadowColor.alpha != 255) {
                writer.writeAttribute("alpha", XFLConverter.doubleToString(dsf.dropShadowColor.getAlphaFloat()));
            }
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(dsf.angle)));
            writer.writeAttribute("blurX", XFLConverter.doubleToString(dsf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(dsf.blurY));
            writer.writeAttribute("color", dsf.dropShadowColor.toHexRGB());
            writer.writeAttribute("distance", XFLConverter.doubleToString(dsf.distance));
            if (!dsf.compositeSource) {
                writer.writeAttribute("hideObject", true);
            }
            if (dsf.innerShadow) {
                writer.writeAttribute("inner", true);
            }
            if (dsf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("quality", dsf.passes);
            writer.writeAttribute("strength", XFLConverter.doubleToString(dsf.strength, 2));
            writer.writeEndElement();
        } else if (filter instanceof BLURFILTER) {
            BLURFILTER bf = (BLURFILTER)filter;
            writer.writeStartElement("BlurFilter");
            writer.writeAttribute("blurX", XFLConverter.doubleToString(bf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(bf.blurY));
            writer.writeAttribute("quality", bf.passes);
            writer.writeEndElement();
        } else if (filter instanceof GLOWFILTER) {
            GLOWFILTER gf = (GLOWFILTER)filter;
            writer.writeStartElement("GlowFilter");
            if (gf.glowColor.alpha != 255) {
                writer.writeAttribute("alpha", gf.glowColor.getAlphaFloat());
            }
            writer.writeAttribute("blurX", XFLConverter.doubleToString(gf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(gf.blurY));
            writer.writeAttribute("color", gf.glowColor.toHexRGB());
            if (gf.innerGlow) {
                writer.writeAttribute("inner", true);
            }
            if (gf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("quality", gf.passes);
            writer.writeAttribute("strength", XFLConverter.doubleToString(gf.strength, 2));
            writer.writeEndElement();
        } else if (filter instanceof BEVELFILTER) {
            BEVELFILTER bf = (BEVELFILTER)filter;
            writer.writeStartElement("BevelFilter");
            writer.writeAttribute("blurX", XFLConverter.doubleToString(bf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(bf.blurY));
            writer.writeAttribute("quality", bf.passes);
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(bf.angle)));
            writer.writeAttribute("distance", bf.distance);
            if (bf.highlightColor.alpha != 255) {
                writer.writeAttribute("highlightAlpha", bf.highlightColor.getAlphaFloat());
            }
            writer.writeAttribute("highlightColor", bf.highlightColor.toHexRGB());
            if (bf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            if (bf.shadowColor.alpha != 255) {
                writer.writeAttribute("shadowAlpha", bf.shadowColor.getAlphaFloat());
            }
            writer.writeAttribute("shadowColor", bf.shadowColor.toHexRGB());
            writer.writeAttribute("strength", XFLConverter.doubleToString(bf.strength, 2));
            if (bf.onTop && !bf.innerShadow) {
                writer.writeAttribute("type", "full");
            } else if (!bf.innerShadow) {
                writer.writeAttribute("type", "outer");
            }
            writer.writeEndElement();
        } else if (filter instanceof GRADIENTGLOWFILTER) {
            GRADIENTGLOWFILTER ggf = (GRADIENTGLOWFILTER)filter;
            writer.writeStartElement("GradientGlowFilter");
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(ggf.angle)));
            writer.writeAttribute("blurX", XFLConverter.doubleToString(ggf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(ggf.blurY));
            writer.writeAttribute("quality", ggf.passes);
            writer.writeAttribute("distance", XFLConverter.doubleToString(ggf.distance));
            if (ggf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("strength", XFLConverter.doubleToString(ggf.strength, 2));
            if (ggf.onTop && !ggf.innerShadow) {
                writer.writeAttribute("type", "full");
            } else if (!ggf.innerShadow) {
                writer.writeAttribute("type", "outer");
            }
            for (int g = 0; g < ggf.gradientColors.length; ++g) {
                RGBA gc = ggf.gradientColors[g];
                writer.writeStartElement("GradientEntry", new String[]{"color", gc.toHexRGB()});
                if (gc.alpha != 255) {
                    writer.writeAttribute("alpha", gc.getAlphaFloat());
                }
                writer.writeAttribute("ratio", XFLConverter.doubleToString((double)ggf.gradientRatio[g] / 255.0));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (filter instanceof GRADIENTBEVELFILTER) {
            GRADIENTBEVELFILTER gbf = (GRADIENTBEVELFILTER)filter;
            writer.writeStartElement("GradientBevelFilter");
            writer.writeAttribute("angle", XFLConverter.doubleToString(XFLConverter.radToDeg(gbf.angle)));
            writer.writeAttribute("blurX", XFLConverter.doubleToString(gbf.blurX));
            writer.writeAttribute("blurY", XFLConverter.doubleToString(gbf.blurY));
            writer.writeAttribute("quality", gbf.passes);
            writer.writeAttribute("distance", XFLConverter.doubleToString(gbf.distance));
            if (gbf.knockout) {
                writer.writeAttribute("knockout", true);
            }
            writer.writeAttribute("strength", XFLConverter.doubleToString(gbf.strength, 2));
            if (gbf.onTop && !gbf.innerShadow) {
                writer.writeAttribute("type", "full");
            } else if (!gbf.innerShadow) {
                writer.writeAttribute("type", "outer");
            }
            for (int g = 0; g < gbf.gradientColors.length; ++g) {
                RGBA gc = gbf.gradientColors[g];
                writer.writeStartElement("GradientEntry", new String[]{"color", gc.toHexRGB()});
                if (gc.alpha != 255) {
                    writer.writeAttribute("alpha", gc.getAlphaFloat());
                }
                writer.writeAttribute("ratio", XFLConverter.doubleToString((double)gbf.gradientRatio[g] / 255.0));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else if (filter instanceof COLORMATRIXFILTER) {
            COLORMATRIXFILTER cmf = (COLORMATRIXFILTER)filter;
            XFLConverter.convertAdjustColorFilter(cmf, writer);
        }
    }

    private static void convertSymbolInstance(String name, MATRIX matrix, ColorTransform colorTransform, boolean cacheAsBitmap, int blendMode, List<FILTER> filters, boolean isVisible, RGBA backgroundColor, CLIPACTIONS clipActions, Amf3Value metadata, CharacterTag tag, HashMap<Integer, CharacterTag> characters, ReadOnlyTagList tags, FLAVersion flaVersion, XFLXmlWriter writer) throws XMLStreamException {
        ObjectType metadataObject;
        DefineButtonTag bt;
        DefineButtonCxformTag bcx;
        if (matrix == null) {
            matrix = new MATRIX();
        }
        if (tag instanceof DefineButtonTag && (bcx = (DefineButtonCxformTag)(bt = (DefineButtonTag)tag).getSwf().getCharacterIdTag(bt.buttonId, 23)) != null) {
            colorTransform = bcx.buttonColorTransform;
        }
        writer.writeStartElement("DOMSymbolInstance", new String[]{"libraryItemName", "Symbol " + tag.getCharacterId()});
        if (name != null) {
            writer.writeAttribute("name", name);
        }
        String blendModeStr = null;
        if (blendMode < BLENDMODES.length) {
            blendModeStr = BLENDMODES[blendMode];
        }
        if (blendModeStr != null) {
            writer.writeAttribute("blendMode", blendModeStr);
        }
        if (tag instanceof ShapeTag) {
            writer.writeAttribute("symbolType", "graphic");
            writer.writeAttribute("loop", "loop");
        } else if (tag instanceof DefineSpriteTag) {
            DefineSpriteTag sprite = (DefineSpriteTag)tag;
            RECT spriteRect = sprite.getRect();
            double centerPoint3DX = XFLConverter.twipToPixel(matrix.translateX + spriteRect.getWidth() / 2);
            double centerPoint3DY = XFLConverter.twipToPixel(matrix.translateY + spriteRect.getHeight() / 2);
            writer.writeAttribute("centerPoint3DX", centerPoint3DX);
            writer.writeAttribute("centerPoint3DY", centerPoint3DY);
        } else if (tag instanceof ButtonTag) {
            writer.writeAttribute("symbolType", "button");
        }
        if (cacheAsBitmap) {
            writer.writeAttribute("cacheAsBitmap", true);
        }
        if (!isVisible && flaVersion.ordinal() >= FLAVersion.CS5_5.ordinal()) {
            writer.writeAttribute("isVisible", false);
        }
        writer.writeStartElement("matrix");
        XFLConverter.convertMatrix(matrix, writer);
        writer.writeEndElement();
        writer.writeStartElement("transformationPoint");
        writer.writeEmptyElement("Point");
        writer.writeEndElement();
        if (backgroundColor != null) {
            writer.writeStartElement("MatteColor", new String[]{"color", backgroundColor.toHexRGB()});
            if (backgroundColor.alpha != 255) {
                writer.writeAttribute("alpha", XFLConverter.doubleToString(backgroundColor.getAlphaFloat()));
            }
            writer.writeEndElement();
        }
        if (colorTransform != null) {
            writer.writeStartElement("color");
            writer.writeStartElement("Color");
            if (colorTransform.getRedMulti() != 256) {
                writer.writeAttribute("redMultiplier", (float)colorTransform.getRedMulti() / 256.0f);
            }
            if (colorTransform.getGreenMulti() != 256) {
                writer.writeAttribute("greenMultiplier", (float)colorTransform.getGreenMulti() / 256.0f);
            }
            if (colorTransform.getBlueMulti() != 256) {
                writer.writeAttribute("blueMultiplier", (float)colorTransform.getBlueMulti() / 256.0f);
            }
            if (colorTransform.getAlphaMulti() != 256) {
                writer.writeAttribute("alphaMultiplier", (float)colorTransform.getAlphaMulti() / 256.0f);
            }
            if (colorTransform.getRedAdd() != 0) {
                writer.writeAttribute("redOffset", colorTransform.getRedAdd());
            }
            if (colorTransform.getGreenAdd() != 0) {
                writer.writeAttribute("greenOffset", colorTransform.getGreenAdd());
            }
            if (colorTransform.getBlueAdd() != 0) {
                writer.writeAttribute("blueOffset", colorTransform.getBlueAdd());
            }
            if (colorTransform.getAlphaAdd() != 0) {
                writer.writeAttribute("alphaOffset", colorTransform.getAlphaAdd());
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (filters != null) {
            writer.writeStartElement("filters");
            for (FILTER f : filters) {
                XFLConverter.convertFilter(f, writer);
            }
            writer.writeEndElement();
        }
        if (tag instanceof DefineButtonTag) {
            writer.writeStartElement("Actionscript");
            writer.writeStartElement("script");
            writer.writeCData("on(press){\r\n" + XFLConverter.convertActionScript12(new ButtonAction((DefineButtonTag)tag)) + "}");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (tag instanceof DefineButton2Tag) {
            DefineButton2Tag db2 = (DefineButton2Tag)tag;
            if (!db2.actions.isEmpty()) {
                writer.writeStartElement("Actionscript");
                writer.writeStartElement("script");
                StringBuilder sbActions = new StringBuilder();
                for (BUTTONCONDACTION bca : db2.actions) {
                    sbActions.append(XFLConverter.convertActionScript12(bca));
                }
                writer.writeCData(sbActions.toString());
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        if (clipActions != null) {
            writer.writeStartElement("Actionscript");
            writer.writeStartElement("script");
            StringBuilder sbActions = new StringBuilder();
            for (CLIPACTIONRECORD rec : clipActions.clipActionRecords) {
                sbActions.append(XFLConverter.convertActionScript12(rec));
            }
            writer.writeCData(sbActions.toString());
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (metadata != null && metadata.getValue() instanceof ObjectType && (metadataObject = (ObjectType)metadata.getValue()).isDynamic()) {
            writer.writeStartElement("persistentData");
            ArrayList<String> exportedNames = new ArrayList<String>();
            for (String n : metadataObject.dynamicMembersKeySet()) {
                Object v = metadataObject.getDynamicMember(n);
                if (v instanceof Long) {
                    exportedNames.add(n);
                    writer.writeStartElement("PD");
                    writer.writeAttribute("n", n);
                    writer.writeAttribute("t", "i");
                    writer.writeAttribute("v", (Long)v);
                    writer.writeEndElement();
                    exportedNames.add(n);
                    continue;
                }
                if (v instanceof Double) {
                    writer.writeStartElement("PD");
                    writer.writeAttribute("n", n);
                    writer.writeAttribute("t", "d");
                    writer.writeAttribute("v", (Double)v);
                    writer.writeEndElement();
                    exportedNames.add(n);
                    continue;
                }
                if (!(v instanceof String)) continue;
                writer.writeStartElement("PD");
                writer.writeAttribute("n", n);
                writer.writeAttribute("v", (String)v);
                writer.writeEndElement();
                exportedNames.add(n);
            }
            for (String n : exportedNames) {
                writer.writeStartElement("PD");
                writer.writeAttribute("n", "PUB_PRST_DATA_EMBED_SWF_" + n);
                writer.writeAttribute("t", "i");
                writer.writeAttribute("v", 1);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static String convertActionScript12(ASMSource as, List<ActionTreeOperation> treeOperations) {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
        try {
            as.getActionScriptSource(writer, null, treeOperations);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return writer.toString();
    }

    private static String convertActionScript12(ASMSource as) {
        return XFLConverter.convertActionScript12(as, new ArrayList<ActionTreeOperation>());
    }

    private static long getTimestamp(SWF swf) {
        Date date = swf.getFileModificationDate();
        return date.getTime() / 1000L;
    }

    private void convertLibrary(SWF swf, Map<Integer, String> characterVariables, Map<Integer, String> characterClasses, Map<Integer, ScriptPack> characterScriptPacks, List<Integer> nonLibraryShapes, String backgroundColor, ReadOnlyTagList tags, HashMap<Integer, CharacterTag> characters, HashMap<String, byte[]> files, HashMap<String, byte[]> datfiles, FLAVersion flaVersion, XFLXmlWriter writer) throws XMLStreamException {
        this.convertMedia(swf, characterVariables, characterClasses, nonLibraryShapes, backgroundColor, tags, characters, files, datfiles, flaVersion, writer);
        this.convertSymbols(swf, characterVariables, characterClasses, characterScriptPacks, nonLibraryShapes, backgroundColor, tags, characters, files, datfiles, flaVersion, writer);
    }

    private void convertSymbols(SWF swf, Map<Integer, String> characterVariables, Map<Integer, String> characterClasses, Map<Integer, ScriptPack> characterScriptPacks, List<Integer> nonLibraryShapes, String backgroundColor, ReadOnlyTagList tags, HashMap<Integer, CharacterTag> characters, HashMap<String, byte[]> files, HashMap<String, byte[]> datfiles, FLAVersion flaVersion, XFLXmlWriter writer) throws XMLStreamException {
        boolean hasSymbol = false;
        for (int ch : characters.keySet()) {
            DefineScalingGridTag scalingGrid;
            CharacterTag symbol = characters.get(ch);
            if (symbol instanceof ShapeTag && nonLibraryShapes.contains(symbol.getCharacterId()) || !(symbol instanceof ShapeTag) && !(symbol instanceof DefineSpriteTag) && !(symbol instanceof ButtonTag)) continue;
            XFLXmlWriter symbolStr = new XFLXmlWriter();
            symbolStr.writeStartElement("DOMSymbolItem", new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns", "http://ns.adobe.com/xfl/2008/", "name", "Symbol " + symbol.getCharacterId(), "lastModified", Long.toString(XFLConverter.getTimestamp(swf))});
            if (symbol instanceof ShapeTag) {
                symbolStr.writeAttribute("symbolType", "graphic");
            } else if (symbol instanceof ButtonTag) {
                symbolStr.writeAttribute("symbolType", "button");
                if (((ButtonTag)symbol).trackAsMenu()) {
                    symbolStr.writeAttribute("trackAsMenu", true);
                }
            }
            boolean linkageExportForAS = false;
            if (characterClasses.containsKey(symbol.getCharacterId())) {
                linkageExportForAS = true;
                symbolStr.writeAttribute("linkageClassName", characterClasses.get(symbol.getCharacterId()));
            }
            if (characterVariables.containsKey(symbol.getCharacterId())) {
                linkageExportForAS = true;
                symbolStr.writeAttribute("linkageIdentifier", characterVariables.get(symbol.getCharacterId()));
            }
            if (linkageExportForAS) {
                symbolStr.writeAttribute("linkageExportForAS", true);
            }
            if ((scalingGrid = symbol.getScalingGridTag()) != null) {
                symbolStr.writeAttribute("scaleGridLeft", XFLConverter.doubleToString((double)scalingGrid.splitter.Xmin / 20.0));
                symbolStr.writeAttribute("scaleGridRight", XFLConverter.doubleToString((double)scalingGrid.splitter.Xmax / 20.0));
                symbolStr.writeAttribute("scaleGridTop", XFLConverter.doubleToString((double)scalingGrid.splitter.Ymin / 20.0));
                symbolStr.writeAttribute("scaleGridBottom", XFLConverter.doubleToString((double)scalingGrid.splitter.Ymax / 20.0));
            }
            String itemIcon = null;
            if (symbol instanceof ButtonTag) {
                symbolStr.writeStartElement("timeline");
                itemIcon = "0";
                symbolStr.writeStartElement("DOMTimeline", new String[]{"name", "Symbol " + symbol.getCharacterId(), "currentFrame", "0"});
                symbolStr.writeStartElement("layers");
                ButtonTag button = (ButtonTag)symbol;
                List<BUTTONRECORD> records = button.getRecords();
                int maxDepth = 0;
                for (BUTTONRECORD rec : records) {
                    if (rec.placeDepth <= maxDepth) continue;
                    maxDepth = rec.placeDepth;
                }
                DefineButtonSoundTag defineButtonSound = button.getSounds();
                int soundLayerOffset = 0;
                if (defineButtonSound != null) {
                    soundLayerOffset = 1;
                    symbolStr.writeStartElement("DOMLayer", new String[]{"name", "Layer 1"});
                    symbolStr.writeStartElement("frames");
                    for (int frame = 1; frame <= 4; ++frame) {
                        int soundChar = 0;
                        SOUNDINFO soundInfo = null;
                        switch (frame) {
                            case 1: {
                                soundChar = defineButtonSound.buttonSoundChar0;
                                soundInfo = defineButtonSound.buttonSoundInfo0;
                                break;
                            }
                            case 2: {
                                soundChar = defineButtonSound.buttonSoundChar1;
                                soundInfo = defineButtonSound.buttonSoundInfo1;
                                break;
                            }
                            case 3: {
                                soundChar = defineButtonSound.buttonSoundChar2;
                                soundInfo = defineButtonSound.buttonSoundInfo2;
                                break;
                            }
                            case 4: {
                                soundChar = defineButtonSound.buttonSoundChar3;
                                soundInfo = defineButtonSound.buttonSoundInfo3;
                            }
                        }
                        symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - 1), "keyMode", Integer.toString(9728)});
                        if (soundChar > 0) {
                            DefineSoundTag sound = (DefineSoundTag)swf.getCharacter(soundChar);
                            XFLConverter.convertSoundUsage(symbolStr, sound, soundInfo);
                        }
                        symbolStr.writeStartElement("elements");
                        symbolStr.writeEndElement();
                        symbolStr.writeEndElement();
                    }
                    symbolStr.writeEndElement();
                    symbolStr.writeEndElement();
                }
                for (int i = maxDepth; i >= 1; --i) {
                    symbolStr.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (maxDepth - i + 1 + soundLayerOffset)});
                    if (i == 1) {
                        symbolStr.writeAttribute("current", true);
                        symbolStr.writeAttribute("isSelected", true);
                    }
                    symbolStr.writeAttribute("color", this.randomOutlineColor());
                    symbolStr.writeStartElement("frames");
                    int lastFrame = 0;
                    for (int frame = 1; frame <= 4; ++frame) {
                        for (BUTTONRECORD rec : records) {
                            CharacterTag character;
                            if (rec.placeDepth != i) continue;
                            boolean ok = false;
                            switch (frame) {
                                case 1: {
                                    ok = rec.buttonStateUp;
                                    break;
                                }
                                case 2: {
                                    ok = rec.buttonStateOver;
                                    break;
                                }
                                case 3: {
                                    ok = rec.buttonStateDown;
                                    break;
                                }
                                case 4: {
                                    ok = rec.buttonStateHitTest;
                                }
                            }
                            if (!ok) continue;
                            CXFORMWITHALPHA colorTransformAlpha = null;
                            int blendMode = 0;
                            ArrayList<FILTER> filters = new ArrayList();
                            if (button instanceof DefineButton2Tag) {
                                colorTransformAlpha = rec.colorTransform;
                                if (rec.buttonHasBlendMode) {
                                    blendMode = rec.blendMode;
                                }
                                if (rec.buttonHasFilterList) {
                                    filters = rec.filterList;
                                }
                            }
                            if ((character = characters.get(rec.characterId)) != null) {
                                MATRIX matrix = rec.placeMatrix;
                                XFLXmlWriter recCharWriter = new XFLXmlWriter();
                                int characterId = character.getCharacterId();
                                if (character instanceof ShapeTag && nonLibraryShapes.contains(characterId)) {
                                    ShapeTag shape = (ShapeTag)character;
                                    XFLConverter.convertShape(characters, matrix, shape.getShapeNum(), shape.getShapes().shapeRecords, shape.getShapes().fillStyles, shape.getShapes().lineStyles, false, false, recCharWriter);
                                } else if (character instanceof TextTag) {
                                    XFLConverter.convertText(null, (TextTag)character, matrix, filters, null, recCharWriter);
                                } else if (character instanceof DefineVideoStreamTag) {
                                    XFLConverter.convertVideoInstance(null, matrix, (DefineVideoStreamTag)character, null, recCharWriter);
                                } else {
                                    XFLConverter.convertSymbolInstance(null, matrix, colorTransformAlpha, false, blendMode, filters, true, null, null, null, characters.get(rec.characterId), characters, tags, flaVersion, recCharWriter);
                                }
                                int duration = frame - lastFrame;
                                lastFrame = frame;
                                if (duration <= 0) continue;
                                if (duration > 1) {
                                    symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - duration), "duration", Integer.toString(duration - 1), "keyMode", Integer.toString(9728)});
                                    symbolStr.writeElementValue("elements", "");
                                    symbolStr.writeEndElement();
                                }
                                symbolStr.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - 1), "keyMode", Integer.toString(9728)});
                                symbolStr.writeStartElement("elements");
                                symbolStr.writeCharactersRaw(recCharWriter.toString());
                                symbolStr.writeEndElement();
                                symbolStr.writeEndElement();
                                continue;
                            }
                            logger.log(Level.WARNING, "Character with id={0} was not found.", rec.characterId);
                        }
                    }
                    symbolStr.writeEndElement();
                    symbolStr.writeEndElement();
                }
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
            } else if (symbol instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)symbol;
                if (sprite.getTags().isEmpty()) continue;
                ScriptPack spriteScriptPack = characterScriptPacks.containsKey(sprite.spriteId) ? characterScriptPacks.get(sprite.spriteId) : null;
                this.convertTimeline(swf.getAbcIndex(), sprite.spriteId, characterVariables.get(sprite.spriteId), nonLibraryShapes, backgroundColor, tags, sprite.getTags(), characters, "Symbol " + symbol.getCharacterId(), flaVersion, files, symbolStr, spriteScriptPack);
            } else if (symbol instanceof ShapeTag) {
                symbolStr.writeStartElement("timeline");
                itemIcon = "1";
                ShapeTag shape = (ShapeTag)symbol;
                symbolStr.writeStartElement("DOMTimeline", new String[]{"name", "Symbol " + symbol.getCharacterId(), "currentFrame", "0"});
                symbolStr.writeStartElement("layers");
                SHAPEWITHSTYLE shapeWithStyle = shape.getShapes();
                if (shapeWithStyle != null) {
                    XFLConverter.convertShape(characters, null, shape.getShapeNum(), shapeWithStyle.shapeRecords, shapeWithStyle.fillStyles, shapeWithStyle.lineStyles, false, true, symbolStr);
                }
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
                symbolStr.writeEndElement();
            }
            symbolStr.writeEndElement();
            String symbolStr2 = this.prettyFormatXML(symbolStr.toString());
            String symbolFile = "Symbol " + symbol.getCharacterId() + ".xml";
            files.put(symbolFile, Utf8Helper.getBytes(symbolStr2));
            if (!hasSymbol) {
                writer.writeStartElement("symbols");
            }
            writer.writeStartElement("Include", new String[]{"href", symbolFile});
            if (itemIcon != null) {
                writer.writeAttribute("itemIcon", itemIcon);
            }
            writer.writeAttribute("loadImmediate", false);
            if (flaVersion.ordinal() >= FLAVersion.CS5_5.ordinal()) {
                writer.writeAttribute("lastModified", XFLConverter.getTimestamp(swf));
            }
            writer.writeEndElement();
            hasSymbol = true;
        }
        if (hasSymbol) {
            writer.writeEndElement();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void convertMedia(SWF swf, Map<Integer, String> characterVariables, Map<Integer, String> characterClasses, List<Integer> nonLibraryShapes, String backgroundColor, ReadOnlyTagList tags, HashMap<Integer, CharacterTag> characters, HashMap<String, byte[]> files, HashMap<String, byte[]> datfiles, FLAVersion flaVersion, XFLXmlWriter writer) throws XMLStreamException {
        boolean hasMedia = false;
        for (int ch : characters.keySet()) {
            CharacterTag symbol = characters.get(ch);
            if (!(symbol instanceof ImageTag) && !(symbol instanceof DefineSoundTag) && !(symbol instanceof DefineVideoStreamTag)) continue;
            hasMedia = true;
        }
        if (!hasMedia) {
            return;
        }
        int mediaCount = 0;
        writer.writeStartElement("media");
        for (int ch : characters.keySet()) {
            CharacterTag symbol = characters.get(ch);
            if (symbol instanceof ImageTag) {
                ImageTag imageTag = (ImageTag)symbol;
                boolean allowSmoothing = false;
                block40: for (Tag tag : swf.getTags()) {
                    if (!(tag instanceof ShapeTag)) continue;
                    HashSet<Integer> needed = new HashSet<Integer>();
                    tag.getNeededCharacters(needed, swf);
                    ShapeTag sht = (ShapeTag)tag;
                    if (!needed.contains(imageTag.getCharacterId())) continue;
                    ArrayList<FILLSTYLE> fs = new ArrayList<FILLSTYLE>();
                    SHAPEWITHSTYLE s = sht.getShapes();
                    for (FILLSTYLE fILLSTYLE : s.fillStyles.fillStyles) {
                        fs.add(fILLSTYLE);
                    }
                    for (SHAPERECORD sHAPERECORD : s.shapeRecords) {
                        if (!(sHAPERECORD instanceof StyleChangeRecord)) continue;
                        StyleChangeRecord scr = (StyleChangeRecord)sHAPERECORD;
                        if (!scr.stateNewStyles) continue;
                        for (FILLSTYLE f2 : scr.fillStyles.fillStyles) {
                            fs.add(f2);
                        }
                    }
                    for (FILLSTYLE fILLSTYLE : fs) {
                        if (!Arrays.asList(64, 65, 66, 67).contains(fILLSTYLE.fillStyleType) || fILLSTYLE.bitmapId != imageTag.getCharacterId()) continue;
                        allowSmoothing = fILLSTYLE.fillStyleType == 65 || fILLSTYLE.fillStyleType == 64;
                        break block40;
                    }
                }
                byte[] imageBytes = Helper.readStream(imageTag.getConvertedImageData());
                SerializableImage image = imageTag.getImageCached();
                ImageFormat format = imageTag.getImageFormat();
                String symbolFile = "bitmap" + symbol.getCharacterId() + imageTag.getImageFormat().getExtension();
                files.put(symbolFile, imageBytes);
                writer.writeStartElement("DOMBitmapItem", new String[]{"name", symbolFile, "sourceLastImported", Long.toString(XFLConverter.getTimestamp(swf)), "externalFileSize", Integer.toString(imageBytes.length)});
                if (allowSmoothing) {
                    writer.writeAttribute("allowSmoothing", true);
                }
                switch (format) {
                    case PNG: 
                    case GIF: {
                        if (imageTag.getOriginalImageFormat() != ImageFormat.JPEG) {
                            writer.writeAttribute("useImportedJPEGData", false);
                            writer.writeAttribute("compressionType", "lossless");
                        }
                        writer.writeAttribute("originalCompressionType", "lossless");
                        break;
                    }
                    case JPEG: {
                        writer.writeAttribute("isJPEG", true);
                    }
                }
                if (characterClasses.containsKey(symbol.getCharacterId())) {
                    writer.writeAttribute("linkageExportForAS", true);
                    writer.writeAttribute("linkageClassName", characterClasses.get(symbol.getCharacterId()));
                }
                writer.writeAttribute("quality", 50);
                writer.writeAttribute("href", symbolFile);
                writer.writeAttribute("bitmapDataHRef", "M " + (mediaCount + 1) + " " + XFLConverter.getTimestamp(swf) + ".dat");
                writer.writeAttribute("frameRight", image.getWidth());
                writer.writeAttribute("frameBottom", image.getHeight());
                writer.writeEndElement();
                ++mediaCount;
                continue;
            }
            if (symbol instanceof DefineSoundTag) {
                void var26_50;
                int soundFormat = 0;
                int soundRate = 0;
                boolean soundType = false;
                boolean soundSize = false;
                long soundSampleCount = 0L;
                byte[] soundData = SWFInputStream.BYTE_ARRAY_EMPTY;
                int[] rateMap = new int[]{5, 11, 22, 44};
                String exportFormat = "flv";
                if (symbol instanceof DefineSoundTag) {
                    DefineSoundTag defineSoundTag = (DefineSoundTag)symbol;
                    soundFormat = defineSoundTag.soundFormat;
                    soundRate = defineSoundTag.soundRate;
                    soundType = defineSoundTag.soundType;
                    soundData = defineSoundTag.soundData.getRangeData();
                    soundSize = defineSoundTag.soundSize;
                    soundSampleCount = defineSoundTag.soundSampleCount;
                }
                boolean bl = false;
                int bits = 0;
                if (soundFormat == 1 || soundFormat == 3 || soundFormat == 0) {
                    exportFormat = "wav";
                    if (soundType) {
                        void var26_43;
                        ++var26_43;
                    }
                    switch (soundRate) {
                        case 0: {
                            var26_44 += 2;
                            break;
                        }
                        case 1: {
                            var26_45 += 6;
                            break;
                        }
                        case 2: {
                            var26_46 += 10;
                            break;
                        }
                        case 3: {
                            var26_47 += 14;
                        }
                    }
                }
                if (soundFormat == 11) {
                    bits = 18;
                }
                if (soundFormat == 1) {
                    exportFormat = "wav";
                    try {
                        SWFInputStream sWFInputStream = new SWFInputStream(swf, soundData);
                        int adpcmCodeSize = (int)sWFInputStream.readUB(2, "adpcmCodeSize");
                        bits = 2 + adpcmCodeSize;
                    }
                    catch (IOException iOException) {
                        logger.log(Level.SEVERE, null, iOException);
                    }
                }
                if (soundFormat == 2) {
                    exportFormat = "mp3";
                    if (!soundType) {
                        void var26_49;
                        ++var26_49;
                    }
                    var26_50 += 4;
                    try {
                        SWFInputStream sWFInputStream = new SWFInputStream(swf, soundData);
                        MP3SOUNDDATA s = new MP3SOUNDDATA(sWFInputStream, false);
                        if (!s.frames.isEmpty()) {
                            MP3FRAME frame = s.frames.get(0);
                            int bitRate = frame.getBitRate();
                            switch (bitRate) {
                                case 8: {
                                    bits = 6;
                                    break;
                                }
                                case 16: {
                                    bits = 7;
                                    break;
                                }
                                case 20: {
                                    bits = 8;
                                    break;
                                }
                                case 24: {
                                    bits = 9;
                                    break;
                                }
                                case 32: {
                                    bits = 10;
                                    break;
                                }
                                case 48: {
                                    bits = 11;
                                    break;
                                }
                                case 56: {
                                    bits = 12;
                                    break;
                                }
                                case 64: {
                                    bits = 13;
                                    break;
                                }
                                case 80: {
                                    bits = 14;
                                    break;
                                }
                                case 112: {
                                    bits = 15;
                                    break;
                                }
                                case 128: {
                                    bits = 16;
                                    break;
                                }
                                case 160: {
                                    bits = 17;
                                }
                            }
                        }
                    }
                    catch (IOException | IndexOutOfBoundsException exception) {
                        logger.log(Level.SEVERE, null, exception);
                    }
                }
                SoundTag soundTag = (SoundTag)((Object)symbol);
                SoundFormat fmt = soundTag.getSoundFormat();
                byte[] data = SWFInputStream.BYTE_ARRAY_EMPTY;
                try {
                    data = new SoundExporter().exportSound(soundTag, SoundExportMode.MP3_WAV);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                String symbolFile = "sound" + symbol.getCharacterId() + "." + exportFormat;
                files.put(symbolFile, data);
                writer.writeStartElement("DOMSoundItem", new String[]{"name", symbolFile, "sourceLastImported", Long.toString(XFLConverter.getTimestamp(swf)), "externalFileSize", Integer.toString(data.length)});
                writer.writeAttribute("href", symbolFile);
                writer.writeAttribute("format", rateMap[soundRate] + "kHz " + (soundSize ? "16bit" : "8bit") + " " + (soundType ? "Stereo" : "Mono"));
                writer.writeAttribute("exportFormat", (int)var26_50);
                writer.writeAttribute("exportBits", bits);
                writer.writeAttribute("sampleCount", soundSampleCount);
                boolean linkageExportForAS = false;
                if (characterClasses.containsKey(symbol.getCharacterId())) {
                    linkageExportForAS = true;
                    writer.writeAttribute("linkageClassName", characterClasses.get(symbol.getCharacterId()));
                }
                if (characterVariables.containsKey(symbol.getCharacterId())) {
                    linkageExportForAS = true;
                    writer.writeAttribute("linkageIdentifier", characterVariables.get(symbol.getCharacterId()));
                }
                if (linkageExportForAS) {
                    writer.writeAttribute("linkageExportForAS", true);
                }
                writer.writeEndElement();
                ++mediaCount;
                continue;
            }
            if (!(symbol instanceof DefineVideoStreamTag)) continue;
            DefineVideoStreamTag video = (DefineVideoStreamTag)symbol;
            String videoType = "no media";
            switch (video.codecID) {
                case 2: {
                    videoType = "h263 media";
                    break;
                }
                case 3: {
                    videoType = "screen share media";
                    break;
                }
                case 4: {
                    videoType = "vp6 media";
                    break;
                }
                case 5: {
                    videoType = "vp6 alpha media";
                }
            }
            byte[] data = SWFInputStream.BYTE_ARRAY_EMPTY;
            try {
                data = new MovieExporter().exportMovie(video, MovieExportMode.FLV);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            String symbolFile = "movie" + symbol.getCharacterId() + ".flv";
            if (data.length == 0) {
                long ts = XFLConverter.getTimestamp(swf);
                String datFileName = "M " + (datfiles.size() + 1) + " " + ts + ".dat";
                writer.writeEmptyElement("DOMVideoItem", new String[]{"name", symbolFile, "sourceExternalFilepath", "./LIBRARY/" + symbolFile, "sourceLastImported", Long.toString(ts), "videoDataHRef", datFileName, "channels", "0", "isSpecial", "true"});
                datfiles.put(datFileName, new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -96, 0, 0, 0, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 64, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, -1, 0, 0, 0, 0, 0});
            } else {
                files.put(symbolFile, data);
                writer.writeStartElement("DOMVideoItem", new String[]{"name", symbolFile, "sourceLastImported", Long.toString(XFLConverter.getTimestamp(swf)), "externalFileSize", Integer.toString(data.length)});
                writer.writeAttribute("href", symbolFile);
                writer.writeAttribute("videoType", videoType);
                writer.writeAttribute("fps", (int)swf.frameRate);
                writer.writeAttribute("width", video.width);
                writer.writeAttribute("height", video.height);
                double len = (double)video.numFrames / (double)swf.frameRate;
                writer.writeAttribute("length", len);
                boolean linkageExportForAS = false;
                if (characterClasses.containsKey(symbol.getCharacterId())) {
                    linkageExportForAS = true;
                    writer.writeAttribute("linkageClassName", characterClasses.get(symbol.getCharacterId()));
                }
                if (characterVariables.containsKey(symbol.getCharacterId())) {
                    linkageExportForAS = true;
                    writer.writeAttribute("linkageIdentifier", characterVariables.get(symbol.getCharacterId()));
                }
                if (linkageExportForAS) {
                    writer.writeAttribute("linkageExportForAS", true);
                }
                writer.writeEndElement();
            }
            ++mediaCount;
        }
        writer.writeEndElement();
    }

    private String prettyFormatXML(String input) {
        return new XmlPrettyFormat().prettyFormat(input, 5, false);
    }

    private static void convertSoundUsage(XFLXmlWriter writer, DefineSoundTag sound, SOUNDINFO soundInfo) throws XMLStreamException {
        String soundName = "sound" + sound.soundId + "." + sound.getExportFormat().toString().toLowerCase();
        writer.writeAttribute("soundName", soundName);
        if (soundInfo.hasInPoint) {
            writer.writeAttribute("inPoint44", soundInfo.inPoint);
        }
        if (soundInfo.hasOutPoint) {
            writer.writeAttribute("outPoint44", soundInfo.outPoint);
        }
        if (soundInfo.hasLoops) {
            if (soundInfo.loopCount == Short.MAX_VALUE) {
                writer.writeAttribute("soundLoopMode", "loop");
            }
            writer.writeAttribute("soundLoop", soundInfo.loopCount);
        }
        if (soundInfo.syncStop) {
            writer.writeAttribute("soundSync", "stop");
        } else if (soundInfo.syncNoMultiple) {
            writer.writeAttribute("soundSync", "start");
        }
        if (soundInfo.hasEnvelope) {
            SOUNDENVELOPE[] envelopeRecords = soundInfo.envelopeRecords;
            long soundLength44 = 0L;
            switch (sound.soundRate) {
                case 0: {
                    soundLength44 = 8L * sound.soundSampleCount;
                    break;
                }
                case 1: {
                    soundLength44 = 4L * sound.soundSampleCount;
                    break;
                }
                case 2: {
                    soundLength44 = 2L * sound.soundSampleCount;
                    break;
                }
                case 3: {
                    soundLength44 = sound.soundSampleCount;
                }
            }
            if (envelopeRecords.length == 1 && envelopeRecords[0].leftLevel == 32768 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "left channel");
            } else if (envelopeRecords.length == 1 && envelopeRecords[0].leftLevel == 0 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 32768) {
                writer.writeAttribute("soundEffect", "right channel");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 32768 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 0 && envelopeRecords[1].leftLevel == 0 && envelopeRecords[1].pos44 == soundLength44 && envelopeRecords[1].rightLevel == 32768) {
                writer.writeAttribute("soundEffect", "fade left to right");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 0 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 32768 && envelopeRecords[1].leftLevel == 32768 && envelopeRecords[1].pos44 == soundLength44 && envelopeRecords[1].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "fade right to left");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 0 && envelopeRecords[0].pos44 == 0L && envelopeRecords[0].rightLevel == 0 && envelopeRecords[1].leftLevel == 32768 && envelopeRecords[1].pos44 == soundLength44 / 4L && envelopeRecords[1].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "fade in");
            } else if (envelopeRecords.length == 2 && envelopeRecords[0].leftLevel == 32768 && envelopeRecords[0].pos44 == soundLength44 * 3L / 4L && envelopeRecords[0].rightLevel == 32768 && envelopeRecords[1].leftLevel == 0 && envelopeRecords[1].pos44 == soundLength44 && envelopeRecords[1].rightLevel == 0) {
                writer.writeAttribute("soundEffect", "fade out");
            } else {
                writer.writeAttribute("soundEffect", "custom");
            }
            writer.writeStartElement("SoundEnvelope");
            for (SOUNDENVELOPE env : envelopeRecords) {
                writer.writeEmptyElement("SoundEnvelopePoint", new String[]{"mark44", Long.toString(env.pos44), "level0", Integer.toString(env.leftLevel), "level1", Integer.toString(env.rightLevel)});
            }
            writer.writeEndElement();
        } else {
            writer.writeStartElement("SoundEnvelope");
            writer.writeEmptyElement("SoundEnvelopePoint", new String[]{"level0", "32768", "level1", "32768"});
            writer.writeEndElement();
        }
    }

    private static void convertFrame(boolean shapeTween, SoundStreamHeadTypeTag soundStreamHead, StartSoundTag startSound, int frame, int duration, String actionScript, String elements, HashMap<String, byte[]> files, XFLXmlWriter writer) throws XMLStreamException {
        DefineSoundTag sound = null;
        if (startSound != null) {
            SWF swf = startSound.getSwf();
            sound = swf.getSound(startSound.soundId);
        }
        writer.writeStartElement("DOMFrame");
        writer.writeAttribute("index", frame);
        if (duration > 1) {
            writer.writeAttribute("duration", duration);
        }
        if (shapeTween) {
            writer.writeAttribute("tweenType", "shape");
            writer.writeAttribute("keyMode", 17922);
        } else {
            writer.writeAttribute("keyMode", 9728);
        }
        if (soundStreamHead != null && startSound == null) {
            String soundName = "sound" + soundStreamHead.getCharacterId() + "." + soundStreamHead.getExportFormat().toString().toLowerCase();
            writer.writeAttribute("soundName", soundName);
            writer.writeAttribute("soundSync", "stream");
            writer.writeStartElement("SoundEnvelope");
            writer.writeEmptyElement("SoundEnvelopePoint", new String[]{"level0", "32768", "level1", "32768"});
            writer.writeEndElement();
        }
        if (startSound != null && sound != null) {
            XFLConverter.convertSoundUsage(writer, sound, startSound.soundInfo);
        }
        if (!actionScript.isEmpty()) {
            writer.writeStartElement("Actionscript");
            writer.writeStartElement("script");
            writer.writeCData(actionScript);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeStartElement("elements");
        writer.writeCharactersRaw(elements);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertVideoInstance(String instanceName, MATRIX matrix, DefineVideoStreamTag video, CLIPACTIONS clipActions, XFLXmlWriter writer) throws XMLStreamException {
        writer.writeStartElement("DOMVideoInstance", new String[]{"libraryItemName", "movie" + video.characterID + ".flv", "frameRight", Integer.toString((int)(20.0 * (double)video.width)), "frameBottom", Integer.toString((int)(20.0 * (double)video.height))});
        if (instanceName != null) {
            writer.writeAttribute("name", instanceName);
        }
        writer.writeStartElement("matrix");
        XFLConverter.convertMatrix(matrix, writer);
        writer.writeEndElement();
        writer.writeStartElement("transformationPoint");
        writer.writeEmptyElement("Point");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void convertFrames(List<Integer> onlyFrames, int startFrame, int endFrame, String prevStr, String afterStr, List<Integer> nonLibraryShapes, ReadOnlyTagList tags, ReadOnlyTagList timelineTags, HashMap<Integer, CharacterTag> characters, int depth, FLAVersion flaVersion, HashMap<String, byte[]> files, XFLXmlWriter writer) throws XMLStreamException {
        boolean lastIn = true;
        XFLXmlWriter writer2 = new XFLXmlWriter();
        prevStr = prevStr + "<frames>";
        int frame = -1;
        String lastElements = "";
        int duration = 1;
        CharacterTag character = null;
        MATRIX matrix = null;
        Amf3Value metadata = null;
        String instanceName = null;
        ColorTransform colorTransForm = null;
        boolean cacheAsBitmap = false;
        int blendMode = 0;
        List<FILTER> filters = new ArrayList<FILTER>();
        boolean isVisible = true;
        RGBA backGroundColor = null;
        CLIPACTIONS clipActions = null;
        int characterId = -1;
        int ratio = -1;
        boolean shapeTween = false;
        MorphShapeTag shapeTweener = null;
        int lastTweenRatio = -1;
        ArrayList<Tag> timTags = timelineTags.toArrayList();
        boolean needsFrameAdd = false;
        SWF swf = null;
        for (int i = timTags.size() - 1; i >= 0 && !(timTags.get(i) instanceof ShowFrameTag); --i) {
            if (!(timTags.get(i) instanceof PlaceObjectTypeTag)) continue;
            needsFrameAdd = true;
            swf = ((Tag)timTags.get(i)).getSwf();
            break;
        }
        if (needsFrameAdd) {
            timTags.add(new ShowFrameTag(swf));
        }
        for (Tag t : timTags) {
            RemoveTag rt;
            PlaceObjectTypeTag po;
            if (t instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)t).getDepth() == depth) {
                int newCharId = po.getCharacterId();
                if (newCharId == -1) {
                    newCharId = characterId;
                }
                if (characters.containsKey(characterId = newCharId)) {
                    character = characters.get(characterId);
                    if (po.flagMove()) {
                        int ratio2;
                        List<FILTER> filters2;
                        int blendMode2;
                        CLIPACTIONS clipActions2;
                        ColorTransform colorTransForm2;
                        String instanceName2;
                        MATRIX matrix2;
                        Amf3Value metadata2 = po.getAmfData();
                        if (metadata2 != null && metadata2.getValue() != null) {
                            metadata = metadata2;
                        }
                        if ((matrix2 = po.getMatrix()) != null) {
                            matrix = matrix2;
                        }
                        if ((instanceName2 = po.getInstanceName()) != null) {
                            instanceName = instanceName2;
                        }
                        if ((colorTransForm2 = po.getColorTransform()) != null) {
                            colorTransForm = colorTransForm2;
                        }
                        if ((clipActions2 = po.getClipActions()) != null) {
                            clipActions = clipActions2;
                        }
                        if (po.cacheAsBitmap()) {
                            cacheAsBitmap = true;
                        }
                        if ((blendMode2 = po.getBlendMode()) > 0) {
                            blendMode = blendMode2;
                        }
                        if ((filters2 = po.getFilters()) != null) {
                            filters = filters2;
                        }
                        if ((ratio2 = po.getRatio()) > -1) {
                            ratio = ratio2;
                        }
                    } else {
                        metadata = po.getAmfData();
                        matrix = po.getMatrix();
                        instanceName = po.getInstanceName();
                        colorTransForm = po.getColorTransform();
                        cacheAsBitmap = po.cacheAsBitmap();
                        blendMode = po.getBlendMode();
                        filters = po.getFilters();
                        ratio = po.getRatio();
                        clipActions = po.getClipActions();
                    }
                }
            }
            if (t instanceof RemoveTag && (rt = (RemoveTag)t).getDepth() == depth) {
                if (shapeTween && character != null) {
                    MorphShapeTag m;
                    shapeTweener = m = (MorphShapeTag)character;
                    shapeTween = false;
                    lastTweenRatio = ratio;
                }
                character = null;
                metadata = null;
                matrix = null;
                instanceName = null;
                colorTransForm = null;
                cacheAsBitmap = false;
                blendMode = 0;
                filters = new ArrayList();
                isVisible = true;
                backGroundColor = null;
                characterId = -1;
                clipActions = null;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            if (frame + 1 >= startFrame && (onlyFrames == null || onlyFrames.contains(frame + 1))) {
                String elements;
                XFLXmlWriter elementsWriter = new XFLXmlWriter();
                if (frame + 1 <= endFrame) {
                    lastIn = true;
                    if (shapeTweener != null) {
                        MorphShapeTag m = shapeTweener;
                        XFLXmlWriter addLastWriter = new XFLXmlWriter();
                        SHAPEWITHSTYLE endShape = m.getShapeAtRatio(lastTweenRatio);
                        XFLConverter.convertShape(characters, matrix, m.getShapeNum() == 1 ? 3 : 4, endShape.shapeRecords, m.getFillStyles().getFillStylesAt(lastTweenRatio), m.getLineStyles().getLineStylesAt(m.getShapeNum(), lastTweenRatio), true, false, addLastWriter);
                        XFLConverter.convertFrame(true, null, null, frame - --duration, duration, "", lastElements, files, writer2);
                        duration = 1;
                        lastElements = addLastWriter.toString();
                        shapeTweener = null;
                    }
                    if (character instanceof ShapeTag && nonLibraryShapes.contains(characterId)) {
                        ShapeTag shape = (ShapeTag)character;
                        XFLConverter.convertShape(characters, matrix, shape.getShapeNum(), shape.getShapes().shapeRecords, shape.getShapes().fillStyles, shape.getShapes().lineStyles, false, false, elementsWriter);
                        shapeTween = false;
                        shapeTweener = null;
                    } else if (character != null) {
                        if (character instanceof MorphShapeTag) {
                            MorphShapeTag m = (MorphShapeTag)character;
                            XFLConverter.convertShape(characters, matrix, m.getShapeNum() == 1 ? 3 : 4, m.getStartEdges().shapeRecords, m.getFillStyles().getStartFillStyles(), m.getLineStyles().getStartLineStyles(m.getShapeNum()), true, false, elementsWriter);
                            shapeTween = true;
                        } else {
                            shapeTween = false;
                            if (character instanceof TextTag) {
                                XFLConverter.convertText(instanceName, (TextTag)character, matrix, filters, clipActions, elementsWriter);
                            } else if (character instanceof DefineVideoStreamTag) {
                                XFLConverter.convertVideoInstance(instanceName, matrix, (DefineVideoStreamTag)character, clipActions, elementsWriter);
                            } else {
                                XFLConverter.convertSymbolInstance(instanceName, matrix, colorTransForm, cacheAsBitmap, blendMode, filters, isVisible, backGroundColor, clipActions, metadata, character, characters, tags, flaVersion, elementsWriter);
                            }
                        }
                    }
                }
                if (!(elements = elementsWriter.toString()).equals(lastElements) && ++frame > 0) {
                    XFLConverter.convertFrame(false, null, null, frame - duration, duration, "", lastElements, files, writer2);
                    duration = 1;
                } else {
                    duration = frame == 0 ? 1 : ++duration;
                }
                lastElements = elements;
                if (frame <= endFrame || !lastIn) continue;
                lastElements = "";
                lastIn = false;
                continue;
            }
            if (lastIn) {
                lastElements = "";
                lastIn = false;
            }
            if (++frame == 0) {
                duration = 1;
                continue;
            }
            ++duration;
        }
        if (!lastElements.isEmpty() || writer2.length() > 0) {
            XFLConverter.convertFrame(false, null, null, ++frame - duration < 0 ? 0 : frame - duration, duration, "", lastElements, files, writer2);
        }
        afterStr = "</frames>" + afterStr;
        if (writer2.length() > 0) {
            writer.writeCharactersRaw(prevStr);
            writer.writeCharactersRaw(writer2.toString());
            writer.writeCharactersRaw(afterStr);
        }
    }

    private static void convertFonts(ReadOnlyTagList tags, XFLXmlWriter writer) throws XMLStreamException {
        boolean hasFont = false;
        for (Tag t : tags) {
            FontTag font;
            if (!(t instanceof FontTag) || (font = (FontTag)t).getCharacterCount() <= 0) continue;
            hasFont = true;
            break;
        }
        if (!hasFont) {
            return;
        }
        writer.writeStartElement("fonts");
        for (Tag t : tags) {
            String fontName;
            FontTag font;
            int fontId;
            if (!(t instanceof FontTag)) continue;
            SWF swf = t.getSwf();
            DefineFontNameTag fontNameTag = (DefineFontNameTag)swf.getCharacterIdTag(fontId = (font = (FontTag)t).getFontId(), 88);
            String string = fontName = fontNameTag == null ? null : fontNameTag.fontName;
            if (fontName == null) {
                fontName = font.getFontNameIntag();
            }
            if (fontName == null) {
                fontName = FontTag.getDefaultFontName();
            }
            int fontStyle = font.getFontStyle();
            String installedFont = FontTag.isFontFamilyInstalled(fontName);
            if (installedFont != null) {
                fontName = new Font(installedFont, fontStyle, 10).getPSName();
            }
            String embedRanges = "";
            String fontChars = font.getCharacters();
            if ("".equals(fontChars)) continue;
            String embeddedCharacters = fontChars;
            embeddedCharacters = embeddedCharacters.replace("\u00a0", "");
            embeddedCharacters = embeddedCharacters.replace(".", "");
            for (char i = '\u0000'; i < ' '; i = (char)((char)(i + 1))) {
                if (i == '\t' || i == '\n' || i == '\r') continue;
                embeddedCharacters = embeddedCharacters.replace("" + i, "");
            }
            boolean hasAllRanges = false;
            for (int r = 0; r < CharacterRanges.rangeCount(); ++r) {
                int i;
                int[] codes = CharacterRanges.rangeCodes(r);
                boolean hasAllInRange = true;
                for (i = 0; i < codes.length; ++i) {
                    if (fontChars.contains("" + (char)codes[i])) continue;
                    hasAllInRange = false;
                    break;
                }
                if (hasAllInRange) {
                    for (i = 0; i < codes.length; ++i) {
                        embeddedCharacters = embeddedCharacters.replace("" + (char)codes[i], "");
                    }
                    if (!"".equals(embedRanges)) {
                        embedRanges = embedRanges + "|";
                    }
                    embedRanges = embedRanges + (r + 1);
                    continue;
                }
                hasAllRanges = false;
            }
            if (hasAllRanges) {
                embedRanges = "9999";
            }
            writer.writeStartElement("DOMFontItem", new String[]{"name", "Font " + fontId, "font", fontName, "size", "0", "id", Integer.toString(fontId), "embedRanges", embedRanges});
            if (!"".equals(embeddedCharacters)) {
                writer.writeAttribute("embeddedCharacters", embeddedCharacters);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static int getPackMainClassId(ScriptPack pack) {
        ABC abc = pack.abc;
        ScriptInfo script = abc.script_info.get(pack.scriptIndex);
        for (int traitIndex : pack.traitIndices) {
            Trait trait = script.traits.traits.get(traitIndex);
            if (!(trait instanceof TraitClass)) continue;
            TraitClass tc = (TraitClass)trait;
            Namespace traitNameNamespace = abc.constants.getNamespace(trait.getName((ABC)abc).namespace_index);
            if (traitNameNamespace.kind != 22) continue;
            return tc.class_info;
        }
        return -1;
    }

    private static Map<Integer, String> getFrameScriptsFromPack(AbcIndexing abcIndex, ScriptPack pack) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        int classIndex = XFLConverter.getPackMainClassId(pack);
        if (classIndex > -1) {
            ABC abc = pack.abc;
            InstanceInfo instanceInfo = abc.instance_info.get(classIndex);
            int constructorMethodIndex = instanceInfo.iinit_index;
            MethodBody constructorBody = abc.findBody(constructorMethodIndex);
            try {
                ArrayList<MethodBody> callStack = new ArrayList<MethodBody>();
                callStack.add(constructorBody);
                constructorBody.convert(callStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, constructorMethodIndex, pack.scriptIndex, classIndex, abc, null, new ScopeStack(), -1, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true, new HashSet<Integer>());
                HashMap<Integer, Multiname> frameToTraitMultiname = new HashMap<Integer, Multiname>();
                if (constructorBody.convertedItems != null) {
                    for (GraphTargetItem ti : constructorBody.convertedItems) {
                        if (!(ti instanceof CallPropertyAVM2Item)) continue;
                        CallPropertyAVM2Item callProp = (CallPropertyAVM2Item)ti;
                        if (!(callProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                        FullMultinameAVM2Item propName = (FullMultinameAVM2Item)callProp.propertyName;
                        if (!"addFrameScript".equals(propName.resolvedMultinameName)) continue;
                        for (int i = 0; i < callProp.arguments.size(); i += 2) {
                            if (!(callProp.arguments.get(i) instanceof IntegerValueAVM2Item)) continue;
                            IntegerValueAVM2Item frameItem = (IntegerValueAVM2Item)callProp.arguments.get(i);
                            int frame = frameItem.intValue();
                            if (callProp.arguments.get(i + 1) instanceof GetLexAVM2Item) {
                                GetLexAVM2Item lex = (GetLexAVM2Item)callProp.arguments.get(i + 1);
                                frameToTraitMultiname.put(frame, lex.propertyName);
                                continue;
                            }
                            if (!(callProp.arguments.get(i + 1) instanceof GetPropertyAVM2Item)) continue;
                            GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)callProp.arguments.get(i + 1);
                            if (!(getProp.object instanceof ThisAVM2Item) || !(getProp.propertyName instanceof FullMultinameAVM2Item)) continue;
                            FullMultinameAVM2Item framePropName = (FullMultinameAVM2Item)getProp.propertyName;
                            int multinameIndex = framePropName.multinameIndex;
                            frameToTraitMultiname.put(frame, abc.constants.getMultiname(multinameIndex));
                        }
                    }
                }
                HashMap<Multiname, TraitMethodGetterSetter> multinameToMethodTrait = new HashMap<Multiname, TraitMethodGetterSetter>();
                for (Trait trait : instanceInfo.instance_traits.traits) {
                    if (!(trait instanceof TraitMethodGetterSetter)) continue;
                    Multiname m = abc.constants.getMultiname(trait.name_index);
                    multinameToMethodTrait.put(abc.constants.getMultiname(trait.name_index), (TraitMethodGetterSetter)trait);
                }
                Iterator<Trait> iterator = frameToTraitMultiname.keySet().iterator();
                while (iterator.hasNext()) {
                    int frame = (Integer)((Object)iterator.next());
                    Multiname multiName = (Multiname)frameToTraitMultiname.get(frame);
                    if (!multinameToMethodTrait.containsKey(multiName)) continue;
                    TraitMethodGetterSetter methodTrait = (TraitMethodGetterSetter)multinameToMethodTrait.get(multiName);
                    int methodIndex = methodTrait.method_info;
                    MethodBody frameBody = abc.findBody(methodIndex);
                    StringBuilder scriptBuilder = new StringBuilder();
                    callStack = new ArrayList();
                    callStack.add(frameBody);
                    frameBody.convert(callStack, abcIndex, new ConvertData(), "??", ScriptExportMode.AS, false, methodIndex, pack.scriptIndex, classIndex, abc, methodTrait, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true, new HashSet<Integer>());
                    StringBuilderTextWriter writer = new StringBuilderTextWriter(Configuration.getCodeFormatting(), scriptBuilder);
                    frameBody.toString(callStack, abcIndex, "??", ScriptExportMode.AS, abc, methodTrait, writer, new ArrayList<DottedChain>(), new HashSet<Integer>());
                    String script = scriptBuilder.toString();
                    ret.put(frame, script);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ret;
    }

    private boolean convertActionScriptLayer(String initClipScript, AbcIndexing abcIndex, int spriteId, ReadOnlyTagList tags, ReadOnlyTagList timeLineTags, String backgroundColor, XFLXmlWriter writer, ScriptPack scriptPack) throws XMLStreamException {
        boolean hasScript = false;
        String script = initClipScript;
        int duration = 0;
        int frame = 0;
        if (!script.isEmpty()) {
            script = "#initclip\r\n" + script + "#endinitclip\r\n";
        }
        Map<Object, Object> frameToScriptMap = new HashMap();
        if (scriptPack != null) {
            frameToScriptMap = XFLConverter.getFrameScriptsFromPack(abcIndex, scriptPack);
        }
        for (Tag t : timeLineTags) {
            if (t instanceof DoActionTag) {
                DoActionTag da = (DoActionTag)t;
                script = script + XFLConverter.convertActionScript12(da);
            }
            if (frameToScriptMap.containsKey(frame)) {
                script = script + (String)frameToScriptMap.get(frame);
                frameToScriptMap.remove(frame);
            }
            if (!(t instanceof ShowFrameTag)) continue;
            if (script.isEmpty()) {
                ++duration;
            } else {
                if (!hasScript) {
                    writer.writeStartElement("DOMLayer", new String[]{"name", "Script Layer", "color", this.randomOutlineColor()});
                    writer.writeStartElement("frames");
                    hasScript = true;
                }
                if (duration > 0) {
                    writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - duration)});
                    if (duration > 1) {
                        writer.writeAttribute("duration", duration);
                    }
                    writer.writeAttribute("keyMode", 9728);
                    writer.writeElementValue("elements", "");
                    writer.writeEndElement();
                }
                writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame)});
                writer.writeAttribute("keyMode", 9728);
                writer.writeStartElement("Actionscript");
                writer.writeStartElement("script");
                writer.writeCData(script);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeElementValue("elements", "");
                writer.writeEndElement();
                script = "";
                duration = 0;
            }
            ++frame;
        }
        if (hasScript) {
            writer.writeEndElement();
            writer.writeEndElement();
        }
        return hasScript;
    }

    private boolean convertLabelsLayer(ReadOnlyTagList tags, ReadOnlyTagList timeLineTags, String backgroundColor, XFLXmlWriter writer) throws XMLStreamException {
        boolean hasLabel = false;
        HashMap frameToLabels = new HashMap();
        int frame = 0;
        int layerCount = 0;
        for (Tag t : timeLineTags) {
            if (t instanceof FrameLabelTag) {
                FrameLabelTag frameLabel = (FrameLabelTag)t;
                if (!frameToLabels.containsKey(frame)) {
                    frameToLabels.put(frame, new ArrayList());
                }
                ((List)frameToLabels.get(frame)).add(frameLabel);
                if (((List)frameToLabels.get(frame)).size() <= layerCount) continue;
                layerCount = ((List)frameToLabels.get(frame)).size();
                continue;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        int frameCount = frame;
        for (int lay = 0; lay < layerCount; ++lay) {
            writer.writeStartElement("DOMLayer", new String[]{"name", "Labels Layer" + (layerCount > 1 ? " " + (lay + 1) : ""), "color", this.randomOutlineColor()});
            writer.writeStartElement("frames");
            int duration = 0;
            for (int i = 0; i < frameCount; ++i) {
                List frameLabels = (List)frameToLabels.get(i);
                FrameLabelTag frameLabel = null;
                if (frameLabels != null && frameLabels.size() > lay) {
                    frameLabel = (FrameLabelTag)frameLabels.get(lay);
                }
                if (frameLabel == null) {
                    ++duration;
                    continue;
                }
                if (duration > 0) {
                    writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame - duration)});
                    if (duration > 1) {
                        writer.writeAttribute("duration", duration);
                    }
                    writer.writeAttribute("keyMode", 9728);
                    writer.writeElementValue("elements", "");
                    writer.writeEndElement();
                }
                writer.writeStartElement("DOMFrame", new String[]{"index", Integer.toString(frame)});
                writer.writeAttribute("keyMode", 9728);
                writer.writeAttribute("name", frameLabel.name);
                if (frameLabel.namedAnchor) {
                    writer.writeAttribute("labelType", "anchor");
                    writer.writeAttribute("bookmark", true);
                } else {
                    writer.writeAttribute("labelType", "name");
                }
                writer.writeElementValue("elements", "");
                writer.writeEndElement();
                duration = 0;
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        return hasLabel;
    }

    private void convertSoundLayer(ReadOnlyTagList timeLineTags, HashMap<String, byte[]> files, XFLXmlWriter writer) throws XMLStreamException {
        int i;
        int soundLayerIndex = 0;
        XFLXmlWriter writer2 = new XFLXmlWriter();
        ArrayList<StartSoundTag> startSounds = new ArrayList<StartSoundTag>();
        ArrayList<Integer> startSoundFrameNumbers = new ArrayList<Integer>();
        ArrayList<SoundStreamHeadTypeTag> soundStreamHeads = new ArrayList<SoundStreamHeadTypeTag>();
        ArrayList<Integer> soundStreamHeadFrameNumbers = new ArrayList<Integer>();
        int frame = 0;
        for (Tag t : timeLineTags) {
            if (t instanceof StartSoundTag) {
                StartSoundTag startSound = (StartSoundTag)t;
                SWF swf = startSound.getSwf();
                DefineSoundTag s = swf.getSound(startSound.soundId);
                if (s == null) {
                    logger.log(Level.WARNING, "Sount tag (ID={0}) was not found", startSound.soundId);
                    continue;
                }
                if (!files.containsKey("sound" + s.soundId + "." + s.getExportFormat().toString().toLowerCase())) {
                    startSound = null;
                }
                if (startSound == null) continue;
                startSounds.add(startSound);
                startSoundFrameNumbers.add(frame);
                continue;
            }
            if (t instanceof SoundStreamHeadTypeTag) {
                SoundStreamHeadTypeTag soundStreamHead = (SoundStreamHeadTypeTag)t;
                if (!files.containsKey("sound" + soundStreamHead.getCharacterId() + "." + soundStreamHead.getExportFormat().toString().toLowerCase())) {
                    soundStreamHead = null;
                }
                if (soundStreamHead == null) continue;
                soundStreamHeads.add(soundStreamHead);
                soundStreamHeadFrameNumbers.add(frame);
                continue;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        for (i = 0; i < soundStreamHeads.size(); ++i) {
            writer.writeStartElement("DOMLayer", new String[]{"name", "Sound Layer " + soundLayerIndex++, "color", this.randomOutlineColor()});
            writer.writeStartElement("frames");
            int startFrame = (Integer)soundStreamHeadFrameNumbers.get(i);
            int duration = frame - startFrame;
            if (startFrame != 0) {
                XFLConverter.convertFrame(false, null, null, 0, startFrame, "", "", files, writer);
            }
            XFLConverter.convertFrame(false, (SoundStreamHeadTypeTag)soundStreamHeads.get(i), null, startFrame, duration, "", "", files, writer);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (i = 0; i < startSounds.size(); ++i) {
            writer.writeStartElement("DOMLayer", new String[]{"name", "Sound Layer " + soundLayerIndex++, "color", this.randomOutlineColor()});
            writer.writeStartElement("frames");
            int startFrame = (Integer)startSoundFrameNumbers.get(i);
            int duration = frame - startFrame;
            if (startFrame != 0) {
                XFLConverter.convertFrame(false, null, null, 0, startFrame, "", "", files, writer);
            }
            XFLConverter.convertFrame(false, null, (StartSoundTag)startSounds.get(i), startFrame, duration, "", "", files, writer);
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private String randomOutlineColor() {
        RGB outlineColor = new RGB();
        do {
            outlineColor.red = this.random.nextInt(256);
            outlineColor.green = this.random.nextInt(256);
            outlineColor.blue = this.random.nextInt(256);
        } while ((outlineColor.red + outlineColor.green + outlineColor.blue) / 3 < 128);
        return outlineColor.toHexRGB();
    }

    private String getMembersToClassName(GraphTargetItem item) {
        DirectValueActionItem dv;
        ArrayList<String> ret = new ArrayList<String>();
        while (item instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)item;
            if (!(mem.memberName instanceof DirectValueActionItem)) {
                return null;
            }
            dv = (DirectValueActionItem)mem.memberName;
            if (!dv.isString()) {
                return null;
            }
            ret.add(0, dv.getAsString());
            item = mem.object;
        }
        if (!(item instanceof GetVariableActionItem)) {
            return null;
        }
        GetVariableActionItem gv = (GetVariableActionItem)item;
        if (!(gv.name instanceof DirectValueActionItem)) {
            return null;
        }
        dv = (DirectValueActionItem)gv.name;
        if (!dv.isString()) {
            return null;
        }
        String varName = dv.getAsString();
        ret.add(0, varName);
        return String.join((CharSequence)".", ret);
    }

    private void convertTimeline(AbcIndexing abcIndex, int spriteId, final String linkageIdentifier, List<Integer> nonLibraryShapes, String backgroundColor, ReadOnlyTagList tags, ReadOnlyTagList timelineTags, HashMap<Integer, CharacterTag> characters, String name, FLAVersion flaVersion, HashMap<String, byte[]> files, XFLXmlWriter writer, ScriptPack scriptPack) throws XMLStreamException {
        int d;
        final ArrayList classNames = new ArrayList();
        ActionTreeOperation getRegisterClassOp = new ActionTreeOperation(){

            @Override
            public void run(List<GraphTargetItem> tree) {
                ArrayList<Integer> listToRemove = new ArrayList<Integer>();
                ArrayList<String> newClassNames = new ArrayList<String>();
                for (int i = 0; i < tree.size(); ++i) {
                    String className;
                    GraphTargetItem item = tree.get(i);
                    if (!(item instanceof CallMethodActionItem)) continue;
                    CallMethodActionItem callMethod = (CallMethodActionItem)item;
                    if (!(callMethod.scriptObject instanceof GetVariableActionItem)) continue;
                    GetVariableActionItem methodObject = (GetVariableActionItem)callMethod.scriptObject;
                    if (!(methodObject.name instanceof DirectValueActionItem) || methodObject.name == null || !methodObject.name.toString().equals("Object") || !(callMethod.methodName instanceof DirectValueActionItem) || !callMethod.methodName.toString().equals("registerClass") || callMethod.arguments.size() != 2 || !(callMethod.arguments.get(0) instanceof DirectValueActionItem) || linkageIdentifier != null && !linkageIdentifier.equals(callMethod.arguments.get(0).toString()) || (className = XFLConverter.this.getMembersToClassName(callMethod.arguments.get(1))) == null) continue;
                    newClassNames.add(className);
                    listToRemove.add(i);
                }
                if (listToRemove.size() != 1) {
                    return;
                }
                classNames.add(newClassNames.get(0));
                tree.remove((Integer)listToRemove.get(0));
            }
        };
        ArrayList<ActionTreeOperation> treeOps = new ArrayList<ActionTreeOperation>();
        treeOps.add(getRegisterClassOp);
        String initClipScript = "";
        for (Tag t : tags) {
            if (!(t instanceof DoInitActionTag)) continue;
            DoInitActionTag dia = (DoInitActionTag)t;
            if (dia.spriteId != spriteId) continue;
            initClipScript = initClipScript + XFLConverter.convertActionScript12(dia, treeOps);
        }
        if (classNames.size() == 1) {
            writer.writeAttribute("linkageClassName", (String)classNames.get(0));
        }
        if (spriteId == -1) {
            writer.writeStartElement("timelines");
        } else {
            writer.writeStartElement("timeline");
        }
        writer.writeStartElement("DOMTimeline", new String[]{"name", name});
        writer.writeStartElement("layers");
        boolean hasLabel = this.convertLabelsLayer(tags, timelineTags, backgroundColor, writer);
        boolean hasScript = this.convertActionScriptLayer(initClipScript, abcIndex, spriteId, tags, timelineTags, backgroundColor, writer, scriptPack);
        int index = 0;
        if (hasLabel) {
            ++index;
        }
        if (hasScript) {
            ++index;
        }
        int maxDepth = XFLConverter.getMaxDepth(timelineTags);
        ArrayList<Integer> clipFrameSplitters = new ArrayList<Integer>();
        ArrayList<PlaceObjectTypeTag> clipPlaces = new ArrayList<PlaceObjectTypeTag>();
        int f = 0;
        HashMap<Integer, PlaceObjectTypeTag> depthToClipPlace = new HashMap<Integer, PlaceObjectTypeTag>();
        HashMap<Object, Integer> clipFinishFrames = new HashMap<Object, Integer>();
        for (Object t : timelineTags) {
            RemoveTag re;
            if (t instanceof ShowFrameTag) {
                ++f;
            }
            if (t instanceof PlaceObjectTypeTag) {
                PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
                if (po.getClipDepth() > -1) {
                    clipFrameSplitters.add(f);
                    clipPlaces.add(po);
                    depthToClipPlace.put(po.getDepth(), po);
                } else if (!po.flagMove() && depthToClipPlace.containsKey(po.getDepth())) {
                    clipFinishFrames.put(depthToClipPlace.get(po.getDepth()), f - 1);
                    depthToClipPlace.remove(po.getDepth());
                }
            }
            if (!(t instanceof RemoveTag) || !depthToClipPlace.containsKey((re = (RemoveTag)t).getDepth())) continue;
            clipFinishFrames.put(depthToClipPlace.get(re.getDepth()), f - 1);
            depthToClipPlace.remove(re.getDepth());
        }
        int frameCount = f;
        if (!depthToClipPlace.isEmpty()) {
            for (PlaceObjectTypeTag po : depthToClipPlace.values()) {
                clipFinishFrames.put(po, frameCount - 1);
            }
        }
        if (clipFrameSplitters.isEmpty() || (Integer)clipFrameSplitters.get(0) != 0) {
            clipFrameSplitters.add(0, 0);
            clipPlaces.add(0, null);
        }
        clipFrameSplitters.add(frameCount);
        clipPlaces.add(null);
        HashMap depthToFramesList = new HashMap();
        for (d = maxDepth; d >= 0; --d) {
            depthToFramesList.put(d, new ArrayList());
            for (int i = 0; i < frameCount; ++i) {
                ((List)depthToFramesList.get(d)).add(i);
            }
        }
        for (d = maxDepth; d >= 0; --d) {
            for (int p = 0; p < clipPlaces.size() - 1; ++p) {
                PlaceObjectTypeTag po = (PlaceObjectTypeTag)clipPlaces.get(p);
                if (po == null || po.getClipDepth() != d) continue;
                int clipFrame = (Integer)clipFrameSplitters.get(p);
                int nextFrame = (Integer)clipFinishFrames.get(po);
                writer.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (index + 1) + "", "color", this.randomOutlineColor(), "layerType", "mask", "locked", "true"});
                XFLConverter.convertFrames(null, clipFrame, nextFrame, "", "", nonLibraryShapes, tags, timelineTags, characters, po.getDepth(), flaVersion, files, writer);
                writer.writeEndElement();
                int parentIndex = index++;
                for (int nd = po.getClipDepth() - 1; nd > po.getDepth(); --nd) {
                    boolean nonEmpty = this.writeLayer(index, (List)depthToFramesList.get(nd), nd, clipFrame, nextFrame, parentIndex, writer, nonLibraryShapes, tags, timelineTags, characters, flaVersion, files);
                    for (int i = clipFrame; i <= nextFrame; ++i) {
                        ((List)depthToFramesList.get(nd)).remove((Object)i);
                    }
                    if (!nonEmpty) continue;
                    ++index;
                }
                for (int i = clipFrame; i <= nextFrame; ++i) {
                    ((List)depthToFramesList.get(po.getDepth())).remove((Object)i);
                }
            }
            boolean nonEmpty = this.writeLayer(index, (List)depthToFramesList.get(d), d, 0, Integer.MAX_VALUE, -1, writer, nonLibraryShapes, tags, timelineTags, characters, flaVersion, files);
            if (!nonEmpty) continue;
            ++index;
        }
        if (index == 0) {
            this.writeEmptyLayer(writer, frameCount);
            ++index;
        }
        this.convertSoundLayer(timelineTags, files, writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeEmptyLayer(XFLXmlWriter writer, int frameCount) throws XMLStreamException {
        writer.writeStartElement("DOMLayer", new String[]{"name", "Layer 1", "color", this.randomOutlineColor()});
        writer.writeAttribute("current", true);
        writer.writeAttribute("isSelected", true);
        writer.writeStartElement("frames");
        writer.writeStartElement("DOMFrame");
        writer.writeAttribute("index", 0);
        writer.writeAttribute("duration", frameCount);
        writer.writeAttribute("keyMode", 9728);
        writer.writeStartElement("elements");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private boolean writeLayer(int index, List<Integer> onlyFrames, int d, int startFrame, int endFrame, int parentLayer, XFLXmlWriter writer, List<Integer> nonLibraryShapes, ReadOnlyTagList tags, ReadOnlyTagList timelineTags, HashMap<Integer, CharacterTag> characters, FLAVersion flaVersion, HashMap<String, byte[]> files) throws XMLStreamException {
        XFLXmlWriter layerPrev = new XFLXmlWriter();
        layerPrev.writeStartElement("DOMLayer", new String[]{"name", "Layer " + (index + 1) + "", "color", this.randomOutlineColor()});
        if (d == 1) {
            layerPrev.writeAttribute("current", true);
            layerPrev.writeAttribute("isSelected", true);
        }
        if (parentLayer != -1 && parentLayer != d) {
            layerPrev.writeAttribute("parentLayerIndex", parentLayer);
            layerPrev.writeAttribute("locked", true);
        }
        layerPrev.writeCharacters("");
        String layerAfter = "</DOMLayer>";
        int prevLength = writer.length();
        XFLConverter.convertFrames(onlyFrames, startFrame, endFrame, layerPrev.toString(), layerAfter, nonLibraryShapes, tags, timelineTags, characters, d, flaVersion, files, writer);
        return writer.length() != prevLength;
    }

    private static void writeFile(AbortRetryIgnoreHandler handler, byte[] data, String file) throws IOException, InterruptedException {
        new RetryTask(() -> {
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(data);
            }
        }, handler).run();
    }

    private static Map<Integer, ScriptPack> getCharacterScriptPacks(SWF swf, Map<Integer, String> characterClasses) {
        HashMap<Integer, ScriptPack> ret = new HashMap<Integer, ScriptPack>();
        HashMap<String, Integer> classToId = new HashMap<String, Integer>();
        for (int id : characterClasses.keySet()) {
            classToId.put(characterClasses.get(id), id);
        }
        ArrayList<String> allClasses = new ArrayList<String>(characterClasses.values());
        List<Object> packs = new ArrayList();
        try {
            packs = swf.getScriptPacksByClassNames(allClasses);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ScriptPack pack : packs) {
            String packClass = pack.getClassPath().toRawString();
            if (!classToId.containsKey(packClass)) continue;
            ret.put((Integer)classToId.get(packClass), pack);
        }
        return ret;
    }

    private static Map<Integer, String> getCharacterClasses(ReadOnlyTagList tags) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (Tag t : tags) {
            if (!(t instanceof SymbolClassTag)) continue;
            SymbolClassTag sc = (SymbolClassTag)t;
            for (int i = 0; i < sc.tags.size(); ++i) {
                if (ret.containsKey(sc.tags.get(i)) || ret.containsValue(sc.names.get(i))) continue;
                ret.put(sc.tags.get(i), sc.names.get(i));
            }
        }
        return ret;
    }

    private static Map<Integer, String> getCharacterVariables(ReadOnlyTagList tags) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (Tag t : tags) {
            if (!(t instanceof ExportAssetsTag)) continue;
            ExportAssetsTag ea = (ExportAssetsTag)t;
            for (int i = 0; i < ea.tags.size(); ++i) {
                if (ret.containsKey(ea.tags.get(i))) continue;
                ret.put(ea.tags.get(i), ea.names.get(i));
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static void convertText(String instanceName, TextTag tag, MATRIX m, List<FILTER> filters, CLIPACTIONS clipActions, XFLXmlWriter writer) throws XMLStreamException {
        MATRIX matrix = new MATRIX(m);
        CSMTextSettingsTag csmts = null;
        XFLXmlWriter filterStr = new XFLXmlWriter();
        if (filters != null) {
            filterStr.writeStartElement("filters");
            for (FILTER fILTER : filters) {
                XFLConverter.convertFilter(fILTER, filterStr);
            }
            filterStr.writeEndElement();
        }
        SWF swf = tag.getSwf();
        for (Tag t : swf.getTags()) {
            if (!(t instanceof CSMTextSettingsTag)) continue;
            CSMTextSettingsTag c = (CSMTextSettingsTag)t;
            if (c.textID != tag.getCharacterId()) continue;
            csmts = c;
            break;
        }
        String string = "standard";
        String antiAliasSharpness = null;
        String antiAliasThickness = null;
        if (csmts != null) {
            if (csmts.thickness == 0.0f & csmts.sharpness == 0.0f) {
                Object var10_13 = null;
            } else {
                String string2 = "customThicknessSharpness";
            }
            antiAliasSharpness = XFLConverter.doubleToString(csmts.sharpness);
            antiAliasThickness = XFLConverter.doubleToString(csmts.thickness);
        }
        String left = null;
        RECT bounds = tag.getBounds();
        if (tag instanceof DefineTextTag || tag instanceof DefineText2Tag) {
            MATRIX textMatrix = tag.getTextMatrix();
            left = XFLConverter.doubleToString((double)textMatrix.translateX / 20.0);
        }
        if (tag instanceof DefineTextTag || tag instanceof DefineText2Tag) {
            void var10_18;
            List<TEXTRECORD> textRecords = new ArrayList();
            if (tag instanceof DefineTextTag) {
                textRecords = ((DefineTextTag)tag).textRecords;
            } else if (tag instanceof DefineText2Tag) {
                textRecords = ((DefineText2Tag)tag).textRecords;
            }
            for (TEXTRECORD rec : textRecords) {
                FontTag ft;
                if (!rec.styleFlagsHasFont || (ft = swf.getFont(rec.fontId)) == null || !ft.isSmall()) continue;
                String string3 = "bitmap";
                break;
            }
            writer.writeStartElement("DOMStaticText");
            if (left != null) {
                writer.writeAttribute("left", left);
            }
            if (var10_18 != null) {
                writer.writeAttribute("fontRenderingMode", (String)var10_18);
            }
            if (instanceName != null) {
                writer.writeAttribute("instanceName", instanceName);
            }
            if (antiAliasSharpness != null) {
                writer.writeAttribute("antiAliasSharpness", antiAliasSharpness);
                writer.writeAttribute("antiAliasThickness", antiAliasThickness);
            }
            Map<String, Object> attrs = TextTag.getTextRecordsAttributes(textRecords, swf);
            writer.writeAttribute("width", tag.getBounds().getWidth() / 2);
            writer.writeAttribute("height", tag.getBounds().getHeight());
            writer.writeAttribute("autoExpand", true);
            writer.writeAttribute("isSelectable", false);
            writer.writeStartElement("matrix");
            XFLConverter.convertMatrix(matrix, writer);
            writer.writeEndElement();
            writer.writeStartElement("textRuns");
            FontTag font = null;
            String psFontName = null;
            int textHeight = -1;
            RGB textColor = null;
            RGBA textColorA = null;
            boolean firstRun = true;
            List leftMargins = (List)attrs.get("allLeftMargins");
            List letterSpacings = (List)attrs.get("allLetterSpacings");
            for (int r = 0; r < textRecords.size(); ++r) {
                TEXTRECORD rec = textRecords.get(r);
                if (rec.styleFlagsHasColor) {
                    if (tag instanceof DefineTextTag) {
                        textColor = rec.textColor;
                    } else {
                        textColorA = rec.textColorA;
                    }
                }
                if (rec.styleFlagsHasFont) {
                    String installedFont;
                    int fontId = rec.fontId;
                    String fontName = null;
                    textHeight = rec.textHeight;
                    font = swf.getFont(fontId);
                    for (Tag t : swf.getTags()) {
                        if (!(t instanceof DefineFontNameTag) || ((DefineFontNameTag)t).fontId != fontId) continue;
                        fontName = ((DefineFontNameTag)t).fontName;
                    }
                    if (fontName == null && font != null) {
                        fontName = font.getFontNameIntag();
                    }
                    if (fontName == null) {
                        fontName = FontTag.getDefaultFontName();
                    }
                    int fontStyle = 0;
                    if (font != null) {
                        fontStyle = font.getFontStyle();
                    }
                    psFontName = (installedFont = FontTag.isFontFamilyInstalled(fontName)) != null ? new Font(installedFont, fontStyle, 10).getPSName() : fontName;
                }
                boolean newline = false;
                if (!firstRun && rec.styleFlagsHasYOffset) {
                    newline = true;
                }
                firstRun = false;
                if (font == null) continue;
                writer.writeStartElement("DOMTextRun");
                writer.writeStartElement("characters");
                writer.writeCharacters((newline ? "\r" : "") + rec.getText(font));
                writer.writeEndElement();
                writer.writeStartElement("textAttrs");
                writer.writeStartElement("DOMTextAttrs", new String[]{"aliasText", "false", "rotation", "true", "size", Double.toString(XFLConverter.twipToPixel(textHeight)), "bitmapSize", Integer.toString(textHeight), "letterSpacing", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)letterSpacings.get(r)).intValue())), "indent", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)attrs.get("indent")).intValue())), "leftMargin", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)leftMargins.get(r)).intValue())), "lineSpacing", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)attrs.get("lineSpacing")).intValue())), "rightMargin", XFLConverter.doubleToString(XFLConverter.twipToPixel(((Integer)attrs.get("rightMargin")).intValue()))});
                if (textColor != null) {
                    writer.writeAttribute("fillColor", textColor.toHexRGB());
                } else if (textColorA != null) {
                    writer.writeAttribute("fillColor", textColorA.toHexRGB());
                    writer.writeAttribute("alpha", textColorA.getAlphaFloat());
                }
                writer.writeAttribute("face", psFontName);
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeCharactersRaw(filterStr.toString());
            writer.writeEndElement();
        } else if (tag instanceof DefineEditTextTag) {
            void var10_22;
            DefineEditTextTag det = (DefineEditTextTag)tag;
            FontTag ft = swf.getFont(det.fontId);
            if (ft != null && ft.isSmall()) {
                String string4 = "bitmap";
            }
            if (!det.useOutlines) {
                String string5 = "device";
            }
            String tagName = det.wasStatic ? "DOMStaticText" : (det.readOnly ? "DOMDynamicText" : "DOMInputText");
            writer.writeStartElement(tagName);
            if (var10_22 != null) {
                writer.writeAttribute("fontRenderingMode", (String)var10_22);
            }
            if (instanceName != null) {
                writer.writeAttribute("name", instanceName);
            }
            if (antiAliasSharpness != null) {
                writer.writeAttribute("antiAliasSharpness", antiAliasSharpness);
                writer.writeAttribute("antiAliasThickness", antiAliasThickness);
            }
            double width = XFLConverter.twipToPixel(bounds.getWidth());
            double height = XFLConverter.twipToPixel(bounds.getHeight());
            double padding = 2.0;
            width -= 2.0 * padding;
            height -= 2.0 * padding;
            if (det.hasLayout) {
                width -= XFLConverter.twipToPixel(det.rightMargin);
                width -= XFLConverter.twipToPixel(det.leftMargin);
            }
            writer.writeAttribute("width", width);
            writer.writeAttribute("height", height);
            if (det.border) {
                writer.writeAttribute("border", true);
            }
            if (det.html) {
                writer.writeAttribute("renderAsHTML", true);
            }
            if (det.noSelect) {
                writer.writeAttribute("isSelectable", false);
            }
            if (det.multiline && det.wordWrap) {
                writer.writeAttribute("lineType", "multiline");
            } else if (det.multiline && !det.wordWrap) {
                writer.writeAttribute("lineType", "multiline no wrap");
            } else if (det.password) {
                writer.writeAttribute("lineType", "password");
            }
            if (det.hasMaxLength) {
                writer.writeAttribute("maxCharacters", det.maxLength);
            }
            if (!det.variableName.isEmpty()) {
                writer.writeAttribute("variableName", det.variableName);
            }
            writer.writeStartElement("matrix");
            XFLConverter.convertMatrix(matrix, writer);
            writer.writeEndElement();
            writer.writeStartElement("textRuns");
            String txt = "";
            if (det.hasText) {
                txt = det.initialText;
            }
            if (det.html) {
                writer.writeCharactersRaw(XFLConverter.convertHTMLText(swf.getTags(), det, txt));
            } else {
                writer.writeStartElement("DOMTextRun");
                writer.writeStartElement("characters");
                writer.writeCharacters(txt);
                writer.writeEndElement();
                int leftMargin = -1;
                int rightMargin = -1;
                int indent = -1;
                int lineSpacing = -1;
                String alignment = null;
                String fontFace = null;
                int size = -1;
                RGBA textColor = null;
                if (det.hasTextColor) {
                    textColor = det.textColor;
                }
                if (det.hasFont) {
                    String fontName = null;
                    for (Tag u : swf.getTags()) {
                        if (u instanceof DefineFontNameTag && ((DefineFontNameTag)u).fontId == det.fontId) {
                            fontName = ((DefineFontNameTag)u).fontName;
                        }
                        if (fontName == null || ft == null) continue;
                        break;
                    }
                    if (ft != null) {
                        if (fontName == null) {
                            fontName = ft.getFontNameIntag();
                        }
                        if (fontName == null) {
                            fontName = FontTag.getDefaultFontName();
                        }
                        boolean italic = ft.isItalic();
                        boolean bold = ft.isBold();
                        size = det.fontHeight;
                        fontFace = fontName;
                        String installedFont = FontTag.isFontFamilyInstalled(fontName);
                        if (installedFont != null) {
                            fontFace = new Font(installedFont, (italic ? 2 : 0) | (bold ? 1 : 0) | (!italic && !bold ? 0 : 0), size < 0 ? 10 : size).getPSName();
                        }
                    }
                }
                if (det.hasLayout) {
                    leftMargin = det.leftMargin;
                    rightMargin = det.rightMargin;
                    indent = det.indent;
                    lineSpacing = det.leading;
                    String[] alignNames = new String[]{"left", "right", "center", "justify"};
                    alignment = det.align < alignNames.length ? alignNames[det.align] : "unknown";
                }
                writer.writeStartElement("textAttrs");
                writer.writeStartElement("DOMTextAttrs");
                if (alignment != null) {
                    writer.writeAttribute("alignment", alignment);
                }
                writer.writeAttribute("rotation", true);
                if (indent > -1) {
                    writer.writeAttribute("indent", XFLConverter.twipToPixel(indent));
                }
                if (leftMargin > -1) {
                    writer.writeAttribute("leftMargin", XFLConverter.twipToPixel(leftMargin));
                }
                if (lineSpacing > -1) {
                    writer.writeAttribute("lineSpacing", XFLConverter.twipToPixel(lineSpacing));
                }
                if (rightMargin > -1) {
                    writer.writeAttribute("rightMargin", XFLConverter.twipToPixel(rightMargin));
                }
                if (size > -1) {
                    writer.writeAttribute("size", XFLConverter.twipToPixel(size));
                    writer.writeAttribute("bitmapSize", size);
                }
                if (fontFace != null) {
                    writer.writeAttribute("face", fontFace);
                }
                if (textColor != null) {
                    writer.writeAttribute("fillColor", textColor.toHexRGB());
                    writer.writeAttribute("alpha", textColor.getAlphaFloat());
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeCharactersRaw(filterStr.toString());
            writer.writeEndElement();
        }
    }

    private boolean hasAmfMetadata(Tag tag) {
        PlaceObjectTypeTag po;
        if (tag instanceof PlaceObjectTypeTag && (po = (PlaceObjectTypeTag)tag).getAmfData() != null && po.getAmfData().getValue() != null) {
            return true;
        }
        if (tag instanceof Timelined) {
            Timelined tl = (Timelined)((Object)tag);
            for (Tag t : tl.getTags()) {
                if (!this.hasAmfMetadata(t)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAmfMetadata(SWF swf) {
        for (Tag t : swf.getTags()) {
            if (!this.hasAmfMetadata(t)) continue;
            return true;
        }
        return false;
    }

    public void convertSWF(AbortRetryIgnoreHandler handler, SWF swf, String swfFileName, String outfile, XFLExportSettings settings, String generator, String generatorVerName, String generatorVersion, boolean parallel, FLAVersion flaVersion) throws IOException, InterruptedException {
        FileAttributesTag fa = swf.getFileAttributes();
        boolean useAS3 = false;
        boolean useNetwork = false;
        if (fa != null) {
            useAS3 = fa.actionScript3;
            useNetwork = fa.useNetwork;
        }
        if (!useAS3 && flaVersion.minASVersion() > 2) {
            throw new IllegalArgumentException("FLA version " + (Object)((Object)flaVersion) + " does not support AS1/2");
        }
        File flaFile = new File(outfile);
        String baseName = swfFileName;
        File f = new File(baseName);
        if ((baseName = f.getName()).contains(".")) {
            baseName = baseName.substring(0, baseName.lastIndexOf(46));
        }
        File scriptsDir = flaFile.getParentFile();
        Path.createDirectorySafe(scriptsDir);
        File xflDataDir = null;
        String xflFile = null;
        if (!settings.compressed) {
            xflDataDir = new File(Path.combine(flaFile.getParentFile().getAbsolutePath(), baseName));
            xflFile = Path.combine(xflDataDir.getAbsolutePath(), baseName + ".xfl");
            Path.createDirectorySafe(xflDataDir);
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        HashMap<String, byte[]> datfiles = new HashMap<String, byte[]>();
        HashMap<Integer, CharacterTag> characters = XFLConverter.getCharacters(swf.getTags());
        List<Integer> nonLibraryShapes = XFLConverter.getNonLibraryShapes(swf.getTags(), characters);
        Map<Integer, String> characterClasses = XFLConverter.getCharacterClasses(swf.getTags());
        Map<Integer, ScriptPack> characterScriptPacks = XFLConverter.getCharacterScriptPacks(swf, characterClasses);
        Map<Integer, String> characterVariables = XFLConverter.getCharacterVariables(swf.getTags());
        boolean hasAmfMetadata = this.hasAmfMetadata(swf);
        String backgroundColor = "#ffffff";
        SetBackgroundColorTag setBgColorTag = swf.getBackgroundColor();
        if (setBgColorTag != null) {
            backgroundColor = setBgColorTag.backgroundColor.toHexRGB();
        }
        double width = XFLConverter.twipToPixel(swf.displayRect.getWidth());
        double height = XFLConverter.twipToPixel(swf.displayRect.getHeight());
        XFLXmlWriter domDocument = new XFLXmlWriter();
        try {
            domDocument.writeStartElement("DOMDocument", new String[]{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns", "http://ns.adobe.com/xfl/2008/", "currentTimeline", "1", "xflVersion", flaVersion.xflVersion(), "creatorInfo", generator, "platform", "Windows", "versionInfo", "Saved by " + generatorVerName, "majorVersion", generatorVersion, "buildNumber", "", "nextSceneIdentifier", "2", "playOptionsPlayLoop", "false", "playOptionsPlayPages", "false", "playOptionsPlayFrameActions", "false", "autoSaveHasPrompted", "true", "backgroundColor", backgroundColor, "frameRate", Integer.toString((int)swf.frameRate)});
            if (Double.compare(width, 550.0) != 0) {
                domDocument.writeAttribute("width", XFLConverter.doubleToString(width));
            }
            if (Double.compare(height, 400.0) != 0) {
                domDocument.writeAttribute("height", XFLConverter.doubleToString(height));
            }
            XFLConverter.convertFonts(swf.getTags(), domDocument);
            this.convertLibrary(swf, characterVariables, characterClasses, characterScriptPacks, nonLibraryShapes, backgroundColor, swf.getTags(), characters, files, datfiles, flaVersion, domDocument);
            ScriptPack documentScriptPack = characterScriptPacks.containsKey(0) ? characterScriptPacks.get(0) : null;
            this.convertTimeline(swf.getAbcIndex(), -1, null, nonLibraryShapes, backgroundColor, swf.getTags(), swf.getTags(), characters, "Scene 1", flaVersion, files, domDocument, documentScriptPack);
            if (hasAmfMetadata) {
                domDocument.writeStartElement("persistentData");
                domDocument.writeStartElement("PD");
                domDocument.writeAttribute("n", "PUB_PRST_DATA_EMBED_SWF_");
                domDocument.writeAttribute("t", "i");
                domDocument.writeAttribute("v", 1);
                domDocument.writeEndElement();
                domDocument.writeEndElement();
            }
            domDocument.writeEndElement();
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String domDocumentStr = this.prettyFormatXML(domDocument.toString());
        if (settings.exportScript) {
            for (Tag t : swf.getTags()) {
                DefineSpriteTag sprite;
                DoInitActionTag dia;
                int chid;
                if (!(t instanceof DoInitActionTag) || !characters.containsKey(chid = (dia = (DoInitActionTag)t).getCharacterId()) || !(characters.get(chid) instanceof DefineSpriteTag) || !(sprite = (DefineSpriteTag)characters.get(chid)).getTags().isEmpty()) continue;
                String data = XFLConverter.convertActionScript12(dia);
                String expName = dia.getSwf().getExportName(dia.spriteId);
                String expPath = expName = expName != null ? expName : "_unk_";
                String prefix = "__Packages.";
                if (expPath.startsWith("__Packages.")) {
                    expPath = expPath.substring("__Packages.".length());
                }
                String expDir = "";
                if (expPath.contains(".")) {
                    expDir = expPath.substring(0, expPath.lastIndexOf(46));
                    expDir = expDir.replace(".", File.separator);
                }
                expPath = expPath.replace(".", File.separator);
                File cdir = new File(scriptsDir.getAbsolutePath() + File.separator + expDir);
                Path.createDirectorySafe(cdir);
                XFLConverter.writeFile(handler, Utf8Helper.getBytes(data), scriptsDir.getAbsolutePath() + File.separator + expPath + ".as");
            }
        }
        int flaSwfVersion = swf.version > flaVersion.maxSwfVersion() ? flaVersion.maxSwfVersion() : swf.version;
        boolean greaterThanCC = flaVersion.ordinal() >= FLAVersion.CC.ordinal();
        XFLXmlWriter publishSettings = new XFLXmlWriter();
        try {
            publishSettings.writeStartElement("flash_profiles");
            publishSettings.writeStartElement("flash_profile", new String[]{"version", "1.0", "name", "Default", "current", "true"});
            publishSettings.writeStartElement("PublishFormatProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("defaultNames", 1);
            publishSettings.writeElementValue("flash", 1);
            publishSettings.writeElementValue("projectorWin", 0);
            publishSettings.writeElementValue("projectorMac", 0);
            publishSettings.writeElementValue("html", 1);
            publishSettings.writeElementValue("gif", 0);
            publishSettings.writeElementValue("jpeg", 0);
            publishSettings.writeElementValue("png", 0);
            publishSettings.writeElementValue(greaterThanCC ? "svg" : "qt", 0);
            publishSettings.writeElementValue("rnwk", 0);
            publishSettings.writeElementValue("swc", 0);
            publishSettings.writeElementValue("flashDefaultName", 1);
            publishSettings.writeElementValue("projectorWinDefaultName", 1);
            publishSettings.writeElementValue("projectorMacDefaultName", 1);
            publishSettings.writeElementValue("htmlDefaultName", 1);
            publishSettings.writeElementValue("gifDefaultName", 1);
            publishSettings.writeElementValue("jpegDefaultName", 1);
            publishSettings.writeElementValue("pngDefaultName", 1);
            publishSettings.writeElementValue(greaterThanCC ? "svgDefaultName" : "qtDefaultName", 1);
            publishSettings.writeElementValue("rnwkDefaultName", 1);
            publishSettings.writeElementValue("swcDefaultName", 1);
            publishSettings.writeElementValue("flashFileName", baseName + ".swf");
            publishSettings.writeElementValue("projectorWinFileName", baseName + ".exe");
            publishSettings.writeElementValue("projectorMacFileName", baseName + ".app");
            publishSettings.writeElementValue("htmlFileName", baseName + ".html");
            publishSettings.writeElementValue("gifFileName", baseName + ".gif");
            publishSettings.writeElementValue("jpegFileName", baseName + ".jpg");
            publishSettings.writeElementValue("pngFileName", baseName + ".png");
            publishSettings.writeElementValue(greaterThanCC ? "svgFileName" : "qtFileName", 1);
            publishSettings.writeElementValue("rnwkFileName", baseName + ".smil");
            publishSettings.writeElementValue("swcFileName", baseName + ".swc");
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishHtmlProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("VersionDetectionIfAvailable", 0);
            publishSettings.writeElementValue("VersionInfo", "12,0,0,0;11,2,0,0;11,1,0,0;10,3,0,0;10,2,153,0;10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
            publishSettings.writeElementValue("UsingDefaultContentFilename", 1);
            publishSettings.writeElementValue("UsingDefaultAlternateFilename", 1);
            publishSettings.writeElementValue("ContentFilename", baseName + "_content.html");
            publishSettings.writeElementValue("AlternateFilename", baseName + "_alternate.html");
            publishSettings.writeElementValue("UsingOwnAlternateFile", 0);
            publishSettings.writeElementValue("OwnAlternateFilename", "");
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("Align", 0);
            publishSettings.writeElementValue("Units", 0);
            publishSettings.writeElementValue("Loop", 1);
            publishSettings.writeElementValue("StartPaused", 0);
            publishSettings.writeElementValue("Scale", 0);
            publishSettings.writeElementValue("HorizontalAlignment", 1);
            publishSettings.writeElementValue("VerticalAlignment", 1);
            publishSettings.writeElementValue("Quality", 4);
            publishSettings.writeElementValue("DeblockingFilter", 0);
            publishSettings.writeElementValue("WindowMode", 0);
            publishSettings.writeElementValue("DisplayMenu", 1);
            publishSettings.writeElementValue("DeviceFont", 0);
            publishSettings.writeElementValue("TemplateFileName", "");
            publishSettings.writeElementValue("showTagWarnMsg", 1);
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishFlashProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("TopDown", "");
            publishSettings.writeElementValue("FireFox", "");
            publishSettings.writeElementValue("Report", 0);
            publishSettings.writeElementValue("Protect", 0);
            publishSettings.writeElementValue("OmitTraceActions", 0);
            publishSettings.writeElementValue("Quality", "80");
            publishSettings.writeElementValue("DeblockingFilter", 0);
            publishSettings.writeElementValue("StreamFormat", 0);
            publishSettings.writeElementValue("StreamCompress", 7);
            publishSettings.writeElementValue("EventFormat", 0);
            publishSettings.writeElementValue("EventCompress", 7);
            publishSettings.writeElementValue("OverrideSounds", 0);
            publishSettings.writeElementValue("Version", flaSwfVersion);
            publishSettings.writeElementValue("ExternalPlayer", FLAVersion.swfVersionToPlayer(flaSwfVersion));
            publishSettings.writeElementValue("ActionScriptVersion", useAS3 ? 3 : 2);
            publishSettings.writeElementValue("PackageExportFrame", 1);
            publishSettings.writeElementValue("PackagePaths", "");
            publishSettings.writeElementValue("AS3PackagePaths", ".");
            publishSettings.writeElementValue("AS3ConfigConst", "CONFIG::FLASH_AUTHORING=\"true\";");
            publishSettings.writeElementValue("DebuggingPermitted", 0);
            publishSettings.writeElementValue("DebuggingPassword", "");
            publishSettings.writeElementValue("CompressMovie", swf.compression == SWFCompression.NONE ? 0 : 1);
            publishSettings.writeElementValue("CompressionType", swf.compression == SWFCompression.LZMA ? 1 : 0);
            publishSettings.writeElementValue("InvisibleLayer", 1);
            publishSettings.writeElementValue("DeviceSound", 0);
            publishSettings.writeElementValue("StreamUse8kSampleRate", 0);
            publishSettings.writeElementValue("EventUse8kSampleRate", 0);
            publishSettings.writeElementValue("UseNetwork", useNetwork ? 1 : 0);
            publishSettings.writeElementValue("DocumentClass", characterClasses.containsKey(0) ? characterClasses.get(0) : "");
            publishSettings.writeElementValue("AS3Strict", 2);
            publishSettings.writeElementValue("AS3Coach", 4);
            publishSettings.writeElementValue("AS3AutoDeclare", 4096);
            publishSettings.writeElementValue("AS3Dialect", "AS3");
            publishSettings.writeElementValue("AS3ExportFrame", 1);
            publishSettings.writeElementValue("AS3Optimize", 1);
            publishSettings.writeElementValue("ExportSwc", 0);
            publishSettings.writeElementValue("ScriptStuckDelay", 15);
            publishSettings.writeElementValue("IncludeXMP", 1);
            publishSettings.writeElementValue("HardwareAcceleration", 0);
            publishSettings.writeElementValue("AS3Flags", 4102);
            publishSettings.writeElementValue("DefaultLibraryLinkage", "rsl");
            publishSettings.writeElementValue("RSLPreloaderMethod", "wrap");
            publishSettings.writeElementValue("RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
            if (greaterThanCC) {
                publishSettings.writeStartElement("LibraryPath");
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(FlexSDK)/frameworks/libs/flex.swc");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(FlexSDK)/frameworks/libs/core.swc");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeEndElement();
                publishSettings.writeElementValueRaw("LibraryVersions", Helper.newLine + "      ");
            } else {
                publishSettings.writeStartElement("LibraryPath");
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs");
                publishSettings.writeElementValue("linkage", "merge");
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("library-path-entry");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs/11.0/textLayout.swc");
                publishSettings.writeElementValue("linkage", "rsl", new String[]{"usesDefault", "true"});
                publishSettings.writeElementValue("rsl-url", "http://fpdownload.adobe.com/pub/swz/tlf/2.0.0.232/textLayout_2.0.0.232.swz");
                publishSettings.writeElementValue("policy-file-url", "http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeEndElement();
                publishSettings.writeStartElement("LibraryVersions");
                publishSettings.writeStartElement("library-version");
                publishSettings.writeElementValue("swc-path", "$(AppConfig)/ActionScript 3.0/libs/11.0/textLayout.swc");
                publishSettings.writeEmptyElement("feature", new String[]{"name", "tlfText", "majorVersion", "2", "minorVersion", "0", "build", "232"});
                publishSettings.writeElementValue("rsl-url", "http://fpdownload.adobe.com/pub/swz/tlf/2.0.0.232/textLayout_2.0.0.232.swz");
                publishSettings.writeElementValue("policy-file-url", "http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
                publishSettings.writeElementValue("rsl-url", "textLayout_2.0.0.232.swz");
                publishSettings.writeEndElement();
                publishSettings.writeEndElement();
            }
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishJpegProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("Progressive", 0);
            publishSettings.writeElementValue("DPI", 0x480000);
            publishSettings.writeElementValue("Size", 0);
            publishSettings.writeElementValue("Quality", 80);
            publishSettings.writeElementValue("MatchMovieDim", 1);
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishRNWKProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("exportFlash", 1);
            publishSettings.writeElementValue("flashBitRate", 0);
            publishSettings.writeElementValue("exportAudio", 1);
            publishSettings.writeElementValue("audioFormat", 0);
            publishSettings.writeElementValue("singleRateAudio", 0);
            publishSettings.writeElementValue("realVideoRate", 100000);
            publishSettings.writeElementValue("speed28K", 1);
            publishSettings.writeElementValue("speed56K", 1);
            publishSettings.writeElementValue("speedSingleISDN", 0);
            publishSettings.writeElementValue("speedDualISDN", 0);
            publishSettings.writeElementValue("speedCorporateLAN", 0);
            publishSettings.writeElementValue("speed256K", 0);
            publishSettings.writeElementValue("speed384K", 0);
            publishSettings.writeElementValue("speed512K", 0);
            publishSettings.writeElementValue("exportSMIL", 1);
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishGifProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("Animated", 0);
            publishSettings.writeElementValue("MatchMovieDim", 1);
            publishSettings.writeElementValue("Loop", 1);
            publishSettings.writeElementValue("LoopCount", "");
            publishSettings.writeElementValue("OptimizeColors", 1);
            publishSettings.writeElementValue("Interlace", 0);
            publishSettings.writeElementValue("Smooth", 1);
            publishSettings.writeElementValue("DitherSolids", 0);
            publishSettings.writeElementValue("RemoveGradients", 0);
            publishSettings.writeElementValue("TransparentOption", "");
            publishSettings.writeElementValue("TransparentAlpha", 128);
            publishSettings.writeElementValue("DitherOption", "");
            publishSettings.writeElementValue("PaletteOption", "");
            publishSettings.writeElementValue("MaxColors", 255);
            publishSettings.writeElementValue("PaletteName", "");
            publishSettings.writeEndElement();
            publishSettings.writeStartElement("PublishPNGProperties", new String[]{"enabled", "true"});
            publishSettings.writeElementValue("Width", width);
            publishSettings.writeElementValue("Height", height);
            publishSettings.writeElementValue("OptimizeColors", 1);
            publishSettings.writeElementValue("Interlace", 0);
            publishSettings.writeElementValue("Transparent", 0);
            publishSettings.writeElementValue("Smooth", 1);
            publishSettings.writeElementValue("DitherSolids", 0);
            publishSettings.writeElementValue("RemoveGradients", 0);
            publishSettings.writeElementValue("MatchMovieDim", 1);
            publishSettings.writeElementValue("DitherOption", "");
            publishSettings.writeElementValue("FilterOption", "");
            publishSettings.writeElementValue("PaletteOption", "");
            publishSettings.writeElementValue("BitDepth", "24-bit with Alpha");
            publishSettings.writeElementValue("MaxColors", 255);
            publishSettings.writeElementValue("PaletteName", "");
            publishSettings.writeEndElement();
            if (!greaterThanCC) {
                publishSettings.writeStartElement("PublishQTProperties", new String[]{"enabled", "true"});
                publishSettings.writeElementValue("Width", width);
                publishSettings.writeElementValue("Height", height);
                publishSettings.writeElementValue("MatchMovieDim", 1);
                publishSettings.writeElementValue("UseQTSoundCompression", 0);
                publishSettings.writeElementValue("AlphaOption", "");
                publishSettings.writeElementValue("LayerOption", "");
                publishSettings.writeElementValue("QTSndSettings", "00000000");
                publishSettings.writeElementValue("ControllerOption", 0);
                publishSettings.writeElementValue("Looping", 0);
                publishSettings.writeElementValue("PausedAtStart", 0);
                publishSettings.writeElementValue("PlayEveryFrame", 0);
                publishSettings.writeElementValue("Flatten", 1);
                publishSettings.writeEndElement();
            }
            publishSettings.writeEndElement();
            publishSettings.writeEndElement();
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String publishSettingsStr = publishSettings.toString();
        if (settings.compressed) {
            String domDocumentF = domDocumentStr;
            String publishSettingsF = publishSettingsStr;
            String outfileF = outfile;
            new RetryTask(() -> {
                try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outfileF));){
                    out.putNextEntry(new ZipEntry("DOMDocument.xml"));
                    out.write(Utf8Helper.getBytes(domDocumentF));
                    out.putNextEntry(new ZipEntry("PublishSettings.xml"));
                    out.write(Utf8Helper.getBytes(publishSettingsF));
                    for (String fileName : files.keySet()) {
                        out.putNextEntry(new ZipEntry("LIBRARY/" + fileName));
                        out.write((byte[])files.get(fileName));
                    }
                    for (String fileName : datfiles.keySet()) {
                        out.putNextEntry(new ZipEntry("bin/" + fileName));
                        out.write((byte[])datfiles.get(fileName));
                    }
                }
            }, handler).run();
        } else {
            Path.createDirectorySafe(xflDataDir);
            XFLConverter.writeFile(handler, Utf8Helper.getBytes(domDocumentStr), xflDataDir.getAbsolutePath() + File.separator + "DOMDocument.xml");
            XFLConverter.writeFile(handler, Utf8Helper.getBytes(publishSettingsStr), xflDataDir.getAbsolutePath() + File.separator + "PublishSettings.xml");
            File libraryDir = new File(xflDataDir.getAbsolutePath() + File.separator + "LIBRARY");
            libraryDir.mkdir();
            File binDir = new File(xflDataDir.getAbsolutePath() + File.separator + "bin");
            binDir.mkdir();
            for (String fileName : files.keySet()) {
                XFLConverter.writeFile(handler, (byte[])files.get(fileName), libraryDir.getAbsolutePath() + File.separator + fileName);
            }
            for (String fileName : datfiles.keySet()) {
                XFLConverter.writeFile(handler, (byte[])datfiles.get(fileName), binDir.getAbsolutePath() + File.separator + fileName);
            }
            XFLConverter.writeFile(handler, Utf8Helper.getBytes("PROXY-CS5"), xflFile);
        }
        if (useAS3 && settings.exportScript) {
            try {
                ScriptExportSettings scriptExportSettings = new ScriptExportSettings(ScriptExportMode.AS, false, true);
                swf.exportActionScript(handler, scriptsDir.getAbsolutePath(), scriptExportSettings, parallel, null);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error during ActionScript3 export", ex);
            }
        }
    }

    private static int normHue(double h) {
        int ret;
        if (Double.isNaN(h)) {
            h = -Math.PI;
        }
        for (ret = (int)Math.round(h * 180.0 / Math.PI); ret > 180; ret -= 360) {
        }
        while (ret < -180) {
            ret += 360;
        }
        return ret;
    }

    private static int normBrightness(double b) {
        if (Double.isNaN(b)) {
            b = -100.0;
        }
        return (int)Math.round(b);
    }

    private static int normSaturation(double s) {
        if (Double.isNaN(s)) {
            return -100;
        }
        if (s == 1.0) {
            return 0;
        }
        if (s - 1.0 < 0.0) {
            return (int)Math.round((s - 1.0) * 100.0);
        }
        return (int)Math.round((s - 1.0) * 100.0 / 3.0);
    }

    private static int normContrast(double c) {
        double[] ctrMap = new double[]{0.0, 0.01, 0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 0.1, 0.11, 0.12, 0.14, 0.15, 0.16, 0.17, 0.18, 0.2, 0.21, 0.22, 0.24, 0.25, 0.27, 0.28, 0.3, 0.32, 0.34, 0.36, 0.38, 0.4, 0.42, 0.44, 0.46, 0.48, 0.5, 0.53, 0.56, 0.59, 0.62, 0.65, 0.68, 0.71, 0.74, 0.77, 0.8, 0.83, 0.86, 0.89, 0.92, 0.95, 0.98, 1.0, 1.06, 1.12, 1.18, 1.24, 1.3, 1.36, 1.42, 1.48, 1.54, 1.6, 1.66, 1.72, 1.78, 1.84, 1.9, 1.96, 2.0, 2.12, 2.25, 2.37, 2.5, 2.62, 2.75, 2.87, 3.0, 3.2, 3.4, 3.6, 3.8, 4.0, 4.3, 4.7, 4.9, 5.0, 5.5, 6.0, 6.5, 6.8, 7.0, 7.3, 7.5, 7.8, 8.0, 8.4, 8.7, 9.0, 9.4, 9.6, 9.8, 10.0};
        if (c == 127.0) {
            return 0;
        }
        if (c - 127.0 < 0.0) {
            return (int)Math.round((c - 127.0) * 100.0 / 127.0);
        }
        c = (c - 127.0) / 127.0;
        for (int i = 0; i < ctrMap.length; ++i) {
            if (!(ctrMap[i] >= c)) continue;
            return i;
        }
        return ctrMap.length - 1;
    }

    private static boolean sameDouble(double a, double b) {
        double EPSILON = 1.0E-5;
        return a == b ? true : Math.abs(a - b) < 1.0E-5;
    }

    private static void convertAdjustColorFilter(COLORMATRIXFILTER filter, XFLXmlWriter writer) throws XMLStreamException {
        float[][] matrix = new float[5][5];
        int index = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                matrix[j][i] = filter.matrix[index];
                ++index;
            }
        }
        double a11 = matrix[0][0];
        double a12 = matrix[0][1];
        double a13 = matrix[0][2];
        double a21 = matrix[1][0];
        double a22 = matrix[1][1];
        double a23 = matrix[1][2];
        double a31 = matrix[2][0];
        double a32 = matrix[2][1];
        double a33 = matrix[2][2];
        double a41 = matrix[4][0];
        double b = (2.4872168661075E13 * a11 * a11 - 1.51430415740925E14 * a12 + 3.41095051289483E14 * a12 * a12 - 1.530209478945E13 * a13 + 8.2428663495404E13 * a12 * a13 - 4.592294873812E12 * a13 * a13 + 4.355625147E10 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) + 2.38473095655E12 * a12 * a41 + 2.409778707E11 * a13 * a41 - 6.8592522E8 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) * a41 + 465.0 * a11 * (4.66201717582E11 * a12 + 5.5756962908E10 * a13 + 7.64132175E8 * (-127.0 + 2.0 * a41))) / (3.9168769545E11 * a11 * a11 + 5.371575610858E12 * a12 * a12 + 1.298089188904E12 * a12 * a13 - 7.2319604312E10 * a13 * a13 + 1860.0 * a11 * (1.835439833E9 * a12 + 2.19515602E8 * a13));
        double c = 127.0 * (495225.0 * a11 + 1661845.0 * a12 + 167930.0 * a13 + 478.0 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13))) / 717495.0;
        double h = 2.0 * (Math.atan((-465.0 * a11 + 287.0 * a12 + 178.0 * a13 + Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13))) / (500.0 * (a12 - a13))) + Math.PI);
        double s = 1543.0 * (-1.0335555E8 * a11 * a11 - 1.58872382E8 * a12 * a12 + 1.90161784E8 * a12 * a13 - 1.34644952E8 * a13 * a13 + 1661845.0 * a12 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) + 167930.0 * a13 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)) + 465.0 * a11 * (274372.0 * a12 + 170168.0 * a13 + 1065.0 * Math.sqrt(216225.0 * a11 * a11 + 332369.0 * a12 * a12 - 397828.0 * a12 * a13 + 281684.0 * a13 * a13 - 930.0 * a11 * (287.0 * a12 + 178.0 * a13)))) / (1.95843847725E11 * a11 * a11 + 2.685787805429E12 * a12 * a12 + 6.49044594452E11 * a12 * a13 - 3.6159802156E10 * a13 * a13 + 930.0 * a11 * (1.835439833E9 * a12 + 2.19515602E8 * a13));
        if (XFLConverter.sameDouble(410.0 * a12, 1543.0 * a31) && XFLConverter.sameDouble(410.0 * a12, 1543.0 * a32) && XFLConverter.sameDouble(3047.0 * a12, 1543.0 * a21) && XFLConverter.sameDouble(3047.0 * a12, 1543.0 * a23) && XFLConverter.sameDouble(a22, a11 + 1504.0 * a12 / 1543.0) && XFLConverter.sameDouble(1133.0 * a12 / 1543.0 + a33, a11) && !XFLConverter.sameDouble(a11, a12) && !XFLConverter.sameDouble(1543.0 * a11 + 3457.0 * a12, 0.0)) {
            h = 0.0;
        }
        writer.writeEmptyElement("AdjustColorFilter", new String[]{"brightness", Integer.toString(XFLConverter.normBrightness(b)), "contrast", Integer.toString(XFLConverter.normContrast(c)), "saturation", Integer.toString(XFLConverter.normSaturation(s)), "hue", Integer.toString(XFLConverter.normHue(h))});
    }

    private static String convertHTMLText(ReadOnlyTagList tags, DefineEditTextTag det, String html) {
        HTMLTextParser tparser = new HTMLTextParser(tags, det);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser sparser = factory.newSAXParser();
            XMLReader parser = sparser.getXMLReader();
            parser.setContentHandler(tparser);
            parser.setErrorHandler(tparser);
            html = "<?xml version=\"1.0\"?>\n<!DOCTYPE some_name [ \n<!ENTITY nbsp \"&#160;\"> \n]><html>" + html + "</html>";
            try {
                parser.parse(new InputSource(new StringReader(html)));
            }
            catch (SAXParseException spe) {
                System.out.println(html);
                System.err.println(tparser.result);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.log(Level.SEVERE, "Error while converting HTML", e);
        }
        return tparser.result.toString();
    }

    private static double twipToPixel(double tw) {
        return tw / 20.0;
    }

    private static class HTMLTextParser
    extends DefaultHandler {
        public XFLXmlWriter result = new XFLXmlWriter();
        private String fontFace = "";
        private String color = "";
        private int size = -1;
        private int indent = -1;
        private int leftMargin = -1;
        private int rightMargin = -1;
        private int lineSpacing = -1;
        private double letterSpacing = -1.0;
        private String alignment = null;
        private final ReadOnlyTagList tags;
        private boolean bold = false;
        private boolean italic = false;
        private boolean underline = false;
        private boolean li = false;
        private String url = null;
        private String target = null;

        @Override
        public void error(SAXParseException e) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        public HTMLTextParser(ReadOnlyTagList tags, DefineEditTextTag det) {
            if (det.hasFont) {
                String fontName = null;
                FontTag ft = null;
                for (Tag u : tags) {
                    if (u instanceof DefineFontNameTag && ((DefineFontNameTag)u).fontId == det.fontId) {
                        fontName = ((DefineFontNameTag)u).fontName;
                    }
                    if (u instanceof FontTag && ((FontTag)u).getFontId() == det.fontId) {
                        ft = (FontTag)u;
                    }
                    if (fontName == null || ft == null) continue;
                    break;
                }
                if (ft != null) {
                    if (fontName == null) {
                        fontName = ft.getFontNameIntag();
                    }
                    if (fontName == null) {
                        fontName = FontTag.getDefaultFontName();
                    }
                    this.italic = ft.isItalic();
                    this.bold = ft.isBold();
                    this.size = det.fontHeight;
                    this.fontFace = new Font(fontName, (this.italic ? 2 : 0) | (this.bold ? 1 : 0) | (!this.italic && !this.bold ? 0 : 0), this.size < 0 ? 10 : this.size).getPSName();
                }
            }
            if (det.hasLayout) {
                this.leftMargin = det.leftMargin;
                this.rightMargin = det.rightMargin;
                this.indent = det.indent;
                this.lineSpacing = det.leading;
                String[] alignNames = new String[]{"left", "right", "center", "justify"};
                this.alignment = det.align < alignNames.length ? alignNames[det.align] : "unknown";
            }
            this.tags = tags;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            block11 : switch (qName) {
                case "a": {
                    String t;
                    String href = attributes.getValue("href");
                    if (href != null) {
                        this.url = href;
                    }
                    if ((t = attributes.getValue("target")) == null) break;
                    this.target = t;
                    break;
                }
                case "b": {
                    this.bold = true;
                    break;
                }
                case "i": {
                    this.italic = true;
                    break;
                }
                case "u": {
                    this.underline = true;
                    break;
                }
                case "li": {
                    this.li = true;
                    break;
                }
                case "p": {
                    String a = attributes.getValue("align");
                    if (a != null) {
                        this.alignment = a;
                    }
                    if (this.result.isEmpty()) break;
                    this.putText("\r\n");
                    break;
                }
                case "font": {
                    String f;
                    String c;
                    String s;
                    String ls = attributes.getValue("letterSpacing");
                    if (ls != null) {
                        try {
                            this.letterSpacing = Double.parseDouble(ls);
                        }
                        catch (NumberFormatException ex) {
                            logger.log(Level.WARNING, "Invalid letter spacing value: {0}", ls);
                        }
                    }
                    if ((s = attributes.getValue("size")) != null) {
                        try {
                            this.size = Integer.parseInt(s);
                        }
                        catch (NumberFormatException ex) {
                            logger.log(Level.WARNING, "Invalid font size: {0}", s);
                        }
                    }
                    if ((c = attributes.getValue("color")) != null) {
                        this.color = c;
                    }
                    if ((f = attributes.getValue("face")) == null) break;
                    for (Tag tag : this.tags) {
                        String installedFont;
                        if (!(tag instanceof FontTag)) continue;
                        FontTag ft = (FontTag)tag;
                        String fontName = null;
                        if (!f.equals(ft.getFontNameIntag())) continue;
                        for (Tag u : this.tags) {
                            if (!(u instanceof DefineFontNameTag) || ((DefineFontNameTag)u).fontId != ft.getFontId()) continue;
                            fontName = ((DefineFontNameTag)u).fontName;
                        }
                        if (fontName == null) {
                            fontName = ft.getFontNameIntag();
                        }
                        if ((installedFont = FontTag.isFontFamilyInstalled(fontName)) != null) {
                            this.fontFace = new Font(installedFont, (this.italic ? 2 : 0) | (this.bold ? 1 : 0) | (!this.italic && !this.bold ? 0 : 0), this.size < 0 ? 10 : this.size).getPSName();
                            break block11;
                        }
                        this.fontFace = fontName;
                        break block11;
                    }
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("a")) {
                this.url = null;
                this.target = null;
            }
            if (qName.equals("b")) {
                this.bold = false;
            }
            if (qName.equals("i")) {
                this.italic = false;
            }
            if (qName.equals("u")) {
                this.underline = false;
            }
            if (qName.equals("li")) {
                this.li = false;
            }
        }

        private void putText(String txt) {
            try {
                this.result.writeStartElement("DOMTextRun");
                this.result.writeElementValue("characters", txt);
                this.result.writeStartElement("textAttrs");
                this.result.writeStartElement("DOMTextAttrs");
                if (this.alignment != null) {
                    this.result.writeAttribute("alignment", this.alignment);
                }
                this.result.writeAttribute("rotation", true);
                if (this.indent > -1) {
                    this.result.writeAttribute("indent", XFLConverter.twipToPixel(this.indent));
                }
                if (this.leftMargin > -1) {
                    this.result.writeAttribute("leftMargin", XFLConverter.twipToPixel(this.leftMargin));
                }
                if (this.letterSpacing > -1.0) {
                    this.result.writeAttribute("letterSpacing", this.letterSpacing);
                }
                if (this.lineSpacing > -1) {
                    this.result.writeAttribute("lineSpacing", XFLConverter.twipToPixel(this.lineSpacing));
                }
                if (this.rightMargin > -1) {
                    this.result.writeAttribute("rightMargin", XFLConverter.twipToPixel(this.rightMargin));
                }
                if (this.size > -1) {
                    this.result.writeAttribute("size", this.size);
                    this.result.writeAttribute("bitmapSize", (int)((double)this.size * 20.0));
                }
                if (this.fontFace != null) {
                    this.result.writeAttribute("face", this.fontFace);
                }
                if (this.color != null) {
                    this.result.writeAttribute("fillColor", this.color);
                }
                if (this.url != null) {
                    this.result.writeAttribute("url", this.url);
                }
                if (this.target != null) {
                    this.result.writeAttribute("target", this.target);
                }
                this.result.writeEndElement();
                this.result.writeEndElement();
                this.result.writeEndElement();
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.putText(new String(ch, start, length));
        }

        @Override
        public void endDocument() {
            if (this.result.isEmpty()) {
                this.putText("");
            }
        }
    }
}

