/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.sound;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.sound.AdpcmDecoder;
import com.jpexs.decompiler.flash.types.sound.MP3Decoder;
import com.jpexs.decompiler.flash.types.sound.NellyMoserDecoder;
import com.jpexs.decompiler.flash.types.sound.NoDecoder;
import com.jpexs.decompiler.flash.types.sound.SoundDecoder;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundFormat {
    public int formatId;
    public int samplingRate;
    public boolean stereo;
    public static final int FORMAT_UNCOMPRESSED_NATIVE_ENDIAN = 0;
    public static final int FORMAT_ADPCM = 1;
    public static final int FORMAT_MP3 = 2;
    public static final int FORMAT_UNCOMPRESSED_LITTLE_ENDIAN = 3;
    public static final int FORMAT_NELLYMOSER16KHZ = 4;
    public static final int FORMAT_NELLYMOSER8KHZ = 5;
    public static final int FORMAT_NELLYMOSER = 6;
    public static final int FORMAT_SPEEX = 11;

    public SoundFormat() {
    }

    public SoundExportFormat getNativeExportFormat() {
        switch (this.formatId) {
            case 0: 
            case 3: {
                return SoundExportFormat.WAV;
            }
            case 2: {
                return SoundExportFormat.MP3;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                return SoundExportFormat.FLV;
            }
        }
        return SoundExportFormat.FLV;
    }

    public SoundFormat(int formatId, int samplingRate, boolean stereo) {
        this.formatId = formatId;
        this.samplingRate = samplingRate;
        this.stereo = stereo;
        this.ensureFormat();
    }

    public byte[] decode(SWFInputStream sis) {
        try {
            return this.getDecoder().decode(sis);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public boolean decode(SWFInputStream sis, OutputStream os) {
        try {
            this.getDecoder().decode(sis, os);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean play(SWFInputStream sis) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.decode(sis, baos)) {
            return false;
        }
        AudioFormat audioFormat = new AudioFormat(this.samplingRate, 16, this.stereo ? 2 : 1, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
            line.open(audioFormat);
            byte[] outData = baos.toByteArray();
            line.write(outData, 0, outData.length);
            line.drain();
            line.stop();
            boolean bl = true;
            return bl;
        }
        catch (LineUnavailableException ex) {
            return false;
        }
    }

    private void ensureFormat() {
        switch (this.formatId) {
            case 4: {
                this.samplingRate = 16000;
                break;
            }
            case 5: {
                this.samplingRate = 8000;
                break;
            }
            case 6: {
                this.samplingRate = 22050;
            }
        }
    }

    public SoundDecoder getDecoder() {
        this.ensureFormat();
        switch (this.formatId) {
            case 0: 
            case 3: {
                return new NoDecoder(this);
            }
            case 1: {
                return new AdpcmDecoder(this);
            }
            case 2: {
                return new MP3Decoder(this);
            }
            case 4: {
                return new NellyMoserDecoder(this);
            }
            case 5: {
                return new NellyMoserDecoder(this);
            }
            case 6: {
                return new NellyMoserDecoder(this);
            }
            case 11: {
                return null;
            }
        }
        return null;
    }

    public String getFormatName() {
        switch (this.formatId) {
            case 0: {
                return "Uncompressed native endian";
            }
            case 1: {
                return "ADPCM";
            }
            case 2: {
                return "MP3";
            }
            case 3: {
                return "Uncompressed little endian";
            }
            case 4: {
                return "NellyMoser 16kHz";
            }
            case 5: {
                return "NellyMoser 8kHz";
            }
            case 6: {
                return "NellyMoser";
            }
            case 11: {
                return "Speex";
            }
        }
        return null;
    }

    private static void writeLE(OutputStream os, long val, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            os.write((int)(val & 0xFFL));
            val >>= 8;
        }
    }

    public boolean createWav(SOUNDINFO soundInfo, List<ByteArrayRange> dataRanges, OutputStream os) throws IOException {
        ByteArrayOutputStream baosFiltered;
        this.ensureFormat();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SoundDecoder decoder = this.getDecoder();
        for (ByteArrayRange dataRange : dataRanges) {
            SWFInputStream sis = new SWFInputStream(null, dataRange.getArray(), 0L, dataRange.getPos() + dataRange.getLength());
            sis.seek(dataRange.getPos());
            decoder.decode(sis, baos);
        }
        boolean convertedStereo = this.stereo;
        if (soundInfo == null) {
            baosFiltered = baos;
        } else {
            int inPoint = soundInfo.hasInPoint ? (int)Math.round((double)(soundInfo.inPoint * (long)this.samplingRate) / 44100.0) : 0;
            int outPoint = soundInfo.hasOutPoint ? (int)Math.round((double)(soundInfo.outPoint * (long)this.samplingRate) / 44100.0) : Integer.MAX_VALUE;
            byte[] data = baos.toByteArray();
            baosFiltered = new ByteArrayOutputStream();
            int inPointBytes = inPoint * 2 * (this.stereo ? 2 : 1);
            int outPointBytes = soundInfo.hasOutPoint ? outPoint * 2 * (this.stereo ? 2 : 1) : data.length;
            for (int i = inPointBytes; i < outPointBytes && i + 1 < data.length; i += this.stereo ? 4 : 2) {
                int left;
                int right = left = (data[i] & 0xFF) + ((data[i + 1] & 0xFF) << 8) << 16 >> 16;
                if (this.stereo) {
                    if (i + 3 >= data.length) break;
                    right = (data[i + 2] & 0xFF) + ((data[i + 3] & 0xFF) << 8) << 16 >> 16;
                }
                if (soundInfo.hasEnvelope) {
                    for (int e = 0; e < soundInfo.envelopeRecords.length - 1; ++e) {
                        int envPosBytes = inPointBytes + (int)((double)(soundInfo.envelopeRecords[e].pos44 * (long)this.samplingRate) / 44100.0 * 2.0 * (double)(this.stereo ? 2 : 1));
                        int envNextPosBytes = inPointBytes + (int)((double)(soundInfo.envelopeRecords[e + 1].pos44 * (long)this.samplingRate) / 44100.0 * 2.0 * (double)(this.stereo ? 2 : 1));
                        if (i < envPosBytes || i > envNextPosBytes) continue;
                        double pos = (double)(i - envPosBytes) / (double)(envNextPosBytes - envPosBytes);
                        int leftLevel = (int)((double)soundInfo.envelopeRecords[e].leftLevel + (double)(soundInfo.envelopeRecords[e + 1].leftLevel - soundInfo.envelopeRecords[e].leftLevel) * pos);
                        int rightLevel = (int)((double)soundInfo.envelopeRecords[e].rightLevel + (double)(soundInfo.envelopeRecords[e + 1].rightLevel - soundInfo.envelopeRecords[e].rightLevel) * pos);
                        double leftMultiplier = (double)leftLevel / 32768.0;
                        double rightMultiplier = (double)rightLevel / 32768.0;
                        left = (int)Math.round((double)left * leftMultiplier);
                        right = (int)Math.round((double)right * rightMultiplier);
                        break;
                    }
                }
                SoundFormat.writeLE(baosFiltered, left, 2);
                SoundFormat.writeLE(baosFiltered, right, 2);
            }
            convertedStereo = true;
        }
        try {
            SoundFormat.createWavFromPcmData(os, this.samplingRate, true, convertedStereo, baosFiltered.toByteArray());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void createWavFromPcmData(OutputStream fos, int soundRateHz, boolean sample16bit, boolean stereo, byte[] data) throws IOException {
        ByteArrayOutputStream subChunk1Data = new ByteArrayOutputStream();
        int audioFormat = 1;
        SoundFormat.writeLE(subChunk1Data, audioFormat, 2);
        int numChannels = stereo ? 2 : 1;
        SoundFormat.writeLE(subChunk1Data, numChannels, 2);
        int sampleRate = soundRateHz;
        SoundFormat.writeLE(subChunk1Data, sampleRate, 4);
        int bitsPerSample = sample16bit ? 16 : 8;
        int byteRate = sampleRate * numChannels * bitsPerSample / 8;
        SoundFormat.writeLE(subChunk1Data, byteRate, 4);
        int blockAlign = numChannels * bitsPerSample / 8;
        SoundFormat.writeLE(subChunk1Data, blockAlign, 2);
        SoundFormat.writeLE(subChunk1Data, bitsPerSample, 2);
        ByteArrayOutputStream chunks = new ByteArrayOutputStream();
        chunks.write(Utf8Helper.getBytes("fmt "));
        byte[] subChunk1DataBytes = subChunk1Data.toByteArray();
        SoundFormat.writeLE(chunks, subChunk1DataBytes.length, 4);
        chunks.write(subChunk1DataBytes);
        chunks.write(Utf8Helper.getBytes("data"));
        SoundFormat.writeLE(chunks, data.length, 4);
        chunks.write(data);
        fos.write(Utf8Helper.getBytes("RIFF"));
        byte[] chunkBytes = chunks.toByteArray();
        SoundFormat.writeLE(fos, 4 + chunkBytes.length, 4);
        fos.write(Utf8Helper.getBytes("WAVE"));
        fos.write(chunkBytes);
    }
}

