/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.sound;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;

public class MP3FRAME {
    private Header h;
    private SampleBuffer samples;
    private byte[] fullData;

    private MP3FRAME() {
    }

    public void setFullData(byte[] fullData) {
        this.fullData = fullData;
    }

    public byte[] getBytes() {
        return this.fullData;
    }

    public static MP3FRAME readFrame(Bitstream bitstream, Decoder decoder) throws IOException {
        MP3FRAME ret = new MP3FRAME();
        try {
            ret.h = bitstream.readFrame();
            if (ret.h == null) {
                return null;
            }
        }
        catch (BitstreamException ex) {
            Logger.getLogger(MP3FRAME.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            ret.samples = (SampleBuffer)decoder.decodeFrame(ret.h, bitstream);
        }
        catch (DecoderException ex) {
            Logger.getLogger(MP3FRAME.class.getName()).log(Level.SEVERE, null, ex);
        }
        bitstream.closeFrame();
        return ret;
    }

    public int getSampleCount() {
        if (this.h.version() == 1) {
            switch (this.h.layer()) {
                case 1: {
                    return 384;
                }
                case 2: {
                    return 1152;
                }
                case 3: {
                    return 1152;
                }
            }
        }
        if (this.h.version() == 0 || this.h.version() == 2) {
            switch (this.h.layer()) {
                case 1: {
                    return 384;
                }
                case 2: {
                    return 1152;
                }
                case 3: {
                    return 576;
                }
            }
        }
        return 0;
    }

    public boolean isStereo() {
        return this.h.mode() != 3;
    }

    public SampleBuffer getSamples() {
        return this.samples;
    }

    public int getSamplingRate() {
        switch (this.h.sample_frequency()) {
            case 2: {
                if (this.h.version() == 1) {
                    return 32000;
                }
                if (this.h.version() == 0) {
                    return 16000;
                }
                return 8000;
            }
            case 0: {
                if (this.h.version() == 1) {
                    return 44100;
                }
                if (this.h.version() == 0) {
                    return 22050;
                }
                return 11025;
            }
            case 1: {
                if (this.h.version() == 1) {
                    return 48000;
                }
                if (this.h.version() == 0) {
                    return 24000;
                }
                return 12000;
            }
        }
        return 0;
    }

    public int getBitRate() {
        return this.h.bitrate();
    }
}

