/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.helpers.SerializableImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;

public class Filtering {
    public static final int INNER = 1;
    public static final int OUTER = 2;
    public static final int FULL = 3;
    private static final Color ALPHA = new Color(0, 0, 0, 0);
    private static final Point POINT_0_0 = new Point(0, 0);
    private static final Point POINT_255_0 = new Point(255, 0);
    private static final Point POINT_511_0 = new Point(511, 0);
    private static final Rectangle RECTANGLE_256_1 = new Rectangle(256, 1);
    private static final Rectangle RECTANGLE_512_1 = new Rectangle(512, 1);

    private static void boxBlurHorizontal(int[] pixels, int[] mask, int[] newColors, int w, int h, int radius) {
        int index = 0;
        for (int y = 0; y < h; ++y) {
            int hits = 0;
            long r = 0L;
            long g = 0L;
            long b = 0L;
            long a = 0L;
            for (int x = -radius; x < w; ++x) {
                int newPixel;
                int oldPixel = x - radius - 1;
                if (oldPixel >= 0) {
                    int color = pixels[index + oldPixel];
                    if (mask == null || (mask[index + oldPixel] >> 24 & 0xFF) > 0) {
                        if (color != 0) {
                            a -= (long)(color >> 24 & 0xFF);
                            r -= (long)(color >> 16 & 0xFF);
                            g -= (long)(color >> 8 & 0xFF);
                            b -= (long)(color & 0xFF);
                        }
                        --hits;
                    }
                }
                if ((newPixel = x + radius) < w) {
                    int color = pixels[index + newPixel];
                    if (mask == null || (mask[index + newPixel] >> 24 & 0xFF) > 0) {
                        if (color != 0) {
                            a += (long)(color >> 24 & 0xFF);
                            r += (long)(color >> 16 & 0xFF);
                            g += (long)(color >> 8 & 0xFF);
                            b += (long)(color & 0xFF);
                        }
                        ++hits;
                    }
                }
                if (x < 0) continue;
                if (mask == null || (mask[index + x] >> 24 & 0xFF) > 0) {
                    if (hits == 0) {
                        newColors[x] = 0;
                        continue;
                    }
                    newColors[x] = RGBA.toInt((int)(r / (long)hits) & 0xFF, (int)(g / (long)hits) & 0xFF, (int)(b / (long)hits) & 0xFF, (int)(a / (long)hits));
                    continue;
                }
                newColors[x] = 0;
            }
            System.arraycopy(newColors, 0, pixels, index, w);
            index += w;
        }
    }

    private static void boxBlurVertical(int[] pixels, int[] mask, int[] newColors, int w, int h, int radius) {
        int oldPixelOffset = -(radius + 1) * w;
        int newPixelOffset = radius * w;
        for (int x = 0; x < w; ++x) {
            int y;
            int hits = 0;
            long r = 0L;
            long g = 0L;
            long b = 0L;
            long a = 0L;
            int index = -radius * w + x;
            for (y = -radius; y < h; ++y) {
                int newPixel;
                int oldPixel = y - radius - 1;
                if (oldPixel >= 0) {
                    int color = pixels[index + oldPixelOffset];
                    if (mask == null || (mask[index + oldPixelOffset] >> 24 & 0xFF) > 0) {
                        if (color != 0) {
                            a -= (long)(color >> 24 & 0xFF);
                            r -= (long)(color >> 16 & 0xFF);
                            g -= (long)(color >> 8 & 0xFF);
                            b -= (long)(color & 0xFF);
                        }
                        --hits;
                    }
                }
                if ((newPixel = y + radius) < h && (mask == null || (mask[index + newPixelOffset] >> 24 & 0xFF) > 0)) {
                    int color = pixels[index + newPixelOffset];
                    if (color != 0) {
                        a += (long)(color >> 24 & 0xFF);
                        r += (long)(color >> 16 & 0xFF);
                        g += (long)(color >> 8 & 0xFF);
                        b += (long)(color & 0xFF);
                    }
                    ++hits;
                }
                if (y >= 0) {
                    newColors[y] = mask == null || (mask[y * w + x] >> 24 & 0xFF) > 0 ? (hits == 0 ? 0 : RGBA.toInt((int)(r / (long)hits) & 0xFF, (int)(g / (long)hits) & 0xFF, (int)(b / (long)hits) & 0xFF, (int)(a / (long)hits) & 0xFF)) : 0;
                }
                index += w;
            }
            for (y = 0; y < h; ++y) {
                pixels[y * w + x] = newColors[y];
            }
        }
    }

    private static void premultiply(int[] p) {
        int length = p.length;
        int offset = 0;
        length += offset;
        for (int i = offset; i < length; ++i) {
            int rgb = p[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            float f = (float)a * 0.003921569f;
            r = (int)((float)r * f);
            g = (int)((float)g * f);
            b = (int)((float)b * f);
            p[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    private static void unpremultiply(int[] p) {
        int length = p.length;
        int offset = 0;
        length += offset;
        for (int i = offset; i < length; ++i) {
            int rgb = p[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            if (a == 0 || a == 255) continue;
            float f = 255.0f / (float)a;
            r = (int)((float)r * f);
            g = (int)((float)g * f);
            b = (int)((float)b * f);
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            p[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    public static SerializableImage blur(SerializableImage src, int hRadius, int vRadius, int iterations) {
        int[] pixels = (int[])Filtering.getRGB(src.getBufferedImage()).clone();
        int width = src.getWidth();
        int height = src.getHeight();
        Filtering.blur(pixels, width, height, hRadius, vRadius, iterations, null);
        BufferedImage ret = new BufferedImage(width, height, src.getType());
        Filtering.setRGB(ret, width, height, pixels);
        return new SerializableImage(ret);
    }

    private static void blur(int[] src, int width, int height, int hRadius, int vRadius, int iterations, int[] mask) {
        int[] inPixels = src;
        Filtering.premultiply(inPixels);
        int[] tempRow = new int[width];
        int[] tempColumn = new int[height];
        for (int i = 0; i < iterations; ++i) {
            Filtering.boxBlurHorizontal(inPixels, mask, tempRow, width, height, hRadius / 2);
            Filtering.boxBlurVertical(inPixels, mask, tempColumn, width, height, vRadius / 2);
        }
        Filtering.unpremultiply(inPixels);
    }

    public static SerializableImage bevel(SerializableImage src, int blurX, int blurY, float strength, int type, int highlightColor, int shadowColor, float angle, float distance, boolean knockout, int iterations) {
        return new SerializableImage(Filtering.gradientBevel(src.getBufferedImage(), new Color[]{new Color(shadowColor, true), new Color(shadowColor & 0xFFFFFF, true), new Color(highlightColor & 0xFFFFFF, true), new Color(highlightColor, true)}, new float[]{0.0f, 0.49803922f, 0.5019608f, 1.0f}, blurX, blurY, strength, type, angle, distance, knockout, iterations));
    }

    public static SerializableImage gradientBevel(SerializableImage src, Color[] colors, float[] ratios, int blurX, int blurY, float strength, int type, float angle, float distance, boolean knockout, int iterations) {
        return new SerializableImage(Filtering.gradientBevel(src.getBufferedImage(), colors, ratios, blurX, blurY, strength, type, angle, distance, knockout, iterations));
    }

    private static BufferedImage gradientBevel(BufferedImage src, Color[] colors, float[] ratios, int blurX, int blurY, float strength, int type, float angle, float distance, boolean knockout, int iterations) {
        BufferedImage shadowIm;
        BufferedImage hilightIm;
        Graphics2D sc;
        Graphics2D hc;
        int width = src.getWidth();
        int height = src.getHeight();
        BufferedImage retImg = new BufferedImage(width, height, src.getType());
        int[] srcPixels = Filtering.getRGB(src);
        int[] revPixels = new int[srcPixels.length];
        for (int i = 0; i < srcPixels.length; ++i) {
            revPixels[i] = (srcPixels[i] & 0xFFFFFF) + (255 - (srcPixels[i] >> 24 & 0xFF) << 24);
        }
        BufferedImage gradient = new BufferedImage(512, 1, src.getType());
        Graphics2D gg = gradient.createGraphics();
        Point p1 = POINT_0_0;
        Point p2 = POINT_511_0;
        gg.setPaint(new LinearGradientPaint(p1, p2, ratios, colors));
        gg.fill(RECTANGLE_512_1);
        int[] gradientPixels = Filtering.getRGB(gradient);
        BufferedImage shadowInner = null;
        BufferedImage hilightInner = null;
        if (type != 2) {
            BufferedImage hilightIm2 = Filtering.dropShadow(src, 0, 0, angle, (double)distance, Color.red, true, iterations, strength, true, true);
            BufferedImage shadowIm2 = Filtering.dropShadow(src, 0, 0, angle + 180.0f, (double)distance, Color.blue, true, iterations, strength, true, true);
            BufferedImage h2 = new BufferedImage(width, height, src.getType());
            BufferedImage s2 = new BufferedImage(width, height, src.getType());
            hc = h2.createGraphics();
            sc = s2.createGraphics();
            hc.drawImage((Image)hilightIm2, 0, 0, null);
            hc.setComposite(AlphaComposite.DstOut);
            hc.drawImage((Image)shadowIm2, 0, 0, null);
            sc.drawImage((Image)shadowIm2, 0, 0, null);
            sc.setComposite(AlphaComposite.DstOut);
            sc.drawImage((Image)hilightIm2, 0, 0, null);
            shadowInner = s2;
            hilightInner = h2;
        }
        BufferedImage shadowOuter = null;
        BufferedImage hilightOuter = null;
        if (type != 1) {
            hilightIm = Filtering.dropShadow(src, 0, 0, angle + 180.0f, (double)distance, Color.red, false, iterations, strength, true, true);
            shadowIm = Filtering.dropShadow(src, 0, 0, angle, (double)distance, Color.blue, false, iterations, strength, true, true);
            BufferedImage h2 = new BufferedImage(width, height, src.getType());
            BufferedImage s2 = new BufferedImage(width, height, src.getType());
            Graphics2D hc2 = h2.createGraphics();
            Graphics2D sc2 = s2.createGraphics();
            hc2.drawImage((Image)hilightIm, 0, 0, null);
            hc2.setComposite(AlphaComposite.DstOut);
            hc2.drawImage((Image)shadowIm, 0, 0, null);
            sc2.drawImage((Image)shadowIm, 0, 0, null);
            sc2.setComposite(AlphaComposite.DstOut);
            sc2.drawImage((Image)hilightIm, 0, 0, null);
            shadowOuter = s2;
            hilightOuter = h2;
        }
        hilightIm = null;
        shadowIm = null;
        switch (type) {
            case 2: {
                hilightIm = hilightOuter;
                shadowIm = shadowOuter;
                break;
            }
            case 1: {
                hilightIm = hilightInner;
                shadowIm = shadowInner;
                break;
            }
            case 3: {
                hilightIm = hilightInner;
                shadowIm = shadowInner;
                hc = hilightIm.createGraphics();
                hc.setComposite(AlphaComposite.SrcOver);
                hc.drawImage((Image)hilightOuter, 0, 0, null);
                sc = shadowIm.createGraphics();
                sc.setComposite(AlphaComposite.SrcOver);
                sc.drawImage((Image)shadowOuter, 0, 0, null);
            }
        }
        int[] mask = null;
        if (type == 1) {
            mask = srcPixels;
        }
        if (type == 2) {
            mask = revPixels;
        }
        Graphics2D retc = retImg.createGraphics();
        retc.setColor(Color.black);
        retc.fillRect(0, 0, width, height);
        retc.setComposite(AlphaComposite.SrcOver);
        retc.drawImage((Image)shadowIm, 0, 0, null);
        retc.drawImage((Image)hilightIm, 0, 0, null);
        int[] ret = Filtering.getRGB(retImg);
        Filtering.blur(ret, width, height, blurX, blurY, iterations, mask);
        for (int i = 0; i < srcPixels.length; ++i) {
            int ah = (int)((float)(ret[i] >> 16 & 0xFF) * strength);
            int as = (int)((float)(ret[i] & 0xFF) * strength);
            int ra = Filtering.cut(ah - as, -255, 255);
            ret[i] = gradientPixels[255 + ra];
        }
        Filtering.setRGB(retImg, width, height, ret);
        if (!knockout) {
            Graphics2D g = retImg.createGraphics();
            g.setComposite(AlphaComposite.DstOver);
            g.drawImage((Image)src, 0, 0, null);
        }
        return retImg;
    }

    public static SerializableImage glow(SerializableImage src, int blurX, int blurY, float strength, Color color, boolean inner, boolean knockout, int iterations) {
        return new SerializableImage(Filtering.dropShadow(src.getBufferedImage(), blurX, blurY, 45.0f, 0.0, color, inner, iterations, strength, knockout, true));
    }

    public static SerializableImage dropShadow(SerializableImage src, int blurX, int blurY, float angle, double distance, Color color, boolean inner, int iterations, float strength, boolean knockout, boolean compositeSource) {
        return new SerializableImage(Filtering.dropShadow(src.getBufferedImage(), blurX, blurY, angle, distance, color, inner, iterations, strength, knockout, compositeSource));
    }

    private static int cut(int val, int min, int max) {
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    private static Color over(Color a, Color b) {
        int resultA = a.getAlpha() + b.getAlpha() * (255 - a.getAlpha()) / 255;
        int resultR = Filtering.cut(((double)a.getRed() * ((double)a.getAlpha() / 255.0) + (double)b.getRed() * ((double)b.getAlpha() / 255.0) * (1.0 - (double)a.getAlpha() / 255.0)) / ((double)resultA / 255.0));
        int resultG = Filtering.cut(((double)a.getGreen() * ((double)a.getAlpha() / 255.0) + (double)b.getGreen() * ((double)b.getAlpha() / 255.0) * (1.0 - (double)a.getAlpha() / 255.0)) / ((double)resultA / 255.0));
        int resultB = Filtering.cut(((double)a.getBlue() * ((double)a.getAlpha() / 255.0) + (double)b.getBlue() * ((double)b.getAlpha() / 255.0) * (1.0 - (double)a.getAlpha() / 255.0)) / ((double)resultA / 255.0));
        return new Color(resultR, resultG, resultB, resultA);
    }

    private static BufferedImage dropShadow(BufferedImage src, int blurX, int blurY, float angle, double distance, Color color, boolean inner, int iterations, float strength, boolean knockout, boolean compositeSource) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] srcPixels = Filtering.getRGB(src);
        int[] shadow = new int[srcPixels.length];
        for (int i = 0; i < srcPixels.length; ++i) {
            int alpha = srcPixels[i] >> 24 & 0xFF;
            if (inner) {
                alpha = 255 - alpha;
            }
            Color shadowColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), Filtering.cut((float)(color.getAlpha() * alpha / 255) * strength));
            shadow[i] = shadowColor.getRGB();
        }
        Color colorAlpha = ALPHA;
        double angleRad = (double)(angle / 180.0f) * Math.PI;
        double moveX = distance * Math.cos(angleRad);
        double moveY = distance * Math.sin(angleRad);
        shadow = Filtering.moveRGB(width, height, shadow, moveX, moveY, inner ? color : colorAlpha);
        if (blurX > 0 || blurY > 0) {
            Filtering.blur(shadow, width, height, blurX, blurY, iterations, null);
        }
        if (knockout || inner) {
            for (int i = 0; i < shadow.length; ++i) {
                int mask = srcPixels[i] >> 24 & 0xFF;
                if (!inner) {
                    mask = 255 - mask;
                }
                if (inner && compositeSource && !knockout) {
                    Color shadowColor = new Color(shadow[i], true);
                    Color srcColor = new Color(srcPixels[i], true);
                    srcColor = new Color(srcColor.getRed(), srcColor.getGreen(), srcColor.getBlue(), 255);
                    Color resultColor = Filtering.over(shadowColor, srcColor);
                    shadow[i] = resultColor.getRGB();
                }
                shadow[i] = (shadow[i] & 0xFFFFFF) + (mask * (shadow[i] >> 24 & 0xFF) / 255 << 24);
            }
        }
        BufferedImage retCanvas = new BufferedImage(width, height, src.getType());
        Filtering.setRGB(retCanvas, width, height, shadow);
        if (!knockout && compositeSource && !inner) {
            Graphics2D g = retCanvas.createGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.drawImage((Image)src, 0, 0, null);
        }
        return retCanvas;
    }

    public static SerializableImage gradientGlow(SerializableImage src, int blurX, int blurY, float angle, double distance, Color[] colors, float[] ratios, int type, int iterations, float strength, boolean knockout) {
        return new SerializableImage(Filtering.gradientGlow(src.getBufferedImage(), blurX, blurY, angle, distance, colors, ratios, type, iterations, strength, knockout));
    }

    private static BufferedImage gradientGlow(BufferedImage src, int blurX, int blurY, float angle, double distance, Color[] colors, float[] ratios, int type, int iterations, float strength, boolean knockout) {
        int i;
        int width = src.getWidth();
        int height = src.getHeight();
        BufferedImage gradCanvas = new BufferedImage(256, 1, src.getType());
        Graphics2D gg = gradCanvas.createGraphics();
        Point p1 = POINT_0_0;
        Point p2 = POINT_255_0;
        gg.setPaint(new LinearGradientPaint(p1, p2, ratios, colors));
        gg.fill(RECTANGLE_256_1);
        int[] gradientPixels = Filtering.getRGB(gradCanvas);
        double angleRad = (double)(angle / 180.0f) * Math.PI;
        double moveX = distance * Math.cos(angleRad);
        double moveY = distance * Math.sin(angleRad);
        int[] srcPixels = Filtering.getRGB(src);
        int[] revPixels = new int[srcPixels.length];
        for (int i2 = 0; i2 < srcPixels.length; ++i2) {
            revPixels[i2] = (srcPixels[i2] & 0xFFFFFF) + (255 - (srcPixels[i2] >> 24 & 0xFF) << 24);
        }
        int[] shadow = new int[srcPixels.length];
        for (int i3 = 0; i3 < srcPixels.length; ++i3) {
            shadow[i3] = 0 + (Filtering.cut(strength * (float)(srcPixels[i3] >> 24 & 0xFF)) << 24);
        }
        Color colorAlpha = ALPHA;
        shadow = Filtering.moveRGB(width, height, shadow, moveX, moveY, colorAlpha);
        int[] mask = null;
        if (type == 1) {
            mask = srcPixels;
        }
        if (type == 2) {
            mask = revPixels;
        }
        Filtering.blur(shadow, width, height, blurX, blurY, iterations, mask);
        if (mask != null) {
            for (i = 0; i < mask.length; ++i) {
                int m = mask[i] >> 24;
                if (m != 0) continue;
                shadow[i] = 0;
            }
        }
        for (i = 0; i < shadow.length; ++i) {
            int a = shadow[i] >> 24 & 0xFF;
            shadow[i] = gradientPixels[a];
        }
        BufferedImage retCanvas = new BufferedImage(width, height, src.getType());
        Filtering.setRGB(retCanvas, width, height, shadow);
        if (!knockout) {
            Graphics2D retImg = retCanvas.createGraphics();
            retImg.setComposite(AlphaComposite.DstOver);
            retImg.drawImage((Image)src, 0, 0, null);
        }
        return retCanvas;
    }

    private static int[] getRGB(BufferedImage image) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        }
        int width = image.getWidth();
        return image.getRGB(0, 0, width, image.getHeight(), null, 0, width);
    }

    public static void setRGB(BufferedImage image, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            image.getRaster().setDataElements(0, 0, width, height, pixels);
        } else {
            image.setRGB(0, 0, width, height, pixels, 0, width);
        }
    }

    private static int[] moveRGB(int width, int height, int[] rgb, double deltaX, double deltaY, Color fill) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Filtering.setRGB(img, width, height, rgb);
        BufferedImage retImg = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)retImg.getGraphics();
        g.setPaint(fill);
        g.fillRect(0, 0, width, height);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(AffineTransform.getTranslateInstance(deltaX, deltaY));
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)img, 0, 0, null);
        return Filtering.getRGB(retImg);
    }

    public static SerializableImage convolution(SerializableImage src, float[] matrix, int w, int h) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        ConvolveOp op = new ConvolveOp(new Kernel(w, h, matrix), 0, new RenderingHints(null));
        op.filter(src.getBufferedImage(), dst);
        return new SerializableImage(dst);
    }

    public static SerializableImage colorMatrix(SerializableImage src, float[][] matrix) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        int[] pixels = (int[])Filtering.getRGB(src.getBufferedImage()).clone();
        for (int i = 0; i < pixels.length; ++i) {
            int rgb = pixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            float[] mr = matrix[0];
            int r2 = Filtering.cut(mr[0] * (float)r + mr[1] * (float)g + mr[2] * (float)b + mr[3] * (float)a + mr[4]);
            float[] mg = matrix[1];
            int g2 = Filtering.cut(mg[0] * (float)r + mg[1] * (float)g + mg[2] * (float)b + mg[3] * (float)a + mg[4]);
            float[] mb = matrix[2];
            int b2 = Filtering.cut(mb[0] * (float)r + mb[1] * (float)g + mb[2] * (float)b + mb[3] * (float)a + mb[4]);
            float[] ma = matrix[3];
            int a2 = Filtering.cut(ma[0] * (float)r + ma[1] * (float)g + ma[2] * (float)b + ma[3] * (float)a + ma[4]);
            pixels[i] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
        }
        Filtering.setRGB(dst, src.getWidth(), src.getHeight(), pixels);
        return new SerializableImage(dst);
    }

    private static int cut(double val) {
        int i = (int)Math.round(val);
        if (i < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        return i;
    }

    public static int colorEffect(int rgb, int redAddTerm, int greenAddTerm, int blueAddTerm, int alphaAddTerm, int redMultTerm, int greenMultTerm, int blueMultTerm, int alphaMultTerm) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = Filtering.cut(r * redMultTerm / 256 + redAddTerm);
        g = Filtering.cut(g * greenMultTerm / 256 + greenAddTerm);
        b = Filtering.cut(b * blueMultTerm / 256 + blueAddTerm);
        a = Filtering.cut(a * alphaMultTerm / 256 + alphaAddTerm);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static SerializableImage colorEffect(SerializableImage src, int redAddTerm, int greenAddTerm, int blueAddTerm, int alphaAddTerm, int redMultTerm, int greenMultTerm, int blueMultTerm, int alphaMultTerm) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        int[] pixels = (int[])Filtering.getRGB(src.getBufferedImage()).clone();
        for (int i = 0; i < pixels.length; ++i) {
            int rgb = pixels[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            r = Filtering.cut(r * redMultTerm / 256 + redAddTerm);
            g = Filtering.cut(g * greenMultTerm / 256 + greenAddTerm);
            b = Filtering.cut(b * blueMultTerm / 256 + blueAddTerm);
            a = Filtering.cut(a * alphaMultTerm / 256 + alphaAddTerm);
            pixels[i] = a << 24 | r << 16 | g << 8 | b;
        }
        Filtering.setRGB(dst, src.getWidth(), src.getHeight(), pixels);
        return new SerializableImage(dst);
    }
}

