/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.annotations.parser;

import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.ConditionalType;
import com.jpexs.decompiler.flash.types.annotations.parser.AnnotationParseException;
import com.jpexs.decompiler.flash.types.annotations.parser.ConditionLexer;
import com.jpexs.decompiler.flash.types.annotations.parser.ConditionToken;
import com.jpexs.decompiler.flash.types.annotations.parser.ConditionTokenType;
import java.io.IOException;
import java.io.StringReader;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ConditionEvaluator {
    private final String[] values;
    private final int[] tags;
    private final boolean revert;

    public ConditionEvaluator(Conditional cond) {
        this.values = cond.value();
        this.tags = cond.tags();
        this.revert = cond.revert();
    }

    public ConditionEvaluator(ConditionalType cond) {
        this.values = cond.value();
        this.tags = cond.tags();
        this.revert = cond.revert();
    }

    private void expressionRest(Map<String, Boolean> fields, Stack<Boolean> stack, ConditionLexer lex) throws IOException, AnnotationParseException {
        ConditionToken tok = lex.lex();
        if (tok == null) {
            return;
        }
        switch (tok.type) {
            case AND: {
                Boolean andOp1 = stack.pop();
                this.expression(fields, stack, lex);
                Boolean andOp2 = stack.pop();
                stack.push(andOp1 != false && andOp2 != false);
                break;
            }
            case OR: {
                Boolean orOp1 = stack.pop();
                this.expression(fields, stack, lex);
                Boolean orOp2 = stack.pop();
                stack.push(orOp1 != false || orOp2 != false);
                break;
            }
            default: {
                lex.pushback(tok);
            }
        }
    }

    private void expression(Map<String, Boolean> fields, Stack<Boolean> stack, ConditionLexer lex) throws IOException, AnnotationParseException {
        ConditionToken tok = lex.lex();
        if (tok == null) {
            return;
        }
        switch (tok.type) {
            case FIELD: {
                if (!fields.containsKey(tok.value)) {
                    throw new AnnotationParseException("Field not found", lex.yyline());
                }
                stack.push(fields.get(tok.value));
                this.expressionRest(fields, stack, lex);
                break;
            }
            case NOT: {
                this.expression(fields, stack, lex);
                Boolean invOp = stack.pop();
                stack.push(invOp == false);
                break;
            }
            case PARENT_OPEN: {
                this.expression(fields, stack, lex);
                tok = lex.lex();
                if (tok.type != ConditionTokenType.PARENT_CLOSE) {
                    throw new AnnotationParseException("End of parent expected", lex.yyline());
                }
                this.expressionRest(fields, stack, lex);
                break;
            }
            default: {
                throw new AnnotationParseException("Expression expected", lex.yyline());
            }
        }
    }

    public boolean eval(Map<String, Boolean> fields, int parentTagId) throws AnnotationParseException {
        if (this.tags.length > 0) {
            boolean tagFound = false;
            for (int i = 0; i < this.tags.length; ++i) {
                if (this.tags[i] != parentTagId) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                boolean result = false;
                if (this.revert) {
                    return !result;
                }
                return result;
            }
        }
        ConditionLexer lex = new ConditionLexer(new StringReader(this.prepareCond()));
        Stack<Boolean> stack = new Stack<Boolean>();
        try {
            this.expression(fields, stack, lex);
        }
        catch (IOException | EmptyStackException ex) {
            throw new AnnotationParseException("Invalid condition:" + this.prepareCond(), lex.yyline());
        }
        if (this.prepareCond().isEmpty()) {
            boolean result = true;
            if (this.revert) {
                return !result;
            }
            return result;
        }
        if (stack.size() != 1) {
            throw new AnnotationParseException("Invalid condition:" + this.prepareCond(), lex.yyline());
        }
        boolean result = stack.pop();
        if (this.revert) {
            return !result;
        }
        return result;
    }

    private String prepareCond() {
        String[] vals = this.values;
        if (vals == null || vals.length == 0) {
            return "";
        }
        String val = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            val = val + "," + vals[i];
        }
        return val;
    }

    public Set<String> getFields() throws AnnotationParseException {
        HashSet<String> ret = new HashSet<String>();
        ConditionLexer lex = new ConditionLexer(new StringReader(this.prepareCond()));
        try {
            ConditionToken tok;
            while ((tok = lex.lex()) != null) {
                if (tok.type != ConditionTokenType.FIELD) continue;
                ret.add(tok.value);
            }
        }
        catch (IOException ex) {
            throw new AnnotationParseException("Invalid condition:" + this.prepareCond(), lex.yyline());
        }
        return ret;
    }
}

