/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.MORPHGRADRECORD;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.io.Serializable;

public class MORPHGRADIENT
implements Serializable {
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Pad"), @EnumValue(value=1, text="Reflect"), @EnumValue(value=2, text="Repeat")})
    public int spreadMode;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Normal RGB"), @EnumValue(value=1, text="Linear RGB")})
    public int interPolationMode;
    public MORPHGRADRECORD[] gradientRecords;

    public static RGBA morphColor(RGBA c1, RGBA c2, int ratio) {
        int r = (int)((double)c1.red + (double)((c2.red - c1.red) * ratio) / 65535.0 + 0.5);
        int g = (int)((double)c1.green + (double)((c2.green - c1.green) * ratio) / 65535.0 + 0.5);
        int b = (int)((double)c1.blue + ((double)(c2.blue - c1.blue) + 0.5) * (double)ratio / 65535.0 + 0.5);
        int a = (int)((double)((float)c1.alpha + (float)((c2.alpha - c1.alpha) * ratio) / 65535.0f) + 0.5);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        if (a > 255) {
            a = 255;
        }
        return new RGBA(r, g, b, a);
    }

    public GRADIENT getGradientAt(int ratio) {
        GRADIENT ret = new GRADIENT();
        ret.spreadMode = this.spreadMode;
        ret.interpolationMode = this.interPolationMode;
        ret.gradientRecords = new GRADRECORD[this.gradientRecords.length];
        for (int m = 0; m < this.gradientRecords.length; ++m) {
            int gratio = this.gradientRecords[m].startRatio + (this.gradientRecords[m].endRatio - this.gradientRecords[m].startRatio) * ratio / 65535;
            ret.gradientRecords[m] = new GRADRECORD();
            ret.gradientRecords[m].color = MORPHGRADIENT.morphColor(this.gradientRecords[m].startColor, this.gradientRecords[m].endColor, ratio);
            ret.gradientRecords[m].ratio = gratio;
        }
        return ret;
    }

    public GRADIENT getStartGradient() {
        GRADIENT ret = new GRADIENT();
        ret.spreadMode = this.spreadMode;
        ret.interpolationMode = this.interPolationMode;
        ret.gradientRecords = new GRADRECORD[this.gradientRecords.length];
        for (int m = 0; m < this.gradientRecords.length; ++m) {
            ret.gradientRecords[m] = this.gradientRecords[m].getStartRecord();
        }
        return ret;
    }

    public GRADIENT getEndGradient() {
        GRADIENT ret = new GRADIENT();
        ret.spreadMode = this.spreadMode;
        ret.interpolationMode = this.interPolationMode;
        ret.gradientRecords = new GRADRECORD[this.gradientRecords.length];
        for (int m = 0; m < this.gradientRecords.length; ++m) {
            ret.gradientRecords[m] = this.gradientRecords[m].getEndRecord();
        }
        return ret;
    }
}

