/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.gfx.FONTINFO;
import com.jpexs.decompiler.flash.types.gfx.GFxInputStream;
import com.jpexs.decompiler.flash.types.gfx.GFxOutputStream;
import com.jpexs.decompiler.flash.types.gfx.TEXGLYPH;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.MemoryInputStream;
import java.io.IOException;

public class FontTextureInfo
extends Tag {
    public static final int ID = 1002;
    public static final String NAME = "FontTextureInfo";
    public long textureID;
    public int textureFormat;
    public String fileName;
    public int textureWidth;
    public int textureHeight;
    public int padPixels;
    public int nominalGlyphSz;
    public TEXGLYPH[] texGlyphs;
    public FONTINFO[] fonts;
    public static final int TEXTURE_FORMAT_DEFAULT = 0;
    public static final int TEXTURE_FORMAT_TGA = 1;
    public static final int TEXTURE_FORMAT_DDS = 2;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        int i;
        sos.writeUI32(this.textureID);
        sos.writeUI16(this.textureFormat);
        sos.writeNetString(this.fileName);
        sos.writeUI16(this.textureWidth);
        sos.writeUI16(this.textureHeight);
        sos.writeUI8(this.padPixels);
        sos.writeUI16(this.nominalGlyphSz);
        sos.writeUI16(this.texGlyphs.length);
        for (i = 0; i < this.texGlyphs.length; ++i) {
            this.texGlyphs[i].write(new GFxOutputStream(sos));
        }
        sos.writeUI16(this.fonts.length);
        for (i = 0; i < this.fonts.length; ++i) {
            this.fonts[i].write(new GFxOutputStream(sos));
        }
    }

    public FontTextureInfo(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1002, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public FontTextureInfo(SWF swf) {
        super(swf, 1002, NAME, null);
        this.fileName = "";
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.textureID = sis.readUI32("textureID");
        this.textureFormat = sis.readUI16("textureFormat");
        this.fileName = sis.readNetString("fileName");
        this.textureWidth = sis.readUI16("textureWidth");
        this.textureHeight = sis.readUI16("textureHeight");
        this.padPixels = sis.readUI8("padPixels");
        this.nominalGlyphSz = sis.readUI16("nominalGlyphSz");
        int numTexGlyphs = sis.readUI16("numTexGlyphs");
        this.texGlyphs = new TEXGLYPH[numTexGlyphs];
        MemoryInputStream mis = sis.getBaseStream();
        for (int i = 0; i < numTexGlyphs; ++i) {
            GFxInputStream gis = new GFxInputStream(mis);
            gis.dumpInfo = sis.dumpInfo;
            this.texGlyphs[i] = new TEXGLYPH(gis);
        }
        sis.skipBytes(mis.getPos());
        int numFonts = sis.readUI16("numFonts");
        this.fonts = new FONTINFO[numFonts];
        mis = sis.getBaseStream();
        for (int i = 0; i < numFonts; ++i) {
            GFxInputStream gis = new GFxInputStream(mis);
            gis.dumpInfo = sis.dumpInfo;
            this.fonts[i] = new FONTINFO(gis);
        }
        sis.skipBytes(mis.getPos());
    }
}

