/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage2;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.npe.dds.DDSReader;

public class DefineSubImage
extends ImageTag {
    public static final int ID = 1008;
    public static final String NAME = "DefineSubImage";
    public int imageId;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    @HideInRawEdit
    private SerializableImage serImage;
    @HideInRawEdit
    private String cachedImageFilename = null;
    @HideInRawEdit
    private Integer cachedX1 = null;
    @HideInRawEdit
    private Integer cachedY1 = null;
    @HideInRawEdit
    private Integer cachedX2 = null;
    @HideInRawEdit
    private Integer cachedY2 = null;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI16(this.imageId);
        sos.writeUI16(this.x1);
        sos.writeUI16(this.y1);
        sos.writeUI16(this.x2);
        sos.writeUI16(this.y2);
    }

    public DefineSubImage(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1008, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    public DefineSubImage(SWF swf) {
        super(swf, 1008, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.x1 = 0;
        this.x2 = 1;
        this.y1 = 0;
        this.y2 = 1;
        this.createFailedImage();
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.imageId = sis.readUI16("imageId");
        this.x1 = sis.readUI16("x1");
        this.y1 = sis.readUI16("y1");
        this.x2 = sis.readUI16("x2");
        this.y2 = sis.readUI16("y2");
    }

    @Override
    public void setImage(byte[] data) throws IOException {
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    protected SerializableImage getImage() {
        this.initImage();
        return this.serImage;
    }

    private void createFailedImage() {
        if (this.x2 - this.x1 <= 0 || this.y2 - this.y1 <= 0) {
            this.serImage = new SerializableImage(1, 1, 7);
            this.serImage.fillTransparent();
            return;
        }
        this.serImage = new SerializableImage(this.x2 - this.x1, this.y2 - this.y1, 3);
        Graphics g = this.serImage.getGraphics();
        g.setColor(SWF.ERROR_COLOR);
        g.fillRect(0, 0, this.x2 - this.x1, this.y2 - this.y1);
        this.cachedImageFilename = null;
        this.cachedX1 = this.x1;
        this.cachedX2 = this.x2;
        this.cachedY1 = this.y1;
        this.cachedY2 = this.y2;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.x2 - this.x1, this.y2 - this.y1);
    }

    private void initImage() {
        DefineExternalImage2 image = this.swf.getExternalImage2(this.imageId);
        if (image == null) {
            this.createFailedImage();
            return;
        }
        int targetWidth = this.x2 - this.x1;
        int targetHeight = this.y2 - this.y1;
        if (!(Objects.equals(this.cachedImageFilename, image.fileName) && Objects.equals(this.cachedX1, this.x1) && Objects.equals(this.cachedX2, this.x2) && Objects.equals(this.cachedY1, this.y1) && Objects.equals(this.cachedY2, this.y2) && (this.serImage == null || this.serImage.getWidth() == targetWidth && this.serImage.getHeight() == targetHeight))) {
            Path imagePath;
            if (targetWidth <= 0 || targetHeight <= 0) {
                this.serImage = new SerializableImage(1, 1, 7);
                this.serImage.fillTransparent();
                return;
            }
            Path path = imagePath = image.getSwf().getFile() == null ? null : Paths.get(image.getSwf().getFile(), new String[0]).getParent().resolve(Paths.get(image.fileName, new String[0]));
            if (imagePath != null && imagePath.toFile().exists()) {
                try {
                    byte[] imageData = Files.readAllBytes(imagePath);
                    int[] pixels = DDSReader.read((byte[])imageData, (DDSReader.Order)DDSReader.ARGB, (int)0);
                    BufferedImage bufImage = new BufferedImage(DDSReader.getWidth((byte[])imageData), DDSReader.getHeight((byte[])imageData), 2);
                    bufImage.getRaster().setDataElements(0, 0, bufImage.getWidth(), bufImage.getHeight(), pixels);
                    Image scaled = bufImage.getScaledInstance(image.targetWidth, image.targetHeight, 1);
                    bufImage = new BufferedImage(targetWidth, targetHeight, 2);
                    bufImage.getGraphics().drawImage(scaled, -this.x1, -this.y1, null);
                    this.serImage = new SerializableImage(bufImage);
                    this.cachedImageFilename = image.fileName;
                    this.cachedX1 = this.x1;
                    this.cachedX2 = this.x2;
                    this.cachedY1 = this.y1;
                    this.cachedY2 = this.y2;
                }
                catch (IOException e) {
                    this.createFailedImage();
                }
            } else {
                this.createFailedImage();
            }
        }
    }
}

