/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.gfx.TgaSupport;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.npe.dds.DDSReader;

public class DefineExternalImage2
extends ImageTag {
    public static final int ID = 1009;
    public static final String NAME = "DefineExternalImage2";
    public int imageID;
    public static final int UNKNOWN_IS_STANDALONE = 0;
    public static final int UNKNOWN_HAS_SUBIMAGES = 9;
    public int unknownID;
    public int bitmapFormat;
    public int targetWidth;
    public int targetHeight;
    public String exportName;
    public String fileName;
    public byte[] extraData;
    public static final int BITMAP_FORMAT_DEFAULT = 0;
    public static final int BITMAP_FORMAT_TGA = 1;
    public static final int BITMAP_FORMAT_DDS = 2;
    public static final int BITMAP_FORMAT2_JPEG = 10;
    public static final int BITMAP_FORMAT2_TGA = 13;
    public static final int BITMAP_FORMAT2_DDS = 14;
    @HideInRawEdit
    private SerializableImage serImage;
    @HideInRawEdit
    private String cachedImageFilename = null;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.imageID);
        sos.writeUI16(this.unknownID);
        sos.writeUI16(this.bitmapFormat);
        sos.writeUI16(this.targetWidth);
        sos.writeUI16(this.targetHeight);
        sos.writeNetString(this.exportName);
        sos.writeNetString(this.fileName);
        if (this.extraData != null) {
            sos.write(this.extraData);
        }
    }

    public DefineExternalImage2(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1009, NAME, data);
        this.readData(sis, data, 0, false, false, false);
        this.characterID = this.unknownID == 0 ? this.imageID : -1;
    }

    public DefineExternalImage2(SWF swf) {
        super(swf, 1009, NAME, null);
        this.exportName = "";
        this.fileName = "";
        this.targetWidth = 1;
        this.targetHeight = 1;
        this.unknownID = 9;
        this.bitmapFormat = 14;
        this.characterID = -1;
        this.createFailedImage();
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.imageID = sis.readUI16("imageID");
        this.unknownID = sis.readUI16("unknownID");
        this.bitmapFormat = sis.readUI16("bitmapFormat");
        this.targetWidth = sis.readUI16("targetWidth");
        this.targetHeight = sis.readUI16("targetHeight");
        this.exportName = sis.readNetString("exportName");
        this.fileName = sis.readNetString("fileName");
        if (sis.available() > 0) {
            this.extraData = sis.readBytesEx(sis.available(), "extraData");
        }
    }

    private void createFailedImage() {
        if (this.targetWidth <= 0 || this.targetHeight <= 0) {
            this.serImage = new SerializableImage(1, 1, 7);
            this.serImage.fillTransparent();
            return;
        }
        this.serImage = new SerializableImage(this.targetWidth, this.targetHeight, 3);
        Graphics g = this.serImage.getGraphics();
        g.setColor(SWF.ERROR_COLOR);
        g.fillRect(0, 0, this.targetWidth, this.targetHeight);
        this.cachedImageFilename = null;
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        this.serImage = new SerializableImage(ImageHelper.read(data));
        this.clearCache();
        this.setModified(true);
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    public SerializableImage getImage() {
        this.initImage();
        return this.serImage;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.targetWidth, this.targetHeight);
    }

    private void initImage() {
        if (!Objects.equals(this.cachedImageFilename, this.fileName) || this.serImage != null && (this.serImage.getWidth() != this.targetWidth || this.serImage.getHeight() != this.targetHeight)) {
            if (this.targetWidth <= 0 || this.targetHeight <= 0) {
                this.serImage = new SerializableImage(1, 1, 7);
                this.serImage.fillTransparent();
            } else if (this.bitmapFormat == 10 || this.bitmapFormat == 13 || this.bitmapFormat == 1) {
                Path imagePath;
                Path path = imagePath = this.getSwf().getFile() == null ? null : Paths.get(this.getSwf().getFile(), new String[0]).getParent().resolve(Paths.get(this.fileName, new String[0]));
                if (imagePath != null && imagePath.toFile().exists()) {
                    try {
                        if (this.bitmapFormat == 13 || this.bitmapFormat == 1) {
                            TgaSupport.init();
                        }
                        BufferedImage bufImage = ImageIO.read(imagePath.toFile());
                        Image scaled = bufImage.getScaledInstance(this.targetWidth, this.targetHeight, 1);
                        bufImage = new BufferedImage(this.targetWidth, this.targetHeight, 2);
                        bufImage.getGraphics().drawImage(scaled, 0, 0, null);
                        this.serImage = new SerializableImage(bufImage);
                        this.cachedImageFilename = this.fileName;
                    }
                    catch (IOException ex) {
                        this.createFailedImage();
                    }
                } else {
                    this.createFailedImage();
                }
            } else if (this.bitmapFormat == 14 || this.bitmapFormat == 14) {
                Path imagePath;
                Path path = imagePath = this.getSwf().getFile() == null ? null : Paths.get(this.getSwf().getFile(), new String[0]).getParent().resolve(Paths.get(this.fileName, new String[0]));
                if (imagePath != null && imagePath.toFile().exists()) {
                    try {
                        byte[] imageData = Files.readAllBytes(imagePath);
                        int[] pixels = DDSReader.read((byte[])imageData, (DDSReader.Order)DDSReader.ARGB, (int)0);
                        BufferedImage bufImage = new BufferedImage(DDSReader.getWidth((byte[])imageData), DDSReader.getHeight((byte[])imageData), 2);
                        bufImage.getRaster().setDataElements(0, 0, bufImage.getWidth(), bufImage.getHeight(), pixels);
                        Image scaled = bufImage.getScaledInstance(this.targetWidth, this.targetHeight, 1);
                        bufImage = new BufferedImage(this.targetWidth, this.targetHeight, 2);
                        bufImage.getGraphics().drawImage(scaled, 0, 0, null);
                        this.serImage = new SerializableImage(bufImage);
                        this.cachedImageFilename = this.fileName;
                    }
                    catch (IOException ex) {
                        this.createFailedImage();
                    }
                } else {
                    this.createFailedImage();
                }
            } else {
                this.createFailedImage();
            }
        }
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public String toString() {
        if (this.unknownID == 0) {
            return super.toString();
        }
        return this.tagName + " (i" + this.imageID + ")";
    }

    @Override
    public void setCharacterId(int characterId) {
    }
}

