/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.text.ParsedSymbol;
import com.jpexs.decompiler.flash.tags.text.TextAlign;
import com.jpexs.decompiler.flash.tags.text.TextLexer;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StaticTextTag
extends TextTag {
    @SWFType(value=BasicType.UI16)
    public int characterID;
    protected int glyphBits;
    protected int advanceBits;
    public RECT textBounds;
    public MATRIX textMatrix;
    public List<TEXTRECORD> textRecords;

    public abstract int getTextNum();

    public StaticTextTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        TEXTRECORD tr;
        this.characterID = sis.readUI16("characterID");
        this.textBounds = sis.readRECT("textBounds");
        this.textMatrix = sis.readMatrix("textMatrix");
        this.glyphBits = sis.readUI8("glyphBits");
        this.advanceBits = sis.readUI8("advanceBits");
        this.textRecords = new ArrayList<TEXTRECORD>();
        while ((tr = sis.readTEXTRECORD(this.getTextNum(), this.glyphBits, this.advanceBits, "record")) != null) {
            this.textRecords.add(tr);
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeRECT(this.textBounds);
        sos.writeMatrix(this.textMatrix);
        int glyphBits = 0;
        int advanceBits = 0;
        for (TEXTRECORD tr : this.textRecords) {
            for (GLYPHENTRY ge : tr.glyphEntries) {
                glyphBits = SWFOutputStream.enlargeBitCountU(glyphBits, ge.glyphIndex);
                advanceBits = SWFOutputStream.enlargeBitCountS(advanceBits, ge.glyphAdvance);
            }
        }
        if (Configuration._debugCopy.get().booleanValue()) {
            glyphBits = Math.max(glyphBits, this.glyphBits);
            advanceBits = Math.max(advanceBits, this.advanceBits);
        }
        sos.writeUI8(glyphBits);
        sos.writeUI8(advanceBits);
        for (TEXTRECORD tr : this.textRecords) {
            sos.writeTEXTRECORD(tr, this.getTextNum(), glyphBits, advanceBits);
        }
        sos.writeUI8(0);
    }

    @Override
    public RECT getBounds() {
        return this.textBounds;
    }

    @Override
    public MATRIX getTextMatrix() {
        return this.textMatrix;
    }

    @Override
    public void setBounds(RECT r) {
        this.textBounds = r;
    }

    @Override
    public List<String> getTexts() {
        FontTag fnt = null;
        ArrayList<String> ret = new ArrayList<String>();
        for (TEXTRECORD rec : this.textRecords) {
            FontTag fnt2;
            if (rec.styleFlagsHasFont && (fnt2 = this.swf.getFont(rec.fontId)) != null) {
                fnt = fnt2;
            }
            if (rec.styleFlagsHasXOffset || rec.styleFlagsHasYOffset) {
                // empty if block
            }
            if (fnt == null) {
                ret.add(AppResources.translate("fontNotFound").replace("%fontId%", Integer.toString(rec.fontId)));
                continue;
            }
            ret.add(rec.getText(fnt));
        }
        return ret;
    }

    @Override
    public List<Integer> getFontIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (TEXTRECORD rec : this.textRecords) {
            if (!rec.styleFlagsHasFont) continue;
            ret.add(rec.fontId);
        }
        return ret;
    }

    @Override
    public void updateTextBounds() {
        this.updateTextBounds(this.textBounds);
    }

    @Override
    public boolean alignText(TextAlign textAlign) {
        StaticTextTag.alignText(this.swf, this.textRecords, textAlign);
        this.setModified(true);
        return true;
    }

    @Override
    public boolean translateText(int diff) {
        this.textMatrix.translateX += diff;
        this.updateTextBounds();
        this.setModified(true);
        return true;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return this.textBounds;
    }

    @Override
    public ExportRectangle calculateTextBounds() {
        return StaticTextTag.calculateTextBounds(this.swf, this.textRecords, this.getTextMatrix());
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public HighlightedText getFormattedText(boolean ignoreLetterSpacing) {
        FontTag fnt = null;
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        writer.append("[").newLine();
        writer.append("xmin ").append(this.textBounds.Xmin).newLine();
        writer.append("ymin ").append(this.textBounds.Ymin).newLine();
        writer.append("xmax ").append(this.textBounds.Xmax).newLine();
        writer.append("ymax ").append(this.textBounds.Ymax).newLine();
        if (this.textMatrix.translateX != 0) {
            writer.append("translatex ").append(this.textMatrix.translateX).newLine();
        }
        if (this.textMatrix.translateY != 0) {
            writer.append("translatey ").append(this.textMatrix.translateY).newLine();
        }
        if (this.textMatrix.hasScale) {
            writer.append("scalex ").append(this.textMatrix.scaleX).newLine();
            writer.append("scaley ").append(this.textMatrix.scaleY).newLine();
        }
        if (this.textMatrix.hasRotate) {
            writer.append("rotateskew0 ").append(this.textMatrix.rotateSkew0).newLine();
            writer.append("rotateskew1 ").append(this.textMatrix.rotateSkew1).newLine();
        }
        writer.append("]");
        int textHeight = 12;
        for (TEXTRECORD rec : this.textRecords) {
            if (rec.styleFlagsHasFont || rec.styleFlagsHasColor || rec.styleFlagsHasXOffset || rec.styleFlagsHasYOffset) {
                int letterSpacing;
                writer.append("[").newLine();
                if (rec.styleFlagsHasFont) {
                    FontTag fnt2 = this.swf.getFont(rec.fontId);
                    if (fnt2 != null) {
                        fnt = fnt2;
                    }
                    writer.append("font ").append(rec.fontId).newLine();
                    writer.append("height ").append(rec.textHeight).newLine();
                    textHeight = rec.textHeight;
                }
                if (fnt != null && !ignoreLetterSpacing && (letterSpacing = StaticTextTag.detectLetterSpacing(rec, fnt, textHeight)) != 0) {
                    writer.append("letterspacing ").append(letterSpacing).newLine();
                }
                if (rec.styleFlagsHasColor) {
                    if (this.getTextNum() == 1) {
                        writer.append("color ").append(rec.textColor.toHexRGB()).newLine();
                    } else {
                        writer.append("color ").append(rec.textColorA.toHexARGB()).newLine();
                    }
                }
                if (rec.styleFlagsHasXOffset) {
                    writer.append("x ").append(rec.xOffset).newLine();
                }
                if (rec.styleFlagsHasYOffset) {
                    writer.append("y ").append(rec.yOffset).newLine();
                }
                writer.append("]");
            }
            if (fnt == null) {
                writer.append(AppResources.translate("fontNotFound").replace("%fontId%", Integer.toString(rec.fontId)));
                continue;
            }
            writer.hilightSpecial(Helper.escapeActionScriptString(rec.getText(fnt)).replace("[", "\\[").replace("]", "\\]"), HighlightSpecialType.TEXT);
        }
        return new HighlightedText(writer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setFormattedText(MissingCharacterHandler missingCharHandler, String formattedText, String[] texts) throws TextParseException {
        try {
            TextLexer lexer = new TextLexer(new StringReader(formattedText));
            ParsedSymbol s = null;
            ArrayList<TEXTRECORD> textRecords = new ArrayList<TEXTRECORD>();
            RGB color = null;
            RGBA colorA = null;
            int fontId = -1;
            int textHeight = -1;
            int letterSpacing = 0;
            FontTag font = null;
            Integer x = null;
            Integer y = null;
            int currentX = 0;
            int currentY = 0;
            int maxX = Integer.MIN_VALUE;
            int minX = Integer.MAX_VALUE;
            MATRIX textMatrix = new MATRIX();
            textMatrix.hasRotate = false;
            textMatrix.hasScale = false;
            RECT textBounds = new RECT();
            int textIdx = 0;
            while ((s = lexer.yylex()) != null) {
                block16 : switch (s.type) {
                    case PARAMETER: {
                        String paramName = (String)s.values[0];
                        String paramValue = (String)s.values[1];
                        switch (paramName) {
                            case "color": {
                                Matcher m;
                                if (this.getTextNum() == 1) {
                                    m = Pattern.compile("#([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])").matcher(paramValue);
                                    if (!m.matches()) {
                                        throw new TextParseException("Invalid color. Valid format is #rrggbb. Found: " + paramValue, lexer.yyline());
                                    }
                                    color = new RGB(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16));
                                    break block16;
                                }
                                m = Pattern.compile("#([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])").matcher(paramValue);
                                if (!m.matches()) {
                                    throw new TextParseException("Invalid color. Valid format is #aarrggbb. Found: " + paramValue, lexer.yyline());
                                }
                                colorA = new RGBA(Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16), Integer.parseInt(m.group(4), 16), Integer.parseInt(m.group(1), 16));
                                break block16;
                            }
                            case "font": {
                                try {
                                    fontId = Integer.parseInt(paramValue);
                                    FontTag ft = this.swf.getFont(fontId);
                                    if (ft == null) {
                                        throw new TextParseException("Font not found.", lexer.yyline());
                                    }
                                    font = ft;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid font id - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "height": {
                                try {
                                    textHeight = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid font height - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "letterspacing": {
                                try {
                                    letterSpacing = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid font letter spacing - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "x": {
                                try {
                                    x = Integer.parseInt(paramValue);
                                    currentX = x;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid x position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "y": {
                                try {
                                    y = Integer.parseInt(paramValue);
                                    currentY = y;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid y position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "xmin": {
                                try {
                                    textBounds.Xmin = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmin position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "xmax": {
                                try {
                                    textBounds.Xmax = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmax position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymin": {
                                try {
                                    textBounds.Ymin = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymin position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymax": {
                                try {
                                    textBounds.Ymax = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymax position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "scalex": {
                                try {
                                    textMatrix.scaleX = Integer.parseInt(paramValue);
                                    textMatrix.hasScale = true;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid scalex value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "scaley": {
                                try {
                                    textMatrix.scaleY = Integer.parseInt(paramValue);
                                    textMatrix.hasScale = true;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid scalex value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rotateskew0": {
                                try {
                                    textMatrix.rotateSkew0 = Integer.parseInt(paramValue);
                                    textMatrix.hasRotate = true;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid rotateskew0 value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rotateskew1": {
                                try {
                                    textMatrix.rotateSkew1 = Integer.parseInt(paramValue);
                                    textMatrix.hasRotate = true;
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid rotateskew1 value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "translatex": {
                                try {
                                    textMatrix.translateX = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid translatex value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "translatey": {
                                try {
                                    textMatrix.translateY = Integer.parseInt(paramValue);
                                    break block16;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid translatey value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                        }
                        throw new TextParseException("Unrecognized parameter name: " + paramName, lexer.yyline());
                    }
                    case TEXT: {
                        int advance;
                        String txt;
                        String string = txt = texts == null || textIdx >= texts.length ? (String)s.values[0] : texts[textIdx++];
                        if (txt == null || font == null && txt.isEmpty()) break;
                        if (font == null) {
                            throw new TextParseException("Font not defined", lexer.yyline());
                        }
                        while (txt.charAt(0) == '\r' || txt.charAt(0) == '\n') {
                            txt = txt.substring(1);
                        }
                        while (txt.charAt(txt.length() - 1) == '\r' || txt.charAt(txt.length() - 1) == '\n') {
                            txt = txt.substring(0, txt.length() - 1);
                        }
                        StringBuilder txtSb = new StringBuilder();
                        for (int i = 0; i < txt.length(); ++i) {
                            char c = txt.charAt(i);
                            if (!font.containsChar(c)) {
                                if (missingCharHandler.handle(this, font, c)) {
                                    return this.setFormattedText(missingCharHandler, formattedText, texts);
                                }
                                if (missingCharHandler.getIgnoreMissingCharacters()) continue;
                                return false;
                            }
                            txtSb.append(c);
                        }
                        txt = txtSb.toString();
                        TEXTRECORD tr = new TEXTRECORD();
                        textRecords.add(tr);
                        if (fontId > -1) {
                            tr.fontId = fontId;
                            tr.textHeight = textHeight;
                            fontId = -1;
                            tr.styleFlagsHasFont = true;
                        }
                        if (this.getTextNum() == 1) {
                            if (color != null) {
                                tr.textColor = color;
                                tr.styleFlagsHasColor = true;
                                color = null;
                            }
                        } else if (colorA != null) {
                            tr.textColorA = colorA;
                            tr.styleFlagsHasColor = true;
                            colorA = null;
                        }
                        if (x != null) {
                            tr.xOffset = x;
                            tr.styleFlagsHasXOffset = true;
                            x = null;
                        }
                        if (y != null) {
                            tr.yOffset = y;
                            tr.styleFlagsHasYOffset = true;
                            y = null;
                        }
                        tr.glyphEntries = new ArrayList<GLYPHENTRY>(txt.length());
                        for (int i = 0; i < txt.length(); currentX += advance, ++i) {
                            char c = txt.charAt(i);
                            Character nextChar = null;
                            if (i + 1 < txt.length()) {
                                nextChar = Character.valueOf(txt.charAt(i + 1));
                            }
                            GLYPHENTRY ge = new GLYPHENTRY();
                            ge.glyphIndex = font.charToGlyph(c);
                            ge.glyphAdvance = advance = StaticTextTag.getAdvance(font, ge.glyphIndex, textHeight, c, nextChar) + letterSpacing;
                            tr.glyphEntries.add(ge);
                        }
                        if (currentX > maxX) {
                            maxX = currentX;
                        }
                        if (currentX >= minX) break;
                        minX = currentX;
                        break;
                    }
                }
            }
            this.setModified(true);
            this.textRecords = textRecords;
            this.textMatrix = textMatrix;
            this.textBounds = textBounds;
        }
        catch (IOException ex) {
            return false;
        }
        catch (TextParseException ex) {
            throw ex;
        }
        this.updateTextBounds();
        return true;
    }

    public static int getAdvance(FontTag font, int glyphIndex, int textHeight, char c, Character nextChar) {
        int advance;
        if (font.hasLayout()) {
            int kerningAdjustment = 0;
            if (nextChar != null) {
                kerningAdjustment = font.getCharKerningAdjustment(c, nextChar.charValue());
            }
            advance = (int)Math.round((double)textHeight * (font.getGlyphAdvance(glyphIndex) + (double)kerningAdjustment) / (font.getDivider() * 1024.0));
        } else {
            String fontName = font.getSystemFontName();
            advance = (int)Math.round(20.0 * (double)FontTag.getSystemFontAdvance(fontName, font.getFontStyle(), (int)((double)textHeight / 20.0), Character.valueOf(c), nextChar));
        }
        return advance;
    }

    public static int detectLetterSpacing(TEXTRECORD textRecord, FontTag font, int textHeight) {
        int totalLetterSpacing = 0;
        List<GLYPHENTRY> glyphEntries = textRecord.glyphEntries;
        for (int i = 0; i < glyphEntries.size(); ++i) {
            GLYPHENTRY glyph = glyphEntries.get(i);
            GLYPHENTRY nextGlyph = null;
            if (i + 1 < glyphEntries.size()) {
                nextGlyph = glyphEntries.get(i + 1);
            }
            char c = font.glyphToChar(glyph.glyphIndex);
            Character nextChar = nextGlyph == null ? null : Character.valueOf(font.glyphToChar(nextGlyph.glyphIndex));
            int advance = StaticTextTag.getAdvance(font, glyph.glyphIndex, textHeight, c, nextChar);
            int letterSpacing = glyph.glyphAdvance - advance;
            totalLetterSpacing += letterSpacing;
        }
        return Math.round(totalLetterSpacing / glyphEntries.size());
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
        for (TEXTRECORD tr : this.textRecords) {
            if (!tr.styleFlagsHasFont) continue;
            needed.add(tr.fontId);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (TEXTRECORD tr : this.textRecords) {
            if (tr.fontId != oldCharacterId) continue;
            tr.fontId = newCharacterId;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (TEXTRECORD tr : this.textRecords) {
            if (tr.fontId != characterId) continue;
            tr.styleFlagsHasFont = false;
            tr.fontId = 0;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public int getUsedParameters() {
        return 0;
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing) {
        StaticTextTag.staticTextToImage(this.swf, this.textRecords, this.getTextNum(), image, this.textMatrix, transformation, colorTransform);
    }

    @Override
    public void toSVG(SVGExporter exporter, int ratio, ColorTransform colorTransform, int level) {
        StaticTextTag.staticTextToSVG(this.swf, this.textRecords, this.getTextNum(), exporter, this.getRect(), this.textMatrix, colorTransform, 1.0);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        StaticTextTag.staticTextToHtmlCanvas(unitDivisor, this.swf, this.textRecords, this.getTextNum(), result, this.textBounds, this.textMatrix, null);
    }
}

